// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/index.d.ts
declare module '@sage/xtrem-x3-cli-dev/index' {
	export * from '@sage/xtrem-x3-cli-dev/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/index.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/index' {
	import { Argv } from 'yargs';
	export const plugin: (yargs: Argv) => Argv;
	export const builder: {};
	export const handler: {};
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/x3-dev.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/x3-dev' {
	import { Argv } from 'yargs';
	export const command = "x3-dev";
	export const desc = "X3 services development commands";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: {};
	//# sourceMappingURL=x3-dev.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/generate.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/generate' {
	import { Argv } from 'yargs';
	export const command = "generate";
	export const desc = "generate X3 services packages based on metadata definition";
	export const builder: (yargs: Argv) => Argv<{
	    scopes: string | undefined;
	} & {
	    "specific-only": boolean | undefined;
	} & {
	    "create-main": boolean | undefined;
	} & {
	    "service-name": string;
	} & {
	    translations: boolean | undefined;
	}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=generate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/generate-translations.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/generate-translations' {
	import { Argv } from 'yargs';
	export const command = "generate-translations";
	export const desc = "generate current X3 services package i18n files based on metadata definition";
	export const builder: (yargs: Argv) => Argv<{
	    "service-name": string;
	}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=generate-translations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/generate-package.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/generate-package' {
	import { Argv } from 'yargs';
	export const command = "generate-package";
	export const desc = "generate current X3 services package based on metadata defintion";
	export const builder: (yargs: Argv) => Argv<{
	    "service-name": string;
	}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=generate-package.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/generate-migrate-translations.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/generate-migrate-translations' {
	import { Argv } from 'yargs';
	export const command = "generate-migrate-translations";
	export const desc = "Migrate i18n files content from source package to actual package";
	export const builder: (yargs: Argv) => Argv<{}>;
	export const handler: (argv: any) => Promise<void>;
	//# sourceMappingURL=generate-migrate-translations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/handlers/generate-package/migrate-translations-handler.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/handlers/generate-package/migrate-translations-handler' {
	export interface MigrateTranslationsOptions {
	    sourcePackagePath: string;
	}
	export interface MigrateContext {
	    dir: string;
	    deployedApp: any;
	    options: MigrateTranslationsOptions;
	}
	export interface MigrateInterDevOptions extends MigrateTranslationsOptions {
	}
	export const migrateTranslationsHandler: (argv: MigrateTranslationsOptions) => void;
	//# sourceMappingURL=migrate-translations-handler.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/handlers/generate-package/generate-translations-handler.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/handlers/generate-package/generate-translations-handler' {
	export interface GenerateTranslationsOptions {
	    serviceName: string;
	}
	export interface GenerateContext {
	    dir: string;
	    deployedApp: any;
	    options: GenerateTranslationsOptions;
	}
	export interface GenerateInterDevOptions extends GenerateTranslationsOptions {
	}
	export const generateTranslationsHandler: (options: GenerateInterDevOptions) => Promise<void>;
	//# sourceMappingURL=generate-translations-handler.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/handlers/generate-package/generate-package-handler.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/handlers/generate-package/generate-package-handler' {
	export interface GeneratePackageOptions {
	    serviceName: string;
	}
	export interface GenerateContext {
	    dir: string;
	    deployedApp: any;
	    options: GeneratePackageOptions;
	}
	export interface GeneratePackageDevOptions extends GeneratePackageOptions {
	}
	export const generatePackageHandler: (options: GeneratePackageDevOptions) => Promise<void>;
	//# sourceMappingURL=generate-package-handler.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/cli/xtrem-x3-cli-dev/build/lib/commands/sub-commands/handlers/generate/generate-handler.d.ts
declare module '@sage/xtrem-x3-cli-dev/lib/commands/sub-commands/handlers/generate/generate-handler' {
	export interface GenerateOptions {
	    scopes?: string;
	    specificOnly?: boolean;
	    createMain?: boolean;
	    translations?: boolean;
	    serviceName: string;
	}
	export interface GenerateContext {
	    dir: string;
	    deployedApp: any;
	    options: GenerateOptions;
	}
	export interface GenerateDevOptions extends GenerateOptions {
	}
	export const generateHandler: (options: GenerateDevOptions) => Promise<void>;
	//# sourceMappingURL=generate-handler.d.ts.map
}
declare module '@sage/xtrem-x3-cli-dev' {
	export * from '@sage/xtrem-x3-cli-dev/index';
}
