/**
Use http://mikemcl.github.io/decimal.js/
https://github.com/MikeMcl/decimal.js
*/
import { Decimal } from './decimal-class';
export type Value = string | number | Decimal;
export type integer = number;
/**
 * Converts a value to a decimal (an instance of Decimal).
 *
 * The value may be a string, a number or a Decimal.
 * Only finite values are allowed. Special values like NaN and Infinity will throw an error.
 */
export declare function toDecimal(value: Value): Decimal;
/**
 * Converts a value to a number.
 *
 * The value may be a string, a number or a decimal (an instance of Decimal).
 * Only finite values are allowed. Special values like NaN and Infinity will throw an error.
 */
export declare function toNumber(value: Value): number;
/**
 * Converts a value to an integer.
 *
 * The value may be a string, a number or a decimal (an instance of Decimal).
 * Only integer values are allowed. Non-integer values like 1.5, NaN and Infinity will throw an error.
 */
export declare function toInteger(value: Value): integer;
export declare function newDecimal(s: string): Decimal;
export declare function add(a: any, b: any): any;
export declare function sub(a: any, b: any): number | import("decimal.js").default;
export declare function mul(a: any, b: any): number | import("decimal.js").default;
export declare function div(a: any, b: any): number | import("decimal.js").default;
export declare function compare(a: any, b: any): number | undefined;
export declare function eq(a: any, b: any): boolean;
export declare function strictEq(a: any, b: any): boolean;
export declare function ne(a: any, b: any): boolean;
export declare function strictNe(a: any, b: any): boolean;
export declare function lt(a: any, b: any): boolean;
export declare function lte(a: any, b: any): boolean;
export declare function gt(a: any, b: any): boolean;
export declare function gte(a: any, b: any): boolean;
export declare function negated(a: any): number | import("decimal.js").default;
export declare function plus(a: any): any;
export declare function abs(value: Value): Decimal | number;
export declare function ceil(value: Value): number;
export declare function floor(value: Value): number;
export declare function pow(base: Value, exponent: Value): Decimal | number;
export declare function max(...values: Value[]): Decimal | number;
export declare function min(...values: Value[]): Decimal | number;
export declare function round(value: Value): number;
export declare function sum(...values: Value[]): Decimal | number;
export declare function uselessFunctionV3(): void;
//# sourceMappingURL=types-lib.d.ts.map