"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Decimal = void 0;
/* eslint-disable no-console */
/**
Use http://mikemcl.github.io/decimal.js/
https://github.com/MikeMcl/decimal.js
*/
const decimal_js_1 = require("decimal.js");
class Decimal extends decimal_js_1.Decimal {
    static make(v) {
        return new Decimal(v);
    }
    static toNumber(v) {
        if (typeof v === 'number')
            return v;
        return v == null ? NaN : v.toNumber();
    }
    static roundAt(v, scale = 0) {
        if (scale === 0)
            return Decimal.make(v).round();
        const scaleFactor = 10 ** scale;
        // Method actually returns a Decimal object, but it is typed as decimal (number) because
        // our transpiler converts decimals (numbers) to Decimal objects.
        return Decimal.make(v).mul(scaleFactor).round().div(scaleFactor);
    }
}
exports.Decimal = Decimal;
//# sourceMappingURL=decimal-class.js.map