/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Tokenizer=void 0;const xtrem_core_1=require("@sage/xtrem-core"),operators=require("./operator"),token_1=require("./token");function _skipSpaces(e,t){for(;t<e.length&&" "===e[t];)t+=1;return t}function _isDigit(e){return/[0-9]/.test(e)}function _isLetter(e){return/[$a-zA-Z%']/.test(e)}function _isWordChar(e){return/[$a-zA-Z0-9_%']/.test(e)}const _literals={true:true,false:false,null:null};function _parseNumber(e,t,r,n){let o,s=r+1;for(;s<t.length&&_isDigit(t[s]);)s+=1;if(s<t.length&&"."===t[s]){for(s+=1;s<t.length&&_isDigit(t[s]);)s+=1;o=parseFloat(e.substring(r,s))}else o=parseInt(e.substring(r,s),10);return n.push(new token_1.Token("literal",e,r,s-r,o)),s}function _parseWord(e,t,r,n){let o=r+1;for(;o<t.length&&_isWordChar(t[o]);)o+=1;const s=t.substr(r,o-r),i=operators.operators.operators[s.toLowerCase()];if(null!=i)n.push(new token_1.Token("operator",e,r,o-r,i));else{const t=_literals[s];if(void 0!==t)n.push(new token_1.Token("literal",e,r,o-r,t));else n.push(new token_1.Token("identifier",e,r,o-r,s))}return o}function _parseQuotedString(e,t,r,n){const o=t[r];let s=r+1,i="";for(;s<t.length;){if(t[s]===o)if(s+=1,s===t.length||t[s]!==o)return n.push(new token_1.Token("literal",e,r,s-r,i)),s;i+=t[s],s+=1}throw new Error(`quoted string not terminated: ${e.substring(r)}`)}function _parseOperator(e,t,r,n){const o=operators.operators.operators[t];return n.push(new token_1.Token("operator",e,r,1,o)),r+1}function _parseDateTime(e,t,r,n){let o=r+1;for(;o<t.length&&"@"!==t[o];)o+=1;if(o===t.length)throw new Error(`date constant not terminated:${e.substring(r,e.length)}`);const s=t.substr(r+1,o-r-1),i=s.length>0?10===s.length?xtrem_core_1.date.parse(s):xtrem_core_1.datetime.parse(s):null;return n.push(new token_1.Token("literal",e,r,o+1-r,i)),o+1}class Tokenizer{static tokenize(e){const t=[];let r=0;for(;r<e.length;){r=_skipSpaces(e,r);const n=e[r];switch(n){case"@":r=_parseDateTime(e,e,r,t);break;case'"':case"'":r=_parseQuotedString(e,e,r,t);break;case".":case"-":case"+":case"(":case")":case",":r=_parseOperator(e,n,r,t);break;default:if(_isLetter(n))r=_parseWord(e,e,r,t);else if(_isDigit(n))r=_parseNumber(e,e,r,t);else throw new Error(`invalid character: ${e.substring(r)}`)}}return t}}exports.Tokenizer=Tokenizer;
//# sourceMappingURL=tokenizer.js.map