/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Parser=void 0;const expression_1=require("./expression"),operator_1=require("./operator"),tokenizer=require("./tokenizer"),_maxPrecedence=8,functions={concat:true,left:true,right:true,substring:true,lower:true,upper:true,replace:true,length:true,locate:true,lpad:true,rpad:true,trim:true,ascii:true,char:true,abs:true,sign:true,round:true,trunc:true,floor:true,ceil:true,pow:true,currentdate:true,currenttime:true,currenttimestamp:true,year:true,month:true,day:true,hour:true,minute:true,second:true,millisecond:true,tzhour:true,tzminute:true,dateadd:true,datesub:true,timestampadd:true,timestampsub:true};function _parseArguments(e,r,t,n){if(t[0]<e.length&&e[t[0]].matches(")"))return void(t[0]+=1);for(;t[0]<e.length;){const r=_parseExpression(e,t,_maxPrecedence);if(n.push(r),t[0]<e.length&&e[t[0]].matches(")"))return void(t[0]+=1);if(t[0]===e.length||!e[t[0]].matches(","))throw new Error(`invalid expression: expected ',' or ')' at ${e[t[0]].getRemainingText()}`);t[0]+=1}throw new Error(`invalid function call syntax: argument missing after ${r.getRemainingText()}`)}function _parseFunctionCall(e,r,t){if(t[0]+=1,!functions[r.value.toLowerCase()])throw new Error(`invalid function name: ${r.value}`);const n=new expression_1.Expression({expressionType:"function",value:r.value});return _parseArguments(e,r,t,n.children),n}function _parsePrefixOperator(e,r,t){let n;switch(r.code){case"-":case"not":return n=_parseExpression(e,t,1),new expression_1.Expression({operator:r,expression1:n});case"(":if(n=_parseExpression(e,t,r.precedence),t[0]===e.length||!e[t[0]].matches(")"))throw new Error(`invalid expression: expected ')' after ${e[t[0]-1].getRemainingText()}`);return t[0]+=1,n;default:throw new Error(`internal error: bad prefix operator ${r.code}`)}}function _parseTerm(e,r){if(r[0]===e.length)throw new Error("premature end of expression");const t=e[r[0]];switch(t.type){case"identifier":if(r[0]+=1,r[0]<e.length&&e[r[0]].matches("("))return _parseFunctionCall(e,t,r);return new expression_1.Expression({expressionType:"identifier",value:t.value});case"literal":return r[0]+=1,new expression_1.Expression({expressionType:"literal",value:t.value});case"operator":{const n=t.value;if(!n.isPrefix)throw new Error(`invalid expression: expected beginning of term at ${t.getRemainingText()}`);return r[0]+=1,_parsePrefixOperator(e,n,r)}default:throw new Error(`internal error: bad token type ${t.type}`)}}function _finishBetween(e,r,t,n){if(r[0]===e.length||!e[r[0]].matches("and"))throw new Error(`invalid expression: expected 'and' after ${e[r[0]-1].getRemainingText()}`);r[0]+=1;const i=_parseExpression(e,r,n);t.children.push(i)}function _parseExpression(e,r,t){let n=_parseTerm(e,r);for(;r[0]<e.length;){const i=e[r[0]],s=i.value instanceof operator_1.Operator?i.value:null;if(null==s||!s.isInfix||s.precedence>t)break;if(r[0]+=1,"in"===s.code){if(r[0]===e.length||!e[r[0]].matches("("))throw new Error(`invalid expression: '(' expected after ${i.getRemainingText()}`);r[0]+=1,n=new expression_1.Expression({operator:s,expression1:n}),_parseArguments(e,i,r,n.children)}else{const t=_parseExpression(e,r,s.precedence-1);if(n=new expression_1.Expression({operator:s,expression1:n,expression2:t}),"between"===s.code)_finishBetween(e,r,n,s.precedence)}if(!s.isAssociative&&s.precedence===t)return n}return n}class Parser{static parse(e){const r=tokenizer.Tokenizer.tokenize(e),t=[];t[0]=0;const n=_parseExpression(r,t,_maxPrecedence);if(t[0]!==r.length)throw new Error(`invalid expression: unexpected token at ${r[t[0]].getRemainingText()}`);return n}}exports.Parser=Parser;
//# sourceMappingURL=parser.js.map