/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.sdataToSql=exports.Converter=void 0;const xtrem_core_1=require("@sage/xtrem-core"),parser_1=require("./parser");function _quote(e){return`'${e.replaceAll("'","''")}'`}function find(e,r){if(null==e)throw new Error(`find error: container is null, key=${r}`);const t=e[r];if(null==t)throw new Error(`key not found: ${r}`);return t}class Converter{constructor(e){this.options=e||{}}_resolve(e){if("identifier"===e.type)e.property=this.options.columnNames?find(this.options.columnNames,e.value):e.value;else if(e.hasChildren()){let r="";if(e.children.forEach(e=>{this._resolve(e),r=r||e.property||""}),r&&"operator"===e.type)switch(e.value.code){case"and":case"or":break;default:e.property=r,e.children.forEach(e=>{if("literal"===e.type)e.property=r})}}}_convert(e){switch(e.type){case"identifier":return this.convertIdentifier(e);case"literal":return this._convertLiteral(e);case"operator":return this._convertOperator(e);case"function":return this.convertFunction(e);default:throw new Error(`internal error: expression type = ${e.type}`)}}_convertLiteral(e){const r=e.property&&this.options.mapLiteral?this.options.mapLiteral(e.property,e.value):e.value;if("string"==typeof r)return _quote(r);if("number"==typeof r)return`${r}`;if(xtrem_core_1.date.isDate(r))return _quote(r.format("YYYYMMDD"));throw new Error("unsupported data type "+typeof r)}_convertPrefix(e,r){return`(${r} ${this._convert(e.children[0])})`}_convertInfix(e,r){if("null"===e.children[1].value&&"literal"===e.children[1].type){const t="<>"===r?" NOT":"";return`(${this._convert(e.children[0])} IS${t} NULL)`}return`(${this._convert(e.children[0])} ${r} ${this._convert(e.children[1])})`}_convertBetween(e){return`(${this._convert(e.children[0])} BETWEEN ${this._convert(e.children[1])} AND ${this._convert(e.children[2])})`}_convertIn(e){return`(${this._convert(e.children[0])}${this._convertList(" IN ",e.children,1)})`}_convertList(e,r,t){const n=[];n.push(e),n.push("(");for(let e=t;e<r.length;e+=1){if(e>t)n.push(", ");n.push(this._convert(r[e]))}return n.push(")"),n.join("")}_convertOperator(e){const r=e.value;switch(r.code){case".":throw new Error(`unsupported operator ${r.text}`);case"-":return 1===e.children.length?this._convertPrefix(e,"-"):this._convertInfix(e,"-");case"in":return this._convertIn(e);case"like":return this._convertInfix(e,"LIKE");case"between":return this._convertBetween(e);default:return this._convertInfix(e,r.code.toUpperCase())}}convertIdentifier(e){return this.options.mapProperty?this.options.mapProperty(e.property):e.property}convertFunction(e){const r=e.value;return this._convertList(r.toUpperCase(),e.children,0)}toSql(e){if(null==e)return null;const r=parser_1.Parser.parse(e);if(!r?.isPredicate())throw new Error(`invalid where clause: not a predicate: ${e}`);return this._resolve(r),this._convert(r)}}function sdataToSql(e,r){return new Converter(r).toSql(e)}exports.Converter=Converter,exports.sdataToSql=sdataToSql;
//# sourceMappingURL=converter.js.map