declare module '@sage/x3-finance-api-partial' {
    import type {
        Account,
        AutomaticJournal,
        ChartOfAccounts,
        Dimension,
        DimensionType,
        EntryType,
        Journal,
        JournalEntryTransaction,
        Ledger,
        OpenItemInput,
        Package as SageX3FinanceData$Package,
        StockJournalDimensions,
        StockJournalDimensionsBinding,
        StockJournalDimensionsInput,
        StockJournalImportDimensions,
        StockJournalImportDimensionsBinding,
        StockJournalImportDimensionsInput,
    } from '@sage/x3-finance-data-api';
    import type {
        EarlyDiscountLateCharge,
        Package as SageX3InvoicingData$Package,
        PaymentMethod,
        Tax,
    } from '@sage/x3-invoicing-data-api';
    import type {
        Package as SageX3ManufacturingData$Package,
        StockJournalImportInput,
    } from '@sage/x3-manufacturing-data-api';
    import type {
        BusinessPartner,
        Currency,
        Package as SageX3MasterData$Package,
        Product,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        LicensePlateNumber,
        Location,
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        StockJournalInput,
        StockStatus,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Company,
        GenericPrintReport,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AnalyticalBalanceAmounts extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: string;
        site: string;
        fiscalYear: integer;
        account: string;
        businessPartner: string;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: string;
        debitAmountInLedgerCurrency: string;
        creditAmountInLedgerCurrency: string;
        debitAmountInCurrency: string;
        creditAmountInCurrency: string;
    }
    export interface AnalyticalBalanceAmountsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        ledgerTypeNumber?: GeneralLedgerTypes;
        company?: string;
        site?: string;
        fiscalYear?: integer | string;
        account?: string;
        businessPartner?: string;
        dimension1?: string;
        dimension2?: string;
        dimension3?: string;
        dimension4?: string;
        dimension5?: string;
        dimension6?: string;
        dimension7?: string;
        dimension8?: string;
        dimension9?: string;
        currency?: string;
        debitAmountInLedgerCurrency?: decimal | string;
        creditAmountInLedgerCurrency?: decimal | string;
        debitAmountInCurrency?: decimal | string;
        creditAmountInCurrency?: decimal | string;
    }
    export interface AnalyticalBalanceAmountsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: string;
        site: string;
        fiscalYear: integer;
        account: string;
        businessPartner: string;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: string;
        debitAmountInLedgerCurrency: string;
        creditAmountInLedgerCurrency: string;
        debitAmountInCurrency: string;
        creditAmountInCurrency: string;
    }
    export interface AnalyticalBalanceAmounts$Operations {
        query: QueryOperation<AnalyticalBalanceAmounts>;
        read: ReadOperation<AnalyticalBalanceAmounts>;
        aggregate: {
            read: AggregateReadOperation<AnalyticalBalanceAmounts>;
            query: AggregateQueryOperation<AnalyticalBalanceAmounts>;
        };
        getDefaults: GetDefaultsOperation<AnalyticalBalanceAmounts>;
    }
    export interface AnalyticalBalanceDimensionTypes extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: string;
        site: string;
        fiscalYear: integer;
        account: string;
        businessPartner: string;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: string;
        dimensionType: DimensionType;
    }
    export interface AnalyticalBalanceDimensionTypesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        ledgerTypeNumber?: GeneralLedgerTypes;
        company?: string;
        site?: string;
        fiscalYear?: integer | string;
        account?: string;
        businessPartner?: string;
        dimension1?: string;
        dimension2?: string;
        dimension3?: string;
        dimension4?: string;
        dimension5?: string;
        dimension6?: string;
        dimension7?: string;
        dimension8?: string;
        dimension9?: string;
        currency?: string;
        dimensionType?: string;
    }
    export interface AnalyticalBalanceDimensionTypesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: string;
        site: string;
        fiscalYear: integer;
        account: string;
        businessPartner: string;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: string;
        dimensionType: DimensionType;
    }
    export interface AnalyticalBalanceDimensionTypes$Lookups {
        dimensionType: QueryOperation<DimensionType>;
    }
    export interface AnalyticalBalanceDimensionTypes$Operations {
        query: QueryOperation<AnalyticalBalanceDimensionTypes>;
        read: ReadOperation<AnalyticalBalanceDimensionTypes>;
        aggregate: {
            read: AggregateReadOperation<AnalyticalBalanceDimensionTypes>;
            query: AggregateQueryOperation<AnalyticalBalanceDimensionTypes>;
        };
        lookups(
            dataOrId: string | { data: AnalyticalBalanceDimensionTypesInput },
        ): AnalyticalBalanceDimensionTypes$Lookups;
        getDefaults: GetDefaultsOperation<AnalyticalBalanceDimensionTypes>;
    }
    export interface AnalyticalBalance extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: Company;
        site: Site;
        fiscalYear: integer;
        account: Account;
        businessPartner: BusinessPartner;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: Currency;
        id: integer;
        ledger: Ledger;
        chartOfAccounts: ChartOfAccounts;
        ledgerCurrency: Currency;
        amounts: ClientCollection<AnalyticalBalanceAmounts>;
        dimensionTypes: ClientCollection<AnalyticalBalanceDimensionTypes>;
    }
    export interface AnalyticalBalanceInput extends ClientNodeInput {
        ledgerTypeNumber?: GeneralLedgerTypes;
        company?: string;
        site?: string;
        fiscalYear?: integer | string;
        account?: string;
        businessPartner?: string;
        dimension1?: string;
        dimension2?: string;
        dimension3?: string;
        dimension4?: string;
        dimension5?: string;
        dimension6?: string;
        dimension7?: string;
        dimension8?: string;
        dimension9?: string;
        currency?: string;
        id?: integer | string;
        ledger?: string;
        chartOfAccounts?: string;
        ledgerCurrency?: string;
        amounts?: Partial<AnalyticalBalanceAmountsInput>[];
        dimensionTypes?: Partial<AnalyticalBalanceDimensionTypesInput>[];
    }
    export interface AnalyticalBalanceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: Company;
        site: Site;
        fiscalYear: integer;
        account: Account;
        businessPartner: BusinessPartner;
        dimension1: string;
        dimension2: string;
        dimension3: string;
        dimension4: string;
        dimension5: string;
        dimension6: string;
        dimension7: string;
        dimension8: string;
        dimension9: string;
        currency: Currency;
        id: integer;
        ledger: Ledger;
        chartOfAccounts: ChartOfAccounts;
        ledgerCurrency: Currency;
        amounts: ClientCollection<AnalyticalBalanceAmountsBinding>;
        dimensionTypes: ClientCollection<AnalyticalBalanceDimensionTypesBinding>;
    }
    export interface AnalyticalBalance$Lookups {
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        account: QueryOperation<Account>;
        businessPartner: QueryOperation<BusinessPartner>;
        currency: QueryOperation<Currency>;
        ledger: QueryOperation<Ledger>;
        chartOfAccounts: QueryOperation<ChartOfAccounts>;
        ledgerCurrency: QueryOperation<Currency>;
    }
    export interface AnalyticalBalance$Operations {
        query: QueryOperation<AnalyticalBalance>;
        read: ReadOperation<AnalyticalBalance>;
        aggregate: {
            read: AggregateReadOperation<AnalyticalBalance>;
            query: AggregateQueryOperation<AnalyticalBalance>;
        };
        lookups(dataOrId: string | { data: AnalyticalBalanceInput }): AnalyticalBalance$Lookups;
        getDefaults: GetDefaultsOperation<AnalyticalBalance>;
    }
    export interface Balance extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: Company;
        site: Site;
        fiscalYear: integer;
        account: Account;
        businessPartner: BusinessPartner;
        currency: Currency;
        ledger: Ledger;
        chartOfAccounts: ChartOfAccounts;
        ledgerCurrency: Currency;
    }
    export interface BalanceInput extends ClientNodeInput {
        ledgerTypeNumber?: GeneralLedgerTypes;
        company?: string;
        site?: string;
        fiscalYear?: integer | string;
        account?: string;
        businessPartner?: string;
        currency?: string;
        ledger?: string;
        chartOfAccounts?: string;
        ledgerCurrency?: string;
    }
    export interface BalanceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        ledgerTypeNumber: GeneralLedgerTypes;
        company: Company;
        site: Site;
        fiscalYear: integer;
        account: Account;
        businessPartner: BusinessPartner;
        currency: Currency;
        ledger: Ledger;
        chartOfAccounts: ChartOfAccounts;
        ledgerCurrency: Currency;
    }
    export interface Balance$Lookups {
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        account: QueryOperation<Account>;
        businessPartner: QueryOperation<BusinessPartner>;
        currency: QueryOperation<Currency>;
        ledger: QueryOperation<Ledger>;
        chartOfAccounts: QueryOperation<ChartOfAccounts>;
        ledgerCurrency: QueryOperation<Currency>;
    }
    export interface Balance$Operations {
        query: QueryOperation<Balance>;
        read: ReadOperation<Balance>;
        aggregate: {
            read: AggregateReadOperation<Balance>;
            query: AggregateQueryOperation<Balance>;
        };
        lookups(dataOrId: string | { data: BalanceInput }): Balance$Lookups;
        getDefaults: GetDefaultsOperation<Balance>;
    }
    export interface FinancialCommitment extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        description: string;
    }
    export interface FinancialCommitmentInput extends ClientNodeInput {
        id?: string;
        description?: string;
    }
    export interface FinancialCommitmentBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        description: string;
    }
    export interface FinancialCommitment$Operations {
        query: QueryOperation<FinancialCommitment>;
        read: ReadOperation<FinancialCommitment>;
        aggregate: {
            read: AggregateReadOperation<FinancialCommitment>;
            query: AggregateQueryOperation<FinancialCommitment>;
        };
        getDefaults: GetDefaultsOperation<FinancialCommitment>;
    }
    export interface JournalEntryAnalyticalLineDimensions extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        journalEntryType: string;
        journalEntryLine: string;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        analyticalLineNumber: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface JournalEntryAnalyticalLineDimensionsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        journalEntryType?: string;
        journalEntryLine?: string;
        lineNumber?: integer | string;
        ledgerTypeNumber?: GeneralLedgerTypes;
        analyticalLineNumber?: integer | string;
        dimensionType?: string;
        dimension?: string;
    }
    export interface JournalEntryAnalyticalLineDimensionsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        journalEntryType: string;
        journalEntryLine: string;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        analyticalLineNumber: integer;
        dimensionType: DimensionType;
        dimension: Dimension;
    }
    export interface JournalEntryAnalyticalLineDimensions$Lookups {
        dimensionType: QueryOperation<DimensionType>;
        dimension: QueryOperation<Dimension>;
    }
    export interface JournalEntryAnalyticalLineDimensions$Operations {
        query: QueryOperation<JournalEntryAnalyticalLineDimensions>;
        read: ReadOperation<JournalEntryAnalyticalLineDimensions>;
        aggregate: {
            read: AggregateReadOperation<JournalEntryAnalyticalLineDimensions>;
            query: AggregateQueryOperation<JournalEntryAnalyticalLineDimensions>;
        };
        lookups(
            dataOrId: string | { data: JournalEntryAnalyticalLineDimensionsInput },
        ): JournalEntryAnalyticalLineDimensions$Lookups;
        getDefaults: GetDefaultsOperation<JournalEntryAnalyticalLineDimensions>;
    }
    export interface JournalEntryAnalyticalLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntryLine: JournalEntry;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        analyticalLineNumber: integer;
        site: Site;
        transactionAmount: string;
        quantity: string;
        dimensions: ClientCollection<JournalEntryAnalyticalLineDimensions>;
    }
    export interface JournalEntryAnalyticalLineInput extends ClientNodeInput {
        journalEntryType?: string;
        journalEntryLine?: string;
        lineNumber?: integer | string;
        ledgerTypeNumber?: GeneralLedgerTypes;
        analyticalLineNumber?: integer | string;
        site?: string;
        transactionAmount?: decimal | string;
        quantity?: decimal | string;
        dimensions?: Partial<JournalEntryAnalyticalLineDimensionsInput>[];
    }
    export interface JournalEntryAnalyticalLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntryLine: JournalEntry;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        analyticalLineNumber: integer;
        site: Site;
        transactionAmount: string;
        quantity: string;
        dimensions: ClientCollection<JournalEntryAnalyticalLineDimensionsBinding>;
    }
    export interface JournalEntryAnalyticalLine$Lookups {
        journalEntryType: QueryOperation<EntryType>;
        journalEntryLine: QueryOperation<JournalEntry>;
        site: QueryOperation<Site>;
    }
    export interface JournalEntryAnalyticalLine$Operations {
        query: QueryOperation<JournalEntryAnalyticalLine>;
        read: ReadOperation<JournalEntryAnalyticalLine>;
        aggregate: {
            read: AggregateReadOperation<JournalEntryAnalyticalLine>;
            query: AggregateQueryOperation<JournalEntryAnalyticalLine>;
        };
        lookups(dataOrId: string | { data: JournalEntryAnalyticalLineInput }): JournalEntryAnalyticalLine$Lookups;
        getDefaults: GetDefaultsOperation<JournalEntryAnalyticalLine>;
    }
    export interface JournalEntryLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntry: JournalEntry;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        site: Site;
        accountingDate: string;
        chartOfAccounts: ChartOfAccounts;
        controlAccount: string;
        account: Account;
        businessPartner: BusinessPartner;
        sign: integer;
        transactionCurrency: Currency;
        transactionAmount: string;
        ledgerCurrency: Currency;
        ledgerAmount: string;
        quantity: string;
        lineDescription: string;
        matchingCode: string;
        matchingDate: string;
        maximumMatchingDate: string;
        tax: Tax;
        analyticalLines: ClientCollection<JournalEntryAnalyticalLine>;
    }
    export interface JournalEntryLineInput extends ClientNodeInput {
        journalEntryType?: string;
        journalEntry?: string;
        lineNumber?: integer | string;
        ledgerTypeNumber?: GeneralLedgerTypes;
        site?: string;
        accountingDate?: string;
        chartOfAccounts?: string;
        controlAccount?: string;
        account?: string;
        businessPartner?: string;
        sign?: integer | string;
        transactionCurrency?: string;
        transactionAmount?: decimal | string;
        ledgerCurrency?: string;
        ledgerAmount?: decimal | string;
        quantity?: decimal | string;
        lineDescription?: string;
        matchingCode?: string;
        matchingDate?: string;
        maximumMatchingDate?: string;
        tax?: string;
        analyticalLines?: Partial<JournalEntryAnalyticalLineInput>[];
    }
    export interface JournalEntryLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntry: JournalEntry;
        lineNumber: integer;
        ledgerTypeNumber: GeneralLedgerTypes;
        site: Site;
        accountingDate: string;
        chartOfAccounts: ChartOfAccounts;
        controlAccount: string;
        account: Account;
        businessPartner: BusinessPartner;
        sign: integer;
        transactionCurrency: Currency;
        transactionAmount: string;
        ledgerCurrency: Currency;
        ledgerAmount: string;
        quantity: string;
        lineDescription: string;
        matchingCode: string;
        matchingDate: string;
        maximumMatchingDate: string;
        tax: Tax;
        analyticalLines: ClientCollection<JournalEntryAnalyticalLine>;
    }
    export interface JournalEntryLine$Lookups {
        journalEntryType: QueryOperation<EntryType>;
        journalEntry: QueryOperation<JournalEntry>;
        site: QueryOperation<Site>;
        chartOfAccounts: QueryOperation<ChartOfAccounts>;
        account: QueryOperation<Account>;
        businessPartner: QueryOperation<BusinessPartner>;
        transactionCurrency: QueryOperation<Currency>;
        ledgerCurrency: QueryOperation<Currency>;
        tax: QueryOperation<Tax>;
    }
    export interface JournalEntryLine$Operations {
        query: QueryOperation<JournalEntryLine>;
        read: ReadOperation<JournalEntryLine>;
        aggregate: {
            read: AggregateReadOperation<JournalEntryLine>;
            query: AggregateQueryOperation<JournalEntryLine>;
        };
        lookups(dataOrId: string | { data: JournalEntryLineInput }): JournalEntryLine$Lookups;
        getDefaults: GetDefaultsOperation<JournalEntryLine>;
    }
    export interface JournalEntry extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntryNumber: string;
        company: Company;
        site: Site;
        journal: Journal;
        accountingDate: string;
        journalEntryStatus: AccountingJournalStatus;
        journalEntryTransaction: JournalEntryTransaction;
        transactionCurrency: Currency;
        journalEntryLines: ClientCollection<JournalEntryLine>;
    }
    export interface JournalEntryInput extends ClientNodeInput {
        journalEntryType?: string;
        journalEntryNumber?: string;
        company?: string;
        site?: string;
        journal?: string;
        accountingDate?: string;
        journalEntryStatus?: AccountingJournalStatus;
        journalEntryTransaction?: string;
        transactionCurrency?: string;
        journalEntryLines?: Partial<JournalEntryLineInput>[];
    }
    export interface JournalEntryBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        journalEntryType: EntryType;
        journalEntryNumber: string;
        company: Company;
        site: Site;
        journal: Journal;
        accountingDate: string;
        journalEntryStatus: AccountingJournalStatus;
        journalEntryTransaction: JournalEntryTransaction;
        transactionCurrency: Currency;
        journalEntryLines: ClientCollection<JournalEntryLine>;
    }
    export interface JournalEntry$Lookups {
        journalEntryType: QueryOperation<EntryType>;
        company: QueryOperation<Company>;
        site: QueryOperation<Site>;
        journal: QueryOperation<Journal>;
        journalEntryTransaction: QueryOperation<JournalEntryTransaction>;
        transactionCurrency: QueryOperation<Currency>;
    }
    export interface JournalEntry$Operations {
        query: QueryOperation<JournalEntry>;
        read: ReadOperation<JournalEntry>;
        aggregate: {
            read: AggregateReadOperation<JournalEntry>;
            query: AggregateQueryOperation<JournalEntry>;
        };
        lookups(dataOrId: string | { data: JournalEntryInput }): JournalEntry$Lookups;
        getDefaults: GetDefaultsOperation<JournalEntry>;
    }
    export interface PrepaymentInvoice extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        date: string;
        site: Site;
    }
    export interface PrepaymentInvoiceInput extends ClientNodeInput {
        id?: string;
        date?: string;
        site?: string;
    }
    export interface PrepaymentInvoiceBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        date: string;
        site: Site;
    }
    export interface PrepaymentInvoice$Lookups {
        site: QueryOperation<Site>;
    }
    export interface PrepaymentInvoice$Operations {
        query: QueryOperation<PrepaymentInvoice>;
        read: ReadOperation<PrepaymentInvoice>;
        aggregate: {
            read: AggregateReadOperation<PrepaymentInvoice>;
            query: AggregateQueryOperation<PrepaymentInvoice>;
        };
        lookups(dataOrId: string | { data: PrepaymentInvoiceInput }): PrepaymentInvoice$Lookups;
        getDefaults: GetDefaultsOperation<PrepaymentInvoice>;
    }
    export interface StatementCreation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        businessPartner: BusinessPartner;
        company: Company;
    }
    export interface StatementCreationInput extends ClientNodeInput {
        id?: string;
        businessPartner?: string;
        company?: string;
    }
    export interface StatementCreationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        businessPartner: BusinessPartner;
        company: Company;
    }
    export interface StatementCreation$Lookups {
        businessPartner: QueryOperation<BusinessPartner>;
        company: QueryOperation<Company>;
    }
    export interface StatementCreation$Operations {
        query: QueryOperation<StatementCreation>;
        read: ReadOperation<StatementCreation>;
        aggregate: {
            read: AggregateReadOperation<StatementCreation>;
            query: AggregateQueryOperation<StatementCreation>;
        };
        lookups(dataOrId: string | { data: StatementCreationInput }): StatementCreation$Lookups;
        getDefaults: GetDefaultsOperation<StatementCreation>;
    }
    export interface OpenItemExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        documentType: EntryType;
        documentNumber: string;
        lineNumber: integer;
        openItemLineNumber: integer;
        journalEntryLineInternalNumber: integer;
        company: Company;
        site: Site;
        currency: Currency;
        controlAccount: string;
        businessPartner: BusinessPartner;
        businessPartnerType: BusinessPartnerType;
        payToOrPayByBusinessPartner: BusinessPartner;
        dueDate: string;
        paymentMethod: PaymentMethod;
        paymentType: OpenItemType;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        sign: integer;
        amountInCurrency: string;
        amountInCompanyCurrency: string;
        paidAmountInCurrency: string;
        paidAmountInCompanyCurrency: string;
        provisionalPaidAmountInCurrency: string;
        provisionalPaidAmountInCompanyCurrency: string;
        canBeReminded: boolean;
        reminderLevel: integer;
        reminderDate: string;
        dispute: MiscellaneousTable;
        paymentApprovalLevel: PaymentApprovalType;
        canBeIncludedInStatement: boolean;
        postedStatus: integer;
        deductedPrepaymentAmount: string;
        prepaymentAmountToDeduct: string;
        fiscalYear: integer;
        period: integer;
        prepaymentInvoiceIssueDate: string;
        isPrepaymentIssued: boolean;
        closedStatus: integer;
        paymentDate: string;
        uniqueNumber: string;
        statementNumber: StatementCreation;
    }
    export interface OpenItemInputExtension {
        documentType?: string;
        documentNumber?: string;
        lineNumber?: integer | string;
        openItemLineNumber?: integer | string;
        journalEntryLineInternalNumber?: integer | string;
        company?: string;
        site?: string;
        currency?: string;
        controlAccount?: string;
        businessPartner?: string;
        businessPartnerType?: BusinessPartnerType;
        payToOrPayByBusinessPartner?: string;
        dueDate?: string;
        paymentMethod?: string;
        paymentType?: OpenItemType;
        earlyDiscountOrLateCharge?: string;
        sign?: integer | string;
        amountInCurrency?: decimal | string;
        amountInCompanyCurrency?: decimal | string;
        paidAmountInCurrency?: decimal | string;
        paidAmountInCompanyCurrency?: decimal | string;
        provisionalPaidAmountInCurrency?: decimal | string;
        provisionalPaidAmountInCompanyCurrency?: decimal | string;
        canBeReminded?: boolean | string;
        reminderLevel?: integer | string;
        reminderDate?: string;
        dispute?: string;
        paymentApprovalLevel?: PaymentApprovalType;
        canBeIncludedInStatement?: boolean | string;
        postedStatus?: integer | string;
        deductedPrepaymentAmount?: decimal | string;
        prepaymentAmountToDeduct?: decimal | string;
        fiscalYear?: integer | string;
        period?: integer | string;
        prepaymentInvoiceIssueDate?: string;
        isPrepaymentIssued?: boolean | string;
        closedStatus?: integer | string;
        paymentDate?: string;
        uniqueNumber?: string;
        statementNumber?: string;
    }
    export interface OpenItemBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        documentType: EntryType;
        documentNumber: string;
        lineNumber: integer;
        openItemLineNumber: integer;
        journalEntryLineInternalNumber: integer;
        company: Company;
        site: Site;
        currency: Currency;
        controlAccount: string;
        businessPartner: BusinessPartner;
        businessPartnerType: BusinessPartnerType;
        payToOrPayByBusinessPartner: BusinessPartner;
        dueDate: string;
        paymentMethod: PaymentMethod;
        paymentType: OpenItemType;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        sign: integer;
        amountInCurrency: string;
        amountInCompanyCurrency: string;
        paidAmountInCurrency: string;
        paidAmountInCompanyCurrency: string;
        provisionalPaidAmountInCurrency: string;
        provisionalPaidAmountInCompanyCurrency: string;
        canBeReminded: boolean;
        reminderLevel: integer;
        reminderDate: string;
        dispute: MiscellaneousTable;
        paymentApprovalLevel: PaymentApprovalType;
        canBeIncludedInStatement: boolean;
        postedStatus: integer;
        deductedPrepaymentAmount: string;
        prepaymentAmountToDeduct: string;
        fiscalYear: integer;
        period: integer;
        prepaymentInvoiceIssueDate: string;
        isPrepaymentIssued: boolean;
        closedStatus: integer;
        paymentDate: string;
        uniqueNumber: string;
        statementNumber: StatementCreation;
    }
    export interface OpenItemExtension$Lookups {
        statementNumber: QueryOperation<StatementCreation>;
    }
    export interface OpenItemExtension$Operations {
        lookups(dataOrId: string | { data: OpenItemInput }): OpenItemExtension$Lookups;
    }
    export interface StockJournalExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
        stockAutomaticJournal: AutomaticJournal;
        journalEntryDocumentType: string;
        dimensions: ClientCollection<StockJournalDimensions>;
        journalEntryDocument: JournalEntry;
    }
    export interface StockJournalInputExtension {
        stockSite?: string;
        isUpdated?: boolean | string;
        product?: string;
        effectiveDate?: string;
        sequence?: integer | string;
        index?: integer | string;
        fifoDate?: string;
        fifoTime?: string;
        fifoTier?: decimal | string;
        owner?: string;
        lot?: string;
        sublot?: string;
        supplierLot?: string;
        location?: string;
        warehouse?: string;
        serialNumber?: string;
        transactionType?: StockTransactionType;
        stockMovementGroup?: string;
        movementDescription?: string;
        project?: string;
        businessPartner?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        documentTypeOriginal?: EntryTypeEnum;
        documentIdOriginal?: string;
        documentLineOriginal?: integer | string;
        documentSequenceOriginal?: integer | string;
        adjustementType?: EntryTypeEnum;
        adjustementDocumentId?: string;
        adjustementDocumentLineId?: integer | string;
        lotCustomField1?: string;
        lotCustomField2?: string;
        lotCustomField3?: decimal | string;
        lotCustomField4?: string;
        packingUnit?: string;
        quantityInPackingUnit?: decimal | string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        orginialPackingUnit?: string;
        originalPackingUnitToStockUnitConversionFactor?: decimal | string;
        orderAmount?: decimal | string;
        movementValue?: decimal | string;
        orderVariance?: decimal | string;
        movementVariance?: decimal | string;
        orderCost?: decimal | string;
        valuedCost?: decimal | string;
        costSource?: CostSource;
        secondaryMovementValue?: decimal | string;
        secondaryMovementVariance?: decimal | string;
        secondaryValuedCost?: decimal | string;
        secondaryCostSource?: CostSource;
        isAdjusted?: boolean | string;
        varianceNotAbsorbed?: decimal | string;
        secondaryVarianceNotAbsorbed?: decimal | string;
        expirationDate?: string;
        status?: string;
        potency?: decimal | string;
        internationalUnitPotency?: decimal | string;
        activQuantity?: decimal | string;
        qualityAnalysisRequestId?: string;
        isPrinted?: boolean | string;
        isAdjustedMovement?: boolean | string;
        labelFormat?: string;
        numberOfLabels?: integer | string;
        financialSite?: string;
        hasStockInterfacePosted?: boolean | string;
        hasStockAccountingPosted?: boolean | string;
        hasStockAccountingPostedSecondary?: boolean | string;
        identifier1?: string;
        identifier2?: string;
        intercompany?: boolean | string;
        useByDate?: string;
        recontrolDate?: string;
        accountingDate?: string;
        majorVersion?: string;
        minorVersion?: string;
        startingSerialNumber?: string;
        stockCustomField1?: string;
        endingSerialNumber?: string;
        stockCustomField2?: string;
        licensePlateNumber?: string;
        stockAutomaticJournal?: string;
        journalEntryDocumentType?: string;
        dimensions?: Partial<StockJournalDimensionsInput>[];
        journalEntryDocument?: string;
    }
    export interface StockJournalBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
        stockAutomaticJournal: AutomaticJournal;
        journalEntryDocumentType: string;
        dimensions: ClientCollection<StockJournalDimensionsBinding>;
        journalEntryDocument: JournalEntry;
    }
    export interface StockJournalExtension$Lookups {
        journalEntryDocument: QueryOperation<JournalEntry>;
    }
    export interface StockJournalExtension$Operations {
        lookups(dataOrId: string | { data: StockJournalInput }): StockJournalExtension$Lookups;
    }
    export interface StockJournalImportExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
        stockAutomaticJournal: AutomaticJournal;
        journalEntryDocumentType: string;
        dimensions: ClientCollection<StockJournalImportDimensions>;
        journalEntryDocument: JournalEntry;
    }
    export interface StockJournalImportInputExtension {
        stockSite?: string;
        isUpdated?: boolean | string;
        product?: string;
        effectiveDate?: string;
        sequence?: integer | string;
        index?: integer | string;
        fifoDate?: string;
        fifoTime?: string;
        fifoTier?: decimal | string;
        owner?: string;
        lot?: string;
        sublot?: string;
        supplierLot?: string;
        location?: string;
        warehouse?: string;
        serialNumber?: string;
        transactionType?: StockTransactionType;
        stockMovementGroup?: string;
        movementDescription?: string;
        project?: string;
        businessPartner?: string;
        documentType?: EntryTypeEnum;
        documentId?: string;
        documentLine?: integer | string;
        documentTypeOriginal?: EntryTypeEnum;
        documentIdOriginal?: string;
        documentLineOriginal?: integer | string;
        documentSequenceOriginal?: integer | string;
        adjustementType?: EntryTypeEnum;
        adjustementDocumentId?: string;
        adjustementDocumentLineId?: integer | string;
        lotCustomField1?: string;
        lotCustomField2?: string;
        lotCustomField3?: decimal | string;
        lotCustomField4?: string;
        packingUnit?: string;
        quantityInPackingUnit?: decimal | string;
        packingUnitToStockUnitConversionFactor?: decimal | string;
        quantityInStockUnit?: decimal | string;
        stockUnit?: string;
        orginialPackingUnit?: string;
        originalPackingUnitToStockUnitConversionFactor?: decimal | string;
        orderAmount?: decimal | string;
        movementValue?: decimal | string;
        orderVariance?: decimal | string;
        movementVariance?: decimal | string;
        orderCost?: decimal | string;
        valuedCost?: decimal | string;
        costSource?: CostSource;
        secondaryMovementValue?: decimal | string;
        secondaryMovementVariance?: decimal | string;
        secondaryValuedCost?: decimal | string;
        secondaryCostSource?: CostSource;
        isAdjusted?: boolean | string;
        varianceNotAbsorbed?: decimal | string;
        secondaryVarianceNotAbsorbed?: decimal | string;
        expirationDate?: string;
        status?: string;
        potency?: decimal | string;
        internationalUnitPotency?: decimal | string;
        activQuantity?: decimal | string;
        qualityAnalysisRequestId?: string;
        isPrinted?: boolean | string;
        isAdjustedMovement?: boolean | string;
        labelFormat?: string;
        numberOfLabels?: integer | string;
        financialSite?: string;
        hasStockInterfacePosted?: boolean | string;
        hasStockAccountingPosted?: boolean | string;
        hasStockAccountingPostedSecondary?: boolean | string;
        identifier1?: string;
        identifier2?: string;
        intercompany?: boolean | string;
        useByDate?: string;
        recontrolDate?: string;
        accountingDate?: string;
        majorVersion?: string;
        minorVersion?: string;
        startingSerialNumber?: string;
        stockCustomField1?: string;
        endingSerialNumber?: string;
        stockCustomField2?: string;
        licensePlateNumber?: string;
        expirationDateString?: string;
        stockAutomaticJournal?: string;
        journalEntryDocumentType?: string;
        dimensions?: Partial<StockJournalImportDimensionsInput>[];
        journalEntryDocument?: string;
    }
    export interface StockJournalImportBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        isUpdated: boolean;
        product: Product;
        effectiveDate: string;
        sequence: integer;
        index: integer;
        fifoDate: string;
        fifoTime: string;
        fifoTier: string;
        owner: string;
        lot: string;
        sublot: string;
        supplierLot: string;
        location: Location;
        warehouse: Warehouse;
        serialNumber: string;
        transactionType: StockTransactionType;
        stockMovementGroup: MiscellaneousTable;
        movementDescription: string;
        project: ProjectLink;
        businessPartner: BusinessPartner;
        documentType: EntryTypeEnum;
        documentId: string;
        documentLine: integer;
        documentTypeOriginal: EntryTypeEnum;
        documentIdOriginal: string;
        documentLineOriginal: integer;
        documentSequenceOriginal: integer;
        adjustementType: EntryTypeEnum;
        adjustementDocumentId: string;
        adjustementDocumentLineId: integer;
        lotCustomField1: string;
        lotCustomField2: string;
        lotCustomField3: string;
        lotCustomField4: string;
        packingUnit: UnitOfMeasure;
        quantityInPackingUnit: string;
        packingUnitToStockUnitConversionFactor: string;
        quantityInStockUnit: string;
        stockUnit: UnitOfMeasure;
        orginialPackingUnit: UnitOfMeasure;
        originalPackingUnitToStockUnitConversionFactor: string;
        orderAmount: string;
        movementValue: string;
        orderVariance: string;
        movementVariance: string;
        orderCost: string;
        valuedCost: string;
        costSource: CostSource;
        secondaryMovementValue: string;
        secondaryMovementVariance: string;
        secondaryValuedCost: string;
        secondaryCostSource: CostSource;
        isAdjusted: boolean;
        varianceNotAbsorbed: string;
        secondaryVarianceNotAbsorbed: string;
        expirationDate: string;
        status: StockStatus;
        potency: string;
        internationalUnitPotency: string;
        activQuantity: string;
        qualityAnalysisRequestId: string;
        isPrinted: boolean;
        isAdjustedMovement: boolean;
        labelFormat: GenericPrintReport;
        numberOfLabels: integer;
        financialSite: Site;
        hasStockInterfacePosted: boolean;
        hasStockAccountingPosted: boolean;
        hasStockAccountingPostedSecondary: boolean;
        identifier1: string;
        identifier2: string;
        intercompany: boolean;
        useByDate: string;
        recontrolDate: string;
        accountingDate: string;
        majorVersion: MajorVersionStatus;
        minorVersion: string;
        startingSerialNumber: string;
        stockCustomField1: string;
        endingSerialNumber: string;
        stockCustomField2: string;
        licensePlateNumber: LicensePlateNumber;
        expirationDateString: string;
        stockAutomaticJournal: AutomaticJournal;
        journalEntryDocumentType: string;
        dimensions: ClientCollection<StockJournalImportDimensionsBinding>;
        journalEntryDocument: JournalEntry;
    }
    export interface StockJournalImportExtension$Lookups {
        journalEntryDocument: QueryOperation<JournalEntry>;
    }
    export interface StockJournalImportExtension$Operations {
        lookups(dataOrId: string | { data: StockJournalImportInput }): StockJournalImportExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-finance/AnalyticalBalanceAmounts': AnalyticalBalanceAmounts$Operations;
        '@sage/x3-finance/AnalyticalBalanceDimensionTypes': AnalyticalBalanceDimensionTypes$Operations;
        '@sage/x3-finance/AnalyticalBalance': AnalyticalBalance$Operations;
        '@sage/x3-finance/Balance': Balance$Operations;
        '@sage/x3-finance/FinancialCommitment': FinancialCommitment$Operations;
        '@sage/x3-finance/JournalEntryAnalyticalLineDimensions': JournalEntryAnalyticalLineDimensions$Operations;
        '@sage/x3-finance/JournalEntryAnalyticalLine': JournalEntryAnalyticalLine$Operations;
        '@sage/x3-finance/JournalEntryLine': JournalEntryLine$Operations;
        '@sage/x3-finance/JournalEntry': JournalEntry$Operations;
        '@sage/x3-finance/PrepaymentInvoice': PrepaymentInvoice$Operations;
        '@sage/x3-finance/StatementCreation': StatementCreation$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-finance-api' {
    export type * from '@sage/x3-finance-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-finance-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-finance-data-api-partial' {
    import type {
        OpenItemBindingExtension,
        OpenItemExtension,
        OpenItemExtension$Lookups,
        OpenItemExtension$Operations,
        OpenItemInputExtension,
    } from '@sage/x3-finance-api';
    export interface OpenItem extends OpenItemExtension {}
    export interface OpenItemBinding extends OpenItemBindingExtension {}
    export interface OpenItemInput extends OpenItemInputExtension {}
    export interface OpenItem$Lookups extends OpenItemExtension$Lookups {}
    export interface OpenItem$Operations extends OpenItemExtension$Operations {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type {
        StockJournalBindingExtension,
        StockJournalExtension,
        StockJournalExtension$Lookups,
        StockJournalExtension$Operations,
        StockJournalInputExtension,
    } from '@sage/x3-finance-api';
    export interface StockJournal extends StockJournalExtension {}
    export interface StockJournalBinding extends StockJournalBindingExtension {}
    export interface StockJournalInput extends StockJournalInputExtension {}
    export interface StockJournal$Lookups extends StockJournalExtension$Lookups {}
    export interface StockJournal$Operations extends StockJournalExtension$Operations {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type {
        StockJournalImportBindingExtension,
        StockJournalImportExtension,
        StockJournalImportExtension$Lookups,
        StockJournalImportExtension$Operations,
        StockJournalImportInputExtension,
    } from '@sage/x3-finance-api';
    export interface StockJournalImport extends StockJournalImportExtension {}
    export interface StockJournalImportBinding extends StockJournalImportBindingExtension {}
    export interface StockJournalImportInput extends StockJournalImportInputExtension {}
    export interface StockJournalImport$Lookups extends StockJournalImportExtension$Lookups {}
    export interface StockJournalImport$Operations extends StockJournalImportExtension$Operations {}
}
