/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3PackageManager=void 0;const xtrem_decimal_1=require("@sage/xtrem-decimal"),typesLib=xtrem_decimal_1,xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_x3_gateway_1=require("@sage/xtrem-x3-gateway"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),logger=xtrem_core_1.Logger.getLogger(__filename,"package-manager");class X3PackageManager extends xtrem_core_1.PackageManager{constructor(e){super(e),this.application=e,process.env.XTREM_USE_MULTI_WORKER=String(typesLib.strictNe(xtrem_core_1.ConfigManager.current.x3?.development?.multiWorkerServiceDisabled,true))}static async getPackageEtag(e){const a=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),t=`SELECT MAX(UPDDATTIM_0) MAX_UPDDATTIM  FROM ${xtrem_x3_gateway_1.FolderManager.getFolderName({context:e})}.APACKAGE`,r=await a.execute(t);if(r.length)return r[0].MAX_UPDDATTIM;return}static async verifyPackageEtag(e){const a=await X3PackageManager.getPackageEtag(e);if(typesLib.eq(X3PackageManager.packageEtag,null))return X3PackageManager.packageEtag=a,true;const t=typesLib.strictEq(X3PackageManager.packageEtag?.getTime(),a?.getTime());return logger.debug(()=>`Package etag verification from DB: ${t}`),logger.debug(()=>`Package etag verification stored: ${a}`),X3PackageManager.packageEtag=a,t}static async verifyPackageCache(e){const a=new Date;if(X3PackageManager.lastCacheCheck=X3PackageManager.lastCacheCheck||a,typesLib.lt(typesLib.sub(a.getTime(),X3PackageManager.lastCacheCheck.getTime()),3e4))return;if(X3PackageManager.lastCacheCheck=a,!await X3PackageManager.verifyPackageEtag(e))logger.debug(()=>"Package cache invalidation."),await e.invalidateCachedCategory("Package")}async getActivePackageNames(e){await X3PackageManager.verifyPackageCache(e);const a=xtrem_x3_gateway_1.FolderManager.getFolderName({context:e}),t=`${a}/ACTIVE_PACKAGES`;return e.getCachedValue({category:"Package",key:t,getValue:async()=>{const t=await xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e).tableExists("APACKAGE",a),r=typesLib.strictEq(e.configuration.deploymentMode,"development");if(!t||typesLib.strictEq(this.application.mainPackage.name,"@sage/xtrem-x3-main")||r&&this.application.mainPackage.dir.includes("/x3/"))return{value:this.application.getPackages().map(e=>e.name)};const g=`SELECT APACK_0 AS PACKAGE_NAME, ENAFLG_0 IS_ACTIVE  FROM ${a}.APACKAGE WHERE ENAFLG_0=2`;return{value:(await xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e).execute(g)).filter(e=>typesLib.strictEq(parseInt(e.IS_ACTIVE,10),2)).map(e=>e.PACKAGE_NAME)}},cacheInMemory:true,ttlInSeconds:3600})}getCurrentVersion(e,a){return Promise.resolve(e.version)}validatePackageVersions(){return Promise.resolve()}createSqlSchemaAndTables(){throw new xtrem_shared_1.LogicError("X3 schema is not managed (createSqlSchemaAndTables)")}ensureSchemaExists(){throw new xtrem_shared_1.LogicError("X3 schema is not managed (ensureSchemaExists)")}createOrUpgradePackageAllocations(e,a){return Promise.resolve()}}exports.X3PackageManager=X3PackageManager;
//# sourceMappingURL=x3-package-manager.js.map