"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysMiscellaneousTables = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const x3SystemUtils = require("..");
const joins = {
    referenceJoins: {
        activityCode: {
            code: 'activityCode',
        },
        access: {
            access: 'access',
        },
        dependency: {
            glossaryId: 'dependency',
        },
    },
};
/** 4GL columnName: ATABTAB */
let SysMiscellaneousTables = class SysMiscellaneousTables extends xtrem_core_1.Node {
};
exports.SysMiscellaneousTables = SysMiscellaneousTables;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NUMTAB',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "glossaryId", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'NUMCAR',
        isStored: true,
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 5 }),
    })
], SysMiscellaneousTables.prototype, "tableNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'LNGDES',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SHODES',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'CODACT',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysActivityCode,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "activityCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'ACS',
        isStored: true,
        columnType: 'string',
        node: () => x3SystemUtils.nodes.SysAccess,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "access", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        columnName: 'MODULE',
        isStored: true,
        isNullable: true,
        dataType: () => x3SystemUtils.enums.sysModuleTableDataType,
    })
], SysMiscellaneousTables.prototype, "module", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        columnName: 'DEPNUM',
        isStored: true,
        columnType: 'integer',
        node: () => SysMiscellaneousTables,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "dependency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'LNGFLG',
        isStored: true,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "modifiableLength", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'LNG',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "length", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FLGSOC',
        isStored: true,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "companyFilter", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FLGLEG',
        isStored: true,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "filterLegislation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'FLGENA',
        isStored: true,
        isNullable: true,
    })
], SysMiscellaneousTables.prototype, "activeFlag", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ALPDES1',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "alpha1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODTYP1',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysMiscellaneousTables.prototype, "type1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SUP1',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "option1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'ALPDES2',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "alpha2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODTYP2',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysMiscellaneousTables.prototype, "type2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SUP2',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "option2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'NUMDES1',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "numeric1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODTYP3',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysMiscellaneousTables.prototype, "type3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SUP3',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "option3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'NUMDES2',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SysMiscellaneousTables.prototype, "numeric2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'CODTYP4',
        isStored: true,
        dataType: () => x3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SysMiscellaneousTables.prototype, "type4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        columnName: 'SUP4',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "option4", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        columnName: 'NBCOL',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "number", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        node: () => x3SystemUtils.nodes.SysMiscellaneousTablesColumns,
    })
], SysMiscellaneousTables.prototype, "columns", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        columnName: 'OBLLEG',
        isStored: true,
    })
], SysMiscellaneousTables.prototype, "legislationMandatory", void 0);
exports.SysMiscellaneousTables = SysMiscellaneousTables = __decorate([
    xtrem_core_1.decorators.node({
        tableName: 'ATABTAB',
        storage: 'external',
        canRead: true,
        canSearch: true,
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({ joins }),
        keyPropertyNames: ['glossaryId'],
        indexes: [
            {
                orderBy: {
                    glossaryId: 1,
                },
                isUnique: true,
            },
        ],
    })
], SysMiscellaneousTables);
//# sourceMappingURL=sys-miscellaneous-tables.js.map