// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/index.d.ts
declare module '@sage/x3-manufacturing-data/index' {
	export * from '@sage/x3-manufacturing-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/index.d.ts
declare module '@sage/x3-manufacturing-data/lib/index' {
	export * as enums from '@sage/x3-manufacturing-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-manufacturing-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-manufacturing-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-manufacturing-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-manufacturing-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/work-center.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/work-center' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, integer } from '@sage/xtrem-core';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	export class WorkCenter extends Node {
	    readonly code: Promise<string>;
	    readonly manufacturingSite: Reference<sageX3System.nodes.Site>;
	    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup>;
	    readonly costingDimension: Promise<string>;
	    readonly weeklyStructure: Reference<sageX3MasterData.nodes.WeeklyStructure>;
	    readonly efficiencyInPercentage: Promise<decimal | null>;
	    readonly shrinkageInPercentage: Promise<decimal | null>;
	    readonly numberOfResources: Promise<integer | null>;
	    readonly automaticClosingPercentage: Promise<decimal | null>;
	    readonly qualificationLevel: Promise<string>;
	    readonly totalExpectedTimeInHours: Promise<decimal | null>;
	    readonly totalTimeCompleteInHours: Promise<decimal | null>;
	    readonly isConstraint: Promise<boolean>;
	    readonly isRccp: Promise<boolean>;
	    readonly isRunDuringEmployeeBreak: Promise<boolean>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=work-center.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/work-center-group.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/work-center-group' {
	import { Node } from '@sage/xtrem-core';
	export class WorkCenterGroup extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=work-center-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/team.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/team' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	export class Team extends Node {
	    readonly teamId: Promise<integer | null>;
	    readonly description: Promise<string>;
	    readonly employeeShortDesignation: Promise<string>;
	    readonly teamType: Promise<sageX3MasterData.enums.EmployeeType>;
	    readonly userCode: Reference<sageX3System.nodes.User | null>;
	    readonly laborRate: Promise<decimal | null>;
	    readonly isActive: Promise<boolean>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly workCenter: Promise<string>;
	    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
	    readonly teamEmployees: Collection<sageX3ManufacturingData.nodes.TeamEmployee>;
	}
	//# sourceMappingURL=team.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/team-employee.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/team-employee' {
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	export class TeamEmployee extends Node {
	    readonly teamId: Reference<sageX3ManufacturingData.nodes.EmployeeId>;
	    readonly teamLine: Promise<integer>;
	    readonly employeeId: Reference<sageX3ManufacturingData.nodes.EmployeeId>;
	    readonly startDate: Promise<date | null>;
	}
	//# sourceMappingURL=team-employee.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/stock-journal-import.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/stock-journal-import' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
	export class StockJournalImport extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly isUpdated: Promise<boolean>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly sequence: Promise<integer | null>;
	    readonly index: Promise<integer | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly fifoTime: Promise<string>;
	    readonly fifoTier: Promise<decimal | null>;
	    readonly owner: Promise<string>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly supplierLot: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly serialNumber: Promise<string>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly movementDescription: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentId: Promise<string>;
	    readonly documentLine: Promise<integer | null>;
	    readonly documentTypeOriginal: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentIdOriginal: Promise<string>;
	    readonly documentLineOriginal: Promise<integer | null>;
	    readonly documentSequenceOriginal: Promise<integer | null>;
	    readonly adjustementType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly adjustementDocumentId: Promise<string>;
	    readonly adjustementDocumentLineId: Promise<integer | null>;
	    readonly lotCustomField1: Promise<string>;
	    readonly lotCustomField2: Promise<string>;
	    readonly lotCustomField3: Promise<decimal | null>;
	    readonly lotCustomField4: Promise<date | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly orginialPackingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly originalPackingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly orderAmount: Promise<decimal | null>;
	    readonly movementValue: Promise<decimal | null>;
	    readonly orderVariance: Promise<decimal | null>;
	    readonly movementVariance: Promise<decimal | null>;
	    readonly orderCost: Promise<decimal | null>;
	    readonly valuedCost: Promise<decimal | null>;
	    readonly costSource: Promise<sageX3StockData.enums.CostSource | null>;
	    readonly secondaryMovementValue: Promise<decimal | null>;
	    readonly secondaryMovementVariance: Promise<decimal | null>;
	    readonly secondaryValuedCost: Promise<decimal | null>;
	    readonly secondaryCostSource: Promise<sageX3StockData.enums.CostSource | null>;
	    readonly isAdjusted: Promise<boolean>;
	    readonly varianceNotAbsorbed: Promise<decimal | null>;
	    readonly secondaryVarianceNotAbsorbed: Promise<decimal | null>;
	    readonly expirationDate: Promise<date | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly potency: Promise<decimal | null>;
	    readonly internationalUnitPotency: Promise<decimal | null>;
	    readonly activQuantity: Promise<decimal | null>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly isPrinted: Promise<boolean>;
	    readonly isAdjustedMovement: Promise<boolean>;
	    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly numberOfLabels: Promise<integer | null>;
	    readonly financialSite: Reference<sageX3System.nodes.Site | null>;
	    readonly hasStockInterfacePosted: Promise<boolean>;
	    readonly hasStockAccountingPosted: Promise<boolean>;
	    readonly hasStockAccountingPostedSecondary: Promise<boolean>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly intercompany: Promise<boolean>;
	    readonly useByDate: Promise<date | null>;
	    readonly recontrolDate: Promise<date | null>;
	    readonly accountingDate: Promise<date | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly startingSerialNumber: Promise<string>;
	    readonly stockCustomField1: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly expirationDateString: Promise<string>;
	}
	//# sourceMappingURL=stock-journal-import.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/index' {
	export * from '@sage/x3-manufacturing-data/lib/nodes/assignment';
	export * from '@sage/x3-manufacturing-data/lib/nodes/employee-id';
	export * from '@sage/x3-manufacturing-data/lib/nodes/stock-journal-import';
	export * from '@sage/x3-manufacturing-data/lib/nodes/team-employee';
	export * from '@sage/x3-manufacturing-data/lib/nodes/team';
	export * from '@sage/x3-manufacturing-data/lib/nodes/work-center-group';
	export * from '@sage/x3-manufacturing-data/lib/nodes/work-center';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/employee-id.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/employee-id' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	export class EmployeeId extends Node {
	    readonly teamId: Promise<integer | null>;
	    readonly description: Promise<string>;
	    readonly employeeShortDesignation: Promise<string>;
	    readonly teamType: Promise<sageX3MasterData.enums.EmployeeType>;
	    readonly userCode: Reference<sageX3System.nodes.User | null>;
	    readonly laborRate: Promise<decimal | null>;
	    readonly isActive: Promise<boolean>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly workCenter: Promise<string>;
	    readonly workCenterGroup: Reference<sageX3ManufacturingData.nodes.WorkCenterGroup | null>;
	}
	//# sourceMappingURL=employee-id.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/nodes/assignment.d.ts
declare module '@sage/x3-manufacturing-data/lib/nodes/assignment' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	export class Assignment extends Node {
	    readonly _x3Auuid: Promise<string>;
	    readonly storageSite: Reference<sageX3System.nodes.Site>;
	    readonly product: Reference<sageX3MasterData.nodes.ProductSite>;
	    readonly requestType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly demandNumber: Promise<string>;
	    readonly demandLineNumber: Promise<integer | null>;
	    readonly demandSequence: Promise<integer | null>;
	    readonly demandOrderType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
	    readonly demandOrderStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly resourceType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly resourceNumber: Promise<string>;
	    readonly resourceLineNumber: Promise<integer | null>;
	    readonly resourceSequence: Promise<integer | null>;
	    readonly resourceOrderType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
	    readonly resourceOrderStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
	    readonly quantityAssigned: Promise<decimal | null>;
	}
	//# sourceMappingURL=assignment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/node-extensions/overhead-extension.d.ts
declare module '@sage/x3-manufacturing-data/lib/node-extensions/overhead-extension' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data/lib/index';
	import { NodeExtension } from '@sage/xtrem-core';
	export class OverheadExtension extends NodeExtension<sageX3StockData.nodes.Overhead> {
	    readonly calculationMethod: Promise<sageX3ManufacturingData.enums.OverheadCalculationMethod | null>;
	    readonly overheadApplicationMode: Promise<sageX3ManufacturingData.enums.OverheadApplicationMethod | null>;
	    readonly formulaBase: Promise<sageX3ManufacturingData.enums.BaseFormulaToCalculateCost | null>;
	}
	declare module '@sage/x3-stock-data/lib/nodes/overhead' {
	    interface Overhead extends OverheadExtension {
	    }
	}
	//# sourceMappingURL=overhead-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-manufacturing-data/lib/node-extensions/index' {
	export * from '@sage/x3-manufacturing-data/lib/node-extensions/overhead-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/workstation-type-long.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/workstation-type-long' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkstationTypeLongEnum {
	    machine = 1,
	    labor = 2,
	    subcontracting = 3
	}
	export interface WorkstationTypeLong$EnumInterface {
	    machine: 1;
	    labor: 2;
	    subcontracting: 3;
	}
	export type WorkstationTypeLong = keyof WorkstationTypeLong$EnumInterface;
	export const workstationTypeLongDatatype: X3EnumDataType<keyof WorkstationTypeLong$EnumInterface, unknown>;
	//# sourceMappingURL=workstation-type-long.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/workload-initialization.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/workload-initialization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkloadInitializationEnum {
	    loadInitialization = 1,
	    loadRecalculationPF = 2,
	    loadRecalculationSPF = 3
	}
	export interface WorkloadInitialization$EnumInterface {
	    loadInitialization: 1;
	    loadRecalculationPF: 2;
	    loadRecalculationSPF: 3;
	}
	export type WorkloadInitialization = keyof WorkloadInitialization$EnumInterface;
	export const workloadInitializationDatatype: X3EnumDataType<keyof WorkloadInitialization$EnumInterface, unknown>;
	//# sourceMappingURL=workload-initialization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderTypeEnum {
	    customerOrder = 1,
	    supplierOrder = 2,
	    subcontractedMaterial = 3,
	    subcontractedService = 4,
	    workOrder = 5,
	    materialRequirements = 6,
	    transferOrder = 7,
	    transferRequest = 8,
	    byProduct = 9,
	    miscellaneousRequests = 10,
	    miscellaneousResources = 11,
	    customerReservation = 12,
	    subcontractOrder = 13,
	    projectDemand = 14
	}
	export interface WorkOrderType$EnumInterface {
	    customerOrder: 1;
	    supplierOrder: 2;
	    subcontractedMaterial: 3;
	    subcontractedService: 4;
	    workOrder: 5;
	    materialRequirements: 6;
	    transferOrder: 7;
	    transferRequest: 8;
	    byProduct: 9;
	    miscellaneousRequests: 10;
	    miscellaneousResources: 11;
	    customerReservation: 12;
	    subcontractOrder: 13;
	    projectDemand: 14;
	}
	export type WorkOrderType = keyof WorkOrderType$EnumInterface;
	export const workOrderTypeDatatype: X3EnumDataType<keyof WorkOrderType$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderStatusEnum {
	    firm = 1,
	    closed = 2
	}
	export interface WorkOrderStatus$EnumInterface {
	    firm: 1;
	    closed: 2;
	}
	export type WorkOrderStatus = keyof WorkOrderStatus$EnumInterface;
	export const workOrderStatusDatatype: X3EnumDataType<keyof WorkOrderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-situation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-situation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderSituationEnum {
	    pending = 1,
	    beingOptimized = 2,
	    printed = 3,
	    inProgress = 4,
	    completed = 5,
	    closedCosted = 6
	}
	export interface WorkOrderSituation$EnumInterface {
	    pending: 1;
	    beingOptimized: 2;
	    printed: 3;
	    inProgress: 4;
	    completed: 5;
	    closedCosted: 6;
	}
	export type WorkOrderSituation = keyof WorkOrderSituation$EnumInterface;
	export const workOrderSituationDatatype: X3EnumDataType<keyof WorkOrderSituation$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-situation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-preparation-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-preparation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderPreparationStatusEnum {
	    notPrepared = 1,
	    partial = 2,
	    full = 3
	}
	export interface WorkOrderPreparationStatus$EnumInterface {
	    notPrepared: 1;
	    partial: 2;
	    full: 3;
	}
	export type WorkOrderPreparationStatus = keyof WorkOrderPreparationStatus$EnumInterface;
	export const workOrderPreparationStatusDatatype: X3EnumDataType<keyof WorkOrderPreparationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-preparation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-management-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderManagementModeEnum {
	    noChange = 1,
	    materialsChange = 2,
	    operationChange = 3,
	    changeMaterialsAndOperations = 4
	}
	export interface WorkOrderManagementMode$EnumInterface {
	    noChange: 1;
	    materialsChange: 2;
	    operationChange: 3;
	    changeMaterialsAndOperations: 4;
	}
	export type WorkOrderManagementMode = keyof WorkOrderManagementMode$EnumInterface;
	export const workOrderManagementModeDatatype: X3EnumDataType<keyof WorkOrderManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-allocation-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-allocation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderAllocationTypeEnum {
	    none = 1,
	    global = 2,
	    mixed = 3,
	    detailed = 4
	}
	export interface WorkOrderAllocationType$EnumInterface {
	    none: 1;
	    global: 2;
	    mixed: 3;
	    detailed: 4;
	}
	export type WorkOrderAllocationType = keyof WorkOrderAllocationType$EnumInterface;
	export const workOrderAllocationTypeDatatype: X3EnumDataType<keyof WorkOrderAllocationType$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-allocation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-order-allocation-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-order-allocation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkOrderAllocationStatusEnum {
	    notAllocated = 1,
	    partial = 2,
	    complete = 3,
	    partialShortage = 4,
	    completeShortage = 5
	}
	export interface WorkOrderAllocationStatus$EnumInterface {
	    notAllocated: 1;
	    partial: 2;
	    complete: 3;
	    partialShortage: 4;
	    completeShortage: 5;
	}
	export type WorkOrderAllocationStatus = keyof WorkOrderAllocationStatus$EnumInterface;
	export const workOrderAllocationStatusDatatype: X3EnumDataType<keyof WorkOrderAllocationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=work-order-allocation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-center-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-center-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkCenterTypeEnum {
	    machine = 1,
	    labour = 2,
	    subcontractor = 3
	}
	export interface WorkCenterType$EnumInterface {
	    machine: 1;
	    labour: 2;
	    subcontractor: 3;
	}
	export type WorkCenterType = keyof WorkCenterType$EnumInterface;
	export const workCenterTypeDatatype: X3EnumDataType<keyof WorkCenterType$EnumInterface, unknown>;
	//# sourceMappingURL=work-center-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-center-type-315.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-center-type-315' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkCenterType315Enum {
	    all = 1,
	    machine = 2,
	    labor = 3,
	    subcontracting = 4
	}
	export interface WorkCenterType315$EnumInterface {
	    all: 1;
	    machine: 2;
	    labor: 3;
	    subcontracting: 4;
	}
	export type WorkCenterType315 = keyof WorkCenterType315$EnumInterface;
	export const workCenterType315Datatype: X3EnumDataType<keyof WorkCenterType315$EnumInterface, unknown>;
	//# sourceMappingURL=work-center-type-315.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/work-center-type-2423.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/work-center-type-2423' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WorkCenterType2423Enum {
	    laborOnly = 1,
	    machineOnly = 2,
	    laborAndMachine = 3
	}
	export interface WorkCenterType2423$EnumInterface {
	    laborOnly: 1;
	    machineOnly: 2;
	    laborAndMachine: 3;
	}
	export type WorkCenterType2423 = keyof WorkCenterType2423$EnumInterface;
	export const workCenterType2423Datatype: X3EnumDataType<keyof WorkCenterType2423$EnumInterface, unknown>;
	//# sourceMappingURL=work-center-type-2423.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-wip-header.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-wip-header' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoWipHeaderEnum {
	    material = 1,
	    labor = 2,
	    machine = 3,
	    subcontract = 4,
	    overhead = 5,
	    totals = 6,
	    balance = 7,
	    actual = 8,
	    standard = 9,
	    reject = 10,
	    variance11 = 11,
	    variance = 12,
	    pcDetail = 13,
	    product = 14,
	    adjustment = 15,
	    materialCostDetail = 16,
	    laborCostDetail = 17,
	    machineCostDetail = 18,
	    subcontractorCostDetail = 19,
	    expenses = 20,
	    overheads = 21,
	    accountingJournal = 22,
	    standardCostLevel = 23,
	    updatedCostLevel = 24,
	    budgetCostLevel = 25,
	    simulatedCostLevel = 26
	}
	export interface WoWipHeader$EnumInterface {
	    material: 1;
	    labor: 2;
	    machine: 3;
	    subcontract: 4;
	    overhead: 5;
	    totals: 6;
	    balance: 7;
	    actual: 8;
	    standard: 9;
	    reject: 10;
	    variance11: 11;
	    variance: 12;
	    pcDetail: 13;
	    product: 14;
	    adjustment: 15;
	    materialCostDetail: 16;
	    laborCostDetail: 17;
	    machineCostDetail: 18;
	    subcontractorCostDetail: 19;
	    expenses: 20;
	    overheads: 21;
	    accountingJournal: 22;
	    standardCostLevel: 23;
	    updatedCostLevel: 24;
	    budgetCostLevel: 25;
	    simulatedCostLevel: 26;
	}
	export type WoWipHeader = keyof WoWipHeader$EnumInterface;
	export const woWipHeaderDatatype: X3EnumDataType<keyof WoWipHeader$EnumInterface, unknown>;
	//# sourceMappingURL=wo-wip-header.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-unforeseen-elements.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-unforeseen-elements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoUnforeseenElementsEnum {
	    ignore = 1,
	    keepUnforeseenElements = 2,
	    discardUnforeseenElements = 3
	}
	export interface WoUnforeseenElements$EnumInterface {
	    ignore: 1;
	    keepUnforeseenElements: 2;
	    discardUnforeseenElements: 3;
	}
	export type WoUnforeseenElements = keyof WoUnforeseenElements$EnumInterface;
	export const woUnforeseenElementsDatatype: X3EnumDataType<keyof WoUnforeseenElements$EnumInterface, unknown>;
	//# sourceMappingURL=wo-unforeseen-elements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-sort-order.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-sort-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoSortOrderEnum {
	    woN = 1,
	    woStartDate = 2,
	    woEndDate = 3
	}
	export interface WoSortOrder$EnumInterface {
	    woN: 1;
	    woStartDate: 2;
	    woEndDate: 3;
	}
	export type WoSortOrder = keyof WoSortOrder$EnumInterface;
	export const woSortOrderDatatype: X3EnumDataType<keyof WoSortOrder$EnumInterface, unknown>;
	//# sourceMappingURL=wo-sort-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-sort-order-2391.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-sort-order-2391' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoSortOrder2391Enum {
	    productionSiteWoN = 1,
	    productionSiteWoStartDate = 2,
	    productionSiteWoEndDate = 3,
	    woN = 4,
	    woStartDate = 5,
	    woEndDate = 6
	}
	export interface WoSortOrder2391$EnumInterface {
	    productionSiteWoN: 1;
	    productionSiteWoStartDate: 2;
	    productionSiteWoEndDate: 3;
	    woN: 4;
	    woStartDate: 5;
	    woEndDate: 6;
	}
	export type WoSortOrder2391 = keyof WoSortOrder2391$EnumInterface;
	export const woSortOrder2391Datatype: X3EnumDataType<keyof WoSortOrder2391$EnumInterface, unknown>;
	//# sourceMappingURL=wo-sort-order-2391.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-provisional-cost-calculation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-provisional-cost-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoProvisionalCostCalculationEnum {
	    no = 1,
	    inWoCreation = 2,
	    inWoCreationAndModification = 3
	}
	export interface WoProvisionalCostCalculation$EnumInterface {
	    no: 1;
	    inWoCreation: 2;
	    inWoCreationAndModification: 3;
	}
	export type WoProvisionalCostCalculation = keyof WoProvisionalCostCalculation$EnumInterface;
	export const woProvisionalCostCalculationDatatype: X3EnumDataType<keyof WoProvisionalCostCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=wo-provisional-cost-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wo-list-sort.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wo-list-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WoListSortEnum {
	    byWorkOrder = 1,
	    byWorkCenter = 2,
	    byProduct = 3,
	    byOrder = 4,
	    byProject = 5,
	    byComponent = 6
	}
	export interface WoListSort$EnumInterface {
	    byWorkOrder: 1;
	    byWorkCenter: 2;
	    byProduct: 3;
	    byOrder: 4;
	    byProject: 5;
	    byComponent: 6;
	}
	export type WoListSort = keyof WoListSort$EnumInterface;
	export const woListSortDatatype: X3EnumDataType<keyof WoListSort$EnumInterface, unknown>;
	//# sourceMappingURL=wo-list-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wip-valuation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wip-valuation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipValuationEnum {
	    notYetCosted = 1,
	    alreadyCosted = 2,
	    all = 3
	}
	export interface WipValuation$EnumInterface {
	    notYetCosted: 1;
	    alreadyCosted: 2;
	    all: 3;
	}
	export type WipValuation = keyof WipValuation$EnumInterface;
	export const wipValuationDatatype: X3EnumDataType<keyof WipValuation$EnumInterface, unknown>;
	//# sourceMappingURL=wip-valuation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wip-transaction-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wip-transaction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipTransactionTypeEnum {
	    materialCost = 1,
	    laborCost = 2,
	    machineCost = 3,
	    subcontractorCost = 4,
	    materialExpenses = 5,
	    laborExpenses = 6,
	    machineExpenses = 7,
	    subcontractorExpenses = 8,
	    materialVariance = 9,
	    laborVariance = 10,
	    machineVariance = 11,
	    subcontractorVariance = 12,
	    overheadVariance = 13,
	    productionStatement = 14,
	    wipBalance = 15,
	    operationReject = 16,
	    adjustment = 17,
	    closingTrackingWithoutWo = 18,
	    invoiceElement = 19,
	    invoiceElementVariance = 20
	}
	export interface WipTransactionType$EnumInterface {
	    materialCost: 1;
	    laborCost: 2;
	    machineCost: 3;
	    subcontractorCost: 4;
	    materialExpenses: 5;
	    laborExpenses: 6;
	    machineExpenses: 7;
	    subcontractorExpenses: 8;
	    materialVariance: 9;
	    laborVariance: 10;
	    machineVariance: 11;
	    subcontractorVariance: 12;
	    overheadVariance: 13;
	    productionStatement: 14;
	    wipBalance: 15;
	    operationReject: 16;
	    adjustment: 17;
	    closingTrackingWithoutWo: 18;
	    invoiceElement: 19;
	    invoiceElementVariance: 20;
	}
	export type WipTransactionType = keyof WipTransactionType$EnumInterface;
	export const wipTransactionTypeDatatype: X3EnumDataType<keyof WipTransactionType$EnumInterface, unknown>;
	//# sourceMappingURL=wip-transaction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wip-line-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wip-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipLineTypeEnum {
	    new = 1,
	    modified = 2,
	    deleted = 3
	}
	export interface WipLineType$EnumInterface {
	    new: 1;
	    modified: 2;
	    deleted: 3;
	}
	export type WipLineType = keyof WipLineType$EnumInterface;
	export const wipLineTypeDatatype: X3EnumDataType<keyof WipLineType$EnumInterface, unknown>;
	//# sourceMappingURL=wip-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/wip-choice.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/wip-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipChoiceEnum {
	    pcpNotCalculated = 1,
	    pcpCalculated = 2,
	    both = 3
	}
	export interface WipChoice$EnumInterface {
	    pcpNotCalculated: 1;
	    pcpCalculated: 2;
	    both: 3;
	}
	export type WipChoice = keyof WipChoice$EnumInterface;
	export const wipChoiceDatatype: X3EnumDataType<keyof WipChoice$EnumInterface, unknown>;
	//# sourceMappingURL=wip-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingEnum {
	    none = 1,
	    partial = 2,
	    complete = 3,
	    closePackaging = 4,
	    stockCount = 5
	}
	export interface Weighing$EnumInterface {
	    none: 1;
	    partial: 2;
	    complete: 3;
	    closePackaging: 4;
	    stockCount: 5;
	}
	export type Weighing = keyof Weighing$EnumInterface;
	export const weighingDatatype: X3EnumDataType<keyof Weighing$EnumInterface, unknown>;
	//# sourceMappingURL=weighing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing-status-wo-wof.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing-status-wo-wof' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingStatusWoWofEnum {
	    notWeighed = 1,
	    weighingInStationUnderProgress = 2,
	    weighingInStationCompleted = 3,
	    weighingInProductionUnderProgress = 4,
	    inProduction = 5,
	    endOfProduction = 6,
	    reconciliationControl = 7,
	    totalWeighingCompleted = 8,
	    orderBlockedForWeighing = 9,
	    orderBlockedForReconciliationControl = 10,
	    orderBlockedForProcessStartControl = 11
	}
	export interface WeighingStatusWoWof$EnumInterface {
	    notWeighed: 1;
	    weighingInStationUnderProgress: 2;
	    weighingInStationCompleted: 3;
	    weighingInProductionUnderProgress: 4;
	    inProduction: 5;
	    endOfProduction: 6;
	    reconciliationControl: 7;
	    totalWeighingCompleted: 8;
	    orderBlockedForWeighing: 9;
	    orderBlockedForReconciliationControl: 10;
	    orderBlockedForProcessStartControl: 11;
	}
	export type WeighingStatusWoWof = keyof WeighingStatusWoWof$EnumInterface;
	export const weighingStatusWoWofDatatype: X3EnumDataType<keyof WeighingStatusWoWof$EnumInterface, unknown>;
	//# sourceMappingURL=weighing-status-wo-wof.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing-status-material-mwf.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing-status-material-mwf' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingStatusMaterialMwfEnum {
	    notWeighed = 1,
	    inWeighingProcess = 2,
	    weighing = 3,
	    reconciliationControl = 4,
	    reconciled = 5,
	    processStartControl = 6,
	    processStarted = 7,
	    consumed = 8
	}
	export interface WeighingStatusMaterialMwf$EnumInterface {
	    notWeighed: 1;
	    inWeighingProcess: 2;
	    weighing: 3;
	    reconciliationControl: 4;
	    reconciled: 5;
	    processStartControl: 6;
	    processStarted: 7;
	    consumed: 8;
	}
	export type WeighingStatusMaterialMwf = keyof WeighingStatusMaterialMwf$EnumInterface;
	export const weighingStatusMaterialMwfDatatype: X3EnumDataType<keyof WeighingStatusMaterialMwf$EnumInterface, unknown>;
	//# sourceMappingURL=weighing-status-material-mwf.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing-station-messages.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing-station-messages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingStationMessagesEnum {
	    valveAlreadyProcessed = 1,
	    minimumRangeOrMaximumRange = 2,
	    maximumTareMaximumRange = 3,
	    elementAlreadyPresent = 4,
	    containerTypeShiSheetFilePackaging = 5,
	    sentenceDoesNotExistOrIsIncorrect = 6,
	    optional = 7,
	    mandatory = 8,
	    boxProcedure = 9,
	    phases = 10,
	    components = 11,
	    weighingHistory = 12,
	    reconciliationNotAllowed = 13,
	    beingReconciled = 14,
	    beingWeighed = 15,
	    elementDoesNotExist = 16,
	    someMaterialsAreNotWeighed = 17,
	    reconciliationStoppedForThePhaseYesValidateNoDelete = 18,
	    severalEntriesWithTheSameLotWeightMandatory = 19,
	    deletionOfAllTheReconciliationsOfThePhase = 20,
	    reconciliationOfThePhaseNotCompletedDeletingTheReconciliationsOfThePhase = 21,
	    reconciliationCompletedForThePhase = 22,
	    nonexistentTrackingTransactionParameterWeitrsnum = 23,
	    nonexistentTrackingCounter = 24,
	    inWeighingProcessMessage = 25,
	    orderNumberAlreadyReconciled = 26,
	    phaseAlreadyReconciled = 27,
	    aMaterialIsShortAndPreventsInclusionInTheWeighingPlan = 28,
	    cancellationWithoutReturn = 29,
	    cancellationWithReturn = 30,
	    confirmationOf1CancellationLine = 31,
	    woClosedWeighingCancellationNotAllowed = 32,
	    weighingAlreadyCanceled = 33,
	    incompatibilityBetweenPackagingAndWeighingMode = 34,
	    reOpenTheLine = 35,
	    endOfContainer = 36,
	    returnThisWoInTheWeighingPlan = 37,
	    reactivationOfTheWoInTheWeighingPlanCorrectlyDone = 38,
	    someExcludedMaterialsExistForThisOfContinue = 39,
	    rectification = 40,
	    codeInUseIsProhibitedAtThisPhase = 41,
	    weighingSelection = 42,
	    weighingNumberAleadyExistsOnTheLine = 43,
	    unableToCommit = 44,
	    orderNumberAlreadyCommitted = 45,
	    phaseAlreadyCommitted = 46,
	    commitmentCompletedForThePhase = 47,
	    commitmentNotCompletedForThePhaseDeletionOfTheCommitmentsForThePhase = 48,
	    deleteAllTheCommitmentsForThePhase = 49,
	    commitmentCompletedForThePhaseYesValidateNoDelete = 50,
	    underCommitment = 51,
	    numberOfMaterialsThatRemainToBeReconciled = 52,
	    numberOfMaterialsThatRemainToBeCommitted = 53,
	    workOrderNotReconciled = 54,
	    operationSelection = 55,
	    productSelection = 56,
	    theEntryBoxIsLinkedWithAWorkstationTheLaunchFromTheCurrentStationIsNotAuthorized = 57,
	    oneOrSeveralMaterialSAreNotReconciled = 58,
	    youNeedToUpdateYourApplicationClientToUseThisFunctionality = 59,
	    numberOfWeighings = 60,
	    greaterThanTheGridSize = 61,
	    cannotModifyWorkOrderBeingWeighed = 62,
	    materialAlreadyReconciledUnableToCancel = 63,
	    materialAlreadyCommittedUnableToCancel = 64,
	    cancellationCompleted = 65,
	    numberOfWeighingsStillToBeEntered = 66,
	    proceedWithTheCancellationYesProceedNoStop = 67,
	    cancellationStopped = 68,
	    unableToCancelTheCancellationMinimumLevelIsThePhaseTheValueOfParameterEngageHasToBeModified = 69,
	    woNotCommittedNoCancellationToBeProcessed = 70,
	    phaseNotCommittedNoCancellationToBeProcessed = 71,
	    resynchronizationOfFlagWeighingPlan = 72,
	    workOrderUpdate = 73,
	    processStartControlCompletedForTheWeighing = 74,
	    processStartControlCompletedForTheWeighingYesValidateNoDelete = 75,
	    weighingProcessStartControlNotCompletedDeletionOfTheWeighingProcessStartControl = 76,
	    processStartControlPerWeighingProcessingOfOneWeighingAtATime = 77,
	    reactivationComplete = 78,
	    reconciliationCompletedForTheContainer = 79,
	    containerAlreadyReconciled = 80,
	    reconciliationCompletedForTheWorkOrder = 81,
	    reconciliationStoppedForTheWorkOrderYesValidateNoDelete = 82,
	    reconciliationStoppedForTheContainerYesValidateNoDelete = 83,
	    deleteAllReconciliationsForThePhase = 84,
	    deleteAllReconciliationsForTheContainer = 85,
	    deleteAllReconciliationsForTheWorkOrder = 86,
	    reconciliationsDidNotCompleteDeletingReconciliations = 87,
	    containerAlreadyCommitted = 88,
	    weighingNumberAlreadyProcessed = 89,
	    weighNo = 90,
	    weighingOperator = 91,
	    unableToUncheckBomRecordAlreadyExistsForThisMasterContainer = 92,
	    unableToUncheckWoRecordAlreadyExistsForThisMasterContainer = 93
	}
	export interface WeighingStationMessages$EnumInterface {
	    valveAlreadyProcessed: 1;
	    minimumRangeOrMaximumRange: 2;
	    maximumTareMaximumRange: 3;
	    elementAlreadyPresent: 4;
	    containerTypeShiSheetFilePackaging: 5;
	    sentenceDoesNotExistOrIsIncorrect: 6;
	    optional: 7;
	    mandatory: 8;
	    boxProcedure: 9;
	    phases: 10;
	    components: 11;
	    weighingHistory: 12;
	    reconciliationNotAllowed: 13;
	    beingReconciled: 14;
	    beingWeighed: 15;
	    elementDoesNotExist: 16;
	    someMaterialsAreNotWeighed: 17;
	    reconciliationStoppedForThePhaseYesValidateNoDelete: 18;
	    severalEntriesWithTheSameLotWeightMandatory: 19;
	    deletionOfAllTheReconciliationsOfThePhase: 20;
	    reconciliationOfThePhaseNotCompletedDeletingTheReconciliationsOfThePhase: 21;
	    reconciliationCompletedForThePhase: 22;
	    nonexistentTrackingTransactionParameterWeitrsnum: 23;
	    nonexistentTrackingCounter: 24;
	    inWeighingProcessMessage: 25;
	    orderNumberAlreadyReconciled: 26;
	    phaseAlreadyReconciled: 27;
	    aMaterialIsShortAndPreventsInclusionInTheWeighingPlan: 28;
	    cancellationWithoutReturn: 29;
	    cancellationWithReturn: 30;
	    confirmationOf1CancellationLine: 31;
	    woClosedWeighingCancellationNotAllowed: 32;
	    weighingAlreadyCanceled: 33;
	    incompatibilityBetweenPackagingAndWeighingMode: 34;
	    reOpenTheLine: 35;
	    endOfContainer: 36;
	    returnThisWoInTheWeighingPlan: 37;
	    reactivationOfTheWoInTheWeighingPlanCorrectlyDone: 38;
	    someExcludedMaterialsExistForThisOfContinue: 39;
	    rectification: 40;
	    codeInUseIsProhibitedAtThisPhase: 41;
	    weighingSelection: 42;
	    weighingNumberAleadyExistsOnTheLine: 43;
	    unableToCommit: 44;
	    orderNumberAlreadyCommitted: 45;
	    phaseAlreadyCommitted: 46;
	    commitmentCompletedForThePhase: 47;
	    commitmentNotCompletedForThePhaseDeletionOfTheCommitmentsForThePhase: 48;
	    deleteAllTheCommitmentsForThePhase: 49;
	    commitmentCompletedForThePhaseYesValidateNoDelete: 50;
	    underCommitment: 51;
	    numberOfMaterialsThatRemainToBeReconciled: 52;
	    numberOfMaterialsThatRemainToBeCommitted: 53;
	    workOrderNotReconciled: 54;
	    operationSelection: 55;
	    productSelection: 56;
	    theEntryBoxIsLinkedWithAWorkstationTheLaunchFromTheCurrentStationIsNotAuthorized: 57;
	    oneOrSeveralMaterialSAreNotReconciled: 58;
	    youNeedToUpdateYourApplicationClientToUseThisFunctionality: 59;
	    numberOfWeighings: 60;
	    greaterThanTheGridSize: 61;
	    cannotModifyWorkOrderBeingWeighed: 62;
	    materialAlreadyReconciledUnableToCancel: 63;
	    materialAlreadyCommittedUnableToCancel: 64;
	    cancellationCompleted: 65;
	    numberOfWeighingsStillToBeEntered: 66;
	    proceedWithTheCancellationYesProceedNoStop: 67;
	    cancellationStopped: 68;
	    unableToCancelTheCancellationMinimumLevelIsThePhaseTheValueOfParameterEngageHasToBeModified: 69;
	    woNotCommittedNoCancellationToBeProcessed: 70;
	    phaseNotCommittedNoCancellationToBeProcessed: 71;
	    resynchronizationOfFlagWeighingPlan: 72;
	    workOrderUpdate: 73;
	    processStartControlCompletedForTheWeighing: 74;
	    processStartControlCompletedForTheWeighingYesValidateNoDelete: 75;
	    weighingProcessStartControlNotCompletedDeletionOfTheWeighingProcessStartControl: 76;
	    processStartControlPerWeighingProcessingOfOneWeighingAtATime: 77;
	    reactivationComplete: 78;
	    reconciliationCompletedForTheContainer: 79;
	    containerAlreadyReconciled: 80;
	    reconciliationCompletedForTheWorkOrder: 81;
	    reconciliationStoppedForTheWorkOrderYesValidateNoDelete: 82;
	    reconciliationStoppedForTheContainerYesValidateNoDelete: 83;
	    deleteAllReconciliationsForThePhase: 84;
	    deleteAllReconciliationsForTheContainer: 85;
	    deleteAllReconciliationsForTheWorkOrder: 86;
	    reconciliationsDidNotCompleteDeletingReconciliations: 87;
	    containerAlreadyCommitted: 88;
	    weighingNumberAlreadyProcessed: 89;
	    weighNo: 90;
	    weighingOperator: 91;
	    unableToUncheckBomRecordAlreadyExistsForThisMasterContainer: 92;
	    unableToUncheckWoRecordAlreadyExistsForThisMasterContainer: 93;
	}
	export type WeighingStationMessages = keyof WeighingStationMessages$EnumInterface;
	export const weighingStationMessagesDatatype: X3EnumDataType<keyof WeighingStationMessages$EnumInterface, unknown>;
	//# sourceMappingURL=weighing-station-messages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing-options.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing-options' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingOptionsEnum {
	    weighedByWorkOrder = 1,
	    weighedByProduct = 2,
	    weighedInProduction = 3
	}
	export interface WeighingOptions$EnumInterface {
	    weighedByWorkOrder: 1;
	    weighedByProduct: 2;
	    weighedInProduction: 3;
	}
	export type WeighingOptions = keyof WeighingOptions$EnumInterface;
	export const weighingOptionsDatatype: X3EnumDataType<keyof WeighingOptions$EnumInterface, unknown>;
	//# sourceMappingURL=weighing-options.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weighing-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weighing-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighingMethodEnum {
	    byVariance = 1,
	    accumulated = 2
	}
	export interface WeighingMethod$EnumInterface {
	    byVariance: 1;
	    accumulated: 2;
	}
	export type WeighingMethod = keyof WeighingMethod$EnumInterface;
	export const weighingMethodDatatype: X3EnumDataType<keyof WeighingMethod$EnumInterface, unknown>;
	//# sourceMappingURL=weighing-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/weigh-station-taken-into-acc.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/weigh-station-taken-into-acc' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WeighStationTakenIntoAccEnum {
	    no = 1,
	    toWeigh = 2,
	    weighingPlan = 3,
	    beingWeighed = 4,
	    weighed = 5,
	    reconciled = 6,
	    committed = 7,
	    weighingUnderProgressByProduct = 8
	}
	export interface WeighStationTakenIntoAcc$EnumInterface {
	    no: 1;
	    toWeigh: 2;
	    weighingPlan: 3;
	    beingWeighed: 4;
	    weighed: 5;
	    reconciled: 6;
	    committed: 7;
	    weighingUnderProgressByProduct: 8;
	}
	export type WeighStationTakenIntoAcc = keyof WeighStationTakenIntoAcc$EnumInterface;
	export const weighStationTakenIntoAccDatatype: X3EnumDataType<keyof WeighStationTakenIntoAcc$EnumInterface, unknown>;
	//# sourceMappingURL=weigh-station-taken-into-acc.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/variance-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/variance-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VarianceTypeEnum {
	    inPercentage = 1,
	    inAmount = 2
	}
	export interface VarianceType$EnumInterface {
	    inPercentage: 1;
	    inAmount: 2;
	}
	export type VarianceType = keyof VarianceType$EnumInterface;
	export const varianceTypeDatatype: X3EnumDataType<keyof VarianceType$EnumInterface, unknown>;
	//# sourceMappingURL=variance-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/variance-calculation-source.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/variance-calculation-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VarianceCalculationSourceEnum {
	    standard = 1,
	    workOrder = 2
	}
	export interface VarianceCalculationSource$EnumInterface {
	    standard: 1;
	    workOrder: 2;
	}
	export type VarianceCalculationSource = keyof VarianceCalculationSource$EnumInterface;
	export const varianceCalculationSourceDatatype: X3EnumDataType<keyof VarianceCalculationSource$EnumInterface, unknown>;
	//# sourceMappingURL=variance-calculation-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/user-role.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/user-role' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UserRoleEnum {
	    productionPlanner = 1,
	    planner = 2,
	    buyer = 3,
	    subcontractPlanner = 4
	}
	export interface UserRole$EnumInterface {
	    productionPlanner: 1;
	    planner: 2;
	    buyer: 3;
	    subcontractPlanner: 4;
	}
	export type UserRole = keyof UserRole$EnumInterface;
	export const userRoleDatatype: X3EnumDataType<keyof UserRole$EnumInterface, unknown>;
	//# sourceMappingURL=user-role.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/update.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/update' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UpdateEnum {
	    no = 1,
	    deferred = 2,
	    immediate = 3
	}
	export interface Update$EnumInterface {
	    no: 1;
	    deferred: 2;
	    immediate: 3;
	}
	export type Update = keyof Update$EnumInterface;
	export const updateDatatype: X3EnumDataType<keyof Update$EnumInterface, unknown>;
	//# sourceMappingURL=update.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-weighing.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-weighing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfWeighingEnum {
	    center = 1,
	    topRightCorner = 2,
	    topLeftCorner = 3,
	    bottomRightCorner = 4,
	    bottomLeftCorner = 5
	}
	export interface TypeOfWeighing$EnumInterface {
	    center: 1;
	    topRightCorner: 2;
	    topLeftCorner: 3;
	    bottomRightCorner: 4;
	    bottomLeftCorner: 5;
	}
	export type TypeOfWeighing = keyof TypeOfWeighing$EnumInterface;
	export const typeOfWeighingDatatype: X3EnumDataType<keyof TypeOfWeighing$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-weighing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-time.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-time' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfTimeEnum {
	    workOrder = 1,
	    product = 2,
	    miscellaneous = 3
	}
	export interface TypeOfTime$EnumInterface {
	    workOrder: 1;
	    product: 2;
	    miscellaneous: 3;
	}
	export type TypeOfTime = keyof TypeOfTime$EnumInterface;
	export const typeOfTimeDatatype: X3EnumDataType<keyof TypeOfTime$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-time.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-sentence.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-sentence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfSentenceEnum {
	    risk = 1,
	    security = 2,
	    environment = 3
	}
	export interface TypeOfSentence$EnumInterface {
	    risk: 1;
	    security: 2;
	    environment: 3;
	}
	export type TypeOfSentence = keyof TypeOfSentence$EnumInterface;
	export const typeOfSentenceDatatype: X3EnumDataType<keyof TypeOfSentence$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-sentence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-manufacturing-cost.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-manufacturing-cost' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfManufacturingCostEnum {
	    theoretical = 1,
	    release = 2,
	    expected = 3,
	    actual = 4,
	    realCostPriceForPlannedQuantity = 5,
	    provisionalProductionForAchievedQuantity = 6
	}
	export interface TypeOfManufacturingCost$EnumInterface {
	    theoretical: 1;
	    release: 2;
	    expected: 3;
	    actual: 4;
	    realCostPriceForPlannedQuantity: 5;
	    provisionalProductionForAchievedQuantity: 6;
	}
	export type TypeOfManufacturingCost = keyof TypeOfManufacturingCost$EnumInterface;
	export const typeOfManufacturingCostDatatype: X3EnumDataType<keyof TypeOfManufacturingCost$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-manufacturing-cost.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-container.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-container' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfContainerEnum {
	    internal = 1,
	    supplier = 2
	}
	export interface TypeOfContainer$EnumInterface {
	    internal: 1;
	    supplier: 2;
	}
	export type TypeOfContainer = keyof TypeOfContainer$EnumInterface;
	export const typeOfContainerDatatype: X3EnumDataType<keyof TypeOfContainer$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-container.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/type-of-allocation-349.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/type-of-allocation-349' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfAllocation349Enum {
	    global = 1,
	    detailed = 2
	}
	export interface TypeOfAllocation349$EnumInterface {
	    global: 1;
	    detailed: 2;
	}
	export type TypeOfAllocation349 = keyof TypeOfAllocation349$EnumInterface;
	export const typeOfAllocation349Datatype: X3EnumDataType<keyof TypeOfAllocation349$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-allocation-349.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/transaction-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/transaction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionTypeEnum {
	    manufacturingRelease = 1,
	    productionTracking = 2
	}
	export interface TransactionType$EnumInterface {
	    manufacturingRelease: 1;
	    productionTracking: 2;
	}
	export type TransactionType = keyof TransactionType$EnumInterface;
	export const transactionTypeDatatype: X3EnumDataType<keyof TransactionType$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/tracking-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/tracking-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TrackingTypeEnum {
	    wo = 1,
	    bom = 2,
	    woReintegration = 3,
	    bomReintegration = 4
	}
	export interface TrackingType$EnumInterface {
	    wo: 1;
	    bom: 2;
	    woReintegration: 3;
	    bomReintegration: 4;
	}
	export type TrackingType = keyof TrackingType$EnumInterface;
	export const trackingTypeDatatype: X3EnumDataType<keyof TrackingType$EnumInterface, unknown>;
	//# sourceMappingURL=tracking-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/tolerance-application.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/tolerance-application' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ToleranceApplicationEnum {
	    onTheWeightRemainingToWeigh = 1,
	    onTheTotalExpectedWeight = 2
	}
	export interface ToleranceApplication$EnumInterface {
	    onTheWeightRemainingToWeigh: 1;
	    onTheTotalExpectedWeight: 2;
	}
	export type ToleranceApplication = keyof ToleranceApplication$EnumInterface;
	export const toleranceApplicationDatatype: X3EnumDataType<keyof ToleranceApplication$EnumInterface, unknown>;
	//# sourceMappingURL=tolerance-application.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/time-unit-code.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/time-unit-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeUnitCodeEnum {
	    hours = 1,
	    minutes = 2
	}
	export interface TimeUnitCode$EnumInterface {
	    hours: 1;
	    minutes: 2;
	}
	export type TimeUnitCode = keyof TimeUnitCode$EnumInterface;
	export const timeUnitCodeDatatype: X3EnumDataType<keyof TimeUnitCode$EnumInterface, unknown>;
	//# sourceMappingURL=time-unit-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/time-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/time-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TimeTypeEnum {
	    preparation = 1,
	    run = 2,
	    postRun = 3,
	    setup = 4
	}
	export interface TimeType$EnumInterface {
	    preparation: 1;
	    run: 2;
	    postRun: 3;
	    setup: 4;
	}
	export type TimeType = keyof TimeType$EnumInterface;
	export const timeTypeDatatype: X3EnumDataType<keyof TimeType$EnumInterface, unknown>;
	//# sourceMappingURL=time-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/technical-sheet-control.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/technical-sheet-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TechnicalSheetControlEnum {
	    no = 1,
	    yesWithoutBlocking = 2,
	    yesWithBlocking = 3,
	    yesWithoutBlockingFirstTracking = 4,
	    yesWithBlockingFirstTracking = 5
	}
	export interface TechnicalSheetControl$EnumInterface {
	    no: 1;
	    yesWithoutBlocking: 2;
	    yesWithBlocking: 3;
	    yesWithoutBlockingFirstTracking: 4;
	    yesWithBlockingFirstTracking: 5;
	}
	export type TechnicalSheetControl = keyof TechnicalSheetControl$EnumInterface;
	export const technicalSheetControlDatatype: X3EnumDataType<keyof TechnicalSheetControl$EnumInterface, unknown>;
	//# sourceMappingURL=technical-sheet-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/tank-recontrol.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/tank-recontrol' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TankRecontrolEnum {
	    no = 1,
	    tank = 2
	}
	export interface TankRecontrol$EnumInterface {
	    no: 1;
	    tank: 2;
	}
	export type TankRecontrol = keyof TankRecontrol$EnumInterface;
	export const tankRecontrolDatatype: X3EnumDataType<keyof TankRecontrol$EnumInterface, unknown>;
	//# sourceMappingURL=tank-recontrol.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/supplier-packaging.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/supplier-packaging' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplierPackagingEnum {
	    internalPackaging = 1,
	    supplierPackaging = 2,
	    mixed = 3
	}
	export interface SupplierPackaging$EnumInterface {
	    internalPackaging: 1;
	    supplierPackaging: 2;
	    mixed: 3;
	}
	export type SupplierPackaging = keyof SupplierPackaging$EnumInterface;
	export const supplierPackagingDatatype: X3EnumDataType<keyof SupplierPackaging$EnumInterface, unknown>;
	//# sourceMappingURL=supplier-packaging.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/subcontracting.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/subcontracting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractingEnum {
	    no = 1,
	    normal = 2,
	    byException = 3
	}
	export interface Subcontracting$EnumInterface {
	    no: 1;
	    normal: 2;
	    byException: 3;
	}
	export type Subcontracting = keyof Subcontracting$EnumInterface;
	export const subcontractingDatatype: X3EnumDataType<keyof Subcontracting$EnumInterface, unknown>;
	//# sourceMappingURL=subcontracting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sub-contract-close-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sub-contract-close-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubContractCloseMethodEnum {
	    production = 1,
	    purchasing = 2
	}
	export interface SubContractCloseMethod$EnumInterface {
	    production: 1;
	    purchasing: 2;
	}
	export type SubContractCloseMethod = keyof SubContractCloseMethod$EnumInterface;
	export const subContractCloseMethodDatatype: X3EnumDataType<keyof SubContractCloseMethod$EnumInterface, unknown>;
	//# sourceMappingURL=sub-contract-close-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/stop-bit.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/stop-bit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StopBitEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2
	}
	export interface StopBit$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	}
	export type StopBit = keyof StopBit$EnumInterface;
	export const stopBitDatatype: X3EnumDataType<keyof StopBit$EnumInterface, unknown>;
	//# sourceMappingURL=stop-bit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/statuses-to-process.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/statuses-to-process' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusesToProcessEnum {
	    plannedFirm = 1,
	    allStatuses = 2
	}
	export interface StatusesToProcess$EnumInterface {
	    plannedFirm: 1;
	    allStatuses: 2;
	}
	export type StatusesToProcess = keyof StatusesToProcess$EnumInterface;
	export const statusesToProcessDatatype: X3EnumDataType<keyof StatusesToProcess$EnumInterface, unknown>;
	//# sourceMappingURL=statuses-to-process.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/status-in-progress.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/status-in-progress' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusInProgressEnum {
	    firm = 1,
	    planned = 2,
	    suggested = 3,
	    closed = 4
	}
	export interface StatusInProgress$EnumInterface {
	    firm: 1;
	    planned: 2;
	    suggested: 3;
	    closed: 4;
	}
	export type StatusInProgress = keyof StatusInProgress$EnumInterface;
	export const statusInProgressDatatype: X3EnumDataType<keyof StatusInProgress$EnumInterface, unknown>;
	//# sourceMappingURL=status-in-progress.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/state-of-the-balance.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/state-of-the-balance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StateOfTheBalanceEnum {
	    inService = 1,
	    notInService = 2
	}
	export interface StateOfTheBalance$EnumInterface {
	    inService: 1;
	    notInService: 2;
	}
	export type StateOfTheBalance = keyof StateOfTheBalance$EnumInterface;
	export const stateOfTheBalanceDatatype: X3EnumDataType<keyof StateOfTheBalance$EnumInterface, unknown>;
	//# sourceMappingURL=state-of-the-balance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/splitting.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/splitting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SplittingEnum {
	    none = 1,
	    equalQuantities = 2,
	    equalRunTimes = 3,
	    equalRunTimes1Rule = 4,
	    equalQuantitiesEfficiency = 5
	}
	export interface Splitting$EnumInterface {
	    none: 1;
	    equalQuantities: 2;
	    equalRunTimes: 3;
	    equalRunTimes1Rule: 4;
	    equalQuantitiesEfficiency: 5;
	}
	export type Splitting = keyof Splitting$EnumInterface;
	export const splittingDatatype: X3EnumDataType<keyof Splitting$EnumInterface, unknown>;
	//# sourceMappingURL=splitting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-wo.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-wo' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortWoEnum {
	    byStartDate = 1,
	    byAR = 2
	}
	export interface SortWo$EnumInterface {
	    byStartDate: 1;
	    byAR: 2;
	}
	export type SortWo = keyof SortWo$EnumInterface;
	export const sortWoDatatype: X3EnumDataType<keyof SortWo$EnumInterface, unknown>;
	//# sourceMappingURL=sort-wo.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-weighing-situation-histor.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-weighing-situation-histor' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortWeighingSituationHistorEnum {
	    workOrder = 1,
	    phase = 2,
	    component = 3,
	    dateWeighed = 4,
	    weighingLocation = 5
	}
	export interface SortWeighingSituationHistor$EnumInterface {
	    workOrder: 1;
	    phase: 2;
	    component: 3;
	    dateWeighed: 4;
	    weighingLocation: 5;
	}
	export type SortWeighingSituationHistor = keyof SortWeighingSituationHistor$EnumInterface;
	export const sortWeighingSituationHistorDatatype: X3EnumDataType<keyof SortWeighingSituationHistor$EnumInterface, unknown>;
	//# sourceMappingURL=sort-weighing-situation-histor.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-sub-contract.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-sub-contract' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortSubContractEnum {
	    byWorkOrder = 1,
	    byWorkCenter = 2,
	    byProduct = 3,
	    byOrder = 4,
	    byOrderDate = 5
	}
	export interface SortSubContract$EnumInterface {
	    byWorkOrder: 1;
	    byWorkCenter: 2;
	    byProduct: 3;
	    byOrder: 4;
	    byOrderDate: 5;
	}
	export type SortSubContract = keyof SortSubContract$EnumInterface;
	export const sortSubContractDatatype: X3EnumDataType<keyof SortSubContract$EnumInterface, unknown>;
	//# sourceMappingURL=sort-sub-contract.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-material-consumptions.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-material-consumptions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortMaterialConsumptionsEnum {
	    byTrackingNumber = 1,
	    byTrackingDate = 2,
	    byWorkOrderNumber = 3,
	    byProduct = 4
	}
	export interface SortMaterialConsumptions$EnumInterface {
	    byTrackingNumber: 1;
	    byTrackingDate: 2;
	    byWorkOrderNumber: 3;
	    byProduct: 4;
	}
	export type SortMaterialConsumptions = keyof SortMaterialConsumptions$EnumInterface;
	export const sortMaterialConsumptionsDatatype: X3EnumDataType<keyof SortMaterialConsumptions$EnumInterface, unknown>;
	//# sourceMappingURL=sort-material-consumptions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-criteria-2370.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-criteria-2370' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortCriteria2370Enum {
	    byDate = 1,
	    byWorkOrder = 2
	}
	export interface SortCriteria2370$EnumInterface {
	    byDate: 1;
	    byWorkOrder: 2;
	}
	export type SortCriteria2370 = keyof SortCriteria2370$EnumInterface;
	export const sortCriteria2370Datatype: X3EnumDataType<keyof SortCriteria2370$EnumInterface, unknown>;
	//# sourceMappingURL=sort-criteria-2370.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-component-weighing-situat.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-component-weighing-situat' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortComponentWeighingSituatEnum {
	    workOrder = 1,
	    phase = 2,
	    component = 3,
	    weighingSituation = 4
	}
	export interface SortComponentWeighingSituat$EnumInterface {
	    workOrder: 1;
	    phase: 2;
	    component: 3;
	    weighingSituation: 4;
	}
	export type SortComponentWeighingSituat = keyof SortComponentWeighingSituat$EnumInterface;
	export const sortComponentWeighingSituatDatatype: X3EnumDataType<keyof SortComponentWeighingSituat$EnumInterface, unknown>;
	//# sourceMappingURL=sort-component-weighing-situat.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-booked-times.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-booked-times' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortBookedTimesEnum {
	    byTrackingNumber = 1,
	    byTrackingDate = 2,
	    byWorkOrderNumber = 3,
	    byWorkCenter = 4
	}
	export interface SortBookedTimes$EnumInterface {
	    byTrackingNumber: 1;
	    byTrackingDate: 2;
	    byWorkOrderNumber: 3;
	    byWorkCenter: 4;
	}
	export type SortBookedTimes = keyof SortBookedTimes$EnumInterface;
	export const sortBookedTimesDatatype: X3EnumDataType<keyof SortBookedTimes$EnumInterface, unknown>;
	//# sourceMappingURL=sort-booked-times.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sort-allocations.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sort-allocations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortAllocationsEnum {
	    byRequirementDate = 1,
	    byPriority = 2,
	    byProduct = 3,
	    byShortageType = 4,
	    lot = 5,
	    location = 6,
	    status = 7
	}
	export interface SortAllocations$EnumInterface {
	    byRequirementDate: 1;
	    byPriority: 2;
	    byProduct: 3;
	    byShortageType: 4;
	    lot: 5;
	    location: 6;
	    status: 7;
	}
	export type SortAllocations = keyof SortAllocations$EnumInterface;
	export const sortAllocationsDatatype: X3EnumDataType<keyof SortAllocations$EnumInterface, unknown>;
	//# sourceMappingURL=sort-allocations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/slack-time-compression.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/slack-time-compression' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SlackTimeCompressionEnum {
	    none = 1,
	    waitingTime = 2,
	    preparationPostRunTimes = 3,
	    allSlackTime = 4,
	    preparationTime = 5,
	    postRunTime = 6,
	    preparationWaitingTimes = 7,
	    postRunWaitingTimes = 8
	}
	export interface SlackTimeCompression$EnumInterface {
	    none: 1;
	    waitingTime: 2;
	    preparationPostRunTimes: 3;
	    allSlackTime: 4;
	    preparationTime: 5;
	    postRunTime: 6;
	    preparationWaitingTimes: 7;
	    postRunWaitingTimes: 8;
	}
	export type SlackTimeCompression = keyof SlackTimeCompression$EnumInterface;
	export const slackTimeCompressionDatatype: X3EnumDataType<keyof SlackTimeCompression$EnumInterface, unknown>;
	//# sourceMappingURL=slack-time-compression.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/shop-floor-tracking.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/shop-floor-tracking' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShopFloorTrackingEnum {
	    employeeId1AlreadyClockedIntoATask = 1,
	    setupRunStartOperationSFailed = 2,
	    operationStopFailed = 3,
	    operationStartFailed = 4,
	    restartOperationSFailed = 5,
	    errorUpdatingNumberOfJobs = 6,
	    selectedOperationSHasAnActiveSetupDoYouWantToStopTheSetupToStartRunActivity = 7,
	    indirectReferences = 8,
	    breaks = 9,
	    errorCreating1Transaction = 10,
	    onlyOneBreakOrExclusiveLaborTransactionAllowedAtATime = 11,
	    employeeId1NotClockedIn = 12,
	    errorStopping1Transaction = 13,
	    employeeId1AlreadyClockedIn = 14,
	    clockInTransactionsMustBeByEmployee = 15,
	    transactionHasAlreadyEnded = 16,
	    errorCreatingAutoBreakTransactions = 17,
	    employeeOnABreakOrExclusiveTask = 18,
	    recordSkippedDueToBreakOrExclusiveIndirect = 19,
	    errorInValidation = 20,
	    errorReadingRecord = 21,
	    workOrderIsNotFirm = 22,
	    errorWritingRecord = 23,
	    errorUpdatingRecord = 24,
	    rejectedQtyCannotBeMoreThanCompletedQty = 25,
	    siteNotValidForSelectedWorkCenterOrWorkCenterGroup = 26,
	    workCenterGroupNotValidForSelectedSiteOrWorkCenter = 27,
	    workCenterNotValidForSelectedSiteOrWorkCenterGroup = 28,
	    invalidWorkCenterType = 29,
	    machineIncludedIsRequiredForThisOperation = 30,
	    errorOpeningOperation1 = 31,
	    errorInTrackingCreation = 32,
	    trackingRecordNotGenerated = 33,
	    noSetupOrRunDurationHasBeenEnteredDoYouWantToContinue = 34,
	    shiftDateIsGreaterThanStartDate = 35,
	    workOrderIsNotAllocated = 36,
	    displayLimitReached1 = 37,
	    shiftDateIsGreaterThanEndDate = 38,
	    startOrEndDateIsMandatory = 39,
	    userAlreadyUsedOnEmployeeId1 = 40,
	    invalidIndirectReferences = 41,
	    laborEntryValidation = 42,
	    recordSkippedDueToAPreviousFailure = 43,
	    laborCenterDoesNotExistAtTheSite = 44,
	    thisActivityHasSuspendedTransactionsAssociatedWithItDoYouWantToReopenThoseTransactions = 45,
	    isNotALaborCenter = 46,
	    substituteValue47 = 47,
	    laborCenterIsRequired = 48,
	    laborCenterCannotBeEnteredIfThePreviousValueIsBlank = 49,
	    operationStatusCannotBeClosedExcludedOrOrdered = 50,
	    workOrderDoesNotExistAtTheSite = 51,
	    workCenterTypeCannotBeSubcontract = 52,
	    employeeIsInactiveCurrentDateIsPastTheEmployeesInactiveDate = 53,
	    employeeId1IsInactive = 54,
	    laborCenterTypeCannotBeSubcontract = 55,
	    activeDateIsAfterOrEqualToInactiveDate = 56,
	    inactiveDateIsBeforeOrEqualToActiveDate = 57,
	    pleaseCreateShiftEndTime = 58,
	    pleaseCreateShiftStartTime = 59,
	    breakCannotEndBeforeShiftStarts = 60,
	    breakCannotEndAfterShiftEnds = 61,
	    breakEndTimeHasToBeAfterStartTime = 62,
	    notAnAutobreak = 63,
	    breakCannotStartBeforeShiftStarts = 64,
	    breakCannotStartAfterShiftEnds = 65,
	    breakStartTimeHasToBeBeforeEndTime = 66,
	    errorDeletingRecord = 67,
	    reloadTheTableAndCancelTheModifications = 68,
	    invalidBreak = 69,
	    employeeId1HasUnpostedShopFloorTrackingActivities = 70,
	    substituteValue71 = 71,
	    breakMustStartAfterThePreviousBreak = 72,
	    substituteValue73 = 73,
	    substituteValue74 = 74,
	    employeeClockInOutIsNotEnabledForThisSite = 75,
	    employeeId1IsADetailedTeam = 76,
	    substituteValue77 = 77,
	    substituteValue78 = 78,
	    substituteValue79 = 79,
	    substituteValue80 = 80,
	    substituteValue81 = 81,
	    substituteValue82 = 82,
	    operationAlreadyStarted = 83,
	    operationClosed = 84,
	    runInProcessForTheSelectedOperation = 85,
	    openIndirects = 86,
	    substituteValue87 = 87,
	    setupInProcessForTheSelectedOperation = 88,
	    employeeId1DoesNotHaveAccessToElapsedLabor = 89,
	    elapsed1TimeCreated = 90,
	    durationOrCompletedQtyIsMandatoryForElapsedRecords = 91,
	    durationIsMandatoryForElapsedRecords = 92,
	    substituteValue93 = 93,
	    employeeTypeFieldCannotBeModifiedWhenShopFloorTrackingTransactionsExist = 94,
	    teamHasShopFloorTrackingTransactionsModifyingNumberOfEmployeesWillNotAffectExistingTransactions = 95,
	    substituteValue96 = 96,
	    substituteValue97 = 97,
	    substituteValue98 = 98,
	    shiftCodeAssignedToTheEmployeeDoesNotMatchTeamShiftCode = 99,
	    employeeTypeCannotBeModifiedWhenTeamRecordsExist = 100,
	    employeeTypeCannotBeModifiedWhenEmployeeIsPartOfATeam = 101,
	    shiftCodeCannotBeModifiedWhenEmployeeIsPartOfATeam = 102,
	    shiftCodeHasBeenUpdatedForTheTeamAndTheEmployeesAssignedToTheTeam = 103,
	    employeeHasOpenActivitiesDoYouWantToStopAllOfTheEmployeesActivities = 104,
	    employeeCannotBeAddedToTheTeam = 105,
	    employeeIsCurrentlyPartOfTeam1DoYouWantToRemoveFromTeam2 = 106,
	    employeeHasOpenActivitiesOnATeamDoYouWantToStopAllOfTheEmployeesActivities = 107,
	    employeeIsAlreadyPartOfAnotherTeam = 108,
	    shopFloorTrackingTransactionsExistThisChangeCouldModifyTheBehaviorOfTheTransactionsDoYouWantToContinue = 109,
	    team1DoesNotHaveAnyTeamMembersAvailableToStartAnActivity = 110,
	    theSitesClockInOutParameter1MustBeActivatedForDetailedTeamEmployeeType = 111,
	    openActivitiesHaveBeenStoppedTransactionsHaveBeenReopenedWithNewNumberOfEmployees = 112,
	    deletingAMachineRecordWillAlsoDeleteTheLaborRecordsAssociatedWithTheMachine = 113,
	    numberOfMachinesMustBeZeroWhenPrimaryWorkCenterTypeIsLabor = 114,
	    onlyEmployeeAndSummaryTeamRecordsCanBeEntered = 115,
	    employee1IsNowIncludedInTeam2Activities = 116,
	    deletingAMachineRecordWillAlsoDeleteTheLaborAndMachineRecordsAssociatedWithTheMachine = 117,
	    employee1IsNotOnTeam2 = 118,
	    substituteValue119 = 119,
	    siteAssignedToTheEmployeeDoesNotMatchTeamSite = 120,
	    summaryTeamOnABreakOrExclusiveTask = 121,
	    detailedTeamOnABreakOrExclusiveTask = 122
	}
	export interface ShopFloorTracking$EnumInterface {
	    employeeId1AlreadyClockedIntoATask: 1;
	    setupRunStartOperationSFailed: 2;
	    operationStopFailed: 3;
	    operationStartFailed: 4;
	    restartOperationSFailed: 5;
	    errorUpdatingNumberOfJobs: 6;
	    selectedOperationSHasAnActiveSetupDoYouWantToStopTheSetupToStartRunActivity: 7;
	    indirectReferences: 8;
	    breaks: 9;
	    errorCreating1Transaction: 10;
	    onlyOneBreakOrExclusiveLaborTransactionAllowedAtATime: 11;
	    employeeId1NotClockedIn: 12;
	    errorStopping1Transaction: 13;
	    employeeId1AlreadyClockedIn: 14;
	    clockInTransactionsMustBeByEmployee: 15;
	    transactionHasAlreadyEnded: 16;
	    errorCreatingAutoBreakTransactions: 17;
	    employeeOnABreakOrExclusiveTask: 18;
	    recordSkippedDueToBreakOrExclusiveIndirect: 19;
	    errorInValidation: 20;
	    errorReadingRecord: 21;
	    workOrderIsNotFirm: 22;
	    errorWritingRecord: 23;
	    errorUpdatingRecord: 24;
	    rejectedQtyCannotBeMoreThanCompletedQty: 25;
	    siteNotValidForSelectedWorkCenterOrWorkCenterGroup: 26;
	    workCenterGroupNotValidForSelectedSiteOrWorkCenter: 27;
	    workCenterNotValidForSelectedSiteOrWorkCenterGroup: 28;
	    invalidWorkCenterType: 29;
	    machineIncludedIsRequiredForThisOperation: 30;
	    errorOpeningOperation1: 31;
	    errorInTrackingCreation: 32;
	    trackingRecordNotGenerated: 33;
	    noSetupOrRunDurationHasBeenEnteredDoYouWantToContinue: 34;
	    shiftDateIsGreaterThanStartDate: 35;
	    workOrderIsNotAllocated: 36;
	    displayLimitReached1: 37;
	    shiftDateIsGreaterThanEndDate: 38;
	    startOrEndDateIsMandatory: 39;
	    userAlreadyUsedOnEmployeeId1: 40;
	    invalidIndirectReferences: 41;
	    laborEntryValidation: 42;
	    recordSkippedDueToAPreviousFailure: 43;
	    laborCenterDoesNotExistAtTheSite: 44;
	    thisActivityHasSuspendedTransactionsAssociatedWithItDoYouWantToReopenThoseTransactions: 45;
	    isNotALaborCenter: 46;
	    substituteValue47: 47;
	    laborCenterIsRequired: 48;
	    laborCenterCannotBeEnteredIfThePreviousValueIsBlank: 49;
	    operationStatusCannotBeClosedExcludedOrOrdered: 50;
	    workOrderDoesNotExistAtTheSite: 51;
	    workCenterTypeCannotBeSubcontract: 52;
	    employeeIsInactiveCurrentDateIsPastTheEmployeesInactiveDate: 53;
	    employeeId1IsInactive: 54;
	    laborCenterTypeCannotBeSubcontract: 55;
	    activeDateIsAfterOrEqualToInactiveDate: 56;
	    inactiveDateIsBeforeOrEqualToActiveDate: 57;
	    pleaseCreateShiftEndTime: 58;
	    pleaseCreateShiftStartTime: 59;
	    breakCannotEndBeforeShiftStarts: 60;
	    breakCannotEndAfterShiftEnds: 61;
	    breakEndTimeHasToBeAfterStartTime: 62;
	    notAnAutobreak: 63;
	    breakCannotStartBeforeShiftStarts: 64;
	    breakCannotStartAfterShiftEnds: 65;
	    breakStartTimeHasToBeBeforeEndTime: 66;
	    errorDeletingRecord: 67;
	    reloadTheTableAndCancelTheModifications: 68;
	    invalidBreak: 69;
	    employeeId1HasUnpostedShopFloorTrackingActivities: 70;
	    substituteValue71: 71;
	    breakMustStartAfterThePreviousBreak: 72;
	    substituteValue73: 73;
	    substituteValue74: 74;
	    employeeClockInOutIsNotEnabledForThisSite: 75;
	    employeeId1IsADetailedTeam: 76;
	    substituteValue77: 77;
	    substituteValue78: 78;
	    substituteValue79: 79;
	    substituteValue80: 80;
	    substituteValue81: 81;
	    substituteValue82: 82;
	    operationAlreadyStarted: 83;
	    operationClosed: 84;
	    runInProcessForTheSelectedOperation: 85;
	    openIndirects: 86;
	    substituteValue87: 87;
	    setupInProcessForTheSelectedOperation: 88;
	    employeeId1DoesNotHaveAccessToElapsedLabor: 89;
	    elapsed1TimeCreated: 90;
	    durationOrCompletedQtyIsMandatoryForElapsedRecords: 91;
	    durationIsMandatoryForElapsedRecords: 92;
	    substituteValue93: 93;
	    employeeTypeFieldCannotBeModifiedWhenShopFloorTrackingTransactionsExist: 94;
	    teamHasShopFloorTrackingTransactionsModifyingNumberOfEmployeesWillNotAffectExistingTransactions: 95;
	    substituteValue96: 96;
	    substituteValue97: 97;
	    substituteValue98: 98;
	    shiftCodeAssignedToTheEmployeeDoesNotMatchTeamShiftCode: 99;
	    employeeTypeCannotBeModifiedWhenTeamRecordsExist: 100;
	    employeeTypeCannotBeModifiedWhenEmployeeIsPartOfATeam: 101;
	    shiftCodeCannotBeModifiedWhenEmployeeIsPartOfATeam: 102;
	    shiftCodeHasBeenUpdatedForTheTeamAndTheEmployeesAssignedToTheTeam: 103;
	    employeeHasOpenActivitiesDoYouWantToStopAllOfTheEmployeesActivities: 104;
	    employeeCannotBeAddedToTheTeam: 105;
	    employeeIsCurrentlyPartOfTeam1DoYouWantToRemoveFromTeam2: 106;
	    employeeHasOpenActivitiesOnATeamDoYouWantToStopAllOfTheEmployeesActivities: 107;
	    employeeIsAlreadyPartOfAnotherTeam: 108;
	    shopFloorTrackingTransactionsExistThisChangeCouldModifyTheBehaviorOfTheTransactionsDoYouWantToContinue: 109;
	    team1DoesNotHaveAnyTeamMembersAvailableToStartAnActivity: 110;
	    theSitesClockInOutParameter1MustBeActivatedForDetailedTeamEmployeeType: 111;
	    openActivitiesHaveBeenStoppedTransactionsHaveBeenReopenedWithNewNumberOfEmployees: 112;
	    deletingAMachineRecordWillAlsoDeleteTheLaborRecordsAssociatedWithTheMachine: 113;
	    numberOfMachinesMustBeZeroWhenPrimaryWorkCenterTypeIsLabor: 114;
	    onlyEmployeeAndSummaryTeamRecordsCanBeEntered: 115;
	    employee1IsNowIncludedInTeam2Activities: 116;
	    deletingAMachineRecordWillAlsoDeleteTheLaborAndMachineRecordsAssociatedWithTheMachine: 117;
	    employee1IsNotOnTeam2: 118;
	    substituteValue119: 119;
	    siteAssignedToTheEmployeeDoesNotMatchTeamSite: 120;
	    summaryTeamOnABreakOrExclusiveTask: 121;
	    detailedTeamOnABreakOrExclusiveTask: 122;
	}
	export type ShopFloorTracking = keyof ShopFloorTracking$EnumInterface;
	export const shopFloorTrackingDatatype: X3EnumDataType<keyof ShopFloorTracking$EnumInterface, unknown>;
	//# sourceMappingURL=shop-floor-tracking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/shop-floor-activities.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/shop-floor-activities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShopFloorActivitiesEnum {
	    clockInOut = 1,
	    indirect = 2,
	    break = 3,
	    setup = 4,
	    run = 5
	}
	export interface ShopFloorActivities$EnumInterface {
	    clockInOut: 1;
	    indirect: 2;
	    break: 3;
	    setup: 4;
	    run: 5;
	}
	export type ShopFloorActivities = keyof ShopFloorActivities$EnumInterface;
	export const shopFloorActivitiesDatatype: X3EnumDataType<keyof ShopFloorActivities$EnumInterface, unknown>;
	//# sourceMappingURL=shop-floor-activities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/setup-time-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/setup-time-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SetupTimeTypeEnum {
	    cumulative = 1,
	    maximum = 2
	}
	export interface SetupTimeType$EnumInterface {
	    cumulative: 1;
	    maximum: 2;
	}
	export type SetupTimeType = keyof SetupTimeType$EnumInterface;
	export const setupTimeTypeDatatype: X3EnumDataType<keyof SetupTimeType$EnumInterface, unknown>;
	//# sourceMappingURL=setup-time-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/serial-number-link-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/serial-number-link-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SerialNumberLinkStatusEnum {
	    new = 1,
	    inProgress = 2,
	    complete = 3
	}
	export interface SerialNumberLinkStatus$EnumInterface {
	    new: 1;
	    inProgress: 2;
	    complete: 3;
	}
	export type SerialNumberLinkStatus = keyof SerialNumberLinkStatus$EnumInterface;
	export const serialNumberLinkStatusDatatype: X3EnumDataType<keyof SerialNumberLinkStatus$EnumInterface, unknown>;
	//# sourceMappingURL=serial-number-link-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sequence-the-weighing-plan.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sequence-the-weighing-plan' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceTheWeighingPlanEnum {
	    site = 1,
	    product = 2,
	    startDate = 3
	}
	export interface SequenceTheWeighingPlan$EnumInterface {
	    site: 1;
	    product: 2;
	    startDate: 3;
	}
	export type SequenceTheWeighingPlan = keyof SequenceTheWeighingPlan$EnumInterface;
	export const sequenceTheWeighingPlanDatatype: X3EnumDataType<keyof SequenceTheWeighingPlan$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-the-weighing-plan.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/separator.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/separator' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SeparatorEnum {
	    point = 1,
	    comma = 2
	}
	export interface Separator$EnumInterface {
	    point: 1;
	    comma: 2;
	}
	export type Separator = keyof Separator$EnumInterface;
	export const separatorDatatype: X3EnumDataType<keyof Separator$EnumInterface, unknown>;
	//# sourceMappingURL=separator.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/semi-final-valuation-price-p.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/semi-final-valuation-price-p' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SemiFinalValuationPricePEnum {
	    standardCost = 1,
	    revisedStandardCost = 2
	}
	export interface SemiFinalValuationPriceP$EnumInterface {
	    standardCost: 1;
	    revisedStandardCost: 2;
	}
	export type SemiFinalValuationPriceP = keyof SemiFinalValuationPriceP$EnumInterface;
	export const semiFinalValuationPricePDatatype: X3EnumDataType<keyof SemiFinalValuationPriceP$EnumInterface, unknown>;
	//# sourceMappingURL=semi-final-valuation-price-p.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/selection-order.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/selection-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOrderEnum {
	    startingDate = 1,
	    priorityCode = 2
	}
	export interface SelectionOrder$EnumInterface {
	    startingDate: 1;
	    priorityCode: 2;
	}
	export type SelectionOrder = keyof SelectionOrder$EnumInterface;
	export const selectionOrderDatatype: X3EnumDataType<keyof SelectionOrder$EnumInterface, unknown>;
	//# sourceMappingURL=selection-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/select-scheduling-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/select-scheduling-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectSchedulingModeEnum {
	    backward = 1,
	    forward = 2,
	    bySelection = 3
	}
	export interface SelectSchedulingMode$EnumInterface {
	    backward: 1;
	    forward: 2;
	    bySelection: 3;
	}
	export type SelectSchedulingMode = keyof SelectSchedulingMode$EnumInterface;
	export const selectSchedulingModeDatatype: X3EnumDataType<keyof SelectSchedulingMode$EnumInterface, unknown>;
	//# sourceMappingURL=select-scheduling-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/select-management-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/select-management-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectManagementMethodEnum {
	    onStock = 1,
	    byOrder = 2,
	    all = 3
	}
	export interface SelectManagementMethod$EnumInterface {
	    onStock: 1;
	    byOrder: 2;
	    all: 3;
	}
	export type SelectManagementMethod = keyof SelectManagementMethod$EnumInterface;
	export const selectManagementMethodDatatype: X3EnumDataType<keyof SelectManagementMethod$EnumInterface, unknown>;
	//# sourceMappingURL=select-management-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/select-lead-time.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/select-lead-time' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectLeadTimeEnum {
	    product = 1,
	    routing = 2
	}
	export interface SelectLeadTime$EnumInterface {
	    product: 1;
	    routing: 2;
	}
	export type SelectLeadTime = keyof SelectLeadTime$EnumInterface;
	export const selectLeadTimeDatatype: X3EnumDataType<keyof SelectLeadTime$EnumInterface, unknown>;
	//# sourceMappingURL=select-lead-time.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sel-hist-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sel-hist-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelHistTypeEnum {
	    supplierOrder = 1,
	    workOrder = 2,
	    customerOrder = 3,
	    purchaseOrderTransfer = 4,
	    workOrderTransfer = 5
	}
	export interface SelHistType$EnumInterface {
	    supplierOrder: 1;
	    workOrder: 2;
	    customerOrder: 3;
	    purchaseOrderTransfer: 4;
	    workOrderTransfer: 5;
	}
	export type SelHistType = keyof SelHistType$EnumInterface;
	export const selHistTypeDatatype: X3EnumDataType<keyof SelHistType$EnumInterface, unknown>;
	//# sourceMappingURL=sel-hist-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/scheduling-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/scheduling-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SchedulingStatusEnum {
	    notScheduled = 1,
	    scheduled = 2,
	    reschedule = 3,
	    optimized = 4
	}
	export interface SchedulingStatus$EnumInterface {
	    notScheduled: 1;
	    scheduled: 2;
	    reschedule: 3;
	    optimized: 4;
	}
	export type SchedulingStatus = keyof SchedulingStatus$EnumInterface;
	export const schedulingStatusDatatype: X3EnumDataType<keyof SchedulingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=scheduling-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/scheduling-process.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/scheduling-process' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SchedulingProcessEnum {
	    scheduling = 1,
	    rescheduling = 2,
	    all = 3
	}
	export interface SchedulingProcess$EnumInterface {
	    scheduling: 1;
	    rescheduling: 2;
	    all: 3;
	}
	export type SchedulingProcess = keyof SchedulingProcess$EnumInterface;
	export const schedulingProcessDatatype: X3EnumDataType<keyof SchedulingProcess$EnumInterface, unknown>;
	//# sourceMappingURL=scheduling-process.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/scheduling-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/scheduling-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SchedulingModeEnum {
	    backward = 1,
	    forward = 2
	}
	export interface SchedulingMode$EnumInterface {
	    backward: 1;
	    forward: 2;
	}
	export type SchedulingMode = keyof SchedulingMode$EnumInterface;
	export const schedulingModeDatatype: X3EnumDataType<keyof SchedulingMode$EnumInterface, unknown>;
	//# sourceMappingURL=scheduling-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/scheduling-code.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/scheduling-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SchedulingCodeEnum {
	    absoluteSuccessor = 1,
	    overlappingWaitLots = 2,
	    overlappingWaitTime = 3,
	    overlappingWaitQuantity = 4,
	    startSynchronization = 5,
	    endSynchronization = 6,
	    allOrderOperationsParallel = 7,
	    subcontractSynchronization = 8,
	    simpleSuccessor = 9
	}
	export interface SchedulingCode$EnumInterface {
	    absoluteSuccessor: 1;
	    overlappingWaitLots: 2;
	    overlappingWaitTime: 3;
	    overlappingWaitQuantity: 4;
	    startSynchronization: 5;
	    endSynchronization: 6;
	    allOrderOperationsParallel: 7;
	    subcontractSynchronization: 8;
	    simpleSuccessor: 9;
	}
	export type SchedulingCode = keyof SchedulingCode$EnumInterface;
	export const schedulingCodeDatatype: X3EnumDataType<keyof SchedulingCode$EnumInterface, unknown>;
	//# sourceMappingURL=scheduling-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/schedule-validated.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/schedule-validated' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScheduleValidatedEnum {
	    schedulingToComplete = 1,
	    schedulingValid = 2
	}
	export interface ScheduleValidated$EnumInterface {
	    schedulingToComplete: 1;
	    schedulingValid: 2;
	}
	export type ScheduleValidated = keyof ScheduleValidated$EnumInterface;
	export const scheduleValidatedDatatype: X3EnumDataType<keyof ScheduleValidated$EnumInterface, unknown>;
	//# sourceMappingURL=schedule-validated.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/schedule-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/schedule-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScheduleTypeEnum {
	    none = 1,
	    normalTracking = 2,
	    range = 3
	}
	export interface ScheduleType$EnumInterface {
	    none: 1;
	    normalTracking: 2;
	    range: 3;
	}
	export type ScheduleType = keyof ScheduleType$EnumInterface;
	export const scheduleTypeDatatype: X3EnumDataType<keyof ScheduleType$EnumInterface, unknown>;
	//# sourceMappingURL=schedule-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/sales-order-allocation-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/sales-order-allocation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesOrderAllocationTypeEnum {
	    shortagesGlobal = 1,
	    global = 2,
	    shortagesDetailed = 3,
	    detailed = 4
	}
	export interface SalesOrderAllocationType$EnumInterface {
	    shortagesGlobal: 1;
	    global: 2;
	    shortagesDetailed: 3;
	    detailed: 4;
	}
	export type SalesOrderAllocationType = keyof SalesOrderAllocationType$EnumInterface;
	export const salesOrderAllocationTypeDatatype: X3EnumDataType<keyof SalesOrderAllocationType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-order-allocation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/run-time-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/run-time-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RunTimeTypeEnum {
	    proportional = 1,
	    rate = 2,
	    fixed = 3
	}
	export interface RunTimeType$EnumInterface {
	    proportional: 1;
	    rate: 2;
	    fixed: 3;
	}
	export type RunTimeType = keyof RunTimeType$EnumInterface;
	export const runTimeTypeDatatype: X3EnumDataType<keyof RunTimeType$EnumInterface, unknown>;
	//# sourceMappingURL=run-time-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/routing-use.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/routing-use' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoutingUseEnum {
	    production = 1,
	    cost = 2,
	    rccp = 3
	}
	export interface RoutingUse$EnumInterface {
	    production: 1;
	    cost: 2;
	    rccp: 3;
	}
	export type RoutingUse = keyof RoutingUse$EnumInterface;
	export const routingUseDatatype: X3EnumDataType<keyof RoutingUse$EnumInterface, unknown>;
	//# sourceMappingURL=routing-use.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/routing-modification-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/routing-modification-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoutingModificationTypeEnum {
	    modifyOperation = 1,
	    modifyStandardOperation = 2,
	    addOperation = 3,
	    deleteOperation = 4
	}
	export interface RoutingModificationType$EnumInterface {
	    modifyOperation: 1;
	    modifyStandardOperation: 2;
	    addOperation: 3;
	    deleteOperation: 4;
	}
	export type RoutingModificationType = keyof RoutingModificationType$EnumInterface;
	export const routingModificationTypeDatatype: X3EnumDataType<keyof RoutingModificationType$EnumInterface, unknown>;
	//# sourceMappingURL=routing-modification-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/role-of-the-transaction.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/role-of-the-transaction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RoleOfTheTransactionEnum {
	    materialIssue = 1,
	    materialReturn = 2
	}
	export interface RoleOfTheTransaction$EnumInterface {
	    materialIssue: 1;
	    materialReturn: 2;
	}
	export type RoleOfTheTransaction = keyof RoleOfTheTransaction$EnumInterface;
	export const roleOfTheTransactionDatatype: X3EnumDataType<keyof RoleOfTheTransaction$EnumInterface, unknown>;
	//# sourceMappingURL=role-of-the-transaction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/result-standarization.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/result-standarization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResultStandarizationEnum {
	    correct = 1,
	    incorrect = 2
	}
	export interface ResultStandarization$EnumInterface {
	    correct: 1;
	    incorrect: 2;
	}
	export type ResultStandarization = keyof ResultStandarization$EnumInterface;
	export const resultStandarizationDatatype: X3EnumDataType<keyof ResultStandarization$EnumInterface, unknown>;
	//# sourceMappingURL=result-standarization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/resource-analysis.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/resource-analysis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ResourceAnalysisEnum {
	    resourceUse = 1,
	    resourceYield = 2
	}
	export interface ResourceAnalysis$EnumInterface {
	    resourceUse: 1;
	    resourceYield: 2;
	}
	export type ResourceAnalysis = keyof ResourceAnalysis$EnumInterface;
	export const resourceAnalysisDatatype: X3EnumDataType<keyof ResourceAnalysis$EnumInterface, unknown>;
	//# sourceMappingURL=resource-analysis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/report-allocation-sorting.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/report-allocation-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportAllocationSortingEnum {
	    product = 1,
	    lot = 2,
	    location = 3,
	    identifier1 = 4,
	    identifier2 = 5,
	    default = 6
	}
	export interface ReportAllocationSorting$EnumInterface {
	    product: 1;
	    lot: 2;
	    location: 3;
	    identifier1: 4;
	    identifier2: 5;
	    default: 6;
	}
	export type ReportAllocationSorting = keyof ReportAllocationSorting$EnumInterface;
	export const reportAllocationSortingDatatype: X3EnumDataType<keyof ReportAllocationSorting$EnumInterface, unknown>;
	//# sourceMappingURL=report-allocation-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/release-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/release-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReleaseModeEnum {
	    complete = 1,
	    materialsOnly = 2,
	    operationsOnly = 3
	}
	export interface ReleaseMode$EnumInterface {
	    complete: 1;
	    materialsOnly: 2;
	    operationsOnly: 3;
	}
	export type ReleaseMode = keyof ReleaseMode$EnumInterface;
	export const releaseModeDatatype: X3EnumDataType<keyof ReleaseMode$EnumInterface, unknown>;
	//# sourceMappingURL=release-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/reason-for-reprint.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/reason-for-reprint' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReasonForReprintEnum {
	    printerUnavailable = 1,
	    endOfRoller = 2,
	    formatError = 3,
	    labelIllegible = 4
	}
	export interface ReasonForReprint$EnumInterface {
	    printerUnavailable: 1;
	    endOfRoller: 2;
	    formatError: 3;
	    labelIllegible: 4;
	}
	export type ReasonForReprint = keyof ReasonForReprint$EnumInterface;
	export const reasonForReprintDatatype: X3EnumDataType<keyof ReasonForReprint$EnumInterface, unknown>;
	//# sourceMappingURL=reason-for-reprint.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/quantity-type-2311.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/quantity-type-2311' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityType2311Enum {
	    active = 1,
	    physical = 2
	}
	export interface QuantityType2311$EnumInterface {
	    active: 1;
	    physical: 2;
	}
	export type QuantityType2311 = keyof QuantityType2311$EnumInterface;
	export const quantityType2311Datatype: X3EnumDataType<keyof QuantityType2311$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-type-2311.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/ps-fdma-recalculation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/ps-fdma-recalculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PsFdmaRecalculationEnum {
	    forWorkOrdersInclStatusBeingOptimized = 1,
	    forWorkOrdersInclStatusOptimized = 2,
	    forWorkOrdersInclStatusInProgress = 3
	}
	export interface PsFdmaRecalculation$EnumInterface {
	    forWorkOrdersInclStatusBeingOptimized: 1;
	    forWorkOrdersInclStatusOptimized: 2;
	    forWorkOrdersInclStatusInProgress: 3;
	}
	export type PsFdmaRecalculation = keyof PsFdmaRecalculation$EnumInterface;
	export const psFdmaRecalculationDatatype: X3EnumDataType<keyof PsFdmaRecalculation$EnumInterface, unknown>;
	//# sourceMappingURL=ps-fdma-recalculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/provisional-cost-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/provisional-cost-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProvisionalCostTypeEnum {
	    theoretical = 1,
	    release = 2,
	    production = 3
	}
	export interface ProvisionalCostType$EnumInterface {
	    theoretical: 1;
	    release: 2;
	    production: 3;
	}
	export type ProvisionalCostType = keyof ProvisionalCostType$EnumInterface;
	export const provisionalCostTypeDatatype: X3EnumDataType<keyof ProvisionalCostType$EnumInterface, unknown>;
	//# sourceMappingURL=provisional-cost-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/provisional-cost-print.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/provisional-cost-print' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProvisionalCostPrintEnum {
	    no = 1,
	    report = 2,
	    trace = 3,
	    reportAndTrace = 4
	}
	export interface ProvisionalCostPrint$EnumInterface {
	    no: 1;
	    report: 2;
	    trace: 3;
	    reportAndTrace: 4;
	}
	export type ProvisionalCostPrint = keyof ProvisionalCostPrint$EnumInterface;
	export const provisionalCostPrintDatatype: X3EnumDataType<keyof ProvisionalCostPrint$EnumInterface, unknown>;
	//# sourceMappingURL=provisional-cost-print.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/project-code.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/project-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProjectCodeEnum {
	    project = 1,
	    document = 2
	}
	export interface ProjectCode$EnumInterface {
	    project: 1;
	    document: 2;
	}
	export type ProjectCode = keyof ProjectCode$EnumInterface;
	export const projectCodeDatatype: X3EnumDataType<keyof ProjectCode$EnumInterface, unknown>;
	//# sourceMappingURL=project-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionStatusEnum {
	    pending = 1,
	    inProcess = 2,
	    completed = 3,
	    cancelled = 4
	}
	export interface ProductionStatus$EnumInterface {
	    pending: 1;
	    inProcess: 2;
	    completed: 3;
	    cancelled: 4;
	}
	export type ProductionStatus = keyof ProductionStatus$EnumInterface;
	export const productionStatusDatatype: X3EnumDataType<keyof ProductionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=production-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-scheduler-wo-fields.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-scheduler-wo-fields' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionSchedulerWoFieldsEnum {
	    customerNameAndNumber = 1,
	    customerName = 2,
	    projectAndTaskNumber = 3,
	    productCategory = 4,
	    productLine = 5,
	    statisticalAnalysis1 = 6,
	    statisticalAnalysis2 = 7,
	    statisticalAnalysis3 = 8,
	    salesOrderNumber = 9
	}
	export interface ProductionSchedulerWoFields$EnumInterface {
	    customerNameAndNumber: 1;
	    customerName: 2;
	    projectAndTaskNumber: 3;
	    productCategory: 4;
	    productLine: 5;
	    statisticalAnalysis1: 6;
	    statisticalAnalysis2: 7;
	    statisticalAnalysis3: 8;
	    salesOrderNumber: 9;
	}
	export type ProductionSchedulerWoFields = keyof ProductionSchedulerWoFields$EnumInterface;
	export const productionSchedulerWoFieldsDatatype: X3EnumDataType<keyof ProductionSchedulerWoFields$EnumInterface, unknown>;
	//# sourceMappingURL=production-scheduler-wo-fields.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-order-processed.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-order-processed' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionOrderProcessedEnum {
	    inProgress = 1,
	    closed = 2
	}
	export interface ProductionOrderProcessed$EnumInterface {
	    inProgress: 1;
	    closed: 2;
	}
	export type ProductionOrderProcessed = keyof ProductionOrderProcessed$EnumInterface;
	export const productionOrderProcessedDatatype: X3EnumDataType<keyof ProductionOrderProcessed$EnumInterface, unknown>;
	//# sourceMappingURL=production-order-processed.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-documents.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-documents' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionDocumentsEnum {
	    workOrder = 1,
	    suggestedWorkOrder = 2,
	    productionTracking = 3,
	    preparation = 4,
	    operationWip = 5,
	    operationSuggestion = 6,
	    wipValuationWithoutWorkOrder = 7
	}
	export interface ProductionDocuments$EnumInterface {
	    workOrder: 1;
	    suggestedWorkOrder: 2;
	    productionTracking: 3;
	    preparation: 4;
	    operationWip: 5;
	    operationSuggestion: 6;
	    wipValuationWithoutWorkOrder: 7;
	}
	export type ProductionDocuments = keyof ProductionDocuments$EnumInterface;
	export const productionDocumentsDatatype: X3EnumDataType<keyof ProductionDocuments$EnumInterface, unknown>;
	//# sourceMappingURL=production-documents.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-cost-sorting.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-cost-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionCostSortingEnum {
	    byDate = 1,
	    byOrderNumber = 2,
	    byActualAmount = 3,
	    byVariancePercentage = 4,
	    byType = 5,
	    byActualQuantity = 6
	}
	export interface ProductionCostSorting$EnumInterface {
	    byDate: 1;
	    byOrderNumber: 2;
	    byActualAmount: 3;
	    byVariancePercentage: 4;
	    byType: 5;
	    byActualQuantity: 6;
	}
	export type ProductionCostSorting = keyof ProductionCostSorting$EnumInterface;
	export const productionCostSortingDatatype: X3EnumDataType<keyof ProductionCostSorting$EnumInterface, unknown>;
	//# sourceMappingURL=production-cost-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-cost-report.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-cost-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionCostReportEnum {
	    none = 1,
	    detail = 2,
	    summary = 3
	}
	export interface ProductionCostReport$EnumInterface {
	    none: 1;
	    detail: 2;
	    summary: 3;
	}
	export type ProductionCostReport = keyof ProductionCostReport$EnumInterface;
	export const productionCostReportDatatype: X3EnumDataType<keyof ProductionCostReport$EnumInterface, unknown>;
	//# sourceMappingURL=production-cost-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-cost-print-detail.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-cost-print-detail' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionCostPrintDetailEnum {
	    header = 1,
	    materialDetail = 2,
	    operationDetail = 3,
	    subTotal = 4,
	    overheadCostSummary = 5,
	    total = 6,
	    releasedOrderSummary = 7,
	    closedReleasedOrderSummary = 8
	}
	export interface ProductionCostPrintDetail$EnumInterface {
	    header: 1;
	    materialDetail: 2;
	    operationDetail: 3;
	    subTotal: 4;
	    overheadCostSummary: 5;
	    total: 6;
	    releasedOrderSummary: 7;
	    closedReleasedOrderSummary: 8;
	}
	export type ProductionCostPrintDetail = keyof ProductionCostPrintDetail$EnumInterface;
	export const productionCostPrintDetailDatatype: X3EnumDataType<keyof ProductionCostPrintDetail$EnumInterface, unknown>;
	//# sourceMappingURL=production-cost-print-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/production-cost-detail-titles.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/production-cost-detail-titles' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductionCostDetailTitlesEnum {
	    materialTotal = 1,
	    componentMachineSubtotal = 2,
	    machineTotal = 3,
	    componentLaborSubtotal = 4,
	    laborTotal = 5,
	    componentSubcontractSubtotal = 6,
	    subcontractTotal = 7,
	    materialOverheadCost = 8,
	    machineOverheadCost = 9,
	    laborOverheadCost = 10,
	    subcontractOverheadCost = 11,
	    componentOverheadCost = 12,
	    overheadCostTotal = 13,
	    totalManufactureCost = 14,
	    componentMaterialSubtotal = 15,
	    serviceOverheadCost = 16,
	    subcontractTotalCost = 17,
	    invoicingElementTotal = 18
	}
	export interface ProductionCostDetailTitles$EnumInterface {
	    materialTotal: 1;
	    componentMachineSubtotal: 2;
	    machineTotal: 3;
	    componentLaborSubtotal: 4;
	    laborTotal: 5;
	    componentSubcontractSubtotal: 6;
	    subcontractTotal: 7;
	    materialOverheadCost: 8;
	    machineOverheadCost: 9;
	    laborOverheadCost: 10;
	    subcontractOverheadCost: 11;
	    componentOverheadCost: 12;
	    overheadCostTotal: 13;
	    totalManufactureCost: 14;
	    componentMaterialSubtotal: 15;
	    serviceOverheadCost: 16;
	    subcontractTotalCost: 17;
	    invoicingElementTotal: 18;
	}
	export type ProductionCostDetailTitles = keyof ProductionCostDetailTitles$EnumInterface;
	export const productionCostDetailTitlesDatatype: X3EnumDataType<keyof ProductionCostDetailTitles$EnumInterface, unknown>;
	//# sourceMappingURL=production-cost-detail-titles.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/product-sort-criteria.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/product-sort-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductSortCriteriaEnum {
	    byDate = 1,
	    byWorkOrder = 2,
	    byProduct = 3
	}
	export interface ProductSortCriteria$EnumInterface {
	    byDate: 1;
	    byWorkOrder: 2;
	    byProduct: 3;
	}
	export type ProductSortCriteria = keyof ProductSortCriteria$EnumInterface;
	export const productSortCriteriaDatatype: X3EnumDataType<keyof ProductSortCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=product-sort-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/product-recontrol-in-station.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/product-recontrol-in-station' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductRecontrolInStationEnum {
	    no = 1,
	    lot = 2,
	    productCodeLot = 3,
	    lotSublot = 4,
	    productCodeLotSublot = 5
	}
	export interface ProductRecontrolInStation$EnumInterface {
	    no: 1;
	    lot: 2;
	    productCodeLot: 3;
	    lotSublot: 4;
	    productCodeLotSublot: 5;
	}
	export type ProductRecontrolInStation = keyof ProductRecontrolInStation$EnumInterface;
	export const productRecontrolInStationDatatype: X3EnumDataType<keyof ProductRecontrolInStation$EnumInterface, unknown>;
	//# sourceMappingURL=product-recontrol-in-station.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/product-code.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/product-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductCodeEnum {
	    routing = 1,
	    product = 2
	}
	export interface ProductCode$EnumInterface {
	    routing: 1;
	    product: 2;
	}
	export type ProductCode = keyof ProductCode$EnumInterface;
	export const productCodeDatatype: X3EnumDataType<keyof ProductCode$EnumInterface, unknown>;
	//# sourceMappingURL=product-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/product-analysis.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/product-analysis' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductAnalysisEnum {
	    overdue = 1,
	    leadTime = 2,
	    time = 3,
	    operationalYield = 4,
	    materialYield = 5
	}
	export interface ProductAnalysis$EnumInterface {
	    overdue: 1;
	    leadTime: 2;
	    time: 3;
	    operationalYield: 4;
	    materialYield: 5;
	}
	export type ProductAnalysis = keyof ProductAnalysis$EnumInterface;
	export const productAnalysisDatatype: X3EnumDataType<keyof ProductAnalysis$EnumInterface, unknown>;
	//# sourceMappingURL=product-analysis.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/prod-sched-operation-fields.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/prod-sched-operation-fields' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProdSchedOperationFieldsEnum {
	    laborCenter = 1,
	    technicalSheet = 2,
	    operationPlanNumber = 3,
	    fixture = 4,
	    program = 5,
	    groupingCriteria = 6,
	    distinctionCriteria = 7
	}
	export interface ProdSchedOperationFields$EnumInterface {
	    laborCenter: 1;
	    technicalSheet: 2;
	    operationPlanNumber: 3;
	    fixture: 4;
	    program: 5;
	    groupingCriteria: 6;
	    distinctionCriteria: 7;
	}
	export type ProdSchedOperationFields = keyof ProdSchedOperationFields$EnumInterface;
	export const prodSchedOperationFieldsDatatype: X3EnumDataType<keyof ProdSchedOperationFields$EnumInterface, unknown>;
	//# sourceMappingURL=prod-sched-operation-fields.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/processing-mode-395.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/processing-mode-395' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingMode395Enum {
	    update = 1,
	    simulation = 2,
	    inquiry = 3
	}
	export interface ProcessingMode395$EnumInterface {
	    update: 1;
	    simulation: 2;
	    inquiry: 3;
	}
	export type ProcessingMode395 = keyof ProcessingMode395$EnumInterface;
	export const processingMode395Datatype: X3EnumDataType<keyof ProcessingMode395$EnumInterface, unknown>;
	//# sourceMappingURL=processing-mode-395.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/processing-mode-372.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/processing-mode-372' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessingMode372Enum {
	    manual = 1,
	    automatic = 2
	}
	export interface ProcessingMode372$EnumInterface {
	    manual: 1;
	    automatic: 2;
	}
	export type ProcessingMode372 = keyof ProcessingMode372$EnumInterface;
	export const processingMode372Datatype: X3EnumDataType<keyof ProcessingMode372$EnumInterface, unknown>;
	//# sourceMappingURL=processing-mode-372.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/process-type-2304.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/process-type-2304' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessType2304Enum {
	    completeWorkOrder = 1,
	    workOrderOperationOnly = 2,
	    workOrderReleasedProductOnly = 3,
	    workOrderMaterialConsumptionOnly = 4,
	    routing = 5,
	    routingOperationOnly = 6,
	    routingProductReleasedOnly = 7,
	    bomMaterialOnly = 8,
	    miscellaneousTimes = 9,
	    trackingOfUnplannedWorkOrderOperation = 10,
	    trackingOfUnplannedRoutingOperation = 11,
	    trackingOfUnplannedWorkOrderMaterial = 12,
	    trackingOfUnplannedBomMaterial = 13,
	    returnOfWorkOrderMaterial = 14,
	    returnOfUnplannedMaterial = 15,
	    bomReintegration = 16,
	    bomReintegrationOnNonPlannedMaterial = 17
	}
	export interface ProcessType2304$EnumInterface {
	    completeWorkOrder: 1;
	    workOrderOperationOnly: 2;
	    workOrderReleasedProductOnly: 3;
	    workOrderMaterialConsumptionOnly: 4;
	    routing: 5;
	    routingOperationOnly: 6;
	    routingProductReleasedOnly: 7;
	    bomMaterialOnly: 8;
	    miscellaneousTimes: 9;
	    trackingOfUnplannedWorkOrderOperation: 10;
	    trackingOfUnplannedRoutingOperation: 11;
	    trackingOfUnplannedWorkOrderMaterial: 12;
	    trackingOfUnplannedBomMaterial: 13;
	    returnOfWorkOrderMaterial: 14;
	    returnOfUnplannedMaterial: 15;
	    bomReintegration: 16;
	    bomReintegrationOnNonPlannedMaterial: 17;
	}
	export type ProcessType2304 = keyof ProcessType2304$EnumInterface;
	export const processType2304Datatype: X3EnumDataType<keyof ProcessType2304$EnumInterface, unknown>;
	//# sourceMappingURL=process-type-2304.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/process-start-control.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/process-start-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcessStartControlEnum {
	    byWorkOrder = 1,
	    byPhase = 2,
	    byWeighing = 3
	}
	export interface ProcessStartControl$EnumInterface {
	    byWorkOrder: 1;
	    byPhase: 2;
	    byWeighing: 3;
	}
	export type ProcessStartControl = keyof ProcessStartControl$EnumInterface;
	export const processStartControlDatatype: X3EnumDataType<keyof ProcessStartControl$EnumInterface, unknown>;
	//# sourceMappingURL=process-start-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/procedure-types-box.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/procedure-types-box' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProcedureTypesBoxEnum {
	    openingOfBox = 1,
	    emptyBoxAtEndOfWorkOrder = 2,
	    emptyBoxAtEndOfPhase = 3
	}
	export interface ProcedureTypesBox$EnumInterface {
	    openingOfBox: 1;
	    emptyBoxAtEndOfWorkOrder: 2;
	    emptyBoxAtEndOfPhase: 3;
	}
	export type ProcedureTypesBox = keyof ProcedureTypesBox$EnumInterface;
	export const procedureTypesBoxDatatype: X3EnumDataType<keyof ProcedureTypesBox$EnumInterface, unknown>;
	//# sourceMappingURL=procedure-types-box.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/priority.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriorityEnum {
	    normal = 1,
	    urgent = 2,
	    veryUrgent = 3
	}
	export interface Priority$EnumInterface {
	    normal: 1;
	    urgent: 2;
	    veryUrgent: 3;
	}
	export type Priority = keyof Priority$EnumInterface;
	export const priorityDatatype: X3EnumDataType<keyof Priority$EnumInterface, unknown>;
	//# sourceMappingURL=priority.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/print-work-order-documents.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/print-work-order-documents' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintWorkOrderDocumentsEnum {
	    optional = 1,
	    mandatory = 2
	}
	export interface PrintWorkOrderDocuments$EnumInterface {
	    optional: 1;
	    mandatory: 2;
	}
	export type PrintWorkOrderDocuments = keyof PrintWorkOrderDocuments$EnumInterface;
	export const printWorkOrderDocumentsDatatype: X3EnumDataType<keyof PrintWorkOrderDocuments$EnumInterface, unknown>;
	//# sourceMappingURL=print-work-order-documents.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/parity.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/parity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParityEnum {
	    noParity = 1,
	    oddParity = 2,
	    evenParity = 3
	}
	export interface Parity$EnumInterface {
	    noParity: 1;
	    oddParity: 2;
	    evenParity: 3;
	}
	export type Parity = keyof Parity$EnumInterface;
	export const parityDatatype: X3EnumDataType<keyof Parity$EnumInterface, unknown>;
	//# sourceMappingURL=parity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/parameter-application-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/parameter-application-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ParameterApplicationTypeEnum {
	    no = 1,
	    yesNonExclusive = 2,
	    yesExclusive = 3
	}
	export interface ParameterApplicationType$EnumInterface {
	    no: 1;
	    yesNonExclusive: 2;
	    yesExclusive: 3;
	}
	export type ParameterApplicationType = keyof ParameterApplicationType$EnumInterface;
	export const parameterApplicationTypeDatatype: X3EnumDataType<keyof ParameterApplicationType$EnumInterface, unknown>;
	//# sourceMappingURL=parameter-application-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/overhead-formula-headings.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/overhead-formula-headings' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OverheadFormulaHeadingsEnum {
	    formulaA = 1,
	    formulaB = 2,
	    formulaC = 3,
	    formulaD = 4
	}
	export interface OverheadFormulaHeadings$EnumInterface {
	    formulaA: 1;
	    formulaB: 2;
	    formulaC: 3;
	    formulaD: 4;
	}
	export type OverheadFormulaHeadings = keyof OverheadFormulaHeadings$EnumInterface;
	export const overheadFormulaHeadingsDatatype: X3EnumDataType<keyof OverheadFormulaHeadings$EnumInterface, unknown>;
	//# sourceMappingURL=overhead-formula-headings.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/overhead-calculation-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/overhead-calculation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OverheadCalculationMethodEnum {
	    cumulated = 1,
	    compound = 2
	}
	export interface OverheadCalculationMethod$EnumInterface {
	    cumulated: 1;
	    compound: 2;
	}
	export type OverheadCalculationMethod = keyof OverheadCalculationMethod$EnumInterface;
	export const overheadCalculationMethodDatatype: X3EnumDataType<keyof OverheadCalculationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=overhead-calculation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/overhead-application-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/overhead-application-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OverheadApplicationMethodEnum {
	    stockReceipt = 1,
	    stockIssue = 2
	}
	export interface OverheadApplicationMethod$EnumInterface {
	    stockReceipt: 1;
	    stockIssue: 2;
	}
	export type OverheadApplicationMethod = keyof OverheadApplicationMethod$EnumInterface;
	export const overheadApplicationMethodDatatype: X3EnumDataType<keyof OverheadApplicationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=overhead-application-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/origin-of-suggestions.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/origin-of-suggestions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginOfSuggestionsEnum {
	    mps = 1,
	    mrp = 2,
	    all = 3
	}
	export interface OriginOfSuggestions$EnumInterface {
	    mps: 1;
	    mrp: 2;
	    all: 3;
	}
	export type OriginOfSuggestions = keyof OriginOfSuggestions$EnumInterface;
	export const originOfSuggestionsDatatype: X3EnumDataType<keyof OriginOfSuggestions$EnumInterface, unknown>;
	//# sourceMappingURL=origin-of-suggestions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/orders-to-be-processed.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/orders-to-be-processed' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrdersToBeProcessedEnum {
	    workOrdersSuggested = 1,
	    workOrdersPlanned = 2
	}
	export interface OrdersToBeProcessed$EnumInterface {
	    workOrdersSuggested: 1;
	    workOrdersPlanned: 2;
	}
	export type OrdersToBeProcessed = keyof OrdersToBeProcessed$EnumInterface;
	export const ordersToBeProcessedDatatype: X3EnumDataType<keyof OrdersToBeProcessed$EnumInterface, unknown>;
	//# sourceMappingURL=orders-to-be-processed.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/order-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/order-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderTypeEnum {
	    suggestedWorkOrder = 1,
	    workOrder = 2,
	    allTypes = 3
	}
	export interface OrderType$EnumInterface {
	    suggestedWorkOrder: 1;
	    workOrder: 2;
	    allTypes: 3;
	}
	export type OrderType = keyof OrderType$EnumInterface;
	export const orderTypeDatatype: X3EnumDataType<keyof OrderType$EnumInterface, unknown>;
	//# sourceMappingURL=order-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/order-status-no-translate.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/order-status-no-translate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderStatusNoTranslateEnum {
	    f = 1,
	    p = 2,
	    s = 3,
	    c = 4
	}
	export interface OrderStatusNoTranslate$EnumInterface {
	    f: 1;
	    p: 2;
	    s: 3;
	    c: 4;
	}
	export type OrderStatusNoTranslate = keyof OrderStatusNoTranslate$EnumInterface;
	export const orderStatusNoTranslateDatatype: X3EnumDataType<keyof OrderStatusNoTranslate$EnumInterface, unknown>;
	//# sourceMappingURL=order-status-no-translate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/order-mnemonics-no-translate.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/order-mnemonics-no-translate' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderMnemonicsNoTranslateEnum {
	    so = 1,
	    po = 2,
	    ms = 3,
	    sc = 4,
	    wo = 5,
	    mw = 6,
	    tr = 7,
	    tp = 8,
	    bw = 9,
	    vd = 10,
	    vr = 11,
	    cr = 12,
	    eo = 13,
	    mt = 14
	}
	export interface OrderMnemonicsNoTranslate$EnumInterface {
	    so: 1;
	    po: 2;
	    ms: 3;
	    sc: 4;
	    wo: 5;
	    mw: 6;
	    tr: 7;
	    tp: 8;
	    bw: 9;
	    vd: 10;
	    vr: 11;
	    cr: 12;
	    eo: 13;
	    mt: 14;
	}
	export type OrderMnemonicsNoTranslate = keyof OrderMnemonicsNoTranslate$EnumInterface;
	export const orderMnemonicsNoTranslateDatatype: X3EnumDataType<keyof OrderMnemonicsNoTranslate$EnumInterface, unknown>;
	//# sourceMappingURL=order-mnemonics-no-translate.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/optimization-priorities.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/optimization-priorities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OptimizationPrioritiesEnum {
	    woPriorityCode = 1,
	    forcedOperation = 2,
	    displacedOperation = 3,
	    firmStatus = 4,
	    plannedStatus = 5,
	    suggestedStatus = 6
	}
	export interface OptimizationPriorities$EnumInterface {
	    woPriorityCode: 1;
	    forcedOperation: 2;
	    displacedOperation: 3;
	    firmStatus: 4;
	    plannedStatus: 5;
	    suggestedStatus: 6;
	}
	export type OptimizationPriorities = keyof OptimizationPriorities$EnumInterface;
	export const optimizationPrioritiesDatatype: X3EnumDataType<keyof OptimizationPriorities$EnumInterface, unknown>;
	//# sourceMappingURL=optimization-priorities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/optimization-method.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/optimization-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OptimizationMethodEnum {
	    prepareDataGantt = 1,
	    prepareData = 2,
	    gantt = 3,
	    updateTheResults = 4
	}
	export interface OptimizationMethod$EnumInterface {
	    prepareDataGantt: 1;
	    prepareData: 2;
	    gantt: 3;
	    updateTheResults: 4;
	}
	export type OptimizationMethod = keyof OptimizationMethod$EnumInterface;
	export const optimizationMethodDatatype: X3EnumDataType<keyof OptimizationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=optimization-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/operation-time-codes.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/operation-time-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationTimeCodesEnum {
	    timeFor1 = 1,
	    timeFor100 = 2,
	    timeFor1000 = 3,
	    timePerLot = 4
	}
	export interface OperationTimeCodes$EnumInterface {
	    timeFor1: 1;
	    timeFor100: 2;
	    timeFor1000: 3;
	    timePerLot: 4;
	}
	export type OperationTimeCodes = keyof OperationTimeCodes$EnumInterface;
	export const operationTimeCodesDatatype: X3EnumDataType<keyof OperationTimeCodes$EnumInterface, unknown>;
	//# sourceMappingURL=operation-time-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/operation-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/operation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationStatusEnum {
	    pending = 1,
	    previousOperationInProcess = 2,
	    previousOperationClosed = 3,
	    inProcess = 4,
	    closed = 5,
	    excluded = 6,
	    ordered = 7
	}
	export interface OperationStatus$EnumInterface {
	    pending: 1;
	    previousOperationInProcess: 2;
	    previousOperationClosed: 3;
	    inProcess: 4;
	    closed: 5;
	    excluded: 6;
	    ordered: 7;
	}
	export type OperationStatus = keyof OperationStatus$EnumInterface;
	export const operationStatusDatatype: X3EnumDataType<keyof OperationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=operation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/operation-sort-criteria.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/operation-sort-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OperationSortCriteriaEnum {
	    expectedCompletionDate = 1,
	    workOrder = 2,
	    releasedProduct = 3,
	    workCenter = 4
	}
	export interface OperationSortCriteria$EnumInterface {
	    expectedCompletionDate: 1;
	    workOrder: 2;
	    releasedProduct: 3;
	    workCenter: 4;
	}
	export type OperationSortCriteria = keyof OperationSortCriteria$EnumInterface;
	export const operationSortCriteriaDatatype: X3EnumDataType<keyof OperationSortCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=operation-sort-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/oh-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/oh-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OhTypeEnum {
	    asPerContext = 1,
	    material = 2,
	    machine = 3,
	    labor = 4,
	    subcontracting = 5
	}
	export interface OhType$EnumInterface {
	    asPerContext: 1;
	    material: 2;
	    machine: 3;
	    labor: 4;
	    subcontracting: 5;
	}
	export type OhType = keyof OhType$EnumInterface;
	export const ohTypeDatatype: X3EnumDataType<keyof OhType$EnumInterface, unknown>;
	//# sourceMappingURL=oh-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/new-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/new-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NewStatusEnum {
	    planned = 1,
	    firm = 2
	}
	export interface NewStatus$EnumInterface {
	    planned: 1;
	    firm: 2;
	}
	export type NewStatus = keyof NewStatus$EnumInterface;
	export const newStatusDatatype: X3EnumDataType<keyof NewStatus$EnumInterface, unknown>;
	//# sourceMappingURL=new-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/mto-network-sort.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/mto-network-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MtoNetworkSortEnum {
	    byWo = 1,
	    bySite = 2,
	    byEndDate = 3
	}
	export interface MtoNetworkSort$EnumInterface {
	    byWo: 1;
	    bySite: 2;
	    byEndDate: 3;
	}
	export type MtoNetworkSort = keyof MtoNetworkSort$EnumInterface;
	export const mtoNetworkSortDatatype: X3EnumDataType<keyof MtoNetworkSort$EnumInterface, unknown>;
	//# sourceMappingURL=mto-network-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/mrp-message.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/mrp-message' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MrpMessageEnum {
	    noAction = 1,
	    advance = 2,
	    delay = 3,
	    increase = 4,
	    reduce = 5,
	    cancel = 6,
	    advanceIncrease = 7,
	    advanceReduce = 8,
	    delayIncrease = 9,
	    delayReduce = 10,
	    delayFirmHorizon = 11,
	    obsoleteProductEndOfLife = 12,
	    overstock = 13,
	    invalidRoutingVersion = 14
	}
	export interface MrpMessage$EnumInterface {
	    noAction: 1;
	    advance: 2;
	    delay: 3;
	    increase: 4;
	    reduce: 5;
	    cancel: 6;
	    advanceIncrease: 7;
	    advanceReduce: 8;
	    delayIncrease: 9;
	    delayReduce: 10;
	    delayFirmHorizon: 11;
	    obsoleteProductEndOfLife: 12;
	    overstock: 13;
	    invalidRoutingVersion: 14;
	}
	export type MrpMessage = keyof MrpMessage$EnumInterface;
	export const mrpMessageDatatype: X3EnumDataType<keyof MrpMessage$EnumInterface, unknown>;
	//# sourceMappingURL=mrp-message.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/mode-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/mode-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModeTypeEnum {
	    toBeCompleted = 1,
	    complete = 2
	}
	export interface ModeType$EnumInterface {
	    toBeCompleted: 1;
	    complete: 2;
	}
	export type ModeType = keyof ModeType$EnumInterface;
	export const modeTypeDatatype: X3EnumDataType<keyof ModeType$EnumInterface, unknown>;
	//# sourceMappingURL=mode-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/mode-selection.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/mode-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModeSelectionEnum {
	    no = 1,
	    manual = 2,
	    automatic = 3
	}
	export interface ModeSelection$EnumInterface {
	    no: 1;
	    manual: 2;
	    automatic: 3;
	}
	export type ModeSelection = keyof ModeSelection$EnumInterface;
	export const modeSelectionDatatype: X3EnumDataType<keyof ModeSelection$EnumInterface, unknown>;
	//# sourceMappingURL=mode-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/method-of-correction.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/method-of-correction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MethodOfCorrectionEnum {
	    lot = 1,
	    allocation = 2
	}
	export interface MethodOfCorrection$EnumInterface {
	    lot: 1;
	    allocation: 2;
	}
	export type MethodOfCorrection = keyof MethodOfCorrection$EnumInterface;
	export const methodOfCorrectionDatatype: X3EnumDataType<keyof MethodOfCorrection$EnumInterface, unknown>;
	//# sourceMappingURL=method-of-correction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-valuation-price-pr.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-valuation-price-pr' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialValuationPricePrEnum {
	    standardCost = 1,
	    revisedStandardCost = 2,
	    lastCost = 3,
	    averageCost = 4,
	    transactionCost = 5
	}
	export interface MaterialValuationPricePr$EnumInterface {
	    standardCost: 1;
	    revisedStandardCost: 2;
	    lastCost: 3;
	    averageCost: 4;
	    transactionCost: 5;
	}
	export type MaterialValuationPricePr = keyof MaterialValuationPricePr$EnumInterface;
	export const materialValuationPricePrDatatype: X3EnumDataType<keyof MaterialValuationPricePr$EnumInterface, unknown>;
	//# sourceMappingURL=material-valuation-price-pr.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-sort.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialSortEnum {
	    byProduct = 1,
	    byOperationProduct = 2,
	    byReservationDateProduct = 3,
	    bySequenceProduct = 4
	}
	export interface MaterialSort$EnumInterface {
	    byProduct: 1;
	    byOperationProduct: 2;
	    byReservationDateProduct: 3;
	    bySequenceProduct: 4;
	}
	export type MaterialSort = keyof MaterialSort$EnumInterface;
	export const materialSortDatatype: X3EnumDataType<keyof MaterialSort$EnumInterface, unknown>;
	//# sourceMappingURL=material-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-sort-criteria.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-sort-criteria' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialSortCriteriaEnum {
	    byDate = 1,
	    byComponent = 2,
	    byWorkOrder = 3,
	    byFinishedProduct = 4,
	    lot = 5
	}
	export interface MaterialSortCriteria$EnumInterface {
	    byDate: 1;
	    byComponent: 2;
	    byWorkOrder: 3;
	    byFinishedProduct: 4;
	    lot: 5;
	}
	export type MaterialSortCriteria = keyof MaterialSortCriteria$EnumInterface;
	export const materialSortCriteriaDatatype: X3EnumDataType<keyof MaterialSortCriteria$EnumInterface, unknown>;
	//# sourceMappingURL=material-sort-criteria.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-reconciliation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-reconciliation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialReconciliationEnum {
	    byWorkOrder = 1,
	    byPhase = 2,
	    byContainer = 3
	}
	export interface MaterialReconciliation$EnumInterface {
	    byWorkOrder: 1;
	    byPhase: 2;
	    byContainer: 3;
	}
	export type MaterialReconciliation = keyof MaterialReconciliation$EnumInterface;
	export const materialReconciliationDatatype: X3EnumDataType<keyof MaterialReconciliation$EnumInterface, unknown>;
	//# sourceMappingURL=material-reconciliation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-list-loading.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-list-loading' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialListLoadingEnum {
	    whenEnteringFunctionWeighingByMaterial = 1,
	    beforeEachLoading = 2
	}
	export interface MaterialListLoading$EnumInterface {
	    whenEnteringFunctionWeighingByMaterial: 1;
	    beforeEachLoading: 2;
	}
	export type MaterialListLoading = keyof MaterialListLoading$EnumInterface;
	export const materialListLoadingDatatype: X3EnumDataType<keyof MaterialListLoading$EnumInterface, unknown>;
	//# sourceMappingURL=material-list-loading.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-cost-selection.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-cost-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialCostSelectionEnum {
	    standardCost = 1,
	    revisedStandardCost = 2,
	    budgetCost = 3,
	    simulatedCost = 4,
	    lastCost = 5,
	    averageCost = 6,
	    lastPurchasePrice = 7,
	    listPrice = 8
	}
	export interface MaterialCostSelection$EnumInterface {
	    standardCost: 1;
	    revisedStandardCost: 2;
	    budgetCost: 3;
	    simulatedCost: 4;
	    lastCost: 5;
	    averageCost: 6;
	    lastPurchasePrice: 7;
	    listPrice: 8;
	}
	export type MaterialCostSelection = keyof MaterialCostSelection$EnumInterface;
	export const materialCostSelectionDatatype: X3EnumDataType<keyof MaterialCostSelection$EnumInterface, unknown>;
	//# sourceMappingURL=material-cost-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-consumption.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-consumption' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialConsumptionEnum {
	    no = 1,
	    yesManual = 2,
	    yesAutomatic = 3,
	    yesManualAndAutomatic = 4
	}
	export interface MaterialConsumption$EnumInterface {
	    no: 1;
	    yesManual: 2;
	    yesAutomatic: 3;
	    yesManualAndAutomatic: 4;
	}
	export type MaterialConsumption = keyof MaterialConsumption$EnumInterface;
	export const materialConsumptionDatatype: X3EnumDataType<keyof MaterialConsumption$EnumInterface, unknown>;
	//# sourceMappingURL=material-consumption.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-consumption-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-consumption-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialConsumptionModeEnum {
	    forExpectedQuantityOnFirstTrack = 1,
	    byQuantityProducedLimited = 2,
	    byQuantityProducedUnlimited = 3
	}
	export interface MaterialConsumptionMode$EnumInterface {
	    forExpectedQuantityOnFirstTrack: 1;
	    byQuantityProducedLimited: 2;
	    byQuantityProducedUnlimited: 3;
	}
	export type MaterialConsumptionMode = keyof MaterialConsumptionMode$EnumInterface;
	export const materialConsumptionModeDatatype: X3EnumDataType<keyof MaterialConsumptionMode$EnumInterface, unknown>;
	//# sourceMappingURL=material-consumption-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-allocation-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-allocation-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialAllocationStatusEnum {
	    none = 1,
	    globalWithShortage = 2,
	    global = 3,
	    detailedWithShortage = 4,
	    detailed = 5
	}
	export interface MaterialAllocationStatus$EnumInterface {
	    none: 1;
	    globalWithShortage: 2;
	    global: 3;
	    detailedWithShortage: 4;
	    detailed: 5;
	}
	export type MaterialAllocationStatus = keyof MaterialAllocationStatus$EnumInterface;
	export const materialAllocationStatusDatatype: X3EnumDataType<keyof MaterialAllocationStatus$EnumInterface, unknown>;
	//# sourceMappingURL=material-allocation-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/material-accumulation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/material-accumulation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialAccumulationEnum {
	    noAccumulation = 1,
	    accumulationUponRelease = 2,
	    accumulationUponTracking = 3
	}
	export interface MaterialAccumulation$EnumInterface {
	    noAccumulation: 1;
	    accumulationUponRelease: 2;
	    accumulationUponTracking: 3;
	}
	export type MaterialAccumulation = keyof MaterialAccumulation$EnumInterface;
	export const materialAccumulationDatatype: X3EnumDataType<keyof MaterialAccumulation$EnumInterface, unknown>;
	//# sourceMappingURL=material-accumulation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/lot-mix.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/lot-mix' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotMixEnum {
	    yes = 1,
	    notInWeighing = 2,
	    notInManufacture = 3
	}
	export interface LotMix$EnumInterface {
	    yes: 1;
	    notInWeighing: 2;
	    notInManufacture: 3;
	}
	export type LotMix = keyof LotMix$EnumInterface;
	export const lotMixDatatype: X3EnumDataType<keyof LotMix$EnumInterface, unknown>;
	//# sourceMappingURL=lot-mix.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/lot-creation-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/lot-creation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotCreationModeEnum {
	    noStockRulesApplied = 1,
	    inPlanning = 2,
	    inRelease = 3,
	    atFirstTracking = 4
	}
	export interface LotCreationMode$EnumInterface {
	    noStockRulesApplied: 1;
	    inPlanning: 2;
	    inRelease: 3;
	    atFirstTracking: 4;
	}
	export type LotCreationMode = keyof LotCreationMode$EnumInterface;
	export const lotCreationModeDatatype: X3EnumDataType<keyof LotCreationMode$EnumInterface, unknown>;
	//# sourceMappingURL=lot-creation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/lot-choice.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/lot-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotChoiceEnum {
	    no = 1,
	    yesWithControl = 2,
	    yes = 3
	}
	export interface LotChoice$EnumInterface {
	    no: 1;
	    yesWithControl: 2;
	    yes: 3;
	}
	export type LotChoice = keyof LotChoice$EnumInterface;
	export const lotChoiceDatatype: X3EnumDataType<keyof LotChoice$EnumInterface, unknown>;
	//# sourceMappingURL=lot-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/load-report.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/load-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadReportEnum {
	    notScheduled = 1,
	    scheduled = 2
	}
	export interface LoadReport$EnumInterface {
	    notScheduled: 1;
	    scheduled: 2;
	}
	export type LoadReport = keyof LoadReport$EnumInterface;
	export const loadReportDatatype: X3EnumDataType<keyof LoadReport$EnumInterface, unknown>;
	//# sourceMappingURL=load-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/load-classification.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/load-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LoadClassificationEnum {
	    byStartDate = 1,
	    byWorkCenterGroup = 2,
	    byWorkCenter = 3,
	    byWorkOrder = 4,
	    byLoadType = 5,
	    byStatus = 6
	}
	export interface LoadClassification$EnumInterface {
	    byStartDate: 1;
	    byWorkCenterGroup: 2;
	    byWorkCenter: 3;
	    byWorkOrder: 4;
	    byLoadType: 5;
	    byStatus: 6;
	}
	export type LoadClassification = keyof LoadClassification$EnumInterface;
	export const loadClassificationDatatype: X3EnumDataType<keyof LoadClassification$EnumInterface, unknown>;
	//# sourceMappingURL=load-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/link-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/link-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LinkTypeEnum {
	    completeOrder = 1,
	    releasedProduct = 2
	}
	export interface LinkType$EnumInterface {
	    completeOrder: 1;
	    releasedProduct: 2;
	}
	export type LinkType = keyof LinkType$EnumInterface;
	export const linkTypeDatatype: X3EnumDataType<keyof LinkType$EnumInterface, unknown>;
	//# sourceMappingURL=link-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/launching-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/launching-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LaunchingModeEnum {
	    full = 1,
	    materialsOnly = 2,
	    operationsOnly = 3,
	    all = 4
	}
	export interface LaunchingMode$EnumInterface {
	    full: 1;
	    materialsOnly: 2;
	    operationsOnly: 3;
	    all: 4;
	}
	export type LaunchingMode = keyof LaunchingMode$EnumInterface;
	export const launchingModeDatatype: X3EnumDataType<keyof LaunchingMode$EnumInterface, unknown>;
	//# sourceMappingURL=launching-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/labor-rate-choice.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/labor-rate-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LaborRateChoiceEnum {
	    workCenterRate = 1,
	    operatorRate = 2,
	    operatorElseWorkCenter = 3
	}
	export interface LaborRateChoice$EnumInterface {
	    workCenterRate: 1;
	    operatorRate: 2;
	    operatorElseWorkCenter: 3;
	}
	export type LaborRateChoice = keyof LaborRateChoice$EnumInterface;
	export const laborRateChoiceDatatype: X3EnumDataType<keyof LaborRateChoice$EnumInterface, unknown>;
	//# sourceMappingURL=labor-rate-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/labeling-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/labeling-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelingModeEnum {
	    manual = 1,
	    automatic = 2
	}
	export interface LabelingMode$EnumInterface {
	    manual: 1;
	    automatic: 2;
	}
	export type LabelingMode = keyof LabelingMode$EnumInterface;
	export const labelingModeDatatype: X3EnumDataType<keyof LabelingMode$EnumInterface, unknown>;
	//# sourceMappingURL=labeling-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/label-printing-2334.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/label-printing-2334' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelPrinting2334Enum {
	    noPrinting = 1,
	    notPrinted = 2,
	    printed = 3,
	    rePrinted = 4
	}
	export interface LabelPrinting2334$EnumInterface {
	    noPrinting: 1;
	    notPrinted: 2;
	    printed: 3;
	    rePrinted: 4;
	}
	export type LabelPrinting2334 = keyof LabelPrinting2334$EnumInterface;
	export const labelPrinting2334Datatype: X3EnumDataType<keyof LabelPrinting2334$EnumInterface, unknown>;
	//# sourceMappingURL=label-printing-2334.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/indirect-access.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/indirect-access' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IndirectAccessEnum {
	    user = 1,
	    supervisor = 2
	}
	export interface IndirectAccess$EnumInterface {
	    user: 1;
	    supervisor: 2;
	}
	export type IndirectAccess = keyof IndirectAccess$EnumInterface;
	export const indirectAccessDatatype: X3EnumDataType<keyof IndirectAccess$EnumInterface, unknown>;
	//# sourceMappingURL=indirect-access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/index.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/index' {
	export * from '@sage/x3-manufacturing-data/lib/enums/actual-overhead-calculation-base';
	export * from '@sage/x3-manufacturing-data/lib/enums/allergens';
	export * from '@sage/x3-manufacturing-data/lib/enums/allocation-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/allocation-priority';
	export * from '@sage/x3-manufacturing-data/lib/enums/allocation-sorts';
	export * from '@sage/x3-manufacturing-data/lib/enums/analysis-dimensions';
	export * from '@sage/x3-manufacturing-data/lib/enums/apply-link-qty-rounding';
	export * from '@sage/x3-manufacturing-data/lib/enums/authorized-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/availability-balance';
	export * from '@sage/x3-manufacturing-data/lib/enums/base-formula-to-calculate-cost';
	export * from '@sage/x3-manufacturing-data/lib/enums/bc-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/bi-mfg-line-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/bom-use';
	export * from '@sage/x3-manufacturing-data/lib/enums/calibration-code';
	export * from '@sage/x3-manufacturing-data/lib/enums/cancellation-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/charge-code-no-translation';
	export * from '@sage/x3-manufacturing-data/lib/enums/charge-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/choice-relupd';
	export * from '@sage/x3-manufacturing-data/lib/enums/classification';
	export * from '@sage/x3-manufacturing-data/lib/enums/closing-controls';
	export * from '@sage/x3-manufacturing-data/lib/enums/component-types';
	export * from '@sage/x3-manufacturing-data/lib/enums/consolidate-load';
	export * from '@sage/x3-manufacturing-data/lib/enums/control-tracking-prev-op';
	export * from '@sage/x3-manufacturing-data/lib/enums/control-upon-closing';
	export * from '@sage/x3-manufacturing-data/lib/enums/cost-level-choice';
	export * from '@sage/x3-manufacturing-data/lib/enums/cost-to-compare';
	export * from '@sage/x3-manufacturing-data/lib/enums/cost-type-314';
	export * from '@sage/x3-manufacturing-data/lib/enums/crystal-reports-production';
	export * from '@sage/x3-manufacturing-data/lib/enums/crystal-reports-wo-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/deallocation-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/default-quantity';
	export * from '@sage/x3-manufacturing-data/lib/enums/descheduling-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/dimension-rate-selection';
	export * from '@sage/x3-manufacturing-data/lib/enums/display-level';
	export * from '@sage/x3-manufacturing-data/lib/enums/efficiency-application';
	export * from '@sage/x3-manufacturing-data/lib/enums/employee-activity-sort';
	export * from '@sage/x3-manufacturing-data/lib/enums/enter-measurement';
	export * from '@sage/x3-manufacturing-data/lib/enums/entry-mode-9641';
	export * from '@sage/x3-manufacturing-data/lib/enums/entry-type-2376';
	export * from '@sage/x3-manufacturing-data/lib/enums/entry-unit';
	export * from '@sage/x3-manufacturing-data/lib/enums/enum-9154';
	export * from '@sage/x3-manufacturing-data/lib/enums/exclusive-codes';
	export * from '@sage/x3-manufacturing-data/lib/enums/expected-material-costing-pric';
	export * from '@sage/x3-manufacturing-data/lib/enums/fdma-recalculation';
	export * from '@sage/x3-manufacturing-data/lib/enums/filter-2373';
	export * from '@sage/x3-manufacturing-data/lib/enums/filter-operations';
	export * from '@sage/x3-manufacturing-data/lib/enums/filter-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/filter';
	export * from '@sage/x3-manufacturing-data/lib/enums/fixed-cost-distribution-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/fixed-overhead-headings';
	export * from '@sage/x3-manufacturing-data/lib/enums/frequency-2305';
	export * from '@sage/x3-manufacturing-data/lib/enums/group-cost-report';
	export * from '@sage/x3-manufacturing-data/lib/enums/historical-sort';
	export * from '@sage/x3-manufacturing-data/lib/enums/indirect-access';
	export * from '@sage/x3-manufacturing-data/lib/enums/label-printing-2334';
	export * from '@sage/x3-manufacturing-data/lib/enums/labeling-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/labor-rate-choice';
	export * from '@sage/x3-manufacturing-data/lib/enums/launching-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/link-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/load-classification';
	export * from '@sage/x3-manufacturing-data/lib/enums/load-report';
	export * from '@sage/x3-manufacturing-data/lib/enums/lot-choice';
	export * from '@sage/x3-manufacturing-data/lib/enums/lot-creation-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/lot-mix';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-accumulation';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-allocation-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-consumption-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-consumption';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-cost-selection';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-list-loading';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-reconciliation';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-sort-criteria';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-sort';
	export * from '@sage/x3-manufacturing-data/lib/enums/material-valuation-price-pr';
	export * from '@sage/x3-manufacturing-data/lib/enums/method-of-correction';
	export * from '@sage/x3-manufacturing-data/lib/enums/mode-selection';
	export * from '@sage/x3-manufacturing-data/lib/enums/mode-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/mrp-message';
	export * from '@sage/x3-manufacturing-data/lib/enums/mto-network-sort';
	export * from '@sage/x3-manufacturing-data/lib/enums/new-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/oh-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/operation-sort-criteria';
	export * from '@sage/x3-manufacturing-data/lib/enums/operation-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/operation-time-codes';
	export * from '@sage/x3-manufacturing-data/lib/enums/optimization-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/optimization-priorities';
	export * from '@sage/x3-manufacturing-data/lib/enums/order-mnemonics-no-translate';
	export * from '@sage/x3-manufacturing-data/lib/enums/order-status-no-translate';
	export * from '@sage/x3-manufacturing-data/lib/enums/order-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/orders-to-be-processed';
	export * from '@sage/x3-manufacturing-data/lib/enums/origin-of-suggestions';
	export * from '@sage/x3-manufacturing-data/lib/enums/overhead-application-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/overhead-calculation-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/overhead-formula-headings';
	export * from '@sage/x3-manufacturing-data/lib/enums/parameter-application-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/parity';
	export * from '@sage/x3-manufacturing-data/lib/enums/print-work-order-documents';
	export * from '@sage/x3-manufacturing-data/lib/enums/priority';
	export * from '@sage/x3-manufacturing-data/lib/enums/procedure-types-box';
	export * from '@sage/x3-manufacturing-data/lib/enums/process-start-control';
	export * from '@sage/x3-manufacturing-data/lib/enums/process-type-2304';
	export * from '@sage/x3-manufacturing-data/lib/enums/processing-mode-372';
	export * from '@sage/x3-manufacturing-data/lib/enums/processing-mode-395';
	export * from '@sage/x3-manufacturing-data/lib/enums/prod-sched-operation-fields';
	export * from '@sage/x3-manufacturing-data/lib/enums/product-analysis';
	export * from '@sage/x3-manufacturing-data/lib/enums/product-code';
	export * from '@sage/x3-manufacturing-data/lib/enums/product-recontrol-in-station';
	export * from '@sage/x3-manufacturing-data/lib/enums/product-sort-criteria';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-cost-detail-titles';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-cost-print-detail';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-cost-report';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-cost-sorting';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-documents';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-order-processed';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-scheduler-wo-fields';
	export * from '@sage/x3-manufacturing-data/lib/enums/production-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/project-code';
	export * from '@sage/x3-manufacturing-data/lib/enums/provisional-cost-print';
	export * from '@sage/x3-manufacturing-data/lib/enums/provisional-cost-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/ps-fdma-recalculation';
	export * from '@sage/x3-manufacturing-data/lib/enums/quantity-type-2311';
	export * from '@sage/x3-manufacturing-data/lib/enums/reason-for-reprint';
	export * from '@sage/x3-manufacturing-data/lib/enums/release-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/report-allocation-sorting';
	export * from '@sage/x3-manufacturing-data/lib/enums/resource-analysis';
	export * from '@sage/x3-manufacturing-data/lib/enums/result-standarization';
	export * from '@sage/x3-manufacturing-data/lib/enums/role-of-the-transaction';
	export * from '@sage/x3-manufacturing-data/lib/enums/routing-modification-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/routing-use';
	export * from '@sage/x3-manufacturing-data/lib/enums/run-time-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/sales-order-allocation-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/schedule-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/schedule-validated';
	export * from '@sage/x3-manufacturing-data/lib/enums/scheduling-code';
	export * from '@sage/x3-manufacturing-data/lib/enums/scheduling-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/scheduling-process';
	export * from '@sage/x3-manufacturing-data/lib/enums/scheduling-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/sel-hist-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/select-lead-time';
	export * from '@sage/x3-manufacturing-data/lib/enums/select-management-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/select-scheduling-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/selection-order';
	export * from '@sage/x3-manufacturing-data/lib/enums/semi-final-valuation-price-p';
	export * from '@sage/x3-manufacturing-data/lib/enums/separator';
	export * from '@sage/x3-manufacturing-data/lib/enums/sequence-the-weighing-plan';
	export * from '@sage/x3-manufacturing-data/lib/enums/serial-number-link-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/setup-time-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/shop-floor-activities';
	export * from '@sage/x3-manufacturing-data/lib/enums/shop-floor-tracking';
	export * from '@sage/x3-manufacturing-data/lib/enums/slack-time-compression';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-allocations';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-booked-times';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-component-weighing-situat';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-criteria-2370';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-material-consumptions';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-sub-contract';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-weighing-situation-histor';
	export * from '@sage/x3-manufacturing-data/lib/enums/sort-wo';
	export * from '@sage/x3-manufacturing-data/lib/enums/splitting';
	export * from '@sage/x3-manufacturing-data/lib/enums/state-of-the-balance';
	export * from '@sage/x3-manufacturing-data/lib/enums/status-in-progress';
	export * from '@sage/x3-manufacturing-data/lib/enums/statuses-to-process';
	export * from '@sage/x3-manufacturing-data/lib/enums/stop-bit';
	export * from '@sage/x3-manufacturing-data/lib/enums/sub-contract-close-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/subcontracting';
	export * from '@sage/x3-manufacturing-data/lib/enums/supplier-packaging';
	export * from '@sage/x3-manufacturing-data/lib/enums/tank-recontrol';
	export * from '@sage/x3-manufacturing-data/lib/enums/technical-sheet-control';
	export * from '@sage/x3-manufacturing-data/lib/enums/time-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/time-unit-code';
	export * from '@sage/x3-manufacturing-data/lib/enums/tolerance-application';
	export * from '@sage/x3-manufacturing-data/lib/enums/tracking-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/transaction-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-allocation-349';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-container';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-manufacturing-cost';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-sentence';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-time';
	export * from '@sage/x3-manufacturing-data/lib/enums/type-of-weighing';
	export * from '@sage/x3-manufacturing-data/lib/enums/update';
	export * from '@sage/x3-manufacturing-data/lib/enums/user-role';
	export * from '@sage/x3-manufacturing-data/lib/enums/variance-calculation-source';
	export * from '@sage/x3-manufacturing-data/lib/enums/variance-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/weigh-station-taken-into-acc';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing-method';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing-options';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing-station-messages';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing-status-material-mwf';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing-status-wo-wof';
	export * from '@sage/x3-manufacturing-data/lib/enums/weighing';
	export * from '@sage/x3-manufacturing-data/lib/enums/wip-choice';
	export * from '@sage/x3-manufacturing-data/lib/enums/wip-line-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/wip-transaction-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/wip-valuation';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-list-sort';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-provisional-cost-calculation';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-sort-order-2391';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-sort-order';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-unforeseen-elements';
	export * from '@sage/x3-manufacturing-data/lib/enums/wo-wip-header';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-center-type-2423';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-center-type-315';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-center-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-allocation-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-allocation-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-management-mode';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-preparation-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-situation';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-status';
	export * from '@sage/x3-manufacturing-data/lib/enums/work-order-type';
	export * from '@sage/x3-manufacturing-data/lib/enums/workload-initialization';
	export * from '@sage/x3-manufacturing-data/lib/enums/workstation-type-long';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/historical-sort.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/historical-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HistoricalSortEnum {
	    byDate = 1,
	    byQuantity = 2
	}
	export interface HistoricalSort$EnumInterface {
	    byDate: 1;
	    byQuantity: 2;
	}
	export type HistoricalSort = keyof HistoricalSort$EnumInterface;
	export const historicalSortDatatype: X3EnumDataType<keyof HistoricalSort$EnumInterface, unknown>;
	//# sourceMappingURL=historical-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/group-cost-report.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/group-cost-report' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupCostReportEnum {
	    material = 1,
	    machine = 2,
	    labor = 3,
	    subcontracting = 4,
	    overheadCosts = 5,
	    calculatedCost = 6
	}
	export interface GroupCostReport$EnumInterface {
	    material: 1;
	    machine: 2;
	    labor: 3;
	    subcontracting: 4;
	    overheadCosts: 5;
	    calculatedCost: 6;
	}
	export type GroupCostReport = keyof GroupCostReport$EnumInterface;
	export const groupCostReportDatatype: X3EnumDataType<keyof GroupCostReport$EnumInterface, unknown>;
	//# sourceMappingURL=group-cost-report.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/frequency-2305.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/frequency-2305' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Frequency2305Enum {
	    dayS = 1,
	    weekS = 2,
	    months = 3
	}
	export interface Frequency2305$EnumInterface {
	    dayS: 1;
	    weekS: 2;
	    months: 3;
	}
	export type Frequency2305 = keyof Frequency2305$EnumInterface;
	export const frequency2305Datatype: X3EnumDataType<keyof Frequency2305$EnumInterface, unknown>;
	//# sourceMappingURL=frequency-2305.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/fixed-overhead-headings.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/fixed-overhead-headings' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FixedOverheadHeadingsEnum {
	    fixedA = 1,
	    fixedB = 2,
	    fixedC = 3,
	    fixedD = 4
	}
	export interface FixedOverheadHeadings$EnumInterface {
	    fixedA: 1;
	    fixedB: 2;
	    fixedC: 3;
	    fixedD: 4;
	}
	export type FixedOverheadHeadings = keyof FixedOverheadHeadings$EnumInterface;
	export const fixedOverheadHeadingsDatatype: X3EnumDataType<keyof FixedOverheadHeadings$EnumInterface, unknown>;
	//# sourceMappingURL=fixed-overhead-headings.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/fixed-cost-distribution-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/fixed-cost-distribution-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FixedCostDistributionModeEnum {
	    proRata = 1,
	    total = 2
	}
	export interface FixedCostDistributionMode$EnumInterface {
	    proRata: 1;
	    total: 2;
	}
	export type FixedCostDistributionMode = keyof FixedCostDistributionMode$EnumInterface;
	export const fixedCostDistributionModeDatatype: X3EnumDataType<keyof FixedCostDistributionMode$EnumInterface, unknown>;
	//# sourceMappingURL=fixed-cost-distribution-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/filter.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/filter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterEnum {
	    notClosed = 1,
	    closed = 2,
	    all = 3
	}
	export interface Filter$EnumInterface {
	    notClosed: 1;
	    closed: 2;
	    all: 3;
	}
	export type Filter = keyof Filter$EnumInterface;
	export const filterDatatype: X3EnumDataType<keyof Filter$EnumInterface, unknown>;
	//# sourceMappingURL=filter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/filter-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/filter-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterTypeEnum {
	    none = 1,
	    nonexclusiveFilter = 2,
	    exclusiveFilter = 3
	}
	export interface FilterType$EnumInterface {
	    none: 1;
	    nonexclusiveFilter: 2;
	    exclusiveFilter: 3;
	}
	export type FilterType = keyof FilterType$EnumInterface;
	export const filterTypeDatatype: X3EnumDataType<keyof FilterType$EnumInterface, unknown>;
	//# sourceMappingURL=filter-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/filter-operations.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/filter-operations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterOperationsEnum {
	    notClosed = 1,
	    closed = 2,
	    all = 3
	}
	export interface FilterOperations$EnumInterface {
	    notClosed: 1;
	    closed: 2;
	    all: 3;
	}
	export type FilterOperations = keyof FilterOperations$EnumInterface;
	export const filterOperationsDatatype: X3EnumDataType<keyof FilterOperations$EnumInterface, unknown>;
	//# sourceMappingURL=filter-operations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/filter-2373.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/filter-2373' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Filter2373Enum {
	    completeOrClose = 1,
	    complete = 2,
	    close = 3
	}
	export interface Filter2373$EnumInterface {
	    completeOrClose: 1;
	    complete: 2;
	    close: 3;
	}
	export type Filter2373 = keyof Filter2373$EnumInterface;
	export const filter2373Datatype: X3EnumDataType<keyof Filter2373$EnumInterface, unknown>;
	//# sourceMappingURL=filter-2373.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/fdma-recalculation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/fdma-recalculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FdmaRecalculationEnum {
	    forWorkOrdersInclStatusBeingOptimized = 1,
	    forWorkOrdersInclStatusOptimized = 2,
	    forWorkOrdersInclStatusInProgress = 3
	}
	export interface FdmaRecalculation$EnumInterface {
	    forWorkOrdersInclStatusBeingOptimized: 1;
	    forWorkOrdersInclStatusOptimized: 2;
	    forWorkOrdersInclStatusInProgress: 3;
	}
	export type FdmaRecalculation = keyof FdmaRecalculation$EnumInterface;
	export const fdmaRecalculationDatatype: X3EnumDataType<keyof FdmaRecalculation$EnumInterface, unknown>;
	//# sourceMappingURL=fdma-recalculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/expected-material-costing-pric.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/expected-material-costing-pric' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpectedMaterialCostingPricEnum {
	    standardPrice = 1,
	    revisedStandardPrice = 2,
	    lastPrice = 3,
	    averageWeightedPrice = 4
	}
	export interface ExpectedMaterialCostingPric$EnumInterface {
	    standardPrice: 1;
	    revisedStandardPrice: 2;
	    lastPrice: 3;
	    averageWeightedPrice: 4;
	}
	export type ExpectedMaterialCostingPric = keyof ExpectedMaterialCostingPric$EnumInterface;
	export const expectedMaterialCostingPricDatatype: X3EnumDataType<keyof ExpectedMaterialCostingPric$EnumInterface, unknown>;
	//# sourceMappingURL=expected-material-costing-pric.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/exclusive-codes.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/exclusive-codes' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExclusiveCodesEnum {
	    timeOff = 1,
	    break = 2,
	    nonExclusiveLabor = 3,
	    exclusiveLabor = 4,
	    autoBreak = 5
	}
	export interface ExclusiveCodes$EnumInterface {
	    timeOff: 1;
	    break: 2;
	    nonExclusiveLabor: 3;
	    exclusiveLabor: 4;
	    autoBreak: 5;
	}
	export type ExclusiveCodes = keyof ExclusiveCodes$EnumInterface;
	export const exclusiveCodesDatatype: X3EnumDataType<keyof ExclusiveCodes$EnumInterface, unknown>;
	//# sourceMappingURL=exclusive-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/enum-9154.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/enum-9154' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Enum9154Enum {
	    automatic = 1,
	    manual = 2,
	    no = 3
	}
	export interface Enum9154$EnumInterface {
	    automatic: 1;
	    manual: 2;
	    no: 3;
	}
	export type Enum9154 = keyof Enum9154$EnumInterface;
	export const enum9154Datatype: X3EnumDataType<keyof Enum9154$EnumInterface, unknown>;
	//# sourceMappingURL=enum-9154.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/entry-unit.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/entry-unit' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryUnitEnum {
	    unitOfOperation = 1,
	    unitOfStock = 2
	}
	export interface EntryUnit$EnumInterface {
	    unitOfOperation: 1;
	    unitOfStock: 2;
	}
	export type EntryUnit = keyof EntryUnit$EnumInterface;
	export const entryUnitDatatype: X3EnumDataType<keyof EntryUnit$EnumInterface, unknown>;
	//# sourceMappingURL=entry-unit.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/entry-type-2376.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/entry-type-2376' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryType2376Enum {
	    creation = 1,
	    modification = 2,
	    all = 3
	}
	export interface EntryType2376$EnumInterface {
	    creation: 1;
	    modification: 2;
	    all: 3;
	}
	export type EntryType2376 = keyof EntryType2376$EnumInterface;
	export const entryType2376Datatype: X3EnumDataType<keyof EntryType2376$EnumInterface, unknown>;
	//# sourceMappingURL=entry-type-2376.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/entry-mode-9641.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/entry-mode-9641' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryMode9641Enum {
	    byWeighingNumber = 1,
	    complete = 2
	}
	export interface EntryMode9641$EnumInterface {
	    byWeighingNumber: 1;
	    complete: 2;
	}
	export type EntryMode9641 = keyof EntryMode9641$EnumInterface;
	export const entryMode9641Datatype: X3EnumDataType<keyof EntryMode9641$EnumInterface, unknown>;
	//# sourceMappingURL=entry-mode-9641.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/enter-measurement.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/enter-measurement' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EnterMeasurementEnum {
	    mandatory = 1,
	    optional = 2,
	    prohibited = 3
	}
	export interface EnterMeasurement$EnumInterface {
	    mandatory: 1;
	    optional: 2;
	    prohibited: 3;
	}
	export type EnterMeasurement = keyof EnterMeasurement$EnumInterface;
	export const enterMeasurementDatatype: X3EnumDataType<keyof EnterMeasurement$EnumInterface, unknown>;
	//# sourceMappingURL=enter-measurement.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/employee-activity-sort.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/employee-activity-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EmployeeActivitySortEnum {
	    employeeId = 1,
	    activityType = 2,
	    startDate = 3,
	    endDate = 4,
	    workOrder = 5,
	    indirectReferences = 6,
	    numberOfJobs = 7
	}
	export interface EmployeeActivitySort$EnumInterface {
	    employeeId: 1;
	    activityType: 2;
	    startDate: 3;
	    endDate: 4;
	    workOrder: 5;
	    indirectReferences: 6;
	    numberOfJobs: 7;
	}
	export type EmployeeActivitySort = keyof EmployeeActivitySort$EnumInterface;
	export const employeeActivitySortDatatype: X3EnumDataType<keyof EmployeeActivitySort$EnumInterface, unknown>;
	//# sourceMappingURL=employee-activity-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/efficiency-application.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/efficiency-application' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EfficiencyApplicationEnum {
	    setupRunTimes = 1,
	    runTime = 2
	}
	export interface EfficiencyApplication$EnumInterface {
	    setupRunTimes: 1;
	    runTime: 2;
	}
	export type EfficiencyApplication = keyof EfficiencyApplication$EnumInterface;
	export const efficiencyApplicationDatatype: X3EnumDataType<keyof EfficiencyApplication$EnumInterface, unknown>;
	//# sourceMappingURL=efficiency-application.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/display-level.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/display-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DisplayLevelEnum {
	    level1 = 1,
	    level2 = 2,
	    level3 = 3
	}
	export interface DisplayLevel$EnumInterface {
	    level1: 1;
	    level2: 2;
	    level3: 3;
	}
	export type DisplayLevel = keyof DisplayLevel$EnumInterface;
	export const displayLevelDatatype: X3EnumDataType<keyof DisplayLevel$EnumInterface, unknown>;
	//# sourceMappingURL=display-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/dimension-rate-selection.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/dimension-rate-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DimensionRateSelectionEnum {
	    standard = 1,
	    revisedStandard = 2,
	    budget = 3,
	    simulation = 4
	}
	export interface DimensionRateSelection$EnumInterface {
	    standard: 1;
	    revisedStandard: 2;
	    budget: 3;
	    simulation: 4;
	}
	export type DimensionRateSelection = keyof DimensionRateSelection$EnumInterface;
	export const dimensionRateSelectionDatatype: X3EnumDataType<keyof DimensionRateSelection$EnumInterface, unknown>;
	//# sourceMappingURL=dimension-rate-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/descheduling-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/descheduling-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeschedulingTypeEnum {
	    deschedule = 1,
	    flagForReschedule = 2
	}
	export interface DeschedulingType$EnumInterface {
	    deschedule: 1;
	    flagForReschedule: 2;
	}
	export type DeschedulingType = keyof DeschedulingType$EnumInterface;
	export const deschedulingTypeDatatype: X3EnumDataType<keyof DeschedulingType$EnumInterface, unknown>;
	//# sourceMappingURL=descheduling-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/default-quantity.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/default-quantity' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultQuantityEnum {
	    none = 1,
	    technicalLot = 2,
	    economicLot = 3
	}
	export interface DefaultQuantity$EnumInterface {
	    none: 1;
	    technicalLot: 2;
	    economicLot: 3;
	}
	export type DefaultQuantity = keyof DefaultQuantity$EnumInterface;
	export const defaultQuantityDatatype: X3EnumDataType<keyof DefaultQuantity$EnumInterface, unknown>;
	//# sourceMappingURL=default-quantity.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/deallocation-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/deallocation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeallocationModeEnum {
	    complete = 1,
	    byAllocationType = 2
	}
	export interface DeallocationMode$EnumInterface {
	    complete: 1;
	    byAllocationType: 2;
	}
	export type DeallocationMode = keyof DeallocationMode$EnumInterface;
	export const deallocationModeDatatype: X3EnumDataType<keyof DeallocationMode$EnumInterface, unknown>;
	//# sourceMappingURL=deallocation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/crystal-reports-wo-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/crystal-reports-wo-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsWoStatusEnum {
	    notStarted = 1,
	    started = 2,
	    all = 3
	}
	export interface CrystalReportsWoStatus$EnumInterface {
	    notStarted: 1;
	    started: 2;
	    all: 3;
	}
	export type CrystalReportsWoStatus = keyof CrystalReportsWoStatus$EnumInterface;
	export const crystalReportsWoStatusDatatype: X3EnumDataType<keyof CrystalReportsWoStatus$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-wo-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/crystal-reports-production.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/crystal-reports-production' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsProductionEnum {
	    surcharge = 1
	}
	export interface CrystalReportsProduction$EnumInterface {
	    surcharge: 1;
	}
	export type CrystalReportsProduction = keyof CrystalReportsProduction$EnumInterface;
	export const crystalReportsProductionDatatype: X3EnumDataType<"surcharge", unknown>;
	//# sourceMappingURL=crystal-reports-production.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/cost-type-314.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/cost-type-314' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostType314Enum {
	    unit = 1,
	    fixed = 2
	}
	export interface CostType314$EnumInterface {
	    unit: 1;
	    fixed: 2;
	}
	export type CostType314 = keyof CostType314$EnumInterface;
	export const costType314Datatype: X3EnumDataType<keyof CostType314$EnumInterface, unknown>;
	//# sourceMappingURL=cost-type-314.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/cost-to-compare.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/cost-to-compare' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostToCompareEnum {
	    standard = 1,
	    revised = 2,
	    budget = 3,
	    simulated = 4,
	    estimatedTheoretical = 5,
	    estimatedRelease = 6,
	    estimatedProduction = 7,
	    estimatedCostPrice = 8
	}
	export interface CostToCompare$EnumInterface {
	    standard: 1;
	    revised: 2;
	    budget: 3;
	    simulated: 4;
	    estimatedTheoretical: 5;
	    estimatedRelease: 6;
	    estimatedProduction: 7;
	    estimatedCostPrice: 8;
	}
	export type CostToCompare = keyof CostToCompare$EnumInterface;
	export const costToCompareDatatype: X3EnumDataType<keyof CostToCompare$EnumInterface, unknown>;
	//# sourceMappingURL=cost-to-compare.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/cost-level-choice.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/cost-level-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostLevelChoiceEnum {
	    singleLevel = 1,
	    multilevel = 2
	}
	export interface CostLevelChoice$EnumInterface {
	    singleLevel: 1;
	    multilevel: 2;
	}
	export type CostLevelChoice = keyof CostLevelChoice$EnumInterface;
	export const costLevelChoiceDatatype: X3EnumDataType<keyof CostLevelChoice$EnumInterface, unknown>;
	//# sourceMappingURL=cost-level-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/control-upon-closing.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/control-upon-closing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlUponClosingEnum {
	    noBlocking = 1,
	    blockingMaterialsOnHold = 2,
	    blockingServiceOnHold = 3,
	    blockingMaterialsAndServiceOnHold = 4
	}
	export interface ControlUponClosing$EnumInterface {
	    noBlocking: 1;
	    blockingMaterialsOnHold: 2;
	    blockingServiceOnHold: 3;
	    blockingMaterialsAndServiceOnHold: 4;
	}
	export type ControlUponClosing = keyof ControlUponClosing$EnumInterface;
	export const controlUponClosingDatatype: X3EnumDataType<keyof ControlUponClosing$EnumInterface, unknown>;
	//# sourceMappingURL=control-upon-closing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/control-tracking-prev-op.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/control-tracking-prev-op' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ControlTrackingPrevOpEnum {
	    no = 1,
	    yesWithoutBlock = 2,
	    yesWithBlock = 3
	}
	export interface ControlTrackingPrevOp$EnumInterface {
	    no: 1;
	    yesWithoutBlock: 2;
	    yesWithBlock: 3;
	}
	export type ControlTrackingPrevOp = keyof ControlTrackingPrevOp$EnumInterface;
	export const controlTrackingPrevOpDatatype: X3EnumDataType<keyof ControlTrackingPrevOp$EnumInterface, unknown>;
	//# sourceMappingURL=control-tracking-prev-op.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/consolidate-load.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/consolidate-load' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsolidateLoadEnum {
	    bySite = 1,
	    byWCGroup = 2,
	    byWorkCenter = 3
	}
	export interface ConsolidateLoad$EnumInterface {
	    bySite: 1;
	    byWCGroup: 2;
	    byWorkCenter: 3;
	}
	export type ConsolidateLoad = keyof ConsolidateLoad$EnumInterface;
	export const consolidateLoadDatatype: X3EnumDataType<keyof ConsolidateLoad$EnumInterface, unknown>;
	//# sourceMappingURL=consolidate-load.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/component-types.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/component-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentTypesEnum {
	    plannedComponent = 1,
	    nonPlannedComponent = 2
	}
	export interface ComponentTypes$EnumInterface {
	    plannedComponent: 1;
	    nonPlannedComponent: 2;
	}
	export type ComponentTypes = keyof ComponentTypes$EnumInterface;
	export const componentTypesDatatype: X3EnumDataType<keyof ComponentTypes$EnumInterface, unknown>;
	//# sourceMappingURL=component-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/closing-controls.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/closing-controls' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClosingControlsEnum {
	    noControl = 1,
	    blockingOutstandingMaterials = 2,
	    blockingOutstandingOperations = 3,
	    blockingOutstandingMaterialsAndOperations = 4
	}
	export interface ClosingControls$EnumInterface {
	    noControl: 1;
	    blockingOutstandingMaterials: 2;
	    blockingOutstandingOperations: 3;
	    blockingOutstandingMaterialsAndOperations: 4;
	}
	export type ClosingControls = keyof ClosingControls$EnumInterface;
	export const closingControlsDatatype: X3EnumDataType<keyof ClosingControls$EnumInterface, unknown>;
	//# sourceMappingURL=closing-controls.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/classification.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ClassificationEnum {
	    bySite = 1,
	    byProduct = 2,
	    byOrderType = 3,
	    byDocumentType = 4,
	    byDate = 5,
	    byRequirementDate = 6,
	    byBp = 7
	}
	export interface Classification$EnumInterface {
	    bySite: 1;
	    byProduct: 2;
	    byOrderType: 3;
	    byDocumentType: 4;
	    byDate: 5;
	    byRequirementDate: 6;
	    byBp: 7;
	}
	export type Classification = keyof Classification$EnumInterface;
	export const classificationDatatype: X3EnumDataType<keyof Classification$EnumInterface, unknown>;
	//# sourceMappingURL=classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/choice-relupd.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/choice-relupd' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChoiceRelupdEnum {
	    none = 1,
	    routing = 2,
	    bom = 3,
	    routingAndBom = 4
	}
	export interface ChoiceRelupd$EnumInterface {
	    none: 1;
	    routing: 2;
	    bom: 3;
	    routingAndBom: 4;
	}
	export type ChoiceRelupd = keyof ChoiceRelupd$EnumInterface;
	export const choiceRelupdDatatype: X3EnumDataType<keyof ChoiceRelupd$EnumInterface, unknown>;
	//# sourceMappingURL=choice-relupd.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/charge-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/charge-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChargeTypeEnum {
	    manufacturingOperation = 1,
	    macroOperation = 2
	}
	export interface ChargeType$EnumInterface {
	    manufacturingOperation: 1;
	    macroOperation: 2;
	}
	export type ChargeType = keyof ChargeType$EnumInterface;
	export const chargeTypeDatatype: X3EnumDataType<keyof ChargeType$EnumInterface, unknown>;
	//# sourceMappingURL=charge-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/charge-code-no-translation.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/charge-code-no-translation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChargeCodeNoTranslationEnum {
	    ow = 1,
	    or = 2
	}
	export interface ChargeCodeNoTranslation$EnumInterface {
	    ow: 1;
	    or: 2;
	}
	export type ChargeCodeNoTranslation = keyof ChargeCodeNoTranslation$EnumInterface;
	export const chargeCodeNoTranslationDatatype: X3EnumDataType<keyof ChargeCodeNoTranslation$EnumInterface, unknown>;
	//# sourceMappingURL=charge-code-no-translation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/cancellation-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/cancellation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CancellationModeEnum {
	    withReturn = 1,
	    withoutReturn = 2
	}
	export interface CancellationMode$EnumInterface {
	    withReturn: 1;
	    withoutReturn: 2;
	}
	export type CancellationMode = keyof CancellationMode$EnumInterface;
	export const cancellationModeDatatype: X3EnumDataType<keyof CancellationMode$EnumInterface, unknown>;
	//# sourceMappingURL=cancellation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/calibration-code.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/calibration-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalibrationCodeEnum {
	    noCalibration = 1,
	    numberOfDays = 2,
	    numberOfWeighings = 3,
	    numberOfDaysAndWeighings = 4,
	    eachWeighing = 5
	}
	export interface CalibrationCode$EnumInterface {
	    noCalibration: 1;
	    numberOfDays: 2;
	    numberOfWeighings: 3;
	    numberOfDaysAndWeighings: 4;
	    eachWeighing: 5;
	}
	export type CalibrationCode = keyof CalibrationCode$EnumInterface;
	export const calibrationCodeDatatype: X3EnumDataType<keyof CalibrationCode$EnumInterface, unknown>;
	//# sourceMappingURL=calibration-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/bom-use.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/bom-use' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BomUseEnum {
	    manufacturing = 1,
	    costing = 2,
	    mrp = 3,
	    mps = 4
	}
	export interface BomUse$EnumInterface {
	    manufacturing: 1;
	    costing: 2;
	    mrp: 3;
	    mps: 4;
	}
	export type BomUse = keyof BomUse$EnumInterface;
	export const bomUseDatatype: X3EnumDataType<keyof BomUse$EnumInterface, unknown>;
	//# sourceMappingURL=bom-use.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/bi-mfg-line-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/bi-mfg-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BiMfgLineTypeEnum {
	    header = 1,
	    releasedProduct = 2,
	    component = 3,
	    operation = 4
	}
	export interface BiMfgLineType$EnumInterface {
	    header: 1;
	    releasedProduct: 2;
	    component: 3;
	    operation: 4;
	}
	export type BiMfgLineType = keyof BiMfgLineType$EnumInterface;
	export const biMfgLineTypeDatatype: X3EnumDataType<keyof BiMfgLineType$EnumInterface, unknown>;
	//# sourceMappingURL=bi-mfg-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/bc-type.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/bc-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BcTypeEnum {
	    fieldSeparator = 1,
	    fixedLength = 2
	}
	export interface BcType$EnumInterface {
	    fieldSeparator: 1;
	    fixedLength: 2;
	}
	export type BcType = keyof BcType$EnumInterface;
	export const bcTypeDatatype: X3EnumDataType<keyof BcType$EnumInterface, unknown>;
	//# sourceMappingURL=bc-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/base-formula-to-calculate-cost.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/base-formula-to-calculate-cost' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BaseFormulaToCalculateCostEnum {
	    amount = 1,
	    hoursOperationsOrQuantities = 2
	}
	export interface BaseFormulaToCalculateCost$EnumInterface {
	    amount: 1;
	    hoursOperationsOrQuantities: 2;
	}
	export type BaseFormulaToCalculateCost = keyof BaseFormulaToCalculateCost$EnumInterface;
	export const baseFormulaToCalculateCostDatatype: X3EnumDataType<keyof BaseFormulaToCalculateCost$EnumInterface, unknown>;
	//# sourceMappingURL=base-formula-to-calculate-cost.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/availability-balance.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/availability-balance' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AvailabilityBalanceEnum {
	    available = 1,
	    unavailable = 2,
	    beingWeighed = 3,
	    beingCalibrated = 4,
	    defective = 5
	}
	export interface AvailabilityBalance$EnumInterface {
	    available: 1;
	    unavailable: 2;
	    beingWeighed: 3;
	    beingCalibrated: 4;
	    defective: 5;
	}
	export type AvailabilityBalance = keyof AvailabilityBalance$EnumInterface;
	export const availabilityBalanceDatatype: X3EnumDataType<keyof AvailabilityBalance$EnumInterface, unknown>;
	//# sourceMappingURL=availability-balance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/authorized-status.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/authorized-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AuthorizedStatusEnum {
	    planned = 1,
	    firm = 2,
	    bySelection = 3
	}
	export interface AuthorizedStatus$EnumInterface {
	    planned: 1;
	    firm: 2;
	    bySelection: 3;
	}
	export type AuthorizedStatus = keyof AuthorizedStatus$EnumInterface;
	export const authorizedStatusDatatype: X3EnumDataType<keyof AuthorizedStatus$EnumInterface, unknown>;
	//# sourceMappingURL=authorized-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/apply-link-qty-rounding.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/apply-link-qty-rounding' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ApplyLinkQtyRoundingEnum {
	    no = 1,
	    basedOnBom = 2
	}
	export interface ApplyLinkQtyRounding$EnumInterface {
	    no: 1;
	    basedOnBom: 2;
	}
	export type ApplyLinkQtyRounding = keyof ApplyLinkQtyRounding$EnumInterface;
	export const applyLinkQtyRoundingDatatype: X3EnumDataType<keyof ApplyLinkQtyRounding$EnumInterface, unknown>;
	//# sourceMappingURL=apply-link-qty-rounding.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/analysis-dimensions.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/analysis-dimensions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AnalysisDimensionsEnum {
	    resources = 1,
	    materials = 2,
	    all = 3
	}
	export interface AnalysisDimensions$EnumInterface {
	    resources: 1;
	    materials: 2;
	    all: 3;
	}
	export type AnalysisDimensions = keyof AnalysisDimensions$EnumInterface;
	export const analysisDimensionsDatatype: X3EnumDataType<keyof AnalysisDimensions$EnumInterface, unknown>;
	//# sourceMappingURL=analysis-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/allocation-sorts.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/allocation-sorts' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationSortsEnum {
	    product = 1,
	    allocationType = 2,
	    lot = 3,
	    location = 4,
	    stockStatus = 5
	}
	export interface AllocationSorts$EnumInterface {
	    product: 1;
	    allocationType: 2;
	    lot: 3;
	    location: 4;
	    stockStatus: 5;
	}
	export type AllocationSorts = keyof AllocationSorts$EnumInterface;
	export const allocationSortsDatatype: X3EnumDataType<keyof AllocationSorts$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-sorts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/allocation-priority.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/allocation-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationPriorityEnum {
	    woPriority = 1,
	    weighingPriority = 2
	}
	export interface AllocationPriority$EnumInterface {
	    woPriority: 1;
	    weighingPriority: 2;
	}
	export type AllocationPriority = keyof AllocationPriority$EnumInterface;
	export const allocationPriorityDatatype: X3EnumDataType<keyof AllocationPriority$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-priority.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/allocation-mode.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/allocation-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationModeEnum {
	    manual = 1,
	    automaticGlobal = 2,
	    automaticDetailed = 3
	}
	export interface AllocationMode$EnumInterface {
	    manual: 1;
	    automaticGlobal: 2;
	    automaticDetailed: 3;
	}
	export type AllocationMode = keyof AllocationMode$EnumInterface;
	export const allocationModeDatatype: X3EnumDataType<keyof AllocationMode$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/allergens.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/allergens' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllergensEnum {
	    foodAllergensRollup = 1,
	    allergensUpdatedTo = 2,
	    youMustEnterAValidAllergen = 3,
	    theSameAllergenCannotBeEnteredMoreThanOnce = 4,
	    allergenCountExceedsTheTableLimitOf1 = 5,
	    unableToUpdateAllergensOnProduct1 = 6,
	    wouldYouLikeToRunAllergensRollupOnThisBillOfMaterials = 7
	}
	export interface Allergens$EnumInterface {
	    foodAllergensRollup: 1;
	    allergensUpdatedTo: 2;
	    youMustEnterAValidAllergen: 3;
	    theSameAllergenCannotBeEnteredMoreThanOnce: 4;
	    allergenCountExceedsTheTableLimitOf1: 5;
	    unableToUpdateAllergensOnProduct1: 6;
	    wouldYouLikeToRunAllergensRollupOnThisBillOfMaterials: 7;
	}
	export type Allergens = keyof Allergens$EnumInterface;
	export const allergensDatatype: X3EnumDataType<keyof Allergens$EnumInterface, unknown>;
	//# sourceMappingURL=allergens.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-manufacturing-data/build/lib/enums/actual-overhead-calculation-base.d.ts
declare module '@sage/x3-manufacturing-data/lib/enums/actual-overhead-calculation-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ActualOverheadCalculationBaseEnum {
	    expected = 1,
	    actual = 2
	}
	export interface ActualOverheadCalculationBase$EnumInterface {
	    expected: 1;
	    actual: 2;
	}
	export type ActualOverheadCalculationBase = keyof ActualOverheadCalculationBase$EnumInterface;
	export const actualOverheadCalculationBaseDatatype: X3EnumDataType<keyof ActualOverheadCalculationBase$EnumInterface, unknown>;
	//# sourceMappingURL=actual-overhead-calculation-base.d.ts.map
}
declare module '@sage/x3-manufacturing-data' {
	export * from '@sage/x3-manufacturing-data/index';
}
