/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-number-decimals.ts":
/*!**********************************************************!*\
  !*** ./lib/client-functions/get-unit-number-decimals.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getUnitNumberOfDecimalList(pageInstance) {\n    try {\n        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            first: 1000,\n        }))\n            .execute());\n        return numberOfDecimalList;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));\n        return [];\n    }\n}\nexports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;\nfunction getNumberOfDecimal(list, unit) {\n    if (unit && list) {\n        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));\n        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;\n    }\n    return 0;\n}\nexports.getNumberOfDecimal = getNumberOfDecimal;\nfunction GetNumberOfDecimals(pageInstance, Unit) {\n    try {\n        const numberOfDecimals = pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            numberOfDecimals: true,\n        }, `${Unit}`)\n            .execute();\n        return numberOfDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n    }\n}\nexports.GetNumberOfDecimals = GetNumberOfDecimals;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-number-decimals.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-view-stock-by-product-site-select-a-lpn.ts":
/*!*********************************************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-product-site-select-a-lpn.ts ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByProductSiteSelectALpn = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_number_decimals_1 = __webpack_require__(/*! ../client-functions/get-unit-number-decimals */ \"./lib/client-functions/get-unit-number-decimals.ts\");\n// TODO: use lot management enum. See Jira ticket X3-162570.\nconst lotNotManaged = 'notManaged';\nlet MobileViewStockByProductSiteSelectALpn = class MobileViewStockByProductSiteSelectALpn extends ui.Page {\n    generateAggregateStockRequest(selector, filter, numberOfRecords = 500) {\n        const tempAggregateRequest = (0, xtrem_client_1.aggregateEdgesSelector)(selector, filter);\n        tempAggregateRequest.__args.first = numberOfRecords; // (X3-197381) TODO: Have to set some sort of hard limit. To be superseded in non-transient way\n        return this.$.graph.node('@sage/x3-stock-data/Stock').aggregate.query(tempAggregateRequest);\n    }\n    async batchAggregateRequests() {\n        const groupByLPN = {\n            licensePlateNumber: {\n                code: {\n                    _by: 'value',\n                },\n            },\n        };\n        const filterByProduct = {\n            location: { code: this.location.value },\n            stockSite: { code: this.site.value },\n            product: { product: { code: this.product.value } },\n        };\n        const requests = {\n            aggregateSumStockQuantity: this.generateAggregateStockRequest({\n                group: groupByLPN,\n                values: {\n                    quantityInStockUnit: {\n                        sum: true,\n                    },\n                },\n            }, {\n                filter: filterByProduct,\n            }),\n            aggregateDistinctLots: this.generateAggregateStockRequest({\n                group: groupByLPN,\n                values: {\n                    lot: {\n                        distinctCount: true,\n                    },\n                },\n            }, {\n                filter: {\n                    ...filterByProduct,\n                    lot: { _ne: null },\n                },\n            }),\n        };\n        return await new ui.queryUtils.BatchRequest(requests).execute();\n    }\n    async _getLocationQuantity() {\n        const groupByLocation = {\n            location: {\n                code: {\n                    _by: 'value',\n                },\n            },\n            product: {\n                product: {\n                    stockUnit: {\n                        code: {\n                            _by: 'value',\n                        },\n                    },\n                },\n            },\n        };\n        const filterByLocation = {\n            product: { product: { code: this.product.value } },\n            stockSite: { code: this.site.value },\n            location: { code: this.location.value },\n        };\n        const requests = {\n            aggregateSumStockQuantity: this.generateAggregateStockRequest({\n                group: groupByLocation,\n                values: {\n                    quantityInStockUnit: { sum: true },\n                },\n            }, {\n                filter: filterByLocation,\n            }),\n        };\n        const aggregateRequest = await new ui.queryUtils.BatchRequest(requests).execute();\n        (0, xtrem_client_1.extractEdges)(aggregateRequest.aggregateSumStockQuantity).forEach(aggregation => {\n            this.stockQuantity.value = `${aggregation.values.quantityInStockUnit.sum} ${aggregation.group.product.product.stockUnit.code}`;\n        });\n    }\n};\nexports.MobileViewStockByProductSiteSelectALpn = MobileViewStockByProductSiteSelectALpn;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: false,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"stockQuantity\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"lotManagementMode\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        canSelect: false,\n        canUserHideColumns: false,\n        canFilter: false,\n        isTransient: true,\n        displayMode: ui.fields.TableDisplayMode.comfortable,\n        mobileCard: undefined,\n        onRowClick(_id, rowItem) {\n            this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSiteProductDetails`, {\n                site: this.site.value,\n                location: this.location.value,\n                product: this.product.value,\n                licensePlateNumber: rowItem.licensePlateNumber,\n            });\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'licensePlateNumber',\n                prefix: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_product_site_select_a_lpn__licensePlateNumberLines____columns__prefix__licensePlateNumber\", \"LPN:\"),\n                canFilter: true,\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockQuantity',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotCount',\n                canFilter: true,\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileViewStockByProductSiteSelectALpn.prototype, \"licensePlateNumberLines\", void 0);\nexports.MobileViewStockByProductSiteSelectALpn = MobileViewStockByProductSiteSelectALpn = __decorate([\n    ui.decorators.page({\n        isTitleHidden: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_product_site_select_a_lpn____title\", \"Stock by product-site\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_product_site_select_a_lpn____subtitle\", \"Select an LPN\"),\n        isTransient: true,\n        skipDirtyCheck: true,\n        headerCard() {\n            return {\n                title: this.location,\n                titleRight: this.stockQuantity,\n                line2: this.product,\n            };\n        },\n        async onLoad() {\n            // Requires a selected location in the query parameters.  Should always exist unless user manually\n            // navigates to this page.\n            const locationParameter = this.$.queryParameters.location;\n            if (!locationParameter) {\n                this.$.showToast(ui.localize('@sage/x3-stock/location-required', 'Selected location is required'), {\n                    type: 'warning',\n                });\n                this.$.router.goTo(`@sage/x3-stock/MobileViewStockByProductSite`);\n                return;\n            }\n            const siteParameter = this.$.queryParameters.site;\n            const productParameter = this.$.queryParameters.product;\n            const stockUnitParameter = this.$.queryParameters.stockUnit;\n            const lotManagementMode = this.$.queryParameters.lotManagementMode;\n            this._numberOfDecimalList = await (0, get_unit_number_decimals_1.getUnitNumberOfDecimalList)(this);\n            const numberDecimal = (0, get_unit_number_decimals_1.getNumberOfDecimal)(this._numberOfDecimalList, stockUnitParameter.toString());\n            this.product.value = productParameter.toString();\n            this.location.value = locationParameter.toString();\n            this.site.value = siteParameter.toString();\n            this.stockUnit.value = stockUnitParameter.toString();\n            this.lotManagementMode.value = lotManagementMode.toString();\n            await this._getLocationQuantity();\n            const aggregatedResults = await this.batchAggregateRequests();\n            const aggregationsLPNMap = new Map();\n            // populate map with all existing LPN's in the stock records for this selected product\n            // we can use aggregated values of stock quantity sums because in the request, no stock records are omitted unlike for distinct lots\n            aggregatedResults.aggregateSumStockQuantity.edges.forEach(lpn => {\n                aggregationsLPNMap.set(lpn.node.group.licensePlateNumber.code, {\n                    stockQuantity: Number(lpn.node.values.quantityInStockUnit.sum),\n                    // Added conditional labeling logic here for the case where a product location is lot tracked but contains no lots\n                    distinctLotCount: typesLib.strictNe(this.lotManagementMode.value, lotNotManaged) ? ui.localize('@sage/x3-stock/lots-title', 'Lots: {{code}}', { code: 0 })\n                        : '',\n                });\n            });\n            // make all forEach() calls optional because there can be no stock records with any lots for a particular product's lpn\n            // Added logic to conditionally hide lot count for items that are not lot tracked\n            aggregatedResults.aggregateDistinctLots.edges?.forEach(lpn => {\n                if (aggregationsLPNMap.has(lpn.node.group.licensePlateNumber.code)) {\n                    aggregationsLPNMap.get(lpn.node.group.licensePlateNumber.code).distinctLotCount =\n                        typesLib.strictNe(this.lotManagementMode.value, lotNotManaged) ? ui.localize('@sage/x3-stock/lots-title', 'Lots: {{code}}', {\n                            code: lpn.node.values.lot.distinctCount,\n                        })\n                            : '';\n                }\n            });\n            // index for map.forEach in aggregationsLPNMap\n            let index = 0;\n            const lpnLinesValue = new Array();\n            aggregationsLPNMap.forEach((value, key) => {\n                var _v;\n                const locationKey = `LOCATION${_v = index, index = typesLib.add(index, 1), _v}`;\n                lpnLinesValue.push({\n                    _id: !key ? locationKey : key,\n                    licensePlateNumber: key,\n                    lotCount: value.distinctLotCount,\n                    stockQuantity: `${value.stockQuantity} ${this.stockUnit.value}`,\n                    stockUnit: stockUnitParameter,\n                });\n            });\n            this.mainBlock.title = ui.localize('@sage/x3-stock/license-plate-number-title', 'LPNs: {{code}}', {\n                code: lpnLinesValue.filter(lpnLine => lpnLine.licensePlateNumber).length,\n            });\n            this.licensePlateNumberLines.value = lpnLinesValue;\n        },\n    })\n], MobileViewStockByProductSiteSelectALpn);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-product-site-select-a-lpn.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-product-site-select-a-lpn.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;