/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-view-stock-by-lpn.ts":
/*!***********************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-lpn.ts ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByLpn = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst stock_control_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/stock-control */ \"../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nlet MobileViewStockByLpn = class MobileViewStockByLpn extends ui.Page {\n    async _init() {\n        await this._initSite();\n    }\n    async _initSite() {\n        this.stockSite.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    async _goToProductDetailsPage(licensePlate, identifier, locationCode) {\n        const aggregateResult = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/Stock')\n            .aggregate.query(ui.queryUtils.edgesSelector({\n            group: {\n                product: {\n                    product: {\n                        code: {\n                            _by: 'value',\n                        },\n                        lotManagementMode: {\n                            _by: 'value',\n                        },\n                        stockUnit: {\n                            code: {\n                                _by: 'value',\n                            },\n                        },\n                    },\n                },\n            },\n            values: {\n                quantityInStockUnit: { sum: true },\n            },\n        }, {\n            filter: {\n                licensePlateNumber: { code: licensePlate },\n                stockSite: this.stockSite.value,\n            },\n            first: 500,\n        }))\n            .execute());\n        // Verify if selected lpn yields at least one result by checking the existence of any aggregated stock quantity sum\n        // if not, reload this page\n        if (typesLib.strictEq(aggregateResult.length, 0)) {\n            this.$.showToast(ui.localize('@sage/x3-stock/notification-warning-lpn-inquiry-zero-products', 'The {{code}} LPN has no products.', { code: licensePlate }), { type: 'info' });\n            this.$.router.goTo('@sage/x3-stock/MobileViewStockByLpn');\n            return;\n        }\n        // Rare, but another product could have been added since the entry was displayed on the screen\n        // If so, then go to the second page instead of the third\n        if (typesLib.gt(aggregateResult.length, 1)) {\n            // Go to the second page to select a product\n            this.$.router.goTo('@sage/x3-stock/MobileViewStockByLpnSelectProduct', {\n                _id: identifier,\n                distinctProductCount: aggregateResult.length,\n                location: locationCode,\n            });\n        }\n        // Go to 3rd page\n        let productDetails;\n        productDetails = aggregateResult.map((value) => {\n            return {\n                product: value.group.product.product.code,\n                stockQuantity: value.values.quantityInStockUnit.sum,\n                stockUnit: value.group.product.product.stockUnit.code,\n            };\n        });\n        this.$.router.goTo('@sage/x3-stock/MobileViewStockByLpnProductDetails', {\n            licensePlateNumber: licensePlate,\n            product: productDetails[0].product,\n            stockQuantity: productDetails[0].stockQuantity,\n            stockUnit: productDetails[0].stockUnit,\n            location: locationCode,\n        });\n    }\n};\nexports.MobileViewStockByLpn = MobileViewStockByLpn;\n__decorate([\n    ui.decorators.section({\n        isHidden: true,\n    })\n], MobileViewStockByLpn.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewStockByLpn.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        parent() {\n            return this.mainBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobileViewStockByLpn.prototype, \"stockSite\", void 0);\nexports.MobileViewStockByLpn = MobileViewStockByLpn = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_lpn____title\", \"View stock by LPN\"), // this value is used to integrate with the feature header's name and in the landing page's menu\n        isTitleHidden: true, // hide the page's title and render that title only in the feature header instead of in both places (see X3-177000 & https://github.com/Sage-ERP-X3/etna/pull/1785)\n        menuItem: stock_control_1.stockControl,\n        priority: 600,\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        mode: 'default',\n        authorizationCode: 'INQSTOLPN',\n        skipDirtyCheck: true,\n        async onLoad() {\n            await this._init();\n        },\n        navigationPanel: {\n            isHeaderHidden: true,\n            canFilter: false,\n            isAutoSelectEnabled: true,\n            listItem: {\n                title: ui.nestedFields.text({ bind: 'code' }),\n                line2: ui.nestedFields.text({ bind: 'status' }),\n                line3: ui.nestedFields.reference({\n                    node: '@sage/x3-stock-data/Location',\n                    bind: 'location',\n                    valueField: 'code',\n                }),\n                line4: ui.nestedFields.checkbox({ bind: 'isActive', isHidden: true }),\n                line5: ui.nestedFields.checkbox({ bind: 'isSingleProduct', isHidden: true }),\n            },\n            optionsMenu: [\n                {\n                    title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_lpn____navigationPanel__optionsMenu__title\", \"Default Site\"),\n                    graphQLFilter: storage => ({ stockSite: { code: String(storage.get('mobile-selected-stock-site')) } }),\n                },\n            ],\n            onSelect(listItemValue) {\n                // If the selected LPN has zero products or is inactive, then display an informational message\n                if (!listItemValue.isActive) {\n                    this.$.removeToasts();\n                    setTimeout(() => this.$.showToast(ui.localize('@sage/x3-stock/notification-warning-lpn-inquiry-inactive-lpn', 'LPN {{code}} is inactive', { code: listItemValue.code }), { type: 'info' }), 10);\n                }\n                else {\n                    // Go to the second page to select a product\n                    this.$.router.goTo('@sage/x3-stock/MobileViewStockByLpnSelectProduct', {\n                        _id: listItemValue._id,\n                        location: listItemValue.location?.code ?? '',\n                    });\n                }\n                return true;\n            },\n        },\n    })\n], MobileViewStockByLpn);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-lpn.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/stock-control.js":
/*!************************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/stock-control.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.stockControl = void 0;\nexports.stockControl = {\n    id: '@sage/x3-stock-data/stock-control-root',\n    priority: 200,\n    title: 'Stock control',\n    icon: 'squares_nine',\n};\n//# sourceMappingURL=stock-control.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcz9kNTQ5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5zdG9ja0NvbnRyb2wgPSB2b2lkIDA7XG5leHBvcnRzLnN0b2NrQ29udHJvbCA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvc3RvY2stY29udHJvbC1yb290JyxcbiAgICBwcmlvcml0eTogMjAwLFxuICAgIHRpdGxlOiAnU3RvY2sgY29udHJvbCcsXG4gICAgaWNvbjogJ3NxdWFyZXNfbmluZScsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c3RvY2stY29udHJvbC5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-lpn.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;