/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/get-unit-number-decimals.ts":
/*!**********************************************************!*\
  !*** ./lib/client-functions/get-unit-number-decimals.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GetNumberOfDecimals = exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getUnitNumberOfDecimalList(pageInstance) {\n    try {\n        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            first: 1000,\n        }))\n            .execute());\n        return numberOfDecimalList;\n    }\n    catch (e) {\n        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));\n        return [];\n    }\n}\nexports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;\nfunction getNumberOfDecimal(list, unit) {\n    if (unit && list) {\n        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));\n        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;\n    }\n    return 0;\n}\nexports.getNumberOfDecimal = getNumberOfDecimal;\nfunction GetNumberOfDecimals(pageInstance, Unit) {\n    try {\n        const numberOfDecimals = pageInstance.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .read({\n            _id: true,\n            numberOfDecimals: true,\n        }, `${Unit}`)\n            .execute();\n        return numberOfDecimals.numberOfDecimals;\n    }\n    catch (e) {\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n    }\n}\nexports.GetNumberOfDecimals = GetNumberOfDecimals;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-unit-number-decimals.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-view-stock-by-location-select-lpn.ts":
/*!***************************************************************!*\
  !*** ./lib/pages/mobile-view-stock-by-location-select-lpn.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileViewStockByLocationSelectLPN = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst get_unit_number_decimals_1 = __webpack_require__(/*! ../client-functions/get-unit-number-decimals */ \"./lib/client-functions/get-unit-number-decimals.ts\");\n// TODO: use lot management enum. See Jira ticket X3-162570.\nconst notManaged = 'notManaged';\nlet MobileViewStockByLocationSelectLPN = class MobileViewStockByLocationSelectLPN extends ui.Page {\n};\nexports.MobileViewStockByLocationSelectLPN = MobileViewStockByLocationSelectLPN;\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"localizedDescription1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"stockQuantity\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"lotManagementMode\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        canSelect: false,\n        canUserHideColumns: false,\n        canFilter: false,\n        isTransient: true,\n        displayMode: ui.fields.TableDisplayMode.comfortable,\n        mobileCard: undefined,\n        onRowClick(_id, rowItem) {\n            if (rowItem.licensePlateNumber) {\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocationProductDetails', {\n                    _id: this._id.value,\n                    product: this.product.value,\n                    licensePlateNumber: rowItem.licensePlateNumber,\n                    lotCount: rowItem.lotCount,\n                    stockQuantity: rowItem.stockQuantity,\n                    stockUnit: rowItem.stockUnit,\n                });\n            }\n            else {\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocationProductDetails', {\n                    _id: this._id.value,\n                    product: this.product.value,\n                    lotCount: rowItem.lotCount,\n                    stockQuantity: rowItem.stockQuantity,\n                    stockUnit: rowItem.stockUnit,\n                });\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'licensePlateNumber',\n                canFilter: true,\n                isReadOnly: true,\n                prefix: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_select_lpn__licensePlateNumberLines____columns__prefix__licensePlateNumber\", \"LPN\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'stockQuantity',\n                isReadOnly: true,\n                postfix(value, rowData) {\n                    return rowData?.stockUnit;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'lotCount',\n                canFilter: true,\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"licensePlateNumberLines\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: false,\n        isReadOnly: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"code\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileViewStockByLocationSelectLPN.prototype, \"_id\", void 0);\nexports.MobileViewStockByLocationSelectLPN = MobileViewStockByLocationSelectLPN = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_select_lpn____title\", \"Stock by location\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_view_stock_by_location_select_lpn____subtitle\", \"Select an LPN\"),\n        isTitleHidden: true, // hide the page's title and render that title only in the feature header instead of in both places (see X3-177000 & https://github.com/Sage-ERP-X3/etna/pull/1785)\n        node: '@sage/x3-stock-data/Location',\n        mode: 'default',\n        skipDirtyCheck: true,\n        navigationPanel: undefined,\n        headerCard() {\n            // TODO Issue: Header Card doesn't support Reference control\n            return {\n                title: this.product,\n                titleRight: this.stockQuantity,\n                line2: this.localizedDescription1,\n            };\n        },\n        async onLoad() {\n            // Requires a selected location & product in the query parameters\n            const productParameter = this.$.queryParameters['product'];\n            const localizedDescription1Parameter = this.$.queryParameters.localizedDescription1;\n            const stockQuantityParameter = this.$.queryParameters['stockQuantity'];\n            const stockUnitParameter = this.$.queryParameters['stockUnit'];\n            const lotManagementModeParameter = this.$.queryParameters['lotManagementMode'] ?? '';\n            if (!this.code.value || !productParameter || !stockQuantityParameter || !stockUnitParameter) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-error-location-inquiry-level3-missing-params', 'A selected location & product are required'), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobileViewStockByLocation');\n                return;\n            }\n            this._numberOfDecimalList = await (0, get_unit_number_decimals_1.getUnitNumberOfDecimalList)(this);\n            const numberDecimal = (0, get_unit_number_decimals_1.getNumberOfDecimal)(this._numberOfDecimalList, stockUnitParameter.toString());\n            this.product.value = productParameter.toString();\n            this.localizedDescription1.value = localizedDescription1Parameter.toString();\n            this.stockQuantity.value = Number(stockQuantityParameter).toFixed(numberDecimal);\n            this.stockQuantity.postfix = stockUnitParameter.toString();\n            this.lotManagementMode.value = lotManagementModeParameter.toString();\n            const aggregateResult = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .aggregate.query(ui.queryUtils.edgesSelector({\n                group: {\n                    licensePlateNumber: {\n                        code: {\n                            _by: 'value',\n                        },\n                    },\n                },\n                values: {\n                    quantityInStockUnit: { sum: true },\n                    lot: { distinctCount: true },\n                },\n            }, {\n                filter: {\n                    location: { code: this.code.value },\n                    stockSite: this.$.storage.get('mobile-selected-stock-site'),\n                    product: { product: { code: this.product.value } },\n                },\n                first: 500, // (X3-197381) TODO: Have to set some sort of hard limit. To be superseded in non-transient way\n            }))\n                .execute());\n            let hasNull = false;\n            this.licensePlateNumberLines.value = aggregateResult.map((value) => {\n                if (!hasNull && !value.group.licensePlateNumber)\n                    hasNull = true;\n                return {\n                    _id: !value.group.licensePlateNumber.code ? '' : value.group.licensePlateNumber.code,\n                    licensePlateNumber: !value.group.licensePlateNumber.code ? '' : value.group.licensePlateNumber.code,\n                    lotCount: typesLib.strictNe(this.lotManagementMode.value, notManaged) ? ui.localize('@sage/x3-stock/location-inquiry-lot', 'Lots: {{code}}', {\n                        code: value.values.lot.distinctCount,\n                    })\n                        : '',\n                    stockQuantity: value.values.quantityInStockUnit.sum,\n                    stockUnit: stockUnitParameter,\n                };\n            });\n            this.mainBlock.title = ui.localize('@sage/x3-stock/location-inquiry-license-plate-number', 'License plate numbers: {{code}}', { code: typesLib.sub(aggregateResult.length, (hasNull ? 1 : 0)) });\n        },\n    })\n], MobileViewStockByLocationSelectLPN);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-view-stock-by-location-select-lpn.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-view-stock-by-location-select-lpn.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;