import { ProductInput } from '@sage/x3-master-data-api';
import { StockChangeInput, StockEntryTransaction } from '@sage/x3-stock-api';
import * as ui from '@sage/xtrem-ui';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockTransaction = DeepPartial<StockEntryTransaction>;
export type inputsSubcontractTransfer = {
    subcontractTransfer: StockChangeInput & {
        id?: string;
    };
    username: string;
    currentLine?: number;
    currentOperation?: number;
    started: boolean;
    selectedTransaction: PartialStockTransaction;
    selectedProduct?: ProductInput;
    destination?: string;
    printingMode?: string;
};
export declare enum PrintingModeEnum {
    noPrint = 1,
    stockLabel = 2,
    substituteValue3 = 3,
    transfertDocument = 4,
    analysisDocument = 5,
    createdContainerLabel = 6,
    stockLabelAndCreatedContainerLabel = 7
}
export declare class MobileSubcontractTransfer extends ui.Page {
    savedObject: inputsSubcontractTransfer;
    private _transactions;
    private _notifier;
    private _mobileSettings;
    private _currentOperation;
    private _numberOfDecimalList;
    stockSite: ui.fields.Text;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    firstLineBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    secondBlock: ui.containers.Block;
    subcontractor: ui.fields.Reference;
    subcontractorDummy: ui.fields.Text;
    subcontractorAddress: ui.fields.Reference;
    subcontractorAddressDummy: ui.fields.Text;
    subcontractLocation: ui.fields.Reference;
    subcontractLocationDummy: ui.fields.Text;
    fourthBlock: ui.containers.Block;
    product: ui.fields.Reference;
    subcontractTransferLinesBlock: ui.containers.Block;
    subcontractTransferLines: ui.fields.Table<any>;
    private _init;
    private _initSite;
    private _initDestination;
    private _disablePage;
    private _initSubcontractor;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveSubcontractTransfer;
    private _initStockChangeLines;
    private _mapSubcontractTransfer;
    private _postInitStockChangeLines;
    prepareDataMutation(): StockChangeInput & {
        id?: string;
    };
    private _callCreationAPI;
    private _getSubcontractor;
    private _getSubContractLocation;
    private _getSubContractLocationFromSupplier;
    private _createValues;
    private _manageSubcontractorFields;
}
export {};
//# sourceMappingURL=mobile-subcontract-transfer.d.ts.map