/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/manage-pages.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/manage-pages.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readSerialNumberFromStockId = exports.handleFilterOnChange = exports.generateStockTableFilter = exports.removeFilters = exports.findSetting = exports.managePages = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * Initialize manage page\n * @param pageInstance current page\n * @param stockSite stock site\n * @param productSite partial product site object\n * @param flowType type of flow\n * @param errorMessage error messages missing settings\n * @param stockSearchFilters mandatory array to return settings\n */\n//todo:\nfunction managePages(pageInstance, stockSite, productSite, flowType, errorMessage, stockSearchFilters) {\n    // Initializing array when undefined\n    stockSearchFilters ??= [];\n    if (stockSearchFilters.length) {\n        // remove all items in array\n        stockSearchFilters.length = 0;\n    }\n    if (!pageInstance || !stockSite || !productSite || !flowType) {\n        throw new xtrem_shared_1.SystemError('Invalid arguments');\n    }\n    const _selectedMobileSettings = JSON.parse(pageInstance.$.queryParameters?.mobileSettings);\n    if (typesLib.strictEq(_selectedMobileSettings, null)) {\n        throw new Error(errorMessage);\n    }\n    // Store value in array only when usable and return true when done\n    const _pushSettings = (field) => {\n        if (typesLib.strictNe(field, 'none')) {\n            stockSearchFilters?.push(field);\n            return true;\n        }\n        return false;\n    };\n    // The fields are memorized until they meet the none type.\n    const _allPushed = _pushSettings(_selectedMobileSettings.stockField1) &&\n        _pushSettings(_selectedMobileSettings.stockField2) &&\n        _pushSettings(_selectedMobileSettings.stockField3) &&\n        _pushSettings(_selectedMobileSettings.stockField4) &&\n        _pushSettings(_selectedMobileSettings.stockField5) &&\n        _pushSettings(_selectedMobileSettings.stockField6) &&\n        _pushSettings(_selectedMobileSettings.stockField7) &&\n        _pushSettings(_selectedMobileSettings.stockField8);\n    if (pageInstance._pageMetadata.layoutFields?.location) {\n        if (!findSetting('location', stockSearchFilters) || typesLib.strictNe(productSite.isLocationManaged, true)) {\n            pageInstance['location'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.lot) {\n        if (!findSetting('lot', stockSearchFilters) || typesLib.strictEq((productSite?.product?.lotManagementMode ?? 'notManaged'), 'notManaged')) {\n            pageInstance['lot'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        if (!findSetting('sublot', stockSearchFilters) || typesLib.strictNe((productSite?.product?.lotManagementMode ?? ''), 'lotAndSublot')) {\n            pageInstance['sublot'].isHidden = true;\n        }\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber) {\n        if (!findSetting('serial', stockSearchFilters) ||\n            !['receivedIssued'].includes(productSite?.product?.serialNumberManagementMode ?? 'receivedIssued')) {\n            pageInstance['serialNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.status) {\n        if (!findSetting('status', stockSearchFilters)) {\n            pageInstance['status'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit) {\n        if (!findSetting('packingUnit', stockSearchFilters)) {\n            pageInstance['packingUnit'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor) {\n        if (!findSetting('pacStkConversionFactor', stockSearchFilters)) {\n            pageInstance['packingUnitToStockUnitConversionFactor'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier1) {\n        if (!findSetting('identifier1', stockSearchFilters)) {\n            pageInstance['identifier1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.identifier2) {\n        if (!findSetting('identifier2', stockSearchFilters)) {\n            pageInstance['identifier2'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber) {\n        if (typesLib.strictNe(productSite.isLicensePlateNumberManaged, true) ||\n            !findSetting('licensePlateNumber', stockSearchFilters)) {\n            pageInstance['licensePlateNumber'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1) {\n        if (!findSetting('customField1', stockSearchFilters)) {\n            pageInstance['stockCustomField1'].isHidden = true;\n        }\n    }\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2) {\n        if (!findSetting('customField2', stockSearchFilters)) {\n            pageInstance['stockCustomField2'].isHidden = true;\n        }\n    }\n}\nexports.managePages = managePages;\n/**\n * Search if filter\n * @param field current search field\n * @param fields list of current filter\n * @returns true when found used filter parameter\n */\nfunction findSetting(field, fields) {\n    return typesLib.gte(fields.findIndex(fld => typesLib.strictEq(fld, field)), 0);\n}\nexports.findSetting = findSetting;\n/**\n * Remove filter (asynchronous for avoiding anticipated onChange)\n * @param pageInstance current page\n */\nasync function removeFilters(pageInstance) {\n    if (pageInstance._pageMetadata.layoutFields?.location)\n        pageInstance['location'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.lot)\n        pageInstance['lot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.sublot)\n        pageInstance['sublot'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.serialNumber)\n        pageInstance['serialNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.status)\n        pageInstance['status'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnit)\n        pageInstance['packingUnit'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor)\n        pageInstance['packingUnitToStockUnitConversionFactor'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier1)\n        pageInstance['identifier1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.identifier2)\n        pageInstance['identifier2'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.licensePlateNumber)\n        pageInstance['licensePlateNumber'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField1)\n        pageInstance['stockCustomField1'].value = null;\n    if (pageInstance._pageMetadata.layoutFields?.stockCustomField2)\n        pageInstance['stockCustomField2'].value = null;\n}\nexports.removeFilters = removeFilters;\nfunction generateStockTableFilter(pageInstance) {\n    const stockSite = pageInstance['_stockSite'];\n    const stockFilter = {\n        availableQuantity: { _gt: '0' },\n        //      quantityInPackingUnit: { _gt: '0' },\n        isBeingCounted: false,\n        owner: stockSite?.code,\n    };\n    let parameterLocation = pageInstance.$.queryParameters?.location;\n    if (!parameterLocation &&\n        pageInstance._pageMetadata.layoutFields?.location &&\n        pageInstance['location'].value) {\n        parameterLocation = pageInstance['location'].value?.code;\n    }\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    const filterLicensePlateNumber = pageInstance._pageMetadata.layoutFields?.licensePlateNumber\n        ? pageInstance['licensePlateNumber'].value?.code\n            ? { licensePlateNumber: { code: pageInstance['licensePlateNumber'].value.code } }\n            : {}\n        : pageInstance.$.queryParameters?.licensePlateNumberOrigin\n            ? { licensePlateNumber: { code: pageInstance.$.queryParameters.licensePlateNumberOrigin } }\n            : { licensePlateNumber: { code: { _in: [undefined, ''] } } };\n    return {\n        ...stockFilter,\n        ...(pageInstance._pageMetadata.layoutFields?.product &&\n            pageInstance['product'].value?.code && {\n            product: { product: { code: pageInstance['product'].value.code } },\n        }),\n        ...filterLicensePlateNumber,\n        ...(pageInstance._pageMetadata.layoutFields?.location &&\n            !pageInstance['location'].isHidden &&\n            pageInstance['location'].value && {\n            location: { code: parameterLocation },\n        }),\n        // lot and sublot are reference fields bound to the same Lot node\n        // so first check if sublot field is enabled with a value. If so, filter for both lot and sublot\n        // otherwise check if lot field is enabled with a value. If so filter for lot and additionally sublot, if applicable\n        ...((pageInstance._pageMetadata.layoutFields?.lot &&\n            !pageInstance['lot'].isHidden &&\n            pageInstance['lot'].value?.lot && {\n            lot: pageInstance['lot'].value.lot,\n            ...(pageInstance['lot'].value.sublot && {\n                sublot: pageInstance['lot'].value.sublot,\n            }),\n        }) ||\n            (pageInstance._pageMetadata.layoutFields?.sublot &&\n                !pageInstance['sublot'].isHidden &&\n                pageInstance['sublot'].value?.sublot && {\n                lot: pageInstance['sublot'].value.lot,\n                sublot: pageInstance['sublot'].value.sublot,\n            })),\n        //...(this.sublot.value?.sublot && { sublot: this.sublot.value.sublot }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            !isFilterSerialNumber &&\n            !pageInstance['serialNumber'].isHidden &&\n            pageInstance['serialNumber'].value?.code && {\n            serialNumber: pageInstance['serialNumber'].value.code,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.serialNumber &&\n            isFilterSerialNumber &&\n            beginSerialNumber &&\n            endSerialNumber && {\n            serialNumber: {\n                _gte: beginSerialNumber,\n                //                  _lte: endSerialNumber,\n            },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.status &&\n            !pageInstance['status'].isHidden &&\n            pageInstance['status'].value && { status: { code: pageInstance['status'].value } }),\n        // ...(this.packingUnit.value && { packingUnit: this._unitMap.get(this.packingUnit.value).unit }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnit &&\n            !pageInstance['packingUnit'].isHidden &&\n            pageInstance['packingUnit'].value && {\n            packingUnit: { code: pageInstance['packingUnit'].value },\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.packingUnitToStockUnitConversionFactor &&\n            !pageInstance['packingUnitToStockUnitConversionFactor'].isHidden &&\n            pageInstance['packingUnitToStockUnitConversionFactor'].value && {\n            packingUnitToStockUnitConversionFactor: pageInstance['packingUnitToStockUnitConversionFactor']\n                .value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier1 &&\n            !pageInstance['identifier1'].isHidden &&\n            pageInstance['identifier1'].value && { identifier1: pageInstance['identifier1'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.identifier2 &&\n            !pageInstance['identifier2'].isHidden &&\n            pageInstance['identifier2'].value && { identifier2: pageInstance['identifier2'].value }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField1 &&\n            !pageInstance['stockCustomField1'].isHidden &&\n            pageInstance['stockCustomField1'].value && {\n            stockCustomField1: pageInstance['stockCustomField1'].value,\n        }),\n        ...(pageInstance._pageMetadata.layoutFields?.stockCustomField2 &&\n            !pageInstance['stockCustomField2'].isHidden &&\n            pageInstance['stockCustomField2'].value && {\n            stockCustomField2: pageInstance['stockCustomField2'].value,\n        }),\n    };\n}\nexports.generateStockTableFilter = generateStockTableFilter;\nfunction _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n    return startingSerialNumber.replace(/\\d+$/, match => {\n        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n    });\n}\nasync function handleFilterOnChange(pageInstance, field, filterCriterion = null) {\n    // if field value is cleared out during onChange, then delete the corresponding filter property in stock table's filter\n    const stockKey = field.id;\n    if (!stockKey) {\n        //throw new SystemError('Invalid stock property to filter');\n        return; // do nothing?\n    }\n    if (!pageInstance._pageMetadata.layoutFields?.stock) {\n        //throw new SystemError('Invalid stock property to pageInstance');\n        return; // do nothing?\n    }\n    const stock = pageInstance['stock'];\n    const stockChangeLines = pageInstance['_stockChangeLines'] ?? null;\n    const miscellaneousStockTransactionLines = pageInstance['_miscellaneousStockTransactionLines'] ?? null;\n    const currentLine = pageInstance['_currentLine'];\n    const currentStockChangeLine = stockChangeLines ? (stockChangeLines[currentLine] ?? null) : null;\n    const currentMiscellaneousStockTransactionLine = miscellaneousStockTransactionLines\n        ? (miscellaneousStockTransactionLines[currentLine] ?? null)\n        : null;\n    const quantityToPick = pageInstance['_quantityToPick'] ?? null;\n    const beginSerialNumber = pageInstance['serialNumber']?.value?.code ?? null;\n    const endSerialNumber = beginSerialNumber && quantityToPick ? _calculateEndingSerialNumber(beginSerialNumber, quantityToPick) : null;\n    const isFilterSerialNumber = pageInstance['_isFilterSerialNumber'] ?? false;\n    // When for the tuple the value is undefined, the key is removed from the filter.\n    if (!field.value) {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'location') && {\n                ...(typesLib.strictEq(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && {\n                    [stockKey]: { category: { _nin: ['subcontract', 'customer'] } },\n                }),\n                ...(typesLib.strictNe(pageInstance.$.page.id, 'MobileSubcontractTransferDetails') && { [stockKey]: undefined }),\n            }),\n            ...(!['location'].includes(stockKey) && { [stockKey]: undefined }),\n        };\n    }\n    else {\n        stock.filter = {\n            ...stock.filter,\n            ...(typesLib.strictEq(stockKey, 'packingUnit') &&\n                pageInstance._pageMetadata.layoutFields?.packingUnit && {\n                [stockKey]: {\n                    code: pageInstance[stockKey].value,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'status') && {\n                [stockKey]: {\n                    code: filterCriterion ??\n                        (field instanceof ui.fields.Reference && field?.valueField\n                            ? { [field.valueField]: field.value[field.valueField] }\n                            : field.value),\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                isFilterSerialNumber &&\n                beginSerialNumber &&\n                endSerialNumber && {\n                [stockKey]: {\n                    _gte: beginSerialNumber,\n                    //                      _lte: endSerialNumber,\n                },\n            }),\n            ...(typesLib.strictEq(stockKey, 'serialNumber') &&\n                !isFilterSerialNumber && {\n                [stockKey]: {\n                    _eq: beginSerialNumber,\n                },\n            }),\n            // All other cases\n            ...(!['packingUnit', 'status', 'serialNumber'].includes(stockKey) && {\n                [stockKey]: filterCriterion ??\n                    (field instanceof ui.fields.Reference && field?.valueField\n                        ? { [field.valueField]: field.value[field.valueField] }\n                        : field.value),\n            }),\n        };\n        // stock.pageSize = 1000;\n    }\n    await _setStockQuantityInPackingUnit(pageInstance, stock, currentStockChangeLine ?? currentMiscellaneousStockTransactionLine);\n    if (!field.value) {\n        field.getNextField(true)?.focus();\n    }\n}\nexports.handleFilterOnChange = handleFilterOnChange;\n/**\n * _setStockQuantityInPackingUnit\n * @param pageInstance current page\n * @param stock stock table\n * @param currentStockLine stock line for lpnOperations or MiscellaneousIssue\n */\nasync function _setStockQuantityInPackingUnit(pageInstance, stock, currentStockLine) {\n    const _stockDetails = currentStockLine?.stockDetails;\n    if (_stockDetails) {\n        stock.selectedRecords.forEach((rowId) => {\n            const stockRecord = stock.getRecordValue(rowId);\n            if (stockRecord) {\n                const qtyTotal = _stockDetails.reduce((acc, curr) => {\n                    return typesLib.add(acc, Number(curr.quantityInPackingUnit));\n                }, 0);\n                stockRecord.quantityInPackingUnit = String(qtyTotal);\n                stock.setRecordValue(stockRecord);\n            }\n        });\n        await pageInstance.$.commitValueAndPropertyChanges();\n    }\n}\n/**\n * Read one serial number for a given stock id\n * @param pageInstance current page\n * @param stockId stock id\n * @param orderBy sort order\n * @returns serial number or null\n */\nasync function readSerialNumberFromStockId(pageInstance, stockId, orderBy) {\n    if (stockId) {\n        try {\n            const serialNumber = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n                .node('@sage/x3-stock-data/SerialNumber')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: { stockId },\n                orderBy: { code: orderBy },\n            }))\n                .execute());\n            if (serialNumber[0]) {\n                return serialNumber[0];\n            }\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number-node', 'Error loading serial number node'), String(e));\n        }\n    }\n    return null;\n}\nexports.readSerialNumberFromStockId = readSerialNumberFromStockId;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/manage-pages.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-stock/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-subcontract-transfer-details.ts":
/*!**********************************************************!*\
  !*** ./lib/pages/mobile-subcontract-transfer-details.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileSubcontractTransferDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_count_serial_number_1 = __webpack_require__(/*! @sage/x3-stock-data/lib/client-functions/get-count-serial-number */ \"../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst manage_pages_1 = __webpack_require__(/*! ../client-functions/manage-pages */ \"./lib/client-functions/manage-pages.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\nconst hideWhenEmptyValue = (value, rowValue) => {\n    return typesLib.strictNe(typeof value, 'number') && !value; // we don't want to hide numeric field with value of 0\n};\n/** Created with X3 Etna Studio at 2020-01-20T10:46:11.764Z */\nlet MobileSubcontractTransferDetails = class MobileSubcontractTransferDetails extends ui.Page {\n    constructor() {\n        /*\n         *\n         *  Technical properties\n         *\n         */\n        super(...arguments);\n        this._currentLine = 0;\n        this._stockFieldSettings = [];\n    }\n    _activeSelectButton() {\n        const currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n    }\n    /*\n     *\n     *  Init functions\n     *\n     */\n    async _init() {\n        const savedInputs = this._getSavedInputs();\n        const storageProductSite = savedInputs?.selectedProduct;\n        this._stockChangeLines = savedInputs?.subcontractTransfer?.stockChangeLines ?? [];\n        this._initSiteCodeField();\n        this._productSite = await this._getProductSite(storageProductSite?.code ?? '');\n        this._initTechnicalProperties();\n        await this._fieldsManagement();\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('mobile-subcontractTransfer'));\n    }\n    async _getProductSite(storageProductSite) {\n        if (storageProductSite) {\n            const productCode = storageProductSite;\n            const productSiteToReceive = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .read({\n                isLocationManaged: true,\n                isLicensePlateNumberManaged: true,\n                defaultInternalContainer: {\n                    code: true,\n                },\n                product: {\n                    code: true,\n                    localizedDescription1: true,\n                    lotManagementMode: true,\n                    serialNumberManagementMode: true,\n                    stockVersionMode: true,\n                    expirationManagementMode: true,\n                    serialSequenceNumber: true,\n                    lotSequenceNumber: true,\n                    stockManagementMode: true,\n                    defaultPotencyInPercentage: true,\n                    expirationLeadTime: true,\n                    expirationTimeUnit: true,\n                    useByDateCoefficient: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    productCategory: {\n                        code: true,\n                    },\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                },\n                            },\n                        },\n                    },\n                },\n            }, `${productCode}|${this.site.value}`)\n                .execute();\n            return productSiteToReceive;\n        }\n    }\n    _initSiteCodeField() {\n        const siteCode = this.$.storage.get('mobile-selected-stock-site');\n        if (siteCode) {\n            this.site.value = siteCode;\n        }\n    }\n    _initTechnicalProperties() {\n        this.product.value = {\n            code: this._productSite.product.code,\n            serialNumberManagementMode: this._productSite.product.serialNumberManagementMode,\n            lotManagementMode: this._productSite.product.lotManagementMode,\n            expirationManagementMode: this._productSite.product.expirationManagementMode,\n            stockUnit: {\n                code: this._productSite.product.stockUnit.code,\n                numberOfDecimals: this._productSite.product.stockUnit.numberOfDecimals,\n            },\n        };\n        this.localizedDescription.value = this._productSite.product.localizedDescription1;\n    }\n    /*\n     *\n     *  Fields management functions\n     *\n     */\n    async _onRowClick(recordId, rowItem) {\n        const _record = this.stock.getRecordValue(recordId);\n        const _stockId = Number(rowItem.stockId);\n        this.stockDetails.value = [rowItem]; // populate details list\n        this.gridBlock.selectedRecordId = recordId; // populate grid row block\n        this._stockId.value = rowItem.stockId;\n        this.quantityToMove.value = Number(_record?.quantityToMove);\n        if (typesLib.strictNe(this.statusDestination.options?.findIndex(line => typesLib.strictEq(line, _record?.statusDestination)), -1)) {\n            this.statusDestination.value = _record?.statusDestination;\n        }\n        if (_record?.packingUnitDestination) {\n            this.packingUnitDestination.value = _record?.packingUnitDestination?.code;\n        }\n        if (_record?.packingUnitToStockUnitConversionFactorDestination) {\n            this.packingUnitToStockUnitConversionFactorDestination.value = _record?.packingUnitToStockUnitConversionFactorDestination;\n        }\n        if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n            this.serialNumberLines.isHidden = false;\n            this.serialNumberLines.value = [];\n            this._stockChangeLines.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(rowItem.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation) &&\n                    line.serialNumber) {\n                    this.serialNumberLines.addRecord({\n                        quantity: Number(line.quantityInPackingUnitDestination),\n                        startingSerialNumber: line.serialNumber,\n                        endingSerialNumber: line.endingSerialNumber,\n                    });\n                }\n            });\n            let currentRecord = _record;\n            if (currentRecord) {\n                this.stock.setRecordValue(currentRecord);\n            }\n        }\n        else {\n            const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line.stockId), Number(rowItem.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n            if (typesLib.gt(lineIndex, -1)) {\n                this._currentLine = lineIndex;\n            }\n            else {\n                this._currentLine = this._stockChangeLines.length;\n                this._stockChangeLines.push({\n                    product: this.product?.value?.code,\n                    stockId: rowItem.stockId,\n                    location: this.stock.getRecordValue(this.gridBlock.selectedRecordId)?.location?.code,\n                    lineNumber: this._currentOperation,\n                    quantityInPackingUnit: rowItem.quantityInPackingUnit,\n                    quantityInPackingUnitDestination: rowItem.quantityInPackingUnit,\n                    packingUnit: this.stock.getRecordValue(this.gridBlock.selectedRecordId).packingUnit?.code,\n                    packingUnitToStockUnitConversionFactor: rowItem.packingUnitToStockUnitConversionFactor,\n                    stockDetails: [\n                        {\n                            quantityInPackingUnit: rowItem.quantityInPackingUnit,\n                        },\n                    ],\n                });\n            }\n        }\n        this._activeSelectButton();\n        await this.$.commitValueAndPropertyChanges();\n        await this.stock.validateWithDetails();\n        this.$.detailPanel.isHidden = false;\n    }\n    async _onRowUnSelect(recordId, rowItem) {\n        let stockRecord = this.stock.getRecordValue(recordId);\n        if (stockRecord) {\n            let i = 0;\n            while (typesLib.lt(i, this._stockChangeLines.length)) {\n                if (typesLib.strictEq(Number(this._stockChangeLines[i].stockId), Number(stockRecord.stockId)) && typesLib.strictEq(Number(this._stockChangeLines[i].lineNumber), Number(this._currentOperation))) {\n                    this._stockChangeLines.splice(i, 1);\n                }\n                else {\n                    i = typesLib.add(i, 1);\n                }\n            }\n            this._saveStockChange();\n            stockRecord.quantityToMove = stockRecord.quantityInPackingUnitOrigin;\n            this.stock.setRecordValue(stockRecord);\n        }\n    }\n    async _fieldsManagement() {\n        this._lotManagement();\n        await this._miscellaneousFieldsManagement();\n        this._initPackingUnitFields();\n        this._serialNumberManagement();\n    }\n    async _onChangeBody() {\n        let currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '');\n        let currentQty = Number(this.quantityToMove.value);\n        if (!currentQty || !this.startingSerialNumber.value) {\n            this.endingSerialNumber.value = null;\n            return;\n        }\n        this.startingSerialNumber.value.code = this.startingSerialNumber.value?.code?.toUpperCase();\n        if (typesLib.gt(currentQty, 1)) {\n            this.endingSerialNumber.value = this._calculateEndingSerialNumber(this.startingSerialNumber.value.code ?? '', currentQty);\n        }\n        else {\n            this.endingSerialNumber.value = this.startingSerialNumber.value.code ?? '';\n        }\n        if (typesLib.gt(currentQty, currentRecord.quantityInPackingUnitOrigin))\n            this.addSerialRange.isHidden = true;\n        else {\n            this.addSerialRange.isHidden = false;\n        }\n        await this.$.commitValueAndPropertyChanges();\n        let validationResult;\n        if ((validationResult = await this.endingSerialNumber.validate())) {\n            this.$.showToast(validationResult, { type: 'warning' });\n        }\n    }\n    _lotManagement() {\n        const lotNotManaged = typesLib.strictEq(this._productSite.product.lotManagementMode, 'notManaged');\n        this.lot.isHidden = lotNotManaged;\n        this.sublot.isHidden = lotNotManaged;\n        this.sublot.isHidden = typesLib.strictNe(this._productSite.product.lotManagementMode, 'lotAndSublot');\n    }\n    _initPackingUnitFields() {\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this._productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        this._packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n        let productPakingUnitSelectValues = productPackingList.map(productPacking => {\n            return `${productPacking.packingUnit.code}`;\n        });\n        this.packingUnit.options = [this._productSite.product.stockUnit.code, ...productPakingUnitSelectValues];\n        this.packingUnitDestination.options = [\n            this._productSite.product.stockUnit.code,\n            ...productPakingUnitSelectValues,\n        ];\n    }\n    async _miscellaneousFieldsManagement() {\n        if (!(this.lot.isHidden || !!this._productSite.product.lotSequenceNumber) &&\n            ['lotAndSublot', 'mandatoryLot'].includes(this._productSite.product.lotManagementMode))\n            this.lot.isMandatory = true;\n        const transaction = this._getSavedInputs().selectedTransaction;\n        this.statusDestination.isHidden = !transaction.isStatusChange;\n        this.packingUnitDestination.isHidden = !transaction.isUnitChange;\n        this.packingUnitToStockUnitConversionFactorDestination.isHidden = !transaction.isUnitChange;\n        if (typesLib.strictEq(transaction.isStatusChange, true))\n            this.status.isMandatory = true;\n        this._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(this._stockSite.code, this._productSite.product.productCategory.code, '26', transaction.stockMovementCode?.code ?? '', this);\n        this.status.options = await this._getStockStatus();\n        this.statusDestination.options = this.status.options;\n    }\n    _serialNumberManagement() {\n        this.serialNumber.isHidden = ['notManaged', 'issued'].includes(this._productSite.product.serialNumberManagementMode);\n        if (['receivedIssued', 'globalReceivedIssued'].includes(this._productSite.product.serialNumberManagementMode)) {\n            this.serialNumber.isMandatory = true;\n            if (typesLib.strictEq(this.lot.isHidden, false))\n                this.lot.isMandatory = false;\n            if (typesLib.strictEq(this.sublot.isHidden, false))\n                this.sublot.isMandatory = false;\n            if (typesLib.strictEq(this.status.isHidden, false))\n                this.status.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnit.isHidden, false))\n                this.packingUnit.isMandatory = false;\n            if (typesLib.strictEq(this.packingUnitDestination.isHidden, false))\n                this.packingUnitDestination.isHidden = true;\n            if (typesLib.strictEq(this.packingUnitToStockUnitConversionFactorDestination.isHidden, false))\n                this.packingUnitToStockUnitConversionFactorDestination.isHidden = true;\n        }\n    }\n    /*\n     *\n     *  record management functions\n     *\n     */\n    _saveDetail() {\n        let currentStockChangeLines = this._stockChangeLines[this._currentLine];\n        this._stockChangeLines[this._currentLine] = {\n            ...currentStockChangeLines,\n        };\n        this._saveStockChange();\n    }\n    _saveStockChange() {\n        const savedInputs = this._getSavedInputs();\n        savedInputs.subcontractTransfer.stockChangeLines = this._stockChangeLines;\n        savedInputs.currentLine = this._currentLine;\n        this.$.storage.set('mobile-subcontractTransfer', JSON.stringify(savedInputs));\n    }\n    _getQuantityInPackingUnitOrigin(record) {\n        if (record.quantityInPackingUnitOrigin) {\n            return record.quantityInPackingUnitOrigin;\n        }\n        else {\n            if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n                this._stockChangeLines = this._getSavedInputs().subcontractTransfer.stockChangeLines ?? [];\n            }\n            let _quantityInPackingUnitOrigin = Number(record.quantityInPackingUnit);\n            this._stockChangeLines?.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictNe(line.lineNumber, this._currentOperation)) {\n                    _quantityInPackingUnitOrigin = Number(typesLib.sub(Number(_quantityInPackingUnitOrigin), typesLib.div((typesLib.mul(Number(line.quantityInPackingUnitDestination), Number(line.packingUnitToStockUnitConversionFactorDestination))), Number(line.packingUnitToStockUnitConversionFactor))));\n                }\n            });\n            return _quantityInPackingUnitOrigin;\n        }\n    }\n    _getquantityInPackingUnitRest(record) {\n        if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n            this._stockChangeLines = this._getSavedInputs().subcontractTransfer.stockChangeLines ?? [];\n        }\n        if (typesLib.strictEq(this._serialNumberManagementMode, undefined)) {\n            this._serialNumberManagementMode = this._getSavedInputs().selectedProduct?.serialNumberManagementMode;\n        }\n        let _quantityInPackingUnitRest = this._getQuantityInPackingUnitOrigin(record);\n        if (typesLib.strictEq(this._serialNumberManagementMode, 'globalReceivedIssued')) {\n            this._stockChangeLines?.forEach(line => {\n                if (typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                    _quantityInPackingUnitRest = Number(typesLib.sub(Number(_quantityInPackingUnitRest), typesLib.div((typesLib.mul(Number(line.quantityInPackingUnitDestination), Number(line.packingUnitToStockUnitConversionFactorDestination))), Number(line.packingUnitToStockUnitConversionFactor))));\n                }\n            });\n        }\n        return _quantityInPackingUnitRest;\n    }\n    _getStockChangeLine(record) {\n        if (typesLib.strictEq(this._stockChangeLines, undefined)) {\n            this._stockChangeLines = this._getSavedInputs().subcontractTransfer.stockChangeLines ?? [];\n        }\n        return this._stockChangeLines?.find(line => typesLib.strictEq(Number(line.stockId), Number(record.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n    }\n    _getQuantityToMove(record) {\n        const line = this._getStockChangeLine(record);\n        let _quantityToMove;\n        if (line) {\n            _quantityToMove = typesLib.div((typesLib.mul(Number(line.quantityInPackingUnitDestination), Number(line.packingUnitToStockUnitConversionFactorDestination))), Number(record.packingUnitToStockUnitConversionFactor));\n        }\n        else {\n            _quantityToMove = Number(record.quantityInPackingUnit);\n        }\n        const _quantityInPackingUnitRest = this._getquantityInPackingUnitRest(record);\n        if (typesLib.gt(Number(_quantityToMove), Number(_quantityInPackingUnitRest))) {\n            _quantityToMove = Number(_quantityInPackingUnitRest);\n        }\n        return _quantityToMove;\n    }\n    _getPackingUnitToStockUnitConversionFactorDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return Number(line.packingUnitToStockUnitConversionFactorDestination);\n        }\n        else {\n            return Number(record.packingUnitToStockUnitConversionFactor);\n        }\n    }\n    _getPackingUnitDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return { code: line.packingUnitDestination };\n        }\n        else {\n            return undefined;\n        }\n    }\n    _getStatusDestination(record) {\n        const line = this._getStockChangeLine(record);\n        if (line) {\n            return line.statusDestination;\n        }\n        else {\n            return '';\n        }\n    }\n    _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n        return startingSerialNumber.replace(/\\d+$/, match => {\n            const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n            const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n            return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n        });\n    }\n    async _getStockStatus() {\n        const selectedStatus = [];\n        this._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }, {\n            filter: {\n                code: { _or: selectedStatus },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_details__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        return response.edges.map((stockStatus) => stockStatus.node.code);\n    }\n};\nexports.MobileSubcontractTransferDetails = MobileSubcontractTransferDetails;\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isTransient: false,\n        isTitleHidden: true,\n        isDisabled: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.select({\n                bind: 'lotManagementMode',\n                optionType: '@sage/x3-master-data/LotManagementMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'expirationManagementMode',\n                optionType: '@sage/x3-master-data/ExpirationManagement',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'stockVersionMode',\n                optionType: '@sage/x3-master-data/StockVersionMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'numberOfDecimals',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLocationManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"isLocationManaged\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        bind: 'isLicensePlateNumberManaged',\n        isTransient: false,\n        isHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"isLicensePlateNumberManaged\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        size: 'small',\n    })\n], MobileSubcontractTransferDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        prefix: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__site____prefix\", \"Site \"),\n    })\n], MobileSubcontractTransferDetails.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__nextButton____title\", \"Next\"),\n        shortcut: ['f2'],\n        buttonType: 'primary',\n        async onClick() {\n            if (typesLib.gt(this.stock.selectedRecords.length, 0)) {\n                (0, manage_pages_1.removeFilters)(this);\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    sublot: undefined,\n                    serialNumber: undefined,\n                    status: undefined,\n                    packingUnit: undefined,\n                    packingUnitToStockUnitConversionFactor: undefined,\n                    identifier1: undefined,\n                    identifier2: undefined,\n                    stockCustomField1: undefined,\n                    stockCustomField2: undefined,\n                };\n                await this.stock.refresh();\n                await this.$.commitValueAndPropertyChanges();\n                this.$.setPageClean();\n                const savedInputs = this._getSavedInputs();\n                savedInputs.currentLine = this._currentLine;\n                this.$.storage.set('mobile-subcontractTransfer', JSON.stringify(savedInputs));\n                this.$.router.goTo('@sage/x3-stock/MobileSubcontractTransfer', { ReturnFromDetail: 'yes' });\n            }\n            else {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__no_stock_error', `Select at least one stock line.`));\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__helperCancelButton____title\", \"Cancel\"),\n        buttonType: 'secondary',\n        async onClick() {\n            const recordId = this.gridBlock?.selectedRecordId ?? '';\n            if (recordId) {\n                const currentRecord = this.stock.getRecordValue(recordId);\n                if (currentRecord) {\n                    let i = 0;\n                    while (typesLib.lt(i, this._stockChangeLines.length)) {\n                        if (typesLib.strictEq(Number(this._stockChangeLines[i].stockId), Number(currentRecord.stockId)) && typesLib.strictEq(Number(this._stockChangeLines[i].lineNumber), Number(this._currentOperation))) {\n                            this._stockChangeLines.splice(i, 1);\n                        }\n                        else {\n                            i = typesLib.add(i, 1);\n                        }\n                    }\n                    this._saveStockChange();\n                    currentRecord.quantityToMove = currentRecord.quantityInPackingUnitOrigin;\n                    currentRecord.quantityInPackingUnitRest = currentRecord.quantityInPackingUnitOrigin;\n                    this.quantityToMove.value = Number(currentRecord.quantityToMove);\n                    currentRecord.quantityInPackingUnitDestination = currentRecord.quantityInPackingUnitOrigin;\n                    this.stock.unselectRecord(recordId);\n                    this.stock.setRecordValue(currentRecord);\n                    this.$.detailPanel.isHidden = true;\n                    this.nextButton.isHidden = false;\n                }\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"helperCancelButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__helperSelectButton____title\", \"Select\"),\n        buttonType: 'primary',\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumberMandatory': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumberMandatory', 'You need to select the serial number and add it first.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        async onClick() {\n            await this.$.commitValueAndPropertyChanges();\n            const errors = await this.stock.validateWithDetails();\n            if (typesLib.strictEq(errors.length, 0)) {\n                const _recordId = this.gridBlock?.selectedRecordId;\n                let _currentRecord = this.stock.getRecordValue(_recordId ?? '');\n                if (typesLib.strictEq(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                    if (typesLib.strictEq(this.serialNumberLines.value.length, 0)) {\n                        throw new Error('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumberMandatory');\n                    }\n                }\n                else {\n                    if (!this.quantityToMove.value || typesLib.lte(this.quantityToMove.value, 0)) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__quantityInPackingUnitDestination_must_be_greater_than_0', 'The quantity to move must be greater than 0'));\n                        return;\n                    }\n                }\n                if (typesLib.gt(Number(this.quantityToMove.value), Number(_currentRecord.quantityInPackingUnitRest))) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__mobile_stock_error', 'Error'), `${ui.localize('@sage/x3-stock/pages__mobile_stock_change_lines__enter_a_quantity_less_than_or_equal_to_the_stock_quantity', 'Enter a quantity less than or equal to the stock quantity.')}`);\n                    return;\n                }\n                if (_currentRecord?.qualityAnalysisRequestId) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__mobile_stock_error', 'Error'), ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__subcontrat_transfer_is_impossible_on_a_line_in_quality_control', 'Subcontract transfer is impossible on a line in quality control.'));\n                    this.$.setPageClean();\n                    return;\n                }\n                if (_recordId && _currentRecord) {\n                    this.stock.selectRecord(_recordId);\n                    const _savedInputs = this._getSavedInputs();\n                    const _subcontractLocation = _savedInputs.subcontractTransfer.subcontractLocation ?? undefined;\n                    const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n                    if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                        if (typesLib.gt(lineIndex, -1)) {\n                            this._stockChangeLines[lineIndex].packingUnitDestination = this.packingUnitDestination.value\n                                ? this.packingUnitDestination.value\n                                : this._stockChangeLines[lineIndex].packingUnit;\n                            this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactorDestination = this\n                                .packingUnitToStockUnitConversionFactorDestination.value\n                                ? Number(this.packingUnitToStockUnitConversionFactorDestination.value)\n                                : this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor;\n                            const _stockDetails = this._stockChangeLines[lineIndex]?.stockDetails;\n                            if (_stockDetails) {\n                                const _stockJournal = _stockDetails[0];\n                                if (this.packingUnitDestination.value) {\n                                    _stockJournal.packingUnit = this.packingUnitDestination.value;\n                                }\n                                else {\n                                    _stockJournal.packingUnit = _currentRecord?.packingUnit?.code;\n                                }\n                                _stockJournal.packingUnitToStockUnitConversionFactor = Number(this.packingUnitToStockUnitConversionFactorDestination.value);\n                                _stockJournal.quantityInPackingUnit = typesLib.div((typesLib.mul(Number(this.quantityToMove.value), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value));\n                                _stockJournal.quantityInStockUnit = typesLib.mul(Number(this.quantityToMove.value), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor));\n                                _stockJournal.location = _subcontractLocation;\n                                if (this.statusDestination.value) {\n                                    _stockJournal.status = this.statusDestination.value;\n                                }\n                                else {\n                                    _stockJournal.status = _currentRecord.status?.code;\n                                }\n                                _stockJournal.identifier1 = _currentRecord?.identifier1;\n                                _stockJournal.identifier2 = _currentRecord?.identifier2;\n                            }\n                        }\n                        else {\n                            this._stockChangeLines[this._currentLine] = {\n                                product: this.product.value?.code,\n                                stockId: String(_currentRecord.stockId),\n                                productDescription: this.product.value?.description1,\n                                quantityInPackingUnit: Number(this.quantityToMove.value),\n                                packingUnitToStockUnitConversionFactor: _currentRecord.packingUnitToStockUnitConversionFactor,\n                                serialNumber: _currentRecord.serialNumber,\n                                lineNumber: this._currentOperation,\n                                packingUnitDestination: this.packingUnitDestination.value\n                                    ? this.packingUnitDestination.value\n                                    : _currentRecord.packingUnit?.code,\n                                stockDetails: [\n                                    {\n                                        packingUnit: this.packingUnitDestination.value\n                                            ? this.packingUnitDestination.value\n                                            : _currentRecord.packingUnit?.code,\n                                        packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                                        quantityInPackingUnit: typesLib.div((typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value)),\n                                        quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor)),\n                                        location: _subcontractLocation,\n                                        status: this.statusDestination.value\n                                            ? this.statusDestination.value\n                                            : _currentRecord.status?.code,\n                                        serialNumber: _currentRecord.serialNumber ?? undefined,\n                                        identifier1: _currentRecord.identifier1 ?? undefined,\n                                        identifier2: _currentRecord.identifier2 ?? undefined,\n                                    },\n                                ],\n                            };\n                        }\n                    }\n                    let qtyTotal = 0;\n                    this._stockChangeLines.forEach(line => {\n                        if (typesLib.strictEq(Number(line.stockId), Number(_currentRecord?.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation)) {\n                            line.stockDetails?.forEach(stockLine => {\n                                qtyTotal = typesLib.add(qtyTotal, typesLib.div((typesLib.mul(Number(Number(stockLine.quantityInPackingUnit)), Number(stockLine.packingUnitToStockUnitConversionFactor))), Number(line.packingUnitToStockUnitConversionFactor)));\n                            });\n                        }\n                    });\n                    this._stockChangeLines[lineIndex].quantityInPackingUnitDestination = typesLib.div((typesLib.mul(Number(qtyTotal), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value));\n                    this._stockChangeLines[lineIndex].quantityInPackingUnit = Number(qtyTotal);\n                    this._stockChangeLines[lineIndex].quantityInStockUnitDestination = typesLib.mul(Number(qtyTotal), Number(this._stockChangeLines[lineIndex].packingUnitToStockUnitConversionFactor));\n                    this._saveDetail();\n                    _currentRecord.quantityToMove = qtyTotal;\n                    _currentRecord.quantityInStockUnitDestination = typesLib.mul(qtyTotal, Number(_currentRecord.packingUnitToStockUnitConversionFactor));\n                    _currentRecord.statusDestination = this.statusDestination.value\n                        ? this.statusDestination.value\n                        : _currentRecord?.status;\n                    _currentRecord.packingUnitDestination =\n                        typesLib.strictNe(this.packingUnitDestination.value, '') ? { code: this.packingUnitDestination.value } : null;\n                    _currentRecord.packingUnitToStockUnitConversionFactorDestination =\n                        this.packingUnitToStockUnitConversionFactorDestination.value;\n                    this.stock.setRecordValue(_currentRecord);\n                }\n            }\n            this.$.detailPanel.isHidden = true;\n            this.nextButton.isHidden = false;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"helperSelectButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        icon: 'add',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__addSerialRange____title\", \"Add...\"),\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumber': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumber', 'The serial number is mandatory');\n                }\n                case '@sage/x3-stock/serial-number-range-overlap': {\n                    return ui.localize('@sage/x3-stock/serial-number-range-overlap', 'The serial numbers are overlapping. Enter another starting or ending serial number.');\n                }\n                case '@sage/x3-stock/pages__mobile_subcontract_transfer__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move': {\n                    return ui.localize('@sage/x3-stock/pages__mobile_subcontract_transfer__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move', 'Select the same amount of serial numbers in the range to match the quantity to move.');\n                }\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default: {\n                    return error;\n                }\n            }\n        },\n        buttonType: 'secondary',\n        async onClick() {\n            if (!this.startingSerialNumber.value) {\n                throw new Error('@sage/x3-stock/pages__mobile_subcontract_transfer_lines__notification__error_startingSerialNumber');\n            }\n            // check that this will add any duplicates\n            const startNumberToAdd = this.startingSerialNumber?.value?.code?.match(/\\d+$/);\n            const endNumberToAdd = Number(this.endingSerialNumber?.value?.match(/\\d+$/));\n            let serialNumberAlreadyUsed = false;\n            if (this.serialNumberLines.value.some(row => {\n                const rowStartMatch = row.startingSerialNumber.match(/\\d+$/);\n                const rowEndMatch = Number(row.endingSerialNumber.match(/\\d+$/));\n                // check if the 'beginning part' of the serial matches\n                if (!startNumberToAdd || typesLib.strictNe(row.startingSerialNumber.substring(0, typesLib.sub(row.startingSerialNumber.length, rowStartMatch.toString().length)), this.startingSerialNumber?.value?.code?.substring(0, typesLib.sub(this.startingSerialNumber.value.code.length, startNumberToAdd.toString().length))))\n                    return false;\n                return typesLib.lte(Number(startNumberToAdd), rowEndMatch) && typesLib.gte(endNumberToAdd, Number(rowStartMatch));\n            })) {\n                serialNumberAlreadyUsed = true;\n            }\n            this._stockChangeLines.forEach(line => {\n                if (typesLib.strictEq(line.product, this.product?.value?.code) && line.serialNumber) {\n                    const startingSerialNumber = Number(line.serialNumber.match(/\\d+$/));\n                    const endingSerialNumber = Number(this._calculateEndingSerialNumber(line.serialNumber, Number(line.quantityInPackingUnitDestination)).match(/\\d+$/));\n                    if (typesLib.lte(Number(startNumberToAdd), endingSerialNumber) && typesLib.gte(Number(endNumberToAdd), startingSerialNumber)) {\n                        serialNumberAlreadyUsed = true;\n                    }\n                }\n            });\n            if (serialNumberAlreadyUsed) {\n                throw new Error('@sage/x3-stock/serial-number-range-overlap');\n            }\n            if (typesLib.ne(this.endingSerialNumber.value, this._calculateEndingSerialNumber(this.startingSerialNumber?.value?.code ?? '', Number(this.quantityToMove.value)))) {\n                throw new Error('@sage/x3-stock/pages__mobile_subcontract_transfer__same-amount-serial-numbers-in-the-range-to-match-quantity-to-move');\n            }\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this._stockSite.code, this._stockId.value ?? '', this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '', '')), Number(this.quantityToMove.value))) {\n                throw new Error('@sage/x3-stock/serial-number-not-sequential');\n            }\n            const _savedInputs = this._getSavedInputs();\n            const _subcontractLocation = _savedInputs.subcontractTransfer.subcontractLocation ?? undefined;\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n            if (_currentRecord) {\n                this.serialNumberLines.addRecord({\n                    quantity: this.quantityToMove.value,\n                    startingSerialNumber: this.startingSerialNumber.value.code,\n                    endingSerialNumber: this.endingSerialNumber.value,\n                });\n                const lineIndex = this._stockChangeLines.findIndex(line => typesLib.strictEq(Number(line?.stockId), Number(_currentRecord.stockId)) && typesLib.strictEq(line.lineNumber, this._currentOperation));\n                if (typesLib.gt(lineIndex, -1)) {\n                    this._currentLine = lineIndex;\n                    this._stockChangeLines[this._currentLine] = {\n                        ...this._stockChangeLines[this._currentLine],\n                        packingUnitDestination: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        quantityInPackingUnitDestination: 0,\n                        packingUnitToStockUnitConversionFactorDestination: 0,\n                    };\n                    this._stockChangeLines[this._currentLine].stockDetails?.push({\n                        packingUnit: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                        quantityInPackingUnit: Number(typesLib.div((typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value))),\n                        quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor)),\n                        location: _subcontractLocation,\n                        status: this.statusDestination.value\n                            ? this.statusDestination.value\n                            : _currentRecord.status?.code,\n                        serialNumber: this.startingSerialNumber.value.code,\n                        endingSerialNumber: this.endingSerialNumber.value,\n                        identifier1: _currentRecord.identifier1 ?? undefined,\n                        identifier2: _currentRecord.identifier2 ?? undefined,\n                    });\n                }\n                else {\n                    this._stockChangeLines.push({\n                        product: this.product?.value?.code,\n                        stockId: String(_currentRecord.stockId),\n                        productDescription: this.product?.value?.description1,\n                        quantityInPackingUnit: Number(this.quantityToMove.value),\n                        packingUnitToStockUnitConversionFactor: _currentRecord.packingUnitToStockUnitConversionFactor,\n                        lineNumber: this._currentOperation,\n                        packingUnitDestination: this.packingUnitDestination.value\n                            ? this.packingUnitDestination.value\n                            : _currentRecord.packingUnit?.code,\n                        quantityInPackingUnitDestination: 0,\n                        packingUnitToStockUnitConversionFactorDestination: 0,\n                        stockDetails: [\n                            {\n                                packingUnit: this.packingUnitDestination.value\n                                    ? this.packingUnitDestination.value\n                                    : _currentRecord.packingUnit?.code,\n                                packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactorDestination.value),\n                                quantityInPackingUnit: Number(typesLib.div((typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor))), Number(this.packingUnitToStockUnitConversionFactorDestination.value))),\n                                quantityInStockUnit: typesLib.mul(Number(this.quantityToMove.value), Number(_currentRecord.packingUnitToStockUnitConversionFactor)),\n                                location: _subcontractLocation,\n                                status: this.statusDestination.value\n                                    ? this.statusDestination.value\n                                    : _currentRecord.status?.code,\n                                serialNumber: this.startingSerialNumber.value.code,\n                                endingSerialNumber: this.endingSerialNumber.value,\n                                identifier1: _currentRecord.identifier1 ?? undefined,\n                                identifier2: _currentRecord.identifier2 ?? undefined,\n                            },\n                        ],\n                    });\n                }\n                this._saveDetail();\n                _currentRecord.quantityToMove = String(0);\n                this.quantityToMove.value = 0;\n                this.stock.setRecordValue(_currentRecord);\n                this.startingSerialNumber.value = null;\n                this.endingSerialNumber.value = null;\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"addSerialRange\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__detailPanelSection____title\", \"Stock change\"),\n        isTitleHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"detailPanelSection\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"bodyBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"detailsBlock\", void 0);\n__decorate([\n    ui.decorators.gridRowBlock({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n        boundTo() {\n            return this.stock;\n        },\n        fieldFilter(columnId) {\n            return false;\n        },\n        readOnlyOverride(columnId) {\n            return undefined;\n            // if undefined is returned, the original readOnly property is used from the column definition\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"gridBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"quantityBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"serialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"destinationBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.detailPanelSection;\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"listSerialNumberBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ status: 'inStock' }, { stockSite: { code: this._stockSite.code } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.location) {\n                this.location.value = this.licensePlateNumber.value.location;\n            }\n            if (!this.licensePlateNumber.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    licensePlateNumber: undefined,\n                };\n                if (!this.licensePlateNumber.isHidden) {\n                    this.licensePlateNumber.value = null;\n                }\n                return;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                licensePlateNumber: { code: this.licensePlateNumber.value.code },\n            };\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__location____placeholder\", \"Scan or select\\u2026\"),\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isTransient: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._stockSite.code },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.location);\n            if (this.location.value) {\n                this.location.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__location____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__location____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'lot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                storageSite: { code: this.site.value ?? '' },\n            };\n        },\n        async onChange() {\n            if (!this.lot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    ...(typesLib.strictEq(this.product.value?.lotManagementMode, 'lotAndSublot') && { sublot: undefined }),\n                };\n                if (!this.sublot.isHidden) {\n                    this.sublot.value = null;\n                }\n                return;\n            }\n            if (!this.sublot.isHidden) {\n                this.sublot.value = this.lot.value; // update sublot field if available, for display purposes only\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.lot.value.lot,\n                ...(this.lot.value?.sublot && { sublot: this.lot.value.sublot }),\n            };\n            this.lot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__sublot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'sublot',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                storageSite: { code: this.site.value ?? '' },\n            };\n        },\n        async onChange() {\n            if (!this.sublot.value) {\n                this.stock.filter = {\n                    ...this.stock.filter,\n                    lot: undefined,\n                    sublot: undefined,\n                };\n                if (!this.lot.isHidden) {\n                    this.lot.value = null;\n                }\n                return;\n            }\n            if (!this.lot.isHidden) {\n                this.lot.value = this.sublot.value;\n            }\n            this.stock.filter = {\n                ...this.stock.filter,\n                lot: this.sublot.value.lot,\n                sublot: this.sublot.value.sublot,\n            };\n            this.sublot.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__sublot____columns__title__lot\", \"Lot\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__sublot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumber____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value?.code ?? '' },\n                stockSite: { code: this.site.value ?? '' },\n                issueDocumentId: '',\n            };\n        },\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.serialNumber, this.serialNumber.value?.code);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__status____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.status, this.status.value);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnit____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnit, this.packingUnit.value);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnitToStockUnitConversionFactor____placeholder\", \"Scan...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        min: 0,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.packingUnitToStockUnitConversionFactor);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__identifier1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier1);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.identifier2);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockCustomField1____title\", \"Stock custom field 1\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockCustomField1____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField1);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"stockCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockCustomField2____title\", \"Stock custom field 2\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockCustomField2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        async onChange() {\n            await (0, manage_pages_1.handleFilterOnChange)(this, this.stockCustomField2);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"stockCustomField2\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.bodyBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isChangeIndicatorDisabled: false,\n        canFilter: false,\n        canSelect: true,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: false,\n        isFullWidth: true,\n        isDisabled: false,\n        hasSearchBoxMobile: false,\n        cardView: true,\n        displayMode: ui.fields.TableDisplayMode.compact,\n        mobileCard: undefined,\n        orderBy: {\n            stockSite: 1,\n            stockId: 1,\n        },\n        filter() {\n            return {\n                ...(0, manage_pages_1.generateStockTableFilter)(this),\n                location: { category: { _nin: ['subcontract', 'customer'] } },\n            };\n        },\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                isReadOnly: true,\n                isHidden: false, // special field that always gets displayed\n                isTransient: true,\n                postfix(value, rowValue) {\n                    return `/ ${ui.formatNumberToCurrentLocale(this.$.detailPanel.isHidden\n                        ? (rowValue?.quantityInPackingUnitOrigin ?? 0)\n                        : (rowValue?.quantityInPackingUnitRest ?? 0), rowValue?.packingUnit?.numberOfDecimals ?? 0)} ${rowValue?.packingUnit?.code ?? ''}`;\n                },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stock____columns__title\", \"Quantity to move\"), // this is important to display a title in the grid row block\n                isTitleHidden: false,\n                isMandatory: false,\n                isFullWidth: true,\n                max(rowValue) {\n                    return rowValue?.quantityInPackingUnitOrigin ?? 0;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitRest',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stock____columns__title__product__product__code\", \"Product\"),\n                isReadOnly: true,\n                isHidden: false,\n                columns: [\n                    ui.nestedFields.text({\n                        bind: { product: { code: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { serialNumberManagementMode: true } },\n                    }),\n                    ui.nestedFields.text({\n                        bind: { product: { stockUnit: { code: true } } },\n                    }),\n                ],\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stock____columns__title__licensePlateNumber__code\", \"License plate number\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.lot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                isReadOnly: true,\n                isHidden() {\n                    return this.sublot.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                isReadOnly: true,\n                isHidden() {\n                    return this.serialNumber.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                isReadOnly: true,\n                isHidden() {\n                    return this.status.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'statusDestination',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.technical({\n                bind: 'packingUnitDestination',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                isTransient: true,\n                nestedFields: [\n                    ui.nestedFields.text({\n                        bind: 'code',\n                    }),\n                    ui.nestedFields.numeric({\n                        bind: 'numberOfDecimals',\n                    }),\n                ],\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden() {\n                    return this.packingUnitToStockUnitConversionFactor.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnitOrigin',\n                isHidden: true,\n                isTitleHidden: true,\n                isTransient: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactorDestination',\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.identifier2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField1',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField1.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCustomField2',\n                isReadOnly: true,\n                isHidden() {\n                    return this.stockCustomField2.isHidden ?? false;\n                },\n            }),\n            ui.nestedFields.technical({\n                bind: 'stockId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'lotReference',\n                node: '@sage/x3-stock-data/Lot',\n                nestedFields: [\n                    ui.nestedFields.date({\n                        bind: 'expirationDate',\n                    }),\n                    ui.nestedFields.date({\n                        bind: 'useByDate',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField1',\n                    }),\n                    ui.nestedFields.text({\n                        bind: 'lotCustomField2',\n                    }),\n                    ui.nestedFields.reference({\n                        bind: 'majorVersion',\n                        node: '@sage/x3-master-data/MajorVersionStatus',\n                        valueField: 'code',\n                    }),\n                ],\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceExpirationDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.date({\n                bind: 'lotReferenceUseByDate',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lotReferenceMajorVersion',\n                isTransient: true,\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.technical({\n                bind: 'quantityInStockUnit',\n            }),\n            ui.nestedFields.technical({\n                bind: 'allocatedQuantity',\n            }),\n            ui.nestedFields.technical({\n                bind: 'qualityAnalysisRequestId',\n            }),\n            ui.nestedFields.technical({\n                bind: 'owner',\n            }),\n        ],\n        onError(error) {\n            switch (error.message) {\n                case '@sage/x3-stock/serial-number-not-sequential': {\n                    return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n                }\n                default:\n                    return error;\n            }\n        },\n        async onRowSelected(recordId, rowItem) {\n            await this._onRowClick(recordId, rowItem);\n        },\n        async onRowUnselected(recordId, rowItem) {\n            await this._onRowUnSelect(recordId, rowItem);\n        },\n        sortColumns(firstColumn, secondColumn) {\n            if (typesLib.strictEq(firstColumn.bind, secondColumn.bind))\n                return 0;\n            if (typesLib.strictEq(firstColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(secondColumn.bind, this._stockFieldSettings[0]) ? 1 : -1;\n            }\n            else if (typesLib.strictEq(secondColumn.bind, 'quantityToMove')) {\n                return typesLib.strictEq(firstColumn.bind, this._stockFieldSettings[0]) ? -1 : 1;\n            }\n            for (const stockFieldSetting of Object.keys(this._stockFieldSettings)) {\n                if (!stockFieldSetting || typesLib.strictEq(stockFieldSetting, 'none'))\n                    break;\n                if (typesLib.strictEq(firstColumn.bind, stockFieldSetting))\n                    return -1;\n                if (typesLib.strictEq(secondColumn.bind, stockFieldSetting))\n                    return 1;\n            }\n            return 1;\n        },\n        mapServerRecord(record) {\n            const _record = {\n                ...record,\n                quantityInPackingUnitOrigin: this._getQuantityInPackingUnitOrigin(record),\n                quantityInPackingUnitRest: this._getquantityInPackingUnitRest(record),\n                quantityToMove: this._getQuantityToMove(record).toString(),\n                statusDestination: this._getStatusDestination(record),\n                packingUnitDestination: this._getPackingUnitDestination(record),\n                packingUnitToStockUnitConversionFactorDestination: this._getPackingUnitToStockUnitConversionFactorDestination(record),\n                lotReferenceExpirationDate: record.lotReference?.expirationDate,\n                lotReferenceUseByDate: record.lotReference?.useByDate,\n                lotReferenceMajorVersion: record.lotReference?.majorVersion?.code,\n                globalSerialNumber: ui.localize('@sage/x3-stock/label-view-all', 'View list'),\n            };\n            return _record;\n        },\n        async onRowClick(recordId, rowItem) {\n            await this._onRowUnSelect(recordId, rowItem);\n            await this._onRowClick(recordId, rowItem);\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"stock\", void 0);\n__decorate([\n    ui.decorators.detailListField({\n        parent() {\n            return this.detailsBlock;\n        },\n        node: '@sage/x3-stock-data/Stock',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: true,\n        fields: [\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-master-data/ProductSite',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title\", \"Product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.reference({\n                bind: 'licensePlateNumber',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__2\", \"License plate number\"),\n                node: '@sage/x3-stock-data/LicensePlateNumber',\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__3\", \"Location\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__4\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__5\", \"Lot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__6\", \"Sublot\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: { majorVersion: { code: true } },\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__7\", \"Major version\"),\n                isReadOnly: true,\n                isHidden: (value) => {\n                    return !value?.majorVersion;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'expirationDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__8\", \"Expiration date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return (!this.product.value || typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') ||\n                        !value?.expirationDate || typesLib.gt(Date.parse(value.expirationDate), Date.now()));\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'useByDate',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__9\", \"Use-by date\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return (!this.product.value || typesLib.strictEq(this.product.value.expirationManagementMode, 'notManaged') ||\n                        !value?.useByDate || typesLib.gt(Date.parse(value.useByDate), Date.now()));\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__10\", \"Lot custom field 1\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField1;\n                },\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Lot',\n                bind: 'lotReference',\n                valueField: 'lotCustomField2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__11\", \"Lot custom field 2\"),\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value?.lotCustomField2;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__12\", \"Serial no.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.link({\n                bind: 'globalSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__13\", \"Serial no.\"),\n                isHidden() {\n                    return typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued');\n                },\n                async onClick(_id, rowData) {\n                    const options = {\n                        skipDirtyCheck: true,\n                    };\n                    try {\n                        await this.$.dialog.page('@sage/x3-stock/MobileGlobalSerialDetails', {\n                            product: this.product.value?.code ?? '',\n                            stockId: rowData.stockId,\n                            subtitle: this.localizedDescription.value ?? '',\n                        }, options);\n                    }\n                    catch (error) {\n                        if (error) {\n                            this.$.showToast(error.message, { timeout: 10000, type: 'error' });\n                        }\n                    }\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityToMove',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__14\", \"Quantity to move\"),\n                isReadOnly: true,\n                isTransient: true,\n                isHidden: true,\n                postfix(value, rowValue) {\n                    return rowValue?.packingUnit.code;\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPackingUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__15\", \"Packing qty.\"),\n                isReadOnly: true,\n                isHidden: false,\n                postfix(value, rowValue) {\n                    return rowValue?.packingUnit?.code ?? '';\n                },\n                scale(value, rowValue) {\n                    return rowValue?.packingUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'packingUnit',\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__16\", \"Unit\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'packingUnitToStockUnitConversionFactor',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__17\", \"Conversion factor\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInStockUnit',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__18\", \"Stock qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__19\", \"Allocated qty.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n                postfix() {\n                    return this.product.value?.stockUnit?.code ?? '';\n                },\n                scale() {\n                    return this.product.value?.stockUnit?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'status',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/StockStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__20\", \"Status\"),\n                isReadOnly: true,\n                isHidden: (value) => {\n                    return !value?.code;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__21\", \"Identifier 1\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'identifier2',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__22\", \"Identifier 2\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'qualityAnalysisRequestId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__23\", \"Analysis req.\"),\n                isReadOnly: true,\n                isHidden: hideWhenEmptyValue,\n            }),\n            ui.nestedFields.text({\n                bind: 'owner',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__stockDetails____fields__title__24\", \"Owner\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"stockDetails\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.quantityBlock;\n        },\n        postfix(value, rowValue) {\n            const _record = this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '');\n            return `/ ${ui.formatNumberToCurrentLocale(this.$.detailPanel.isHidden\n                ? (_record?.quantityInPackingUnitOrigin ?? 0)\n                : (_record?.quantityInPackingUnitRest ?? 0), _record?.packingUnit?.numberOfDecimals ?? 0)} ${_record?.packingUnit?.code ?? ''}`;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__quantityToMove____title\", \"Quantity to move\"), // this is important to display a title in the grid row block\n        isMandatory: false,\n        isFullWidth: true,\n        isTransient: true,\n        max() {\n            return this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')\n                ?.quantityInPackingUnitRest;\n        },\n        scale() {\n            return (this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '')?.packingUnit\n                ?.numberOfDecimals ?? 0);\n        },\n        async onChange() {\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n            if (_currentRecord) {\n                _currentRecord.quantityToMove = String(this.quantityToMove.value);\n                this.stock.setRecordValue(_currentRecord);\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"quantityToMove\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__startingSerialNumber____title\", \"Starting serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__startingSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        canFilter: false,\n        isDisabled: false,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        minLookupCharacters: 1,\n        filter() {\n            return {\n                _and: [{ product: { code: this.product.value?.code } }, { stockId: this._stockId.value ?? undefined }],\n            };\n        },\n        async onChange() {\n            await this._onChangeBody();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__startingSerialNumber____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__startingSerialNumber____columns__title__product__code\", \"Product\"),\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'stockId',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__startingSerialNumber____columns__title__stockId\", \"Stock ID\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileSubcontractTransferDetails.prototype, \"startingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__endingSerialNumber____title\", \"Ending serial number\"),\n        isMandatory: false,\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: true,\n        async validation(value) {\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued'))\n                return;\n            const _currentRecord = this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '');\n            const _currentQty = Number(this.quantityToMove.value);\n            if (typesLib.strictNe((await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this._stockSite.code, this._stockId.value ?? '', this.startingSerialNumber.value?.code ?? '', this.endingSerialNumber.value ?? '', value)), _currentQty)) {\n                return ui.localize('@sage/x3-stock/serial-number-not-sequential', 'The serial numbers are not sequential. Check your entry.');\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"endingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__statusDestination____title\", \"Destination Status\"),\n        width: 'small',\n        isMandatory: false,\n        isTransient: true,\n        onChange() {\n            this._activeSelectButton();\n            if (this.statusDestination.value) {\n                this.statusDestination.getNextField(true)?.focus();\n            }\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"statusDestination\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnitDestination____title\", \"Destination unit\"),\n        width: 'small',\n        isMandatory: false,\n        isTransient: true,\n        onChange() {\n            if (!this.packingUnitDestination.value)\n                return;\n            const selectedValue = this.packingUnitDestination.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.packingUnitToStockUnitConversionFactorDestination.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled =\n                    !selectedUnit.isPackingFactorEntryAllowed;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactorDestination.value = 1;\n                this.packingUnitToStockUnitConversionFactorDestination.isDisabled = true;\n            }\n            this._activeSelectButton();\n            this.packingUnitDestination.getNextField(true)?.focus();\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"packingUnitDestination\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.destinationBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__packingUnitToStockUnitConversionFactorDestination____title\", \"Destination conversion factor\"),\n        isDisabled: true,\n        isMandatory: false,\n        isTransient: true,\n        scale: 5,\n        onChange() {\n            this._activeSelectButton();\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"packingUnitToStockUnitConversionFactorDestination\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.serialNumberBlock;\n        },\n        isTransient: true,\n        isHidden: true,\n    })\n], MobileSubcontractTransferDetails.prototype, \"_stockId\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.listSerialNumberBlock;\n        },\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        isTransient: true,\n        isFullWidth: true,\n        isDisabled: false,\n        node: '@sage/x3-stock/StockCountSerialNumber',\n        mobileCard: undefined,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumberLines____columns__title__startingSerialNumber\", \"Starting serial Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumberLines____columns__title__quantity\", \"Quantity\"),\n                isReadOnly: true,\n                postfix(value, rowValue) {\n                    return this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '')?.packingUnit?.code ?? '';\n                },\n                scale() {\n                    return (this.stock.getRecordValue(this.gridBlock.selectedRecordId ?? '')?.packingUnit\n                        ?.numberOfDecimals ?? 0);\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'endingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumberLines____columns__title__endingSerialNumber\", \"Ending Serial Number\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'bin',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details__serialNumberLines____dropdownActions__title\", \"Delete\"),\n                onClick(recordId) {\n                    // line removal in the saved object\n                    const removedRecordSerialNumber = this.serialNumberLines.getRecordValue(recordId);\n                    if (removedRecordSerialNumber) {\n                        const removedIndexSerialNumber = this._stockChangeLines[this._currentLine].stockDetails?.findIndex(number => typesLib.strictEq(number.serialNumber, removedRecordSerialNumber?.startingSerialNumber)) ?? -1;\n                        if (typesLib.strictNe(removedIndexSerialNumber, -1)) {\n                            this._stockChangeLines[this._currentLine].stockDetails?.splice(removedIndexSerialNumber, 1);\n                        }\n                        this._saveDetail();\n                        // Clear quantity of this._currentLine\n                        const _currentRecord = this.stock.getRecordValue(this.gridBlock?.selectedRecordId ?? '');\n                        if (_currentRecord) {\n                            _currentRecord.quantityToMove = String(0);\n                            this.stock.setRecordValue(_currentRecord);\n                        }\n                        //remove from the card\n                        this.serialNumberLines.removeRecord(recordId);\n                    }\n                    this.startingSerialNumber.isDisabled = false;\n                },\n            },\n        ],\n        fieldActions() {\n            return [this.addSerialRange];\n        },\n    })\n], MobileSubcontractTransferDetails.prototype, \"serialNumberLines\", void 0);\nexports.MobileSubcontractTransferDetails = MobileSubcontractTransferDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details____title\", \"Subcontracting\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_subcontract_transfer_details____subtitle\", \"Enter stock details\"),\n        mode: 'default',\n        node: '@sage/x3-master-data/ProductSite',\n        isTitleHidden: true,\n        isTransient: false,\n        navigationPanel: undefined,\n        headerCard() {\n            return {\n                title: this.product,\n                line2: this.localizedDescription,\n            };\n        },\n        businessActions() {\n            return [this.nextButton];\n        },\n        async onLoad() {\n            if (!this._getSavedInputs()?.selectedProduct) {\n                return;\n            }\n            this._stockSite = JSON.parse(this.$.queryParameters.stockSite);\n            const _savedInputs = this._getSavedInputs();\n            this._stockChangeLines = _savedInputs?.subcontractTransfer.stockChangeLines ?? [];\n            this._currentLine = _savedInputs?.currentLine ?? 0;\n            this._currentOperation = _savedInputs?.currentOperation ?? 0;\n            this._serialNumberManagementMode = _savedInputs?.selectedProduct?.serialNumberManagementMode;\n            await this._init();\n            if (typesLib.strictNe(this._productSite.product.serialNumberManagementMode, 'globalReceivedIssued')) {\n                this.addSerialRange.isHidden = true;\n                this.serialNumberBlock.isHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n                this.serialNumberLines.isTitleHidden = true;\n                this.listSerialNumberBlock.isHidden = true;\n            }\n            this.serialNumberLines.title = 'Serial number(s) to move    ';\n            (0, manage_pages_1.managePages)(this, this._stockSite.code, { ...this.$.values, product: { ...this.product.value } }, '3', ui.localize('@sage/x3-stock/pages__mobile-settings__mandatory-settings-missing', 'Mandatory settings missing.'), this._stockFieldSettings);\n            await this.stock.refresh();\n        },\n        detailPanel() {\n            return {\n                isCloseButtonHidden: true,\n                isTitleHidden: true,\n                isHidden: true,\n                isTransient: true,\n                header: this.detailPanelSection,\n                sections: [],\n                footerActions: [this.helperCancelButton, this.helperSelectButton],\n            };\n        },\n    })\n], MobileSubcontractTransferDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-subcontract-transfer-details.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts":
/*!**********************************************************************************!*\
  !*** ../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getCountSerialNumber = void 0;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\n/**\n * async getCountSerialNumber for count number of serial numbers in range\n * @param _pageInstance this page\n * @param _productCode product code\n * @param _stockSiteCode  stock site code\n * @param _stockId optional stock id\n * @param _startingSerialNumberCode starting serial number\n * @param _endingSerialNumberCode  ending serial number\n * @param value to control\n * @returns counted serial number in range or throw exception\n */\nasync function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {\n    // Create a readable payload, but removing CR/LF before to send request.\n    const _payload = `{\n        product: { code: '${_productCode}' },\n        stockSite: { code: '${_stockSiteCode}' },\n        ${_stockId ? `stockId: '${_stockId}',` : ''}\n        _and: [\n            {\n                code: { _gte: '${_startingSerialNumberCode}' },\n            },\n            {\n                code: { _lte: '${_endingSerialNumberCode}' },\n            },\n        ],\n    }`.replace(/[\\r\\n]/g, '');\n    try {\n        const response = await _pageInstance.$.graph.raw(`query {\n                        x3StockData{\n                            serialNumber {\n                                query(filter: \"${_payload}\") {\n                                    totalCount\n                                }\n                            }\n                        }\n                    }`);\n        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);\n    }\n}\nexports.getCountSerialNumber = getCountSerialNumber;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-subcontract-transfer-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;