/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-label-printing.ts":
/*!**************************************************!*\
  !*** ./lib/pages/mobile-stock-label-printing.ts ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockLabelPrinting = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst other_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/other */ \"../../shared/x3-stock-data/build/lib/menu-items/other.js\");\nconst generic_print_report_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/generic-print-report */ \"../../shared/x3-system/lib/client-functions/generic-print-report.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nlet MobileStockLabelPrinting = class MobileStockLabelPrinting extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this.stockLabel = '';\n    }\n    async _init() {\n        await this._initSite();\n        if (this.site.value) {\n            this.numberOfLabel.value = 1;\n            this.expirationDate.value = await this._getDate();\n            this.receiptDate.value = await this._getDate();\n            if (await this._getLabel()) {\n                this._setPrintButtonEnabled();\n                await this._getListStockUnit();\n                await this._getListStockStatus();\n                return true;\n            }\n        }\n        return false;\n    }\n    _disablePage() {\n        this.product.isDisabled = true;\n        this.entryNumber.isDisabled = true;\n        this.stockUnit.isDisabled = true;\n        this.location.isDisabled = true;\n        this.lot.isDisabled = true;\n        this.subLot.isDisabled = true;\n        this.stockStatus.isDisabled = true;\n        this.receiptQuantity.isDisabled = true;\n        this.receiptDate.isDisabled = true;\n        this.expirationDate.isDisabled = true;\n        this.numberOfLabel.isDisabled = true;\n        this.destination.isDisabled = true;\n    }\n    async _initSite() {\n        this.site.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    _setPrintButtonEnabled() {\n        this.printButton.isDisabled =\n            typesLib.strictEq(this.product.value, null) || typesLib.strictEq(this.destination.value, null) || typesLib.strictEq(this.stockUnit.value, '') || typesLib.strictEq(this.numberOfLabel.value, 0);\n    }\n    async _getDate() {\n        return xtrem_date_time_1.DateValue.today().toString();\n    }\n    async _getLabel() {\n        const options = {\n            acceptButton: {\n                text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n            },\n        };\n        const _response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/MobileAutomationSetup')\n            .query(ui.queryUtils.edgesSelector({\n            stockLabel: { reportName: true },\n            isAlwaysLabelDestination: true,\n        }, {\n            filter: {\n                _and: [\n                    { site: { code: this.site.value ?? '' } },\n                    { stockLabel: { reportName: { _ne: null } } },\n                ],\n            },\n            orderBy: { site: { code: -1 } },\n        }))\n            .execute());\n        if (!this._assignLabelWhenExisting(_response)) {\n            const _response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-master-data/MobileAutomationSetup')\n                .query(ui.queryUtils.edgesSelector({\n                stockLabel: { reportName: true },\n                isAlwaysLabelDestination: true,\n            }, {\n                filter: {\n                    _and: [{ site: '' }, { stockLabel: { reportName: { _ne: null } } }],\n                },\n            }))\n                .execute());\n            if (!this.site.value || !this._assignLabelWhenExisting(_response)) {\n                this.stockLabel = '';\n                this.isAlwaysLabelDestination = false;\n            }\n        }\n        if (typesLib.strictEq(this.stockLabel, '')) {\n            // CAUTION: Do not use await here\n            (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-no-stock-label-setup', 'No stock label setup'), options);\n            return false;\n        }\n        const mobileLabelDestination = this.$.storage.get('mobile-label-destination');\n        if (this.isAlwaysLabelDestination) {\n            if (!mobileLabelDestination) {\n                // CAUTION: Do not use await here\n                (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-no-label-destination-defined', 'No label destination defined'), options);\n                return false;\n            }\n            else {\n                this.destination.isDisabled = true;\n                this.destination.value = { code: mobileLabelDestination };\n            }\n        }\n        else {\n            if (typesLib.strictNe(this.stockLabel, '')) {\n                this.destination.isDisabled = false;\n            }\n            if (mobileLabelDestination) {\n                this.destination.value = { code: mobileLabelDestination };\n            }\n        }\n        return true;\n    }\n    /**\n     * assign label when existing.\n     * @param _response\n     * @returns true when label assigned\n     */\n    _assignLabelWhenExisting(_response) {\n        return (!!_response?.length &&\n            _response.some(edge => {\n                const _label = edge.stockLabel?.reportName;\n                if (_label) {\n                    this.stockLabel = _label ?? '';\n                    this.isAlwaysLabelDestination = edge.isAlwaysLabelDestination;\n                }\n                return !!_label;\n            }));\n    }\n    async _getListStockUnit() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n        }, {\n            first: 500,\n        }))\n            .execute());\n        if (response.length) {\n            const stockUnits = [];\n            response.some(edge => {\n                stockUnits.push(edge.code);\n            });\n            this.stockUnit.options = stockUnits;\n        }\n    }\n    async _getListStockStatus() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n        }, {\n            first: 500,\n        }))\n            .execute());\n        if (response.length) {\n            const stockStatus = [];\n            response.some(edge => {\n                stockStatus.push(edge.code);\n            });\n            this.stockStatus.options = stockStatus;\n        }\n    }\n    async _callPrintAPI() {\n        let result;\n        const customParameters = {\n            site: this.site.value,\n            product: this.product?.value?.code,\n            entry: this.entryNumber.value,\n            stockunit: this.stockUnit.value,\n            location: this.location?.value?.code,\n            lot: this.lot.value,\n            sublot: this.subLot.value,\n            status: this.stockStatus.value,\n            receiptdate: this.receiptDate.value,\n            receiptquantity: this.receiptQuantity.value,\n            expirationdate: this.expirationDate.value,\n            numberoflabels: this.numberOfLabel.value,\n        };\n        try {\n            result = await (0, generic_print_report_1.genericPrintReport)(this, this.stockLabel, '', this.destination.value?.code ?? '', customParameters);\n        }\n        catch (error) {\n            return error;\n        }\n        return result;\n    }\n};\nexports.MobileStockLabelPrinting = MobileStockLabelPrinting;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobileStockLabelPrinting.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__printButton____title\", \"Print\"),\n        buttonType: 'primary',\n        shortcut: ['f2'],\n        isDisabled: true,\n        async onClick() {\n            if (!(await (0, control_1.validateWithDetails)(this)))\n                return;\n            this.printButton.isDisabled = true;\n            this.$.loader.isHidden = false;\n            const result = await this._callPrintAPI();\n            this.$.loader.isHidden = true;\n            if ((!result && typesLib.strictNe(result, 0)) || result instanceof Error) {\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                };\n                let message = '';\n                if (!result?.message) {\n                    message = `${ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                }\n                else {\n                    const _messages = [];\n                    const _results = result;\n                    let _diagnoses = _results?.diagnoses;\n                    if (typesLib.gt(_diagnoses?.length, 1)) {\n                        _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                    }\n                    // This is used to retrieve messages from the Client() class otherwise BusinessRuleError\n                    ((_results?.errors\n                        ? _results.errors[0]?.extensions?.diagnoses\n                        : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                            _results.extensions?.diagnoses ??\n                            _diagnoses)) ?? [])\n                        .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                        .forEach((d) => {\n                        const _message = d.message.split(`\\n`);\n                        _messages.push(..._message);\n                    });\n                    const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                    options.mdContent = true;\n                    message = `**${ui.localize('@sage/x3-stock/dialog-print-an-error-occurred', 'An error occurred.')}**\\n\\n`;\n                    if (typesLib.strictEq(_result.length, 1)) {\n                        message = typesLib.add(message, `${_result[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                    }\n                }\n                this.$.loader.isHidden = true;\n                this.printButton.isDisabled = false;\n                await this.$.sound.error();\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options))) {\n                    return;\n                }\n            }\n            else {\n                // if success, first clean up session & reload the page, then display success message\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                    },\n                };\n                await this.$.sound.success();\n                await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-stock/dialog-success-title', 'Success'), ui.localize('@sage/x3-stock/dialog-success-stock-labels-printed', 'Labels printed: {{stockLabel}}.', {\n                    stockLabel: this.stockLabel,\n                }), options);\n                this.$.setPageClean();\n                await this.$.router.refresh();\n                this.product.focus();\n            }\n            this._setPrintButtonEnabled();\n        },\n    })\n], MobileStockLabelPrinting.prototype, \"printButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockLabelPrinting.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobileStockLabelPrinting.prototype, \"productBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobileStockLabelPrinting.prototype, \"parametersBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        helperTextField: 'description1',\n        filter() {\n            return {\n                productSites: {\n                    _atLeast: 1,\n                    stockSite: this.site.value ?? undefined,\n                },\n            };\n        },\n        onChange() {\n            this._setPrintButtonEnabled();\n        },\n        onError(error, originScreenId, originElementId) {\n            ui.console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        isAutoSelectEnabled: true,\n        isTransient: true,\n        isMandatory: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____columns__title__code\", \"Product\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/ProductCategory',\n                bind: 'productCategory',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____columns__title__productCategory__code\", \"Category\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____columns__title__productStatus\", \"Status\"),\n                isReadOnly: true,\n                isTitleHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__product____columns__title__upc\", \"UPC code\"),\n                isReadOnly: true,\n                isTitleHidden: false,\n            }),\n        ],\n    })\n], MobileStockLabelPrinting.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__entryNumber____title\", \"Entry no.\"),\n        isMandatory: false,\n        maxLength: 20,\n    })\n], MobileStockLabelPrinting.prototype, \"entryNumber\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__stockUnit____title\", \"Stock unit\"),\n        isMandatory: true,\n        onChange() {\n            this.stockUnit.getNextField(true)?.focus();\n        },\n    })\n], MobileStockLabelPrinting.prototype, \"stockUnit\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__location____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__location____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        filter() {\n            return {\n                stockSite: { code: this.site.value ?? undefined },\n            };\n        },\n        onChange() {\n            if (this.location.value)\n                this.location.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n        ],\n        minLookupCharacters: 1,\n        isMandatory: false,\n        canFilter: false,\n    })\n], MobileStockLabelPrinting.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__lot____title\", \"Lot\"),\n        maxLength: 15,\n        isMandatory: false,\n    })\n], MobileStockLabelPrinting.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__subLot____title\", \"Sub-lot\"),\n        maxLength: 5,\n        isMandatory: false,\n    })\n], MobileStockLabelPrinting.prototype, \"subLot\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__stockStatus____title\", \"Stock status\"),\n        isMandatory: false,\n        onChange() {\n            this.stockStatus.getNextField(true)?.focus();\n        },\n    })\n], MobileStockLabelPrinting.prototype, \"stockStatus\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__receiptQuantity____title\", \"Receipt quantity\"),\n        isMandatory: true,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 0,\n    })\n], MobileStockLabelPrinting.prototype, \"receiptQuantity\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__receiptDate____title\", \"Receipt date\"),\n        isTransient: true,\n        isMandatory: false,\n    })\n], MobileStockLabelPrinting.prototype, \"receiptDate\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__expirationDate____title\", \"Expiration date\"),\n        isTransient: true,\n        isMandatory: false,\n    })\n], MobileStockLabelPrinting.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.parametersBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__numberOfLabel____title\", \"Number of labels\"),\n        isMandatory: true,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 1,\n    })\n], MobileStockLabelPrinting.prototype, \"numberOfLabel\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-system/Destination',\n        filter() {\n            return {\n                isActive: true,\n                destination: { _in: ['printer', 'zplPrinter'] },\n            };\n        },\n        valueField: 'code',\n        columns: [\n            ui.nestedFields.text({ bind: 'code', title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__destination____columns__title__code\", \"Code\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'description', title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__destination____columns__title__description\", \"Description\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'destination', title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__destination____columns__title__destination\", \"Type\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'printerName', title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__destination____columns__title__printerName\", \"Name\"), canFilter: true }),\n            ui.nestedFields.checkbox({ bind: 'isActive', isHidden: true }),\n            ui.nestedFields.text({ bind: 'destination', isHidden: true }),\n        ],\n        isAutoSelectEnabled: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing__destination____title\", \"Label destination\"),\n        helperTextField: 'description',\n        canFilter: false,\n        parent() {\n            return this.parametersBlock;\n        },\n        onChange() {\n            this._setPrintButtonEnabled();\n        },\n    })\n], MobileStockLabelPrinting.prototype, \"destination\", void 0);\nexports.MobileStockLabelPrinting = MobileStockLabelPrinting = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_label_printing____title\", \"Stock label printing\"),\n        mode: 'default',\n        menuItem: other_1.other,\n        priority: 300,\n        isTransient: false,\n        isTitleHidden: true,\n        authorizationCode: 'CWSSLP',\n        access: { node: '@sage/x3-system/GenericPrintReport' },\n        async onLoad() {\n            if (!(await this._init())) {\n                this._disablePage();\n            }\n        },\n        businessActions() {\n            return [this.printButton];\n        },\n    })\n], MobileStockLabelPrinting);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-label-printing.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts":
/*!************************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.GenericPrintPayloadMapping = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\n/** @internal */\nclass GenericPrintPayloadMapping {\n    /**\n     * Parse xtrem variable such as boolean and date to X3 format\n     * @param valueFromPayload\n     * @return value or undefined when type object is not authorized.\n     */\n    static xtremToLegacyDataFormatting(value) {\n        let valueFromPayload = value;\n        /**\n         * check if the variable is an instance of date\n         */\n        if (valueFromPayload instanceof xtrem_date_time_1.DateValue) {\n            valueFromPayload = valueFromPayload.value;\n        }\n        else if (typesLib.strictEq(typeof valueFromPayload, 'object') || typesLib.strictEq(typeof valueFromPayload, 'function')) {\n            /**\n             * check if the variable is an unsupported object instance or function\n             */\n            return undefined;\n        }\n        /**\n         * check if is in date format YYYY-MM-DD\n         */\n        const found = valueFromPayload?.toString().match(/([12]\\d{3}-(0[1-9]|1[0-2])-(0[1-9]|[12]\\d|3[01]))/g);\n        if (typesLib.strictNe(found, null)) {\n            return found?.toString().replace(/-/g, '');\n        }\n        /**\n         * if boolean translate\n         *  true -> 1 and false -> 0 to meet x3 variables\n         */\n        if (typesLib.strictEq(Boolean(valueFromPayload), valueFromPayload)) {\n            return valueFromPayload ? '2' : '1';\n        }\n        return String(valueFromPayload);\n    }\n    /**\n     *\n     * @param content Format content entry\n     * @returns JSON formatted objet\n     */\n    static stringifyContent(content) {\n        return JSON.stringify(content, (_key, value) => {\n            return value ?? '';\n        }, 4);\n    }\n    /**\n     * Convert a object to a string contain all properties/values\n     * @param object Object to convert.\n     * @returns String formatted.\n     */\n    static convertObjectToParameters(object) {\n        const _parameters = {\n            parametersNames: [],\n            parametersValues: [],\n        };\n        Object.entries(object).forEach(([key, value]) => {\n            const valueFormatted = GenericPrintPayloadMapping.xtremToLegacyDataFormatting(value);\n            if (typesLib.strictNe(valueFormatted, undefined)) {\n                _parameters.parametersNames.push(key);\n                _parameters.parametersValues.push(valueFormatted);\n            }\n        });\n        return _parameters;\n    }\n    /**\n     * Create a updated value of object ready to export (JSON) / specif format\n     * @param payloadContent\n     * @return updated payload\n     */\n    static updatePrintPayload(payloadContent) {\n        const _UpdatedPayloadContent = {};\n        const _payloadContent = JSON.parse(GenericPrintPayloadMapping.stringifyContent(payloadContent));\n        // prepare object to export without processing any object : boolean, date,number, string only\n        Object.entries(_payloadContent).forEach(([key, value]) => {\n            const valueComputed = GenericPrintPayloadMapping.xtremToLegacyDataFormatting(value);\n            if (typesLib.strictNe(valueComputed, undefined)) {\n                _UpdatedPayloadContent[key] = valueComputed;\n            }\n        });\n        return _UpdatedPayloadContent;\n    }\n    /**\n     * Build the page payload from the graphql one\n     * @param graphQLPayload\n     * @return parameters values\n     */\n    static buildGraphQLPayload(graphQLPayload) {\n        const _parameters = {\n            parametersNames: [],\n            parametersValues: [],\n        };\n        // Custom parameters has object\n        if (typesLib.eq(graphQLPayload, null) || typesLib.strictNe(typeof graphQLPayload, 'object') || typesLib.strictEq(Object.keys(graphQLPayload).length, 0)) {\n            throw Error('Custom parameters is mandatory');\n        }\n        const updatedGraphQLPayload = GenericPrintPayloadMapping.updatePrintPayload(graphQLPayload);\n        return GenericPrintPayloadMapping.convertObjectToParameters(updatedGraphQLPayload);\n    }\n}\nexports.GenericPrintPayloadMapping = GenericPrintPayloadMapping;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/generic-print-report.ts":
/*!***************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/generic-print-report.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.genericPrintReport = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst generic_print_payload_mapping_1 = __webpack_require__(/*! ./generic-print-payload-mapping */ \"../../shared/x3-system/lib/client-functions/generic-print-payload-mapping.ts\");\nasync function genericPrintReport(pageInstance, reportName, language, destination, graphQlPayload) {\n    let result;\n    if (typesLib.strictEq((reportName || ''), '')) {\n        throw new xtrem_shared_1.SystemError('Report name is mandatory');\n    }\n    if (typesLib.strictEq((destination || ''), '')) {\n        throw new xtrem_shared_1.SystemError('Destination is mandatory');\n    }\n    // Custom parameters has object\n    if (typesLib.eq(graphQlPayload, null) || typesLib.strictNe(typeof graphQlPayload, 'object') || typesLib.strictEq(Object.keys(graphQlPayload).length, 0)) {\n        throw new xtrem_shared_1.SystemError('Custom parameters is mandatory');\n    }\n    ui.console.debug(`Custom payload in input : ${JSON.stringify(graphQlPayload)}`);\n    const _customParameters = generic_print_payload_mapping_1.GenericPrintPayloadMapping.buildGraphQLPayload(graphQlPayload);\n    ui.console.debug(`Prepared custom payload : ${JSON.stringify(_customParameters)}`);\n    /**\n     * Explanation of errorCode cases :\n     *  n = Error code number.\n     *  0 = Done.\n     * -1 = Result of mutation not return expected errorCode message.\n     * -2 = Failure without error when calling mutation (unchanged value).\n     */\n    // Populate required arguments\n    const _mutationArgs = {\n        reportName: reportName,\n        language: language,\n        destination: destination,\n        parametersNames: _customParameters.parametersNames,\n        parametersValues: _customParameters.parametersValues,\n        errorCode: -2,\n    };\n    ui.console.debug(`Prepared mutation arguments : ${JSON.stringify(_mutationArgs)}`);\n    try {\n        result =\n            (await pageInstance.$.graph\n                .node('@sage/x3-system/GenericPrintReport')\n                .mutations.printReport({\n                reportName: false,\n                language: false,\n                destination: false,\n                parametersNames: false,\n                parametersValues: false,\n                errorCode: true,\n            }, {\n                parameters: _mutationArgs,\n            })\n                .execute())?.errorCode ?? -1;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.SystemError(error.message, error);\n    }\n    return result;\n}\nexports.genericPrintReport = genericPrintReport;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/generic-print-report.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/other.js":
/*!****************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/other.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.other = void 0;\nexports.other = {\n    id: '@sage/x3-stock-data/other-root',\n    priority: 600,\n    title: 'Other',\n    icon: 'ellipsis_horizontal',\n};\n//# sourceMappingURL=other.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvb3RoZXIuanMiLCJtYXBwaW5ncyI6IkFBQWE7QUFDYiw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsYUFBYTtBQUNiLGFBQWE7QUFDYjtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4uLy4uL3NoYXJlZC94My1zdG9jay1kYXRhL2J1aWxkL2xpYi9tZW51LWl0ZW1zL290aGVyLmpzPzk5YzMiXSwic291cmNlc0NvbnRlbnQiOlsiXCJ1c2Ugc3RyaWN0XCI7XG5PYmplY3QuZGVmaW5lUHJvcGVydHkoZXhwb3J0cywgXCJfX2VzTW9kdWxlXCIsIHsgdmFsdWU6IHRydWUgfSk7XG5leHBvcnRzLm90aGVyID0gdm9pZCAwO1xuZXhwb3J0cy5vdGhlciA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvb3RoZXItcm9vdCcsXG4gICAgcHJpb3JpdHk6IDYwMCxcbiAgICB0aXRsZTogJ090aGVyJyxcbiAgICBpY29uOiAnZWxsaXBzaXNfaG9yaXpvbnRhbCcsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9b3RoZXIuanMubWFwIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/other.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-label-printing.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;