/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-count.ts":
/*!*****************************************!*\
  !*** ./lib/pages/mobile-stock-count.ts ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockCount = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst stock_control_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/stock-control */ \"../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nlet MobileStockCount = class MobileStockCount extends ui.Page {\n    async _initializePage() {\n        await this._initializeSite();\n        //Only initialize the rest of the page if the siteField is defined\n        if (this.siteField.value) {\n            this.excludeCountedLines.value = true;\n            this.multiCountLabel.value = ui.localize('@sage/x3-stock/multiple-counts-label', 'Multiple counts');\n            this.stockCountSession.focus();\n        }\n        else {\n            this._disablePage();\n        }\n    }\n    _disablePage() {\n        this.excludeCountedLines.isDisabled = true;\n        this.stockCountSession.isDisabled = true;\n        this.stockCountSessionList.isDisabled = true;\n    }\n    async _initializeSite() {\n        await this._initSite();\n        // If coming back to this page from the detail page, renumber the stock count list\n        if (this.siteField.value &&\n            this.$.storage.get('mobile-selected-session') &&\n            this.$.storage.get('mobile-selected-list')) {\n            await (0, control_1.renumberStockCountList)(this.$.storage.get('mobile-selected-session'), this.$.storage.get('mobile-selected-list'), this);\n        }\n    }\n    async _initSite() {\n        this.siteField.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    async _searchStockCountSessionWorksheets(stockCountSession) {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock/StockCountList')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n            numberOfLines: true,\n            stockCountListStatus: true,\n            isStockCountLocked: true,\n        }, {\n            filter: {\n                stockCountSessionNumber: stockCountSession,\n                stockCountListStatus: {\n                    _in: ['toBeCounted', 'cancelled', 'counted', 'partialValidation', 'validated'],\n                },\n            },\n        }))\n            .execute());\n    }\n    async _processSelectedStockCountSession(value) {\n        let worksheets = await this._searchStockCountSessionWorksheets(value.stockCountSession);\n        if (typesLib.strictEq(worksheets.length, 1)) {\n            this.stockCountSessionList.isDisabled = this.stockCountSessionList.isReadOnly = true;\n            this.stockCountSessionList.value = worksheets[0];\n            await this._processSelectedStockCountList(worksheets[0]);\n        }\n        else {\n            this.stockCountSessionList.isDisabled = this.stockCountSessionList.isReadOnly = false;\n            this.stockCountSessionList.focus();\n            this.stockCountSessionList.value = null;\n        }\n    }\n    async _processSelectedStockCountList(value) {\n        await (0, control_1.renumberStockCountList)(value.stockCountSessionNumber, value.stockCountListNumber, this);\n        this.$.storage.set('mobile-selected-session', value.stockCountSessionNumber);\n        this.$.storage.set('mobile-selected-list', value.stockCountListNumber);\n        const firstAvailableCountRecord = (await this._getFirstAvailableCountRecord(this, value.stockCountSessionNumber, value.stockCountListNumber, this.excludeCountedLines.value ?? true));\n        if (!firstAvailableCountRecord) {\n            this.$.showToast(ui.localize('@sage/x3-stock/notification-selected-stock-session-already-fully-counted', 'The selected Stock count session list is already fully counted'), {\n                type: 'warning',\n            });\n            return false;\n        }\n        this.$.setPageClean();\n        this.$.router.goTo('@sage/x3-stock/MobileStockCountDetail', {\n            _id: firstAvailableCountRecord._id,\n            stockCountListDetail: JSON.stringify(firstAvailableCountRecord),\n            excludeCountedLines: (this.excludeCountedLines.value ?? true).toString(),\n        });\n        return true;\n    }\n    /** @internal */\n    async _getFirstAvailableCountRecord(pageInstance, stockCountSessionNumber, stockCountListNumber, excludeCountedLines = true) {\n        const stockCountListDetailFilter = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountList: { stockCountListNumber: stockCountListNumber },\n            stockCountListStatus: {\n                _in: ['toBeCounted', 'counted'],\n            },\n        };\n        let result = undefined;\n        if (excludeCountedLines) {\n            stockCountListDetailFilter._and = [\n                {\n                    _or: [\n                        {\n                            countedStockInPackingUnit: '0',\n                            isZeroStock: false,\n                        },\n                        {\n                            stockCountSession: { isMultipleCount: true },\n                            countedStockInPackingUnit1: '0',\n                            isZeroStock1: false,\n                        },\n                        {\n                            stockCountSession: { isMultipleCount: true },\n                            countedStockInPackingUnit2: '0',\n                            isZeroStock2: false,\n                        },\n                    ],\n                },\n            ];\n        }\n        // retrieve all detail records given the count session list (optionally exclude fully counted records)\n        const stockCountListDetailRecords = (0, xtrem_client_1.extractEdges)((await pageInstance.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            stockCountSessionNumber: true,\n            stockCountSession: { isMultipleCount: true },\n            stockCountList: { stockCountListNumber: true },\n            countedStockInPackingUnit: true,\n            countedStockInPackingUnit1: true,\n            countedStockInPackingUnit2: true,\n            isZeroStock: true,\n            isZeroStock1: true,\n            isZeroStock2: true,\n        }, {\n            filter: stockCountListDetailFilter,\n            orderBy: {\n                // most importantly, order the detail records by productRankNumber\n                productRankNumber: +1,\n            },\n        }))\n            .execute()) ?? []);\n        // if every record has already been counted & verified(?)\n        if (typesLib.strictNe(stockCountListDetailRecords.length, 0)) {\n            if (stockCountListDetailRecords[0].stockCountSession.isMultipleCount) {\n                // NOTE: If a 'multi count' worksheet is not on the final count, any fully counted lines will be omitted despite whether excludeCountedLines is set to false or not\n                // if any record has countedStockInPackingUnit1 = 0 and isZeroStock1 = false, then this stock count list worksheet is currently on count #1\n                result = stockCountListDetailRecords.find(_ => typesLib.strictEq(Number(_.countedStockInPackingUnit1), 0) && !_.isZeroStock1); // iterate for any record has not been counted for the first time\n                if (!result) {\n                    result = stockCountListDetailRecords.find(_ => typesLib.strictEq(Number(_.countedStockInPackingUnit2), 0) && !_.isZeroStock2); // iterate for any record has not been counted for the second time\n                }\n            }\n            return result ?? stockCountListDetailRecords[0];\n        }\n        return undefined;\n    }\n};\nexports.MobileStockCount = MobileStockCount;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobileStockCount.prototype, \"siteField\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockCount.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileStockCount.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.separatorField({\n        parent() {\n            return this.mainBlock;\n        },\n        isInvisible: true,\n    })\n], MobileStockCount.prototype, \"separatorField\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__excludeCountedLines____title\", \"Exclude counted lines\"),\n        isFullWidth: true,\n    })\n], MobileStockCount.prototype, \"excludeCountedLines\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSession____title\", \"Stock count session\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSession____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock/StockCountSession',\n        valueField: 'stockCountSession',\n        isMandatory: true,\n        canFilter: false,\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        filter() {\n            return {\n                stockSite: {\n                    code: this.siteField.value,\n                },\n                stockCountSessionStatus: 'toBeCounted',\n            };\n        },\n        async onChange() {\n            if (this.stockCountSession.value) {\n                this.multiCountLabel.isHidden = !this.stockCountSession.value.isMultipleCount;\n                await this._processSelectedStockCountSession(this.stockCountSession.value);\n            }\n            else {\n                this.multiCountLabel.isHidden = true;\n                this.stockCountSessionList.isDisabled = this.stockCountSessionList.isReadOnly = true;\n                this.stockCountSessionList.value = null;\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'stockCountSession',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSession____columns__title__stockCountSession\", \"Stock Count Session Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCountSessionStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSession____columns__title__stockCountSessionStatus\", \"Stock Count Session Status\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCountSessionDescription',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSession____columns__title__stockCountSessionDescription\", \"Stock Count Session Description\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isMultipleCount',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCount.prototype, \"stockCountSession\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____title\", \"Stock count session list\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock/StockCountList',\n        valueField: 'stockCountListNumber',\n        isMandatory: true,\n        canFilter: false,\n        isReadOnly: true,\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        filter() {\n            return {\n                stockCountSessionNumber: this.stockCountSession.value?.stockCountSession,\n                stockCountListStatus: {\n                    _in: ['toBeCounted', 'cancelled', 'counted', 'partialValidation', 'validated'],\n                },\n            };\n        },\n        async onChange() {\n            if (this.stockCountSessionList.value) {\n                await this._processSelectedStockCountList(this.stockCountSessionList.value);\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'stockCountListNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____columns__title__stockCountListNumber\", \"Stock Count List Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCountListStatus',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____columns__title__stockCountListStatus\", \"Stock Count List Status\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'stockCountListDescription',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____columns__title__stockCountListDescription\", \"Stock Count Session Worksheet Description\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'numberOfLines',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count__stockCountSessionList____columns__title__numberOfLines\", \"Number of Lines to be Counted\"),\n                isReadOnly: true,\n            }),\n        ],\n    })\n], MobileStockCount.prototype, \"stockCountSessionList\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.mainBlock;\n        },\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCount.prototype, \"multiCountLabel\", void 0);\nexports.MobileStockCount = MobileStockCount = __decorate([\n    ui.decorators.page({\n        isTitleHidden: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count____title\", \"Stock count\"),\n        menuItem: stock_control_1.stockControl,\n        priority: 700,\n        isTransient: true,\n        authorizationCode: 'CWSACC',\n        access: { node: '@sage/x3-stock/StockCountList' },\n        skipDirtyCheck: true,\n        async onLoad() {\n            await this._initializePage();\n        },\n    })\n], MobileStockCount);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-count.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/stock-control.js":
/*!************************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/stock-control.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.stockControl = void 0;\nexports.stockControl = {\n    id: '@sage/x3-stock-data/stock-control-root',\n    priority: 200,\n    title: 'Stock control',\n    icon: 'squares_nine',\n};\n//# sourceMappingURL=stock-control.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcz9kNTQ5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5zdG9ja0NvbnRyb2wgPSB2b2lkIDA7XG5leHBvcnRzLnN0b2NrQ29udHJvbCA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvc3RvY2stY29udHJvbC1yb290JyxcbiAgICBwcmlvcml0eTogMjAwLFxuICAgIHRpdGxlOiAnU3RvY2sgY29udHJvbCcsXG4gICAgaWNvbjogJ3NxdWFyZXNfbmluZScsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c3RvY2stY29udHJvbC5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-count.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;