/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-count-serial-panel.ts":
/*!******************************************************!*\
  !*** ./lib/pages/mobile-stock-count-serial-panel.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockCountSerialPanel = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst get_count_serial_number_1 = __webpack_require__(/*! @sage/x3-stock-data/lib/client-functions/get-count-serial-number */ \"../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nlet MobileStockCountSerialPanel = class MobileStockCountSerialPanel extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._serialNumberRegExp1 = /^$|^[^|]+$/;\n        this._serialNumberRegExp2 = /\\d$/; // want to distinguish the error of serial number not ending with a number\n    }\n    /*\n     *\n     *  Helper Functions\n     *\n     */\n    async _onChangeBody() {\n        if (!this.quantity.value ||\n            !this.startingSerialNumber.value ||\n            (await this.quantity.validate()) ||\n            (await this.startingSerialNumber.validate())) {\n            this.endingSerialNumber.value = null;\n            return;\n        }\n        this.startingSerialNumber.value = this.startingSerialNumber.value.toUpperCase();\n        if (typesLib.gt(this.quantity.value, 1)) {\n            this.endingSerialNumber.value = this._calculateEndingSerialNumber(this.startingSerialNumber.value, this.quantity.value);\n        }\n        else {\n            this.endingSerialNumber.value = this.startingSerialNumber.value;\n        }\n        // validate range does not contain existing or non-existent serial numbers\n        await this.$.commitValueAndPropertyChanges();\n        let validationResult;\n        if ((validationResult = await this.endingSerialNumber.validate())) {\n            this.$.showToast(validationResult, { type: 'warning' });\n        }\n    }\n    _calculateEndingSerialNumber(startingSerialNumber, quantity) {\n        return startingSerialNumber.replace(/\\d+$/, match => {\n            const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();\n            const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);\n            return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');\n        });\n    }\n};\nexports.MobileStockCountSerialPanel = MobileStockCountSerialPanel;\n__decorate([\n    ui.decorators.referenceField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n        node: '@sage/x3-stock/StockCountSession',\n        valueField: 'stockCountSession',\n        canFilter: false,\n    })\n], MobileStockCountSerialPanel.prototype, \"stockCountSession\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n        node: '@sage/x3-stock/StockCountList',\n        valueField: 'stockCountListNumber',\n        canFilter: false,\n    })\n], MobileStockCountSerialPanel.prototype, \"stockCountList\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        // parent() {\n        //     return this.bodyBlock;\n        // },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__product____title\", \"Product\"),\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isReadOnly: true,\n        //isFullWidth: true,\n        isTransient: true,\n        canFilter: false,\n    })\n], MobileStockCountSerialPanel.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"headerStockCountSessionNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"headerStockCountListNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"headerProduct\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isHidden: true,\n        isDisabled: true,\n        isTransient: true,\n        node: '@sage/x3-stock-data/Stock',\n        valueField: 'stockId',\n        canFilter: false,\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountSerialPanel.prototype, \"stockId\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.section;\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"bodyBlock\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__status____title\", \"Status\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isReadOnly: true,\n        isFullWidth: false,\n        isTransient: true,\n        canFilter: false,\n    })\n], MobileStockCountSerialPanel.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__packingUnit____title\", \"Unit\"),\n        node: '@sage/x3-master-data/UnitOfMeasure',\n        valueField: 'code',\n        isReadOnly: true,\n        isFullWidth: false,\n        isTransient: true,\n        canFilter: false,\n    })\n], MobileStockCountSerialPanel.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__quantityInPackingUnit____title\", \"Stock\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"quantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__countedStockInPackingUnit____title\", \"Counted quantity\"),\n        isReadOnly: true,\n        isFullWidth: true,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"countedStockInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__projectedBalance____title\", \"Projected balance\"),\n        isReadOnly: true,\n        isFullWidth: true,\n        isTransient: true,\n    })\n], MobileStockCountSerialPanel.prototype, \"projectedBalance\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__quantity____title\", \"Quantity\"),\n        isFullWidth: true,\n        isMandatory: true,\n        isTransient: true,\n        min: 1,\n        isDisabled() {\n            return typesLib.strictEq(this.projectedBalance.value, 0);\n        },\n        async onChange() {\n            await this._onChangeBody();\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"quantity\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__startingSerialNumber____title\", \"Starting serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__startingSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/SerialNumber',\n        valueField: 'code',\n        isMandatory: true,\n        isTransient: true,\n        isFullWidth: true,\n        canFilter: false,\n        async validation(value) {\n            if (!this._serialNumberRegExp1.test(value)) {\n                return ui.localize('@sage/x3-stock/serial-number-range-regular-expression-validation-1', 'Invalid value');\n            }\n            if (!this._serialNumberRegExp2.test(value)) {\n                return ui.localize('@sage/x3-stock/serial-number-range-regular-expression-validation-2', 'Error in incrementing the serial numbers');\n            }\n        },\n        filter() {\n            if (this.product.value && this.stockId.value)\n                return {\n                    product: { code: this.product.value.code },\n                    stockSite: { code: this._stockSite.code || '' },\n                    ...(!this.startingSerialNumber.isNewEnabled && {\n                        issueDate: null,\n                        issueDocumentId: { _in: [null, ''] },\n                        stockId: this.stockId.value.stockId,\n                    }),\n                };\n        },\n        isDisabled() {\n            return typesLib.strictEq(this.projectedBalance.value, 0);\n        },\n        async onChange() {\n            await this._onChangeBody();\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"startingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.bodyBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__endingSerialNumber____title\", \"Ending serial number\"),\n        isMandatory: true,\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: true,\n        async validation(value) {\n            const _countedSerialNumber = await (0, get_count_serial_number_1.getCountSerialNumber)(this, this.product.value?.code ?? '', this._stockSite.code ?? '', undefined, this.startingSerialNumber.value ?? '', this.endingSerialNumber.value ?? '', value);\n            if (this.startingSerialNumber.isNewEnabled && _countedSerialNumber) {\n                return ui.localize('@sage/x3-stock/serial-number-range-contains-existing', 'Range contains existing serial number(s)');\n            }\n            else if (!this.startingSerialNumber.isNewEnabled && typesLib.strictNe(_countedSerialNumber, this.quantity.value)) {\n                return ui.localize('@sage/x3-stock/serial-number-range-contains-non-existent', 'Range contains non-existent serial number(s)');\n            }\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"endingSerialNumber\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.bodyBlock;\n        },\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canResizeColumns: false,\n        canUserHideColumns: false,\n        isTitleHidden: false,\n        //isTransient: false,\n        isTransient: true, // (X3-257606) TODO Issue: Deleting table row(s) that are loaded in a non-transient causes errors. After this is fixed, change this table back to isTransient: false\n        isFullWidth: true,\n        isDisabled: false,\n        node: '@sage/x3-stock/StockCountSerialNumber',\n        mobileCard: undefined,\n        columns: [\n            ui.nestedFields.reference({\n                bind: 'stockCountListNumber',\n                valueField: 'stockCountListNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__serialNumberLines____columns__title__stockCountListNumber__stockCountListNumber\", \"Stock Count List Number\"),\n                node: '@sage/x3-stock/StockCountList',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantity',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__serialNumberLines____columns__title__quantity\", \"Quantity\"),\n                isReadOnly: true,\n                postfix() {\n                    return this.packingUnit.value?.code || '';\n                },\n                scale() {\n                    return this.packingUnit.value?.numberOfDecimals ?? 0;\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__serialNumberLines____columns__title__startingSerialNumber\", \"Starting serial Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'endingSerialNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__serialNumberLines____columns__title__endingSerialNumber\", \"Ending Serial Number\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'bin',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__serialNumberLines____dropdownActions__title\", \"Delete\"),\n                onClick(recordId, rowItem) {\n                    if (this.projectedBalance.value)\n                        this.projectedBalance.value = typesLib.add(this.projectedBalance.value, typesLib.mul((rowItem.quantity ? rowItem.quantity : 0), (this.startingSerialNumber.isNewEnabled ? 1 : -1)));\n                    this.quantity.max = this.quantity.value = typesLib.abs(this.projectedBalance.value ? this.projectedBalance.value : 0);\n                    this.serialNumberLines.removeRecord(recordId);\n                    this.startingSerialNumber.isDisabled = false;\n                },\n            },\n        ],\n        fieldActions() {\n            return [this.addSerialRange];\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"serialNumberLines\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__cancel____title\", \"Cancel\"),\n        shortcut: ['f4'],\n        buttonType: 'secondary',\n        isTransient: true,\n        onClick() {\n            this.$.finish();\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"cancel\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__save____title\", \"Save\"),\n        buttonType: 'primary',\n        isTransient: true,\n        shortcut: ['f2'],\n        isDisabled() {\n            return typesLib.strictNe(this.projectedBalance.value, 0);\n        },\n        async onClick() {\n            let indexNumber = 0;\n            this.$.finish(this.serialNumberLines.value.map(serialNumberLine => {\n                return {\n                    //E = Quantity is over\n                    // S = Quantity is short\n                    stockCountVariance: this.startingSerialNumber.isNewEnabled ? 'E' : 'S',\n                    serialNumberIndexNumber: (indexNumber = typesLib.add(indexNumber, 1)),\n                    quantity: serialNumberLine.quantity,\n                    startingSerialNumber: serialNumberLine.startingSerialNumber,\n                    endingSerialNumber: serialNumberLine.endingSerialNumber,\n                    stockSite: serialNumberLine.stockSite?.code,\n                };\n            }));\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"save\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        icon: 'add',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel__addSerialRange____title\", \"Add\"),\n        isTransient: true,\n        isDisabled() {\n            return typesLib.strictEq(this.projectedBalance.value, 0);\n        },\n        async onClick() {\n            if (!(await (0, control_1.validateWithDetails)(this)))\n                return;\n            // check that this will add any duplicates\n            const startNumberToAdd = this.startingSerialNumber.value?.match(/\\d+$/);\n            const endNumberToAdd = Number(this.endingSerialNumber.value?.match(/\\d+$/));\n            if (this.serialNumberLines.value.some(row => {\n                const rowStartMatch = row.startingSerialNumber?.match(/\\d+$/);\n                const rowEndMatch = Number(row.endingSerialNumber?.match(/\\d+$/));\n                // check if the 'beginning part' of the serial matches\n                if (startNumberToAdd &&\n                    rowStartMatch &&\n                    this.startingSerialNumber.value && typesLib.strictNe(row.startingSerialNumber?.substring(0, typesLib.sub(row.startingSerialNumber.length, rowStartMatch.toString().length)), this.startingSerialNumber.value.substring(0, typesLib.sub(this.startingSerialNumber.value.length, startNumberToAdd.toString().length))))\n                    return false;\n                //https://stackoverflow.com/questions/36035074/how-can-i-find-an-overlap-between-two-given-ranges/36035369\n                return typesLib.lte(Number(startNumberToAdd), rowEndMatch) && typesLib.gte(endNumberToAdd, Number(rowStartMatch));\n            })) {\n                this.$.showToast(ui.localize('@sage/x3-stock/serial-number-range-overlap', 'The serial numbers are overlapping. Enter another starting or ending serial number.'), { type: 'error' });\n                return;\n            }\n            if (this.stockCountList.value &&\n                this.quantity.value &&\n                this.startingSerialNumber.value &&\n                this.endingSerialNumber.value) {\n                this.serialNumberLines.addRecord({\n                    stockCountListNumber: this.stockCountList.value,\n                    quantity: this.quantity.value,\n                    startingSerialNumber: this.startingSerialNumber.value,\n                    endingSerialNumber: this.endingSerialNumber.value,\n                    stockSite: { code: this._stockSite.code },\n                });\n            }\n            if (this.projectedBalance.value)\n                this.projectedBalance.value = typesLib.sub(this.projectedBalance.value, typesLib.mul((this.quantity.value ? this.quantity.value : 0), (this.startingSerialNumber.isNewEnabled ? 1 : -1)));\n            this.startingSerialNumber.value = this.endingSerialNumber.value = null;\n            this.quantity.max = this.quantity.value = typesLib.abs(this.projectedBalance.value ? this.projectedBalance.value : 0);\n            if (!this.quantity.value)\n                this.quantity.value = null;\n        },\n    })\n], MobileStockCountSerialPanel.prototype, \"addSerialRange\", void 0);\nexports.MobileStockCountSerialPanel = MobileStockCountSerialPanel = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel____title\", \"Stock count\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_serial_panel____subtitle\", \"Enter serial number\"),\n        isTitleHidden: true,\n        isTransient: false, // the only non-transient is serialNumberLines (the serial number range table)\n        node: '@sage/x3-stock/StockCountListDetail',\n        mode: 'default',\n        navigationPanel: undefined,\n        async onLoad() {\n            const stockCountListDetail = JSON.parse(this.$.queryParameters.stockCountListDetail);\n            // before even proceeding to the update process, check if the product is global serial tracked. If so, then user must provide additional information i.e. serial number ranges\n            this._stockSite = stockCountListDetail.stockSite;\n            this.stockCountSession.value = stockCountListDetail.stockCountSession;\n            this.headerStockCountSessionNumber.value = this.stockCountSession.value.stockCountSession || '';\n            this.stockCountList.value = stockCountListDetail.stockCountList;\n            this.headerStockCountListNumber.value = this.stockCountList.value.stockCountListNumber || '';\n            this.stockId.value = stockCountListDetail.stockLine;\n            this.product.value = stockCountListDetail.product;\n            this.headerProduct.value = this.product.value.code || '';\n            this.location.value = stockCountListDetail.location;\n            this.location.isHidden = !this.location.value;\n            this.status.value = stockCountListDetail.status;\n            this.quantityInPackingUnit.value = Number(stockCountListDetail.quantityInPackingUnit);\n            this.packingUnit.value = stockCountListDetail.packingUnit;\n            if (!this.quantityInPackingUnit.value) {\n                this.quantityInPackingUnit.isHidden = this.packingUnit.isHidden = true;\n            }\n            this.countedStockInPackingUnit.value = Number(stockCountListDetail.countedStockInPackingUnit);\n            const projectedBalance = typesLib.sub(this.countedStockInPackingUnit.value, Number(stockCountListDetail.quantityInPackingUnit));\n            this.startingSerialNumber.isNewEnabled = typesLib.gt(projectedBalance, 0); // first, determine if this is to receive (overage) or issue (under) serial numbers\n            this.projectedBalance.value = typesLib.sub(projectedBalance, typesLib.mul((this.serialNumberLines.value.reduce((a, serialRange) => typesLib.add(a, (serialRange.quantity ? serialRange.quantity : 0)), 0) ?? 0), (this.startingSerialNumber.isNewEnabled ? 1 : -1))); // then calculate actual projectedBalance by including any previously inputted serial ranges\n            this.quantity.value = this.quantity.max = typesLib.abs(this.projectedBalance.value);\n            this.serialNumberLines.title = typesLib.add('Serial number(s) to ', (this.startingSerialNumber.isNewEnabled ? 'receive' : 'issue'));\n        },\n        headerCard() {\n            return {\n                title: this.headerStockCountSessionNumber,\n                titleRight: this.headerStockCountListNumber,\n                line2: this.headerProduct,\n            };\n        },\n        businessActions() {\n            return [this.cancel, this.save];\n        },\n    })\n], MobileStockCountSerialPanel);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-count-serial-panel.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts":
/*!**********************************************************************************!*\
  !*** ../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getCountSerialNumber = void 0;\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\n/**\n * async getCountSerialNumber for count number of serial numbers in range\n * @param _pageInstance this page\n * @param _productCode product code\n * @param _stockSiteCode  stock site code\n * @param _stockId optional stock id\n * @param _startingSerialNumberCode starting serial number\n * @param _endingSerialNumberCode  ending serial number\n * @param value to control\n * @returns counted serial number in range or throw exception\n */\nasync function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {\n    // Create a readable payload, but removing CR/LF before to send request.\n    const _payload = `{\n        product: { code: '${_productCode}' },\n        stockSite: { code: '${_stockSiteCode}' },\n        ${_stockId ? `stockId: '${_stockId}',` : ''}\n        _and: [\n            {\n                code: { _gte: '${_startingSerialNumberCode}' },\n            },\n            {\n                code: { _lte: '${_endingSerialNumberCode}' },\n            },\n        ],\n    }`.replace(/[\\r\\n]/g, '');\n    try {\n        const response = await _pageInstance.$.graph.raw(`query {\n                        x3StockData{\n                            serialNumber {\n                                query(filter: \"${_payload}\") {\n                                    totalCount\n                                }\n                            }\n                        }\n                    }`);\n        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;\n    }\n    catch (error) {\n        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);\n    }\n}\nexports.getCountSerialNumber = getCountSerialNumber;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/lib/client-functions/get-count-serial-number.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-count-serial-panel.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;