/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-count-detail.ts":
/*!************************************************!*\
  !*** ./lib/pages/mobile-stock-count-detail.ts ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockCountDetail = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nvar MobileStockCountDetailPageMode;\n(function (MobileStockCountDetailPageMode) {\n    MobileStockCountDetailPageMode[MobileStockCountDetailPageMode[\"update\"] = 0] = \"update\";\n    MobileStockCountDetailPageMode[MobileStockCountDetailPageMode[\"create\"] = 1] = \"create\";\n})(MobileStockCountDetailPageMode || (MobileStockCountDetailPageMode = {}));\n/** @internal */\nfunction generateDetailFilter(selectedStockCountListDetail, excludeCountedLines) {\n    let stockCountListDetailFilter = {\n        stockCountSessionNumber: selectedStockCountListDetail.stockCountSessionNumber,\n        stockCountList: {\n            stockCountListNumber: selectedStockCountListDetail.stockCountList?.stockCountListNumber,\n        },\n        stockCountListStatus: {\n            _in: ['toBeCounted', 'counted'],\n        },\n        countedStockInPackingUnit: '0',\n        isZeroStock: false,\n    };\n    if (!excludeCountedLines) {\n        delete stockCountListDetailFilter.countedStockInPackingUnit;\n        delete stockCountListDetailFilter.isZeroStock;\n    }\n    if (selectedStockCountListDetail.stockCountSession?.isMultipleCount) {\n        if (typesLib.strictEq(Number(selectedStockCountListDetail.countedStockInPackingUnit1), 0) &&\n            !selectedStockCountListDetail.isZeroStock1) {\n            stockCountListDetailFilter.countedStockInPackingUnit1 = '0';\n            stockCountListDetailFilter.isZeroStock1 = false;\n        }\n        else if (typesLib.strictEq(Number(selectedStockCountListDetail.countedStockInPackingUnit2), 0) &&\n            !selectedStockCountListDetail.isZeroStock2) {\n            stockCountListDetailFilter.countedStockInPackingUnit2 = '0';\n            stockCountListDetailFilter.isZeroStock2 = false;\n        }\n    }\n    return stockCountListDetailFilter;\n}\nlet MobileStockCountDetail = class MobileStockCountDetail extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._unitMap = new Map();\n    }\n    /*\n     *\n     *  Helper Functions\n     *\n     */\n    async _preloadVersion(productCode, lot, sublot, majorVersion, minorVersion) {\n        let record; // TODO: Issue: Cannot read a record that contains 'empty' for a key index (ex. a lot record without a sublot)\n        // if this is lot & sublot tracked product + user input is a lot record that exists\n        if (lot.value &&\n            sublot.value &&\n            (record = await this.$.graph\n                .node('@sage/x3-stock-data/Lot')\n                .read({ _id: true, majorVersion: { code: true }, minorVersion: true }, `${productCode}|${lot.value}|${sublot.value}`)\n                .execute())) {\n            // if lot record exists, preload verions based from the lot record\n            majorVersion.value = record.majorVersion;\n            minorVersion.value = record.minorVersion ?? '';\n            sublot.getNextField(true)?.focus();\n        }\n        else if (lot.value &&\n            !sublot.value &&\n            (record = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Lot')\n                .query(ui.queryUtils.edgesSelector({\n                majorVersion: { code: true },\n                minorVersion: true,\n            }, {\n                filter: {\n                    product: { code: productCode },\n                    code: lot.value,\n                    sublot: '', // TODO: Verify: to filter on 'empty', use empty string or null?\n                },\n            }))\n                .execute())[0])) {\n            majorVersion.value = record.majorVersion;\n            minorVersion.value = record.minorVersion ?? '';\n            lot.getNextField(true)?.focus();\n        }\n        else {\n            if (await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/dialog-message-warning-inquiry-item-does-not-exist', '{{item}} does not exist.  Do you want to continue?', {\n                item: `${sublot.value ? `${lot.value} : ${sublot.value}` : lot.value}`,\n            }), {\n                acceptButton: { text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes') },\n                cancelButton: { text: ui.localize('@sage/x3-stock/button-cancel-no', 'No') },\n            })) {\n                // preload version from version-related nodes based on selected product\n                const versionRecord = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                    .node('@sage/x3-stock-data/MajorVersionStatus')\n                    .query(ui.queryUtils.edgesSelector({\n                    code: true,\n                    minorVersions: {\n                        query: {\n                            edges: {\n                                node: {\n                                    minorVersion: true,\n                                },\n                            },\n                            __args: {\n                                filter: JSON.stringify({ type: 'stock' }),\n                                orderBy: JSON.stringify({ minorVersion: -1 }),\n                            },\n                        },\n                    },\n                }, {\n                    filter: {\n                        product: { code: productCode },\n                        status: { _in: ['Active', 'Stopped'] },\n                    },\n                    orderBy: { status: +1 },\n                }))\n                    .execute())[0];\n                majorVersion.value = versionRecord;\n                minorVersion.value = versionRecord?.minorVersions[0]?.minorVersion ?? '';\n                sublot.value ? sublot.getNextField(true)?.focus() : lot.getNextField(true)?.focus();\n            }\n            else {\n                // clear out values\n                lot.value = '';\n                sublot.value = '';\n                majorVersion.value = null;\n                minorVersion.value = '';\n                lot.focus();\n                return;\n            }\n        }\n    }\n    /**\n     * Initialize the states of fields on the ADC Count Detail page\n     * @param mode - specify whether to be in update or new (aka. create) mode\n     * @param productCode - (optional) specify a productCode to refresh and set the state of the specified mode (update or new) based on the productCode's product settings.\n     * If you merely switching back to the previous mode, don't specify this parameter to avoid a server-side call\n     */\n    async _initializePage(mode, productCode) {\n        const updateMode = typesLib.strictEq(mode, MobileStockCountDetailPageMode.update);\n        // Initialize line number field\n        this.stockCountListDetailLineNumbers.isHidden = this.stockCountListDetailLineNumbers.isDisabled = !updateMode;\n        this.stockCountListDetailLineNumbers.value = updateMode\n            ? {\n                productRankNumber: this.productRankNumber.value,\n                _id: this._id.value,\n            }\n            : null;\n        //header fields\n        this.headerStockCountListNumber.value = this.stockCountList.value.stockCountListNumber;\n        this.headerStockCountSessionNumber.value = this.stockCountSession.value.stockCountSession;\n        this.headerProductCode.value = this.product.value.code;\n        this.headerProductDescription.value = this.productLocalizedDescription1.value.localizedDescription1;\n        this.headerProductCode.isHidden = !updateMode;\n        this.headerProductDescription.isHidden = !updateMode;\n        // Hide/unhide blocks & initialize the block being displayed\n        this.updateBlock.isHidden = !updateMode;\n        this.newBlock.isHidden = updateMode;\n        await this._getIsTheoreticalQuantityDisplayed();\n        if (!this.newBlock.isHidden) {\n            await this._initializeNewBlock(productCode);\n        }\n        else {\n            // skip initializing update block when simply transitioning from new to update mode\n            await this._initializeUpdateBlock(productCode);\n        }\n        // Initialize Business Action buttons\n        this.nextButton.isHidden = this.nextButton.isDisabled = !updateMode;\n        this.updateButton.isHidden = this.updateButton.isDisabled = !updateMode;\n        this.newButton.isHidden = this.newButton.isDisabled = !updateMode;\n        this.viewCountsButton.isHidden = this.viewCountsButton.isDisabled = !updateMode;\n        this.cancelButton.isHidden = this.cancelButton.isDisabled = updateMode;\n        this.createButton.isHidden = this.createButton.isDisabled = updateMode;\n        this.$.removeToasts(); // to remove any lingering notifications due to page validations\n    }\n    async _initializeNewBlock(productCode) {\n        // TODO: Verify: Is there a way and is it more efficiency to be able to retrieve isLicensePlateNumberManaged & isLocationManaged from the product reference field\n        let productSiteSettings = productCode && this.stockSite.value?.code ? await this._fetchProductSettings(productCode) : null;\n        // Enable/disable fields based on selected product's settings (or if not provided, disable everything)\n        this.newLocation.isHidden = this.newLocation.isDisabled = !productSiteSettings?.isLocationManaged;\n        this.newLicensePlateNumber.isHidden = this.newLicensePlateNumber.isDisabled =\n            !productSiteSettings?.isLicensePlateNumberManaged;\n        this.newLot.isHidden = this.newLot.isDisabled =\n            !productSiteSettings?.product.lotManagementMode || typesLib.strictEq(productSiteSettings.product.lotManagementMode, 'notManaged');\n        this.newSublot.isHidden = this.newSublot.isDisabled =\n            !productSiteSettings?.product.lotManagementMode || typesLib.strictNe(productSiteSettings.product.lotManagementMode, 'lotAndSublot');\n        this.newSerialNumber.isHidden = this.newSerialNumber.isDisabled =\n            !productSiteSettings?.product.serialNumberManagementMode || typesLib.strictNe(productSiteSettings.product.serialNumberManagementMode, 'receivedIssued');\n        // Version is never editable. It is preloaded based on selected product.\n        // However version fields should be only hidden based on product's settings\n        this.newMajorVersion.isHidden =\n            !productSiteSettings?.product.stockVersionMode || typesLib.strictEq(productSiteSettings.product.stockVersionMode, 'no');\n        this.newMinorVersion.isHidden =\n            !productSiteSettings?.product.stockVersionMode || typesLib.strictNe(productSiteSettings.product.stockVersionMode, 'majorAndMinor');\n        this.newPackingUnit.isHidden = this.newPackingUnit.isDisabled = !productSiteSettings;\n        //packingUnit is disable if product managed by serial number\n        this.newPackingUnit.isReadOnly =\n            !productSiteSettings?.product.serialNumberManagementMode ||\n                !['notManaged', 'receivedIssued'].includes(productSiteSettings.product.serialNumberManagementMode);\n        this.newStatus.isHidden = this.newStatus.isDisabled = !productSiteSettings;\n        this.newCountedStockInPackingUnit.isHidden = this.newCountedStockInPackingUnit.isDisabled =\n            !productSiteSettings;\n        // Clear values + any value initializations\n        if (!productSiteSettings) {\n            this.newProduct.value = null;\n            this.newProduct.focus();\n        }\n        else {\n            this.newLicensePlateNumber.value = null;\n            this.newLocation.value = null;\n            this.newLot.value = '';\n            this.newSublot.value = '';\n            this.newSerialNumber.value = '';\n            this.newMajorVersion.value = null;\n            this.newMinorVersion.value = '';\n            this.newPackingUnit.options = [];\n            this.newPackingUnit.value = null;\n            this._unitMap.clear();\n            this.newStatus.value = { code: 'A' }; // (X3-240602) TODO: Issue:  Implement default values from TABSTORUL\n            this.newCountedStockInPackingUnit.value = null;\n            // Other component-level initializations\n            this.newLot.isMandatory =\n                !this.newLot.isDisabled &&\n                    ['mandatoryLot', 'lotAndSublot'].includes(productSiteSettings.product.lotManagementMode);\n            if (!this.packingUnit.isHidden)\n                if (!this.newPackingUnit.isDisabled) {\n                    this._onChangeNewPackingUnit(this.newPackingUnit, false, productCode);\n                    // let productPackingList = productSiteSettings.product.packingUnits;\n                    // let productPackingUnitSelectValues = productPackingList.map(productPacking => {\n                    //     return `${productPacking.packingUnit.code}`;\n                    // });\n                    // this.newPackingUnit.options = [\n                    //     productSiteSettings.product.stockUnit.code,\n                    //     ...productPackingUnitSelectValues,\n                    // ];\n                    // this.newPackingUnit.value = this.newPackingUnit.options[0];\n                    // if (this.newPackingUnit.value !== productSiteSettings.product.stockUnit.code) {\n                    //     let _index = productPackingList.findIndex(\n                    //         unit => (unit.unit.code = this.newPackingUnit.options[0]),\n                    //     );\n                    //     _index > -1\n                    //         ? (this.packingUnitToStockUnitConversionFactor.value = Number(\n                    //               productPackingList[_index].packingUnitToStockUnitConversionFactor,\n                    //           ))\n                    //         : (this.packingUnitToStockUnitConversionFactor.value = 1);\n                    // } else this.packingUnitToStockUnitConversionFactor.value = 1;\n                }\n            //if item is serial tracked, quantity must be 0 or 1\n            this.newCountedStockInPackingUnit.max = !this.newSerialNumber.isDisabled ? 1 : undefined;\n            // focus logic\n            await this.$.commitValueAndPropertyChanges();\n            this.newProduct.getNextField(true)?.focus(); // (X3-249511) TODO: Issue: Selecting certain products will cause unexpected UI behavior like getNextField returning null\n        }\n    }\n    async _initializeUpdateBlock(productCode) {\n        if (!productCode)\n            return;\n        let productSiteSettings = await this._fetchProductSettings(productCode);\n        const isEditable = !this.stockLine.value; // make certain fields 'editable' if record is not associated to any stock record, meaning a record that was created via 'Add line' functionality\n        // Display/Hide fields based on current count record product's settings\n        if (!productSiteSettings.isLocationManaged) {\n            this.location.isHidden = true;\n        }\n        else {\n            this.location.isHidden = false;\n            this.location.isReadOnly = !isEditable;\n        }\n        if (!productSiteSettings.isLicensePlateNumberManaged) {\n            this.editableLicensePlateNumber.isHidden = true;\n        }\n        else {\n            this.editableLicensePlateNumber.isHidden = false;\n            this.editableLicensePlateNumber.value = this.licensePlateNumber.value?.code\n                ? { code: this.licensePlateNumber.value.code }\n                : null; // special logic here to copy non-transient value to a transient field\n            this.editableLicensePlateNumber.isReadOnly = !isEditable;\n        }\n        if (typesLib.strictEq(productSiteSettings.product.lotManagementMode, 'notManaged')) {\n            this.editableLot.isHidden = true;\n            this.editableLot.isMandatory = false;\n        }\n        else {\n            this.editableLot.isHidden = false;\n            this.editableLot.value = this.lot.value;\n            this.editableLot.isReadOnly = !isEditable;\n            // this.editableLot.isMandatory = productSiteSettings.product.lotManagementMode !== 'optionalLot'; // bug isMandatory with transient field\n        }\n        if (typesLib.strictNe(productSiteSettings.product.lotManagementMode, 'lotAndSublot')) {\n            this.sublot.isHidden = true;\n        }\n        else {\n            this.sublot.isHidden = false;\n            this.sublot.isReadOnly = !isEditable;\n        }\n        if (typesLib.strictNe(productSiteSettings.product.serialNumberManagementMode, 'receivedIssued')) {\n            this.serialNumber.isHidden = true;\n        }\n        else {\n            this.serialNumber.isHidden = false;\n            this.serialNumber.isReadOnly = !isEditable;\n        }\n        this.majorVersion.isHidden = typesLib.strictEq(productSiteSettings.product.stockVersionMode, 'no');\n        this.minorVersion.isHidden = typesLib.strictNe(productSiteSettings.product.stockVersionMode, 'majorAndMinor');\n        this.packingUnit.isHidden = false;\n        this.status.isHidden = false;\n        this.identifier1.isHidden = !this.identifier1.value;\n        this.identifier2.isHidden = !this.identifier2.value;\n        this.quantityInPackingUnit.isHidden = !this._isTheoreticalQuantityDisplayed;\n        this.isZeroStock.isHidden = true;\n        this.countedStockInPackingUnit.isHidden = false;\n        if (!this.stockLine.value)\n            this.quantityInPackingUnit.value = null;\n        this.quantityInPackingUnit.scale = this.packingUnit.value.numberOfDecimals; // also display quantity in decimals\n        this.countedStockInPackingUnit.scale = this.packingUnit.value.numberOfDecimals;\n        this.countedStockInPackingUnit.value =\n            typesLib.strictNe(this.countedStockInPackingUnit.value, 0) || this.isZeroStock.value\n                ? this.countedStockInPackingUnit.value\n                : null;\n        //if item is serial tracked, quantity must be 0 or 1\n        this.countedStockInPackingUnit.max = !this.serialNumber.isHidden ? 1 : undefined;\n        this.countedStockInPackingUnit.focus();\n    }\n    async _fetchProductSettings(productCode) {\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .read({\n            isLicensePlateNumberManaged: true, // determine is LPN should be displayed\n            isLocationManaged: true,\n            product: {\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n                stockVersionMode: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            },\n        }, `${productCode}|${this.stockSite.value.code}`)\n            .execute();\n        // TODO: Verify: This check is probably not needed\n        if (!response) {\n            throw new Error(`Nonexistent product code: ${productCode}`);\n        }\n        return {\n            ...response,\n            product: {\n                ...response.product,\n                packingUnits: (0, xtrem_client_1.extractEdges)(response.product.packingUnits.query),\n            },\n        };\n    }\n    _mapMultiCountMode() {\n        if (!this.stockCountSession.value.isMultipleCount) {\n            this.multiCountNumber.value = 0;\n            return;\n        }\n        if (typesLib.strictEq(this.countedStockInPackingUnit1.value, 0) && !this.isZeroStock1.value) {\n            this.multiCountNumber.value = 1;\n            this.multiCountMode.value = ui.localize('@sage/x3-stock/constant-stock-count-details__count', 'Count {{count}}', {\n                count: this.multiCountNumber.value,\n            });\n        }\n        else if (typesLib.strictEq(this.countedStockInPackingUnit2.value, 0) && !this.isZeroStock2.value) {\n            this.multiCountNumber.value = 2;\n            this.multiCountMode.value = ui.localize('@sage/x3-stock/constant-stock-count-details__count', 'Count {{count}}', {\n                count: this.multiCountNumber.value,\n            });\n        }\n        else if (typesLib.strictEq(this.countedStockInPackingUnit.value, 0) && !this.isZeroStock.value) {\n            this.multiCountMode.value = ui.localize('@sage/x3-stock/constant-stock-count-details__final-count', 'Final count');\n            this.multiCountNumber.value = 0;\n        }\n        else {\n            this.multiCountMode.value = ui.localize('@sage/x3-stock/constant__counted-literal', 'Counted');\n            this.multiCountNumber.value = 0;\n        }\n    }\n    /** @internal */\n    async _callProcessCountAPI(mode, serialNumberRanges) {\n        // if parameter value like licensePlateNumber is not applicable (i.e. selected product is not lpn managed),\n        // parameter should still be specified but set to empty (not null)\n        // Warning : this anonymous parameters block is mirror of mutation\n        let _processCountArgs;\n        if (typesLib.strictEq(mode, MobileStockCountDetailPageMode.update)) {\n            _processCountArgs = {\n                stockCountSessionNumber: this.stockCountSession.value?.stockCountSession ?? '',\n                stockCountListNumber: this.stockCountList.value?.stockCountListNumber ?? '',\n                productRankNumber: Number(this.productRankNumber.value),\n                product: this.product.value?.code ?? '',\n                licensePlateNumber: this.editableLicensePlateNumber.value?.code ?? '',\n                location: this.location.value?.code ?? '',\n                // apparently if value of non-transient filterSelect is empty, it becomes undefined\n                lot: this.editableLot.value ?? '',\n                sublot: this.sublot.value ?? '',\n                serialNumber: this.serialNumber.value ?? '',\n                status: this.status.value ?? '',\n                majorVersion: this.majorVersion.value?.code ?? '',\n                minorVersion: this.minorVersion.value ?? '',\n                packingUnit: this.packingUnit.value.code,\n                countedStockInPackingUnit: Number(this.countedStockInPackingUnit.value),\n                packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactor.value),\n                multiCountNumber: Number(this.multiCountNumber.value),\n                serialNumberQuantity: [],\n                startingSerialNumber: [],\n                endingSerialNumber: [],\n                serialNumberVariance: [],\n            };\n        }\n        else {\n            // if in create mode\n            _processCountArgs = {\n                stockCountSessionNumber: this.stockCountSession.value?.stockCountSession ?? '',\n                stockCountListNumber: this.stockCountList.value?.stockCountListNumber ?? '',\n                productRankNumber: 0,\n                product: this.newProduct.value?.code ?? '',\n                licensePlateNumber: this.newLicensePlateNumber.value?.code ?? '',\n                location: this.newLocation.value?.code ?? '',\n                lot: this.newLot.value ?? '',\n                sublot: this.newSublot.value ?? '',\n                serialNumber: this.newSerialNumber.value ?? '',\n                status: this.newStatus.value.code,\n                majorVersion: this.newMajorVersion.value?.code ?? '',\n                minorVersion: this.newMinorVersion.value ?? '',\n                packingUnit: this.newPackingUnit.value ?? '',\n                countedStockInPackingUnit: Number(this.newCountedStockInPackingUnit.value),\n                packingUnitToStockUnitConversionFactor: Number(this.packingUnitToStockUnitConversionFactor.value),\n                multiCountNumber: Number(this.multiCountNumber.value),\n                serialNumberQuantity: [],\n                startingSerialNumber: [],\n                endingSerialNumber: [],\n                serialNumberVariance: [],\n            };\n        }\n        // Arrays must contain an element, even if empty.\n        if (serialNumberRanges.length) {\n            serialNumberRanges.forEach(_ => {\n                _processCountArgs.serialNumberQuantity.push(Number(_.quantity));\n                _processCountArgs.startingSerialNumber.push(_.startingSerialNumber);\n                _processCountArgs.endingSerialNumber.push(_.endingSerialNumber);\n                _processCountArgs.serialNumberVariance.push(_.stockCountVariance);\n            });\n        }\n        else {\n            _processCountArgs.serialNumberQuantity.push(0);\n            _processCountArgs.startingSerialNumber.push('');\n            _processCountArgs.endingSerialNumber.push('');\n            _processCountArgs.serialNumberVariance.push('');\n        }\n        try {\n            const response = (await this.$.graph\n                .node('@sage/x3-stock/StockCountListDetail')\n                .mutations.processCount({\n                stockCountSessionNumber: true,\n                stockCountListNumber: true,\n            }, { parameters: _processCountArgs })\n                .execute());\n            if (!response?.stockCountSessionNumber) {\n                return new xtrem_shared_1.ApiError(`Mutation response is empty`, []);\n            }\n            return response;\n        }\n        catch (error) {\n            return error;\n        }\n    }\n    _filterLicensePlateNumber(productCode, locationCode) {\n        let filter = {\n            // TODO: Add site criterion to filter for LPNs\n            stockSite: { code: this.stockSite.value?.code ?? undefined },\n            isActive: true,\n            _and: [\n                {\n                    _or: [\n                        { isSingleProduct: { _eq: false } },\n                        {\n                            isSingleProduct: { _eq: true }, // to not imply isSingleProduct is true here because this property is nullable\n                            stock: { _atLeast: 1, product: { product: { code: productCode } } },\n                        },\n                        {\n                            isSingleProduct: { _eq: true }, // to not imply isSingleProduct is true here because this property is nullable\n                            stock: { _none: true }, // TODO: Verify: Does this do what it was intended for? Filter for empty collection\n                        },\n                    ],\n                },\n            ],\n            // NOTE: No filter criterion on location category because for ADC Counts it can be any location category\n        };\n        // TODO: Add the container filter\n        // if (this.container.value?.code) {\n        //     filter.container = { code: this.container.value.code };\n        // }\n        if (locationCode) {\n            filter._and.push({\n                _or: [\n                    { location: { code: locationCode } },\n                    {\n                        // to also include entries without location that have 'free' status\n                        location: { code: null },\n                        status: 'free',\n                    },\n                ],\n            });\n        }\n        return filter;\n    }\n    async _onChangeLicensePlateNumber(licensePlateNumber, location) {\n        if (!licensePlateNumber.value) {\n            location.isDisabled = false;\n            location.value = null;\n            return;\n        }\n        // Populate and disable To Location field if selected LPN is associated with a location\n        if (licensePlateNumber.value?.location) {\n            // LPN can be associated with or without a location\n            location.value = licensePlateNumber.value.location;\n            location.isDisabled = true;\n        }\n        else {\n            location.isDisabled = false; // should be enabled if LPN is 'free' status (i.e. can be associated to any location)\n            location.value = null;\n        }\n        await this.$.commitValueAndPropertyChanges();\n        licensePlateNumber.getNextField(true)?.focus();\n    }\n    async _onChangeNewPackingUnit(newPackingUnit, update, productCode) {\n        // if (!newPackingUnit.value) {\n        //     return;\n        // }\n        let productSiteSettings = await this._fetchProductSettings(productCode ?? '');\n        let productPackingList = productSiteSettings.product.packingUnits;\n        let productPackingUnitSelectValues = productPackingList.map(productPacking => {\n            return `${productPacking.packingUnit.code}`;\n        });\n        this.newPackingUnit.options = [productSiteSettings.product.stockUnit.code, ...productPackingUnitSelectValues];\n        if (!update)\n            this.newPackingUnit.value = this.newPackingUnit.options[0];\n        if (typesLib.strictNe(this.newPackingUnit.value, productSiteSettings.product.stockUnit.code)) {\n            let _index = productPackingList.findIndex(unit => typesLib.strictEq(unit.packingUnit.code, this.newPackingUnit.value));\n            typesLib.gt(_index, -1) ? (this.packingUnitToStockUnitConversionFactor.value = Number(productPackingList[_index].packingUnitToStockUnitConversionFactor))\n                : (this.packingUnitToStockUnitConversionFactor.value = 1);\n        }\n        else\n            this.packingUnitToStockUnitConversionFactor.value = 1;\n        await this.$.commitValueAndPropertyChanges();\n        newPackingUnit.getNextField(true)?.focus();\n    }\n    async _onChangeLot(lot, sublot, majorVersion, minorVersion, productCode) {\n        // if lot is manually cleared out, then clear out sublot as well ONLY if it doesn't have a pre-populated sublot\n        if (!lot.value) {\n            sublot.value = '';\n            majorVersion.value = null;\n            minorVersion.value = '';\n            return;\n        }\n        lot.value = lot.value.toUpperCase();\n        await this.$.commitValueAndPropertyChanges(); // to commit the programmatic text changes for validation (otherwise, an error icon may appear despite the value appearing to be valid)\n        await lot.validate();\n        // TODO: Implement: Preload sublot based on selected lot\n        // TODO: Verify: This is not possible to do due to X3-240877\n        // if (this.newLot.value.sublot) {\n        //     // if lot has an associated sublot, then populate sublot and disable it\n        //     this.newSublot.value = this.newLot.helperText;\n        //     this.newSublot.isDisabled = true;\n        // }\n        if (sublot.isHidden || sublot.value) {\n            // preload version if current product is not sublot tracked or has a non-empty value for sublot\n            await this._preloadVersion(productCode, lot, sublot, majorVersion, minorVersion);\n        }\n        else {\n            lot.getNextField(true)?.focus();\n        }\n    }\n    async _onChangeSublot(lot, sublot, majorVersion, minorVersion, productCode) {\n        if (!sublot.value)\n            return;\n        sublot.value = sublot.value.toUpperCase();\n        await this.$.commitValueAndPropertyChanges();\n        await sublot.validate();\n        // If the lot/sublot combination is new, pop-up a warning dialog message\n        if (lot.value && sublot.value) {\n            await this._preloadVersion(productCode, lot, sublot, majorVersion, minorVersion);\n        }\n    }\n    async _onClickUpdate() {\n        // perform client-side validation\n        if (!(await (0, control_1.validateWithDetails)(this)))\n            return;\n        // before even proceeding to the update process, check if the product is global serial tracked. If so, then user must provide additional information i.e. serial number ranges\n        let globalSerialRanges = [];\n        if (typesLib.strictEq(this.product.value?.serialNumberManagementMode, 'globalReceivedIssued') && typesLib.strictEq(this.multiCountNumber.value, 0) && typesLib.strictNe(this.quantityInPackingUnit.value, this.countedStockInPackingUnit.value) &&\n            !(globalSerialRanges = await this.$.dialog\n                .page('@sage/x3-stock/MobileStockCountSerialPanel', {\n                stockCountListDetail: JSON.stringify({\n                    stockSite: this.stockSite.value,\n                    stockCountSession: this.stockCountSession.value,\n                    stockCountList: this.stockCountList.value,\n                    stockLine: this.stockLine.value,\n                    product: this.product.value,\n                    location: this.location.value,\n                    status: this.status.value,\n                    identifier1: this.identifier1.value,\n                    identifier2: this.identifier2.value,\n                    quantityInPackingUnit: String(this.quantityInPackingUnit.value),\n                    packingUnit: this.packingUnit.value,\n                    countedStockInPackingUnit: String(this.countedStockInPackingUnit.value),\n                }),\n                ...(typesLib.eq(this.oldCountedStockInPackingUnit.value, this.countedStockInPackingUnit.value) && {\n                    _id: this._id.value ?? '',\n                }),\n            })\n                .catch(() => {\n                /* to swallow up any error */\n            }))) {\n            await this.$.sound.success();\n            this.countedStockInPackingUnit.focus();\n            return;\n        }\n        // to prevent extreme scenarios from rapidly clicking the update button multiple times\n        this.updateButton.isDisabled = true;\n        this.nextButton.isDisabled = true;\n        this.newButton.isDisabled = true;\n        this.viewCountsButton.isDisabled = true;\n        this.$.loader.isHidden = false;\n        const result = await this._callProcessCountAPI(MobileStockCountDetailPageMode.update, globalSerialRanges);\n        this.$.loader.isHidden = true;\n        if (!result || result instanceof Error) {\n            const options = {\n                acceptButton: {\n                    text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                },\n                cancelButton: {\n                    text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                },\n                size: 'small',\n            };\n            let message = '';\n            await this.$.sound.error();\n            if (!result?.message) {\n                message = `${ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options)) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    await this.$.router.emptyPage();\n                    (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockCount');\n                }\n            }\n            else {\n                const _messages = [];\n                const _results = result;\n                let _diagnoses = _results?.diagnoses;\n                if (typesLib.gt(_diagnoses?.length, 1)) {\n                    _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                }\n                // This is used to retrieve messages from the Client() class otherwise BusinessRuleError\n                ((_results?.errors\n                    ? _results.errors[0]?.extensions?.diagnoses\n                    : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                        _results.extensions?.diagnoses ??\n                        _diagnoses)) ?? [])\n                    .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                    .forEach((d) => {\n                    const _message = d.message.split(`\\n`);\n                    _messages.push(..._message);\n                });\n                const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                options.mdContent = true;\n                message = `**${ui.localize('@sage/x3-stock/dialog-error-stock-count-update', 'An error occurred')}**\\n\\n`;\n                if (typesLib.strictEq(_result.length, 1)) {\n                    message = typesLib.add(message, `${_result[0]}`);\n                }\n                else {\n                    message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                }\n            }\n            if (!(await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options))) {\n                this.$.setPageClean();\n            }\n            this.updateButton.isDisabled = false;\n            this.nextButton.isDisabled = false;\n            this.newButton.isDisabled = false;\n            this.viewCountsButton.isDisabled = false;\n        }\n        else {\n            // if success, do NOT display any dialog message\n            this.$.setPageClean();\n            await this.$.sound.success();\n            if (!(await this.$.router.hasNextRecord())) {\n                const options = {\n                    fullScreen: true,\n                    rightAligned: false,\n                    acceptButton: {\n                        isDisabled: false,\n                        isHidden: false,\n                        text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                    },\n                };\n                await (0, dialogs_1.dialogMessage)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), ui.localize('@sage/x3-stock/end-of-count-list', 'End of count list'), options);\n                (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockCount');\n            }\n            else {\n                await this.$.router.nextRecord();\n            }\n        }\n    }\n    async _onClickCreate() {\n        // perform client-side validation\n        if (!(await (0, control_1.validateWithDetails)(this)))\n            return;\n        let globalSerialRanges = [];\n        if (typesLib.strictEq(this.newProduct.value?.serialNumberManagementMode, 'globalReceivedIssued') && typesLib.strictEq(this.multiCountNumber.value, 0) &&\n            // quantity is always considered an overage\n            !(globalSerialRanges = await this.$.dialog\n                .page('@sage/x3-stock/MobileStockCountSerialPanel', {\n                stockCountListDetail: JSON.stringify({\n                    stockSite: this.stockSite.value,\n                    stockCountSession: this.stockCountSession.value,\n                    stockCountList: this.stockCountList.value,\n                    product: this.newProduct.value,\n                    location: this.newLocation.value,\n                    status: this.newStatus.value?.code,\n                    quantityInPackingUnit: '0',\n                    packingUnit: { code: this.newPackingUnit.value },\n                    countedStockInPackingUnit: String(this.newCountedStockInPackingUnit.value),\n                }),\n            })\n                .catch(() => {\n                /* to swallow up any error */\n            }))) {\n            this.newCountedStockInPackingUnit.focus();\n            return;\n        }\n        // to prevent extreme scenarios from rapidly clicking the update button multiple times\n        this.createButton.isDisabled = true;\n        this.cancelButton.isDisabled = true;\n        this.$.loader.isHidden = false;\n        const result = await this._callProcessCountAPI(MobileStockCountDetailPageMode.create, globalSerialRanges);\n        this.$.loader.isHidden = true;\n        if (!result || result instanceof Error) {\n            const options = {\n                acceptButton: {\n                    text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                },\n                cancelButton: {\n                    text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                },\n                size: 'small',\n            };\n            let message = '';\n            await this.$.sound.error();\n            if (!result?.message) {\n                message = `${ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options)) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    await this.$.router.emptyPage();\n                    (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockCount');\n                }\n            }\n            else {\n                const _messages = [];\n                const _results = result;\n                let _diagnoses = _results?.diagnoses;\n                if (typesLib.gt(_diagnoses?.length, 1)) {\n                    _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                }\n                // This is used to retrieve messages from the Client() class otherwise BusinessRuleError\n                ((_results?.errors\n                    ? _results.errors[0]?.extensions?.diagnoses\n                    : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                        _results.extensions?.diagnoses ??\n                        _diagnoses)) ?? [])\n                    .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                    .forEach((d) => {\n                    const _message = d.message.split(`\\n`);\n                    _messages.push(..._message);\n                });\n                const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                options.mdContent = true;\n                message = `**${ui.localize('@sage/x3-stock/dialog-error-stock-count-create', 'An error occurred')}**\\n\\n`;\n                if (typesLib.strictEq(_result.length, 1)) {\n                    message = typesLib.add(message, `${_result[0]}`);\n                }\n                else {\n                    message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                }\n            }\n            if (!(await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options))) {\n                this.$.setPageClean();\n            }\n            this.createButton.isDisabled = false;\n            this.cancelButton.isDisabled = false;\n        }\n        else {\n            await this.$.sound.success();\n            // go to back to Update mode\n            this._initializePage(MobileStockCountDetailPageMode.update);\n        }\n    }\n    async _validateCount(counted) {\n        if (!counted)\n            counted = 0;\n        if (!this.stockLine.value)\n            return true;\n        const validate = typesLib.gte(typesLib.mul(counted, (this.packingUnitToStockUnitConversionFactor?.value ?? 0)), Number(this.stockLine.value.allocatedQuantity));\n        if (!validate) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-stock-count-details-quantity-message', 'Counted quantity cannot be less than allocated quantity'));\n        }\n        return validate;\n    }\n    async _getIsTheoreticalQuantityDisplayed() {\n        const responseSite = await this.$.graph\n            .node('@sage/x3-master-data/MobileAutomationSetup')\n            .query(ui.queryUtils.edgesSelector({\n            isTheoreticalQuantityDisplayed: true,\n        }, {\n            filter: {\n                site: this.stockSite.value,\n            },\n        }))\n            .execute();\n        if (typesLib.strictNe(responseSite.edges.length, 0)) {\n            responseSite.edges.some(edge => {\n                this._isTheoreticalQuantityDisplayed = edge.node.isTheoreticalQuantityDisplayed;\n            });\n        }\n        else {\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/MobileAutomationSetup')\n                .query(ui.queryUtils.edgesSelector({\n                isTheoreticalQuantityDisplayed: true,\n            }, {\n                filter: {\n                    site: null,\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0)) {\n                response.edges.some(edge => {\n                    this._isTheoreticalQuantityDisplayed = edge.node.isTheoreticalQuantityDisplayed;\n                });\n            }\n            else {\n                this._isTheoreticalQuantityDisplayed = false;\n            }\n        }\n    }\n};\nexports.MobileStockCountDetail = MobileStockCountDetail;\n__decorate([\n    ui.decorators.referenceField({\n        isTitleHidden: true,\n        isHidden: true,\n        isReadOnly: true,\n        node: '@sage/x3-system/Site',\n        valueField: 'code',\n        canFilter: false,\n    })\n], MobileStockCountDetail.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        node: '@sage/x3-stock/StockCountSession',\n        valueField: 'stockCountSession',\n        canFilter: false,\n        columns: [\n            ui.nestedFields.checkbox({\n                bind: 'isMultipleCount',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isNonUsableProductSelected',\n                isHidden: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'stockCountSessionMode',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'stockCycleCountClassA',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'stockCycleCountClassB',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'stockCycleCountClassC',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'stockCycleCountClassD',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"stockCountSession\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isTitleHidden: true,\n        isReadOnly: true,\n    })\n], MobileStockCountDetail.prototype, \"headerStockCountSessionNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isTitleHidden: true,\n        isReadOnly: true,\n        node: '@sage/x3-stock/StockCountList',\n        valueField: 'stockCountListNumber',\n        canFilter: false,\n    })\n], MobileStockCountDetail.prototype, \"stockCountList\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isTitleHidden: true,\n        isReadOnly: true,\n    })\n], MobileStockCountDetail.prototype, \"headerStockCountListNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isTitleHidden: true,\n        isReadOnly: true,\n    })\n], MobileStockCountDetail.prototype, \"headerProductCode\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isTitleHidden: true,\n        isReadOnly: true,\n    })\n], MobileStockCountDetail.prototype, \"headerProductDescription\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"productRankNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"_id\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n        bind: 'countedStockInPackingUnit',\n    })\n], MobileStockCountDetail.prototype, \"oldCountedStockInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"countedStockInPackingUnit1\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"countedStockInPackingUnit2\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"isZeroStock1\", void 0);\n__decorate([\n    ui.decorators.checkboxField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"isZeroStock2\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isHidden: true,\n        isDisabled: true,\n        node: '@sage/x3-stock-data/Stock',\n        bind: 'stockLine',\n        valueField: 'stockId',\n        canFilter: false,\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'allocatedQuantity',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"stockLine\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        isHidden: true,\n        isDisabled: true,\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        canFilter: false,\n    })\n], MobileStockCountDetail.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n        isDisabled: true,\n    })\n], MobileStockCountDetail.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isHidden: true,\n        isDisabled: true,\n        isTransient: true, // transient input for processCount\n    })\n], MobileStockCountDetail.prototype, \"multiCountNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockCountDetail.prototype, \"multiCountMode\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileStockCountDetail.prototype, \"lineNumberBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileStockCountDetail.prototype, \"updateBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        isTitleHidden: true,\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileStockCountDetail.prototype, \"newBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.lineNumberBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____title\", \"Line number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock/StockCountListDetail',\n        valueField: 'productRankNumber',\n        isTransient: true,\n        isAutoSelectEnabled: true,\n        isDropdownDisabled: false,\n        isFullWidth: false,\n        minLookupCharacters: 1,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return generateDetailFilter(JSON.parse(this.$.queryParameters.stockCountListDetail), typesLib.strictEq(this.$.queryParameters.excludeCountedLines, 'true'));\n        },\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'productRankNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____columns__title__productRankNumber\", \"Line Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____columns__title__product__code\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'localizedDescription1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____columns__title__product__localizedDescription1\", \"Description\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'upc',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__stockCountListDetailLineNumbers____columns__title__product__upc\", \"UPC\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lot',\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'serialNumber',\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: '_id',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (!this.stockCountListDetailLineNumbers.value)\n                return;\n            await this.$.router.selectRecord(this.stockCountListDetailLineNumbers.value._id);\n        },\n    })\n], MobileStockCountDetail.prototype, \"stockCountListDetailLineNumbers\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__product____title\", \"Product\"),\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        isReadOnly: true,\n        isFullWidth: true,\n        isHidden: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__productLocalizedDescription1____title\", \"Product description\"),\n        node: '@sage/x3-master-data/Product',\n        bind: 'product',\n        valueField: 'localizedDescription1',\n        isReadOnly: true,\n        isFullWidth: true,\n        isHidden: true,\n        canFilter: false,\n    })\n], MobileStockCountDetail.prototype, \"productLocalizedDescription1\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____title\", \"License plate number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isHidden: true, // this is important, otherwise field will still show up briefly before it is determined to be enabled/disabled during onLoad\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        // (X3-237456) TODO: Issue: Lookup panel's load more button does not work for licensePlateNumber reference field\n        filter() {\n            return this._filterLicensePlateNumber(this.product.value.code, this.location.value?.code);\n        },\n        async onChange() {\n            await this._onChangeLicensePlateNumber(this.editableLicensePlateNumber, this.location);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____columns__title__code\", \"License Plate Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____columns__title__location__code\", \"Location\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____columns__title__container__code\", \"Container\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLicensePlateNumber____columns__title__status\", \"Status\"),\n                map(value, rowData) {\n                    switch (value) {\n                        case 'free':\n                            return 'Free';\n                        case 'inStock':\n                            return 'In Stock';\n                        default:\n                            return '';\n                    }\n                },\n                borderColor: ui.tokens.colorsYang100,\n                optionType: '@sage/x3-stock-data/ContainerStatus',\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"editableLicensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__location____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__location____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: true,\n        isFullWidth: true,\n        isHidden: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return { stockSite: { code: this.stockSite.value.code } };\n        },\n        onChange() {\n            if (this.location.value)\n                this.location.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'category',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__location____columns__title__category\", \"Category\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLot____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/Lot',\n        valueField: 'code',\n        helperText: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLot____helperText\", \"sublot\"), // TODO: Preload sublot based on selected lot\n        isHelperTextHidden: true,\n        isFullWidth: true,\n        isNewEnabled: true,\n        isTransient: true, // (X3-248932) TODO: Issue: auto-populating non-transient filterSelect causes a Bad Request. Remove this workaround\n        isHidden: true,\n        validation: /^$|^[^|a-z]+$/, // added a check for negating lower-case characters to avoid edge cases\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value.code },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLot____columns__title__code\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__editableLot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n        async onChange() {\n            await this._onChangeLot(this.editableLot, this.sublot, this.majorVersion, this.minorVersion, this.product.value.code);\n        },\n    })\n], MobileStockCountDetail.prototype, \"editableLot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__sublot____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        isFullWidth: false,\n        isHidden: true,\n        validation: /^$|^[^|a-z]+$/,\n        async onChange() {\n            await this._onChangeSublot(this.editableLot, this.sublot, this.majorVersion, this.minorVersion, this.product.value.code);\n        },\n    })\n], MobileStockCountDetail.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__serialNumber____placeholder\", \"Scan or select\\u2026\"),\n        isMandatory: true, // No support of auto generating serial numbers in ADC counts so if a serial number is required, it must be manually entered\n        isFullWidth: true,\n        isHidden: true,\n        validation: /^$|^[^|]+$/,\n    })\n], MobileStockCountDetail.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__majorVersion____title\", \"Major version\"),\n        isHidden: true,\n        isDisabled: true,\n        isFullWidth: false,\n        node: '@sage/x3-stock-data/MajorVersionStatus',\n        valueField: 'code',\n    })\n], MobileStockCountDetail.prototype, \"majorVersion\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__minorVersion____title\", \"Minor version\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"minorVersion\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__packingUnit____title\", \"Unit\"),\n        node: '@sage/x3-master-data/UnitOfMeasure',\n        valueField: 'code',\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.numeric({\n                bind: 'numberOfDecimals',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__status____title\", \"Status\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__identifier1____title\", \"Identifier 1\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__identifier2____title\", \"Identifier 2\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__quantityInPackingUnit____title\", \"Stock\"),\n        isReadOnly: true,\n        isFullWidth: false,\n        isHidden: true,\n    })\n], MobileStockCountDetail.prototype, \"quantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__isZeroStock____title\", \"Zero stock\"),\n        isFullWidth: false,\n        isHidden: true,\n        borderColor: ui.tokens.colorsUtilityMajor025,\n        map(value, rowValue) {\n            return typesLib.strictEq(value, true) ? 'Yes' : 'No';\n        },\n    })\n], MobileStockCountDetail.prototype, \"isZeroStock\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.updateBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__countedStockInPackingUnit____title\", \"Counted quantity\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__countedStockInPackingUnit____placeholder\", \"Enter quantity\"),\n        isMandatory: false,\n        isFullWidth: true,\n        isNotZero: false,\n        isHidden: true,\n        min: 0,\n    })\n], MobileStockCountDetail.prototype, \"countedStockInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newProduct____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newProduct____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-master-data/Product',\n        valueField: 'code',\n        helperTextField: 'upc',\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        isHelperTextHidden: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            // Criterion for isNonUsableProductSelected (if CUNSESSION.ITMSTA006 = 1, then ITMSTA <> 6)\n            let stockCountSessionFilter = !this.stockCountSession.value.isNonUsableProductSelected\n                ? { productStatus: { _nin: ['notUsable'] } }\n                : {};\n            // Criterion for stockCountSessionMode\n            let productSiteFilter = {};\n            switch (this.stockCountSession.value.stockCountSessionMode) {\n                case 'manualSelection': {\n                    // then product site ITMFACILIT.CUNDOD must <> 3 (noCount)\n                    productSiteFilter.countManagementMode = {\n                        _nin: ['notCounted'],\n                    };\n                    break;\n                }\n                case 'cycleStockCount': {\n                    // then product site ITMFACILIT.CUNDOD must = 1 (cycleCount)\n                    productSiteFilter.countManagementMode = 'cycleCount';\n                    break;\n                }\n                case 'annualStockCount': {\n                    // then product site ITMFACILIT.CUNDOD must = 2 (annualCount)\n                    productSiteFilter.countManagementMode = 'annualCount';\n                    break;\n                }\n            }\n            // Criterion for ADC class\n            productSiteFilter.abcClass = { _in: [null] };\n            if (this.stockCountSession.value.stockCycleCountClassA) {\n                productSiteFilter.abcClass._in.push('classA');\n            }\n            if (this.stockCountSession.value.stockCycleCountClassB) {\n                productSiteFilter.abcClass._in.push('classB');\n            }\n            if (this.stockCountSession.value.stockCycleCountClassC) {\n                productSiteFilter.abcClass._in.push('classC');\n            }\n            if (this.stockCountSession.value.stockCycleCountClassD) {\n                productSiteFilter.abcClass._in.push('classD');\n            }\n            return {\n                ...stockCountSessionFilter,\n                productSites: { _atLeast: 1, stockSite: { code: this.stockSite.value.code }, ...productSiteFilter },\n                stockManagementMode: { _ne: 'notManaged' }, // STOMGTCOD = 2\n                _or: [\n                    { stockVersionMode: { _in: ['no', null] } },\n                    {\n                        // if ECCSTO > 1, then LOAECCFLG must = 2\n                        stockVersionMode: { _nin: ['no'] }, // this checks if product is version managed\n                        isVersionPreloaded: true,\n                    },\n                ],\n            };\n        },\n        async onChange() {\n            await this._initializeNewBlock(this.newProduct.value?.code);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newProduct____columns__title__code\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newProduct____columns__title__upc\", \"UPC\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'localizedDescription1',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newProduct____columns__title__localizedDescription1\", \"Description\"),\n                isReadOnly: true,\n            }),\n            // hidden column for internal use (in particular formatting options in unit field)\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/UnitOfMeasure',\n                bind: 'stockUnit',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.select({\n                bind: 'serialNumberManagementMode',\n                optionType: '@sage/x3-master-data/SerialNumberManagement',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"newProduct\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____title\", \"License plate number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        isMandatory: false,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        // (X3-237456) TODO: Issue: Lookup panel's load more button does not work for licensePlateNumber reference field\n        filter() {\n            return this._filterLicensePlateNumber(this.newProduct.value.code, this.newLocation.value?.code);\n        },\n        async onChange() {\n            await this._onChangeLicensePlateNumber(this.newLicensePlateNumber, this.newLocation);\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____columns__title__code\", \"License Plate Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____columns__title__location__code\", \"Location\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____columns__title__container__code\", \"Container\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLicensePlateNumber____columns__title__status\", \"Status\"),\n                map(value, rowData) {\n                    switch (value) {\n                        case 'free':\n                            return 'Free';\n                        case 'inStock':\n                            return 'In Stock';\n                        default:\n                            return '';\n                    }\n                },\n                borderColor: ui.tokens.colorsYang100,\n                optionType: '@sage/x3-stock-data/ContainerStatus',\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"newLicensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLocation____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLocation____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: true,\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.stockSite.value.code },\n                // TODO: Implement: To be used for location 'suggestions'\n                // at least 1 stock record must exist for the product & site\n                // stock: {\n                //     _atLeast: 1,\n                //     // stockSite: { code: this.stockSite.value.code }, // TODO: Verify: is this redundant?\n                //     product: { code: this.newProduct.value.code },\n                //     isBeingCounted: { _ne: true }, // TODO: Verify: to include both false & null(?)\n                //     // (XT-1401 & XT-5527) TODO: Issue: Computational value on the right-hand side of graphql logical operator\n                //     //quantityInStockUnit: { _gt (allocatedQuantity + inProcessQuantity) },\n                //     remainingQuantity: { _gt: '0' }, // workaround for computational value by creating a non-stored computed property\n                // },\n            };\n        },\n        onChange() {\n            if (this.newLocation.value)\n                this.newLocation.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLocation____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLocation____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'category',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLocation____columns__title__category\", \"Category\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileStockCountDetail.prototype, \"newLocation\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLot____placeholder\", \"Scan or select\\u2026\"),\n        node: '@sage/x3-stock-data/Lot',\n        valueField: 'code',\n        helperText: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLot____helperText\", \"sublot\"), // TODO: Preload sublot based on selected lot\n        isHelperTextHidden: true,\n        isTransient: true,\n        isFullWidth: true,\n        isNewEnabled: true,\n        validation: /^$|^[^|a-z]+$/, // added a check for negating lower-case characters to avoid edge cases\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.newProduct.value.code },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLot____columns__title__code\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newLot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n        async onChange() {\n            await this._onChangeLot(this.newLot, this.newSublot, this.newMajorVersion, this.newMinorVersion, this.newProduct.value.code);\n        },\n    })\n], MobileStockCountDetail.prototype, \"newLot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newSublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newSublot____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: false,\n        validation: /^$|^[^|a-z]+$/,\n        async onChange() {\n            await this._onChangeSublot(this.newLot, this.newSublot, this.newMajorVersion, this.newMinorVersion, this.newProduct.value?.code ?? '');\n        },\n    })\n], MobileStockCountDetail.prototype, \"newSublot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newSerialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newSerialNumber____placeholder\", \"Scan or select\\u2026\"),\n        isTransient: true,\n        isMandatory: true, // No support of auto generating serial numbers in ADC counts so if a serial number is required, it must be manually entered\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n    })\n], MobileStockCountDetail.prototype, \"newSerialNumber\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.newBlock;\n        },\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: false,\n        node: '@sage/x3-stock-data/MajorVersionStatus',\n        valueField: 'code',\n    })\n], MobileStockCountDetail.prototype, \"newMajorVersion\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newMinorVersion____title\", \"Minor version\"),\n        isTransient: true,\n        isReadOnly: true,\n        isFullWidth: false,\n    })\n], MobileStockCountDetail.prototype, \"newMinorVersion\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newPackingUnit____title\", \"Unit\"),\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: false,\n        onChange() {\n            this._onChangeNewPackingUnit(this.newPackingUnit, true, this.newProduct.value.code);\n            // this.newPackingUnit.getNextField(true)?.focus();\n        },\n    })\n], MobileStockCountDetail.prototype, \"newPackingUnit\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newStatus____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newStatus____placeholder\", \"Enter status\"),\n        node: '@sage/x3-stock-data/StockStatus',\n        valueField: 'code',\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: false,\n        isAutoSelectEnabled: true,\n        isDropdownDisabled: false,\n        minLookupCharacters: 1,\n        canFilter: false,\n        // filter() {}, // (X3-240602) TODO: Issue: Add filter for status according to stock management rules\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newStatus____columns__title__code\", \"Status\"),\n                isReadOnly: true,\n            }),\n        ],\n        onChange() {\n            this.newStatus.getNextField(true)?.focus();\n        },\n    })\n], MobileStockCountDetail.prototype, \"newStatus\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.newBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newCountedStockInPackingUnit____title\", \"Counted quantity\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newCountedStockInPackingUnit____placeholder\", \"Enter quantity\"),\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isNotZero: true,\n        scale: 5,\n        min: 0,\n    })\n], MobileStockCountDetail.prototype, \"newCountedStockInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__nextButton____title\", \"Next\"),\n        shortcut: ['f3'],\n        buttonType: 'secondary',\n        isDisabled: true,\n        async onClick() {\n            if (!(await this.$.router.hasNextRecord())) {\n                // // Loop back to the 1st record of the selected stock count list\n                // const nextRecordId = (\n                //     await this.$.graph\n                //         .node('@sage/x3-stock/StockCountListDetail')\n                //         .queries.getFirstAvailableCountRecord(\n                //             { _id: true },\n                //             {\n                //                 // TODO: Issue: ERROR 'Expected type IntReference'. Cannot specify a StockCountList reference type parameter because _id is string in Sage X3 tables but expects int\n                //                 stockCountSessionNumber: this.stockCountSessionNumber.value.stockCountSession,\n                //                 stockCountListNumber: this.stockCountListNumber.value.stockCountListNumber,\n                //                 excludeCountedLines: this.$.queryParameters.excludeCountedLines === 'true',\n                //             },\n                //         )\n                //         .execute()\n                // )._id;\n                // // handle edgy case of the selected stock count list containing\n                // if (nextRecordId && nextRecordId !== this._id.value) {\n                //     await this.$.router.selectRecord(nextRecordId);\n                // }\n                if (await (0, dialogs_1.dialogMessage)(this, 'info', ui.localize('@sage/x3-stock/dialog-information-title', 'Information'), ui.localize('@sage/x3-stock/end-of-count-list', 'End of count list'), {\n                    fullScreen: true,\n                    rightAligned: false,\n                    acceptButton: {\n                        isDisabled: false,\n                        isHidden: false,\n                        text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                    },\n                })) {\n                    this.$.router.goTo('@sage/x3-stock/MobileStockCount');\n                }\n                return;\n            }\n            await this.$.router.nextRecord();\n        },\n    })\n], MobileStockCountDetail.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__updateButton____title\", \"Submit\"),\n        buttonType: 'primary',\n        isDisabled: true,\n        async onClick() {\n            if (!this.countedStockInPackingUnit?.value || typesLib.strictEq(this.countedStockInPackingUnit?.value, 0)) {\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/dialog-warn-stock-count-details-zero-stock-quantity', 'Zero stock?'), {\n                    fullScreen: true,\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                    },\n                })) {\n                    this.countedStockInPackingUnit.value = 0;\n                }\n                else {\n                    this.countedStockInPackingUnit.focus();\n                    return;\n                }\n            }\n            if (typesLib.lt(this.countedStockInPackingUnit?.value, 0)) {\n                return;\n            }\n            const valid = await this._validateCount(this.countedStockInPackingUnit.value);\n            if (!valid) {\n                this.countedStockInPackingUnit.focus();\n                return;\n            }\n            await this._onClickUpdate();\n        },\n    })\n], MobileStockCountDetail.prototype, \"updateButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__newButton____title\", \"Add line\"),\n        onClick() {\n            this._initializePage(MobileStockCountDetailPageMode.create);\n        },\n    })\n], MobileStockCountDetail.prototype, \"newButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__viewCountsButton____title\", \"View count\"),\n        onClick() {\n            this.$.router.goTo('@sage/x3-stock/MobileViewCountList', {});\n        },\n    })\n], MobileStockCountDetail.prototype, \"viewCountsButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__cancelButton____title\", \"Cancel\"),\n        shortcut: ['f4'],\n        buttonType: 'secondary',\n        onClick() {\n            this._initializePage(MobileStockCountDetailPageMode.update);\n        },\n    })\n], MobileStockCountDetail.prototype, \"cancelButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail__createButton____title\", \"Create\"),\n        buttonType: 'primary',\n        async onClick() {\n            await this._onClickCreate();\n        },\n    })\n], MobileStockCountDetail.prototype, \"createButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        isTitleHidden: true,\n        isHidden: true,\n        shortcut: ['f2'],\n        async onClick() {\n            await (this.updateButton.isHidden ? this._onClickCreate() : this._onClickUpdate());\n        },\n    })\n], MobileStockCountDetail.prototype, \"hiddenShortcutButton\", void 0);\nexports.MobileStockCountDetail = MobileStockCountDetail = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail____title\", \"Stock count\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail____subtitle\", \"Enter stock details\"),\n        isTitleHidden: true,\n        isTransient: false,\n        skipDirtyCheck: true, // (X3-250910) TODO: Obsolete: Un-dirty specific field components. Like Line number field\n        node: '@sage/x3-stock/StockCountListDetail',\n        mode: 'default',\n        navigationPanel: {\n            canFilter: false,\n            isHeaderHidden: true,\n            listItem: {\n                title: ui.nestedFields.numeric({ bind: 'productRankNumber' }), // this is needed because entries is ordered by node property specified specified by titleLine\n                line2: ui.nestedFields.text({ bind: '_id' }),\n            },\n            optionsMenu: [\n                {\n                    title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_count_detail____navigationPanel__optionsMenu__title\", \"\"),\n                    graphQLFilter: (storage, queryParameters) => generateDetailFilter(JSON.parse(queryParameters.stockCountListDetail), typesLib.strictEq(queryParameters.excludeCountedLines, 'true')),\n                },\n            ],\n        },\n        async onLoad() {\n            try {\n                this.$.isNavigationPanelHidden = true;\n                this._mapMultiCountMode();\n                await this._initializePage(MobileStockCountDetailPageMode.update, this.product.value.code);\n            }\n            catch (e) {\n                // TODO: Verify: Is this try/catch necessary for a non-transient page\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-error-missing-params', 'Missing required parameters'), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobileStockCount');\n            }\n        },\n        headerCard() {\n            return {\n                title: this.headerStockCountSessionNumber,\n                titleRight: this.headerStockCountListNumber,\n                line2: this.headerProductCode,\n                line2Right: this.headerProductDescription,\n                ...(this.multiCountMode.value && { line3: this.multiCountMode }),\n            };\n        },\n        businessActions() {\n            return [\n                this.updateButton,\n                this.newButton,\n                this.nextButton,\n                this.viewCountsButton,\n                this.cancelButton,\n                this.createButton,\n            ];\n        },\n    })\n], MobileStockCountDetail);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-count-detail.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-count-detail.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;