/// <reference types="@sage/x3-system/api" />
import { Product, UnitOfMeasure } from '@sage/x3-master-data-api';
import { GraphApi, StockCountList, StockCountListDetail, StockCountSession } from '@sage/x3-stock-api';
import { LicensePlateNumber, Location, Lot, MajorVersionStatus, Stock, StockStatus } from '@sage/x3-stock-data-api';
import { Site } from '@sage/x3-system-api';
import * as ui from '@sage/xtrem-ui';
export declare class MobileStockCountDetail extends ui.Page<GraphApi> {
    private _unitMap;
    _isTheoreticalQuantityDisplayed: boolean;
    stockSite: ui.fields.Reference<Site>;
    stockCountSession: ui.fields.Reference<StockCountSession>;
    headerStockCountSessionNumber: ui.fields.Text;
    stockCountList: ui.fields.Reference<StockCountList>;
    headerStockCountListNumber: ui.fields.Text;
    headerProductCode: ui.fields.Text;
    headerProductDescription: ui.fields.Text;
    productRankNumber: ui.fields.Numeric;
    _id: ui.fields.Text;
    oldCountedStockInPackingUnit: ui.fields.Numeric;
    countedStockInPackingUnit1: ui.fields.Numeric;
    countedStockInPackingUnit2: ui.fields.Numeric;
    isZeroStock1: ui.fields.Checkbox;
    isZeroStock2: ui.fields.Checkbox;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    stockLine: ui.fields.Reference<Stock>;
    licensePlateNumber: ui.fields.Reference<LicensePlateNumber>;
    lot: ui.fields.Text;
    multiCountNumber: ui.fields.Numeric;
    multiCountMode: ui.fields.Text;
    mainSection: ui.containers.Section;
    lineNumberBlock: ui.containers.Block;
    updateBlock: ui.containers.Block;
    /**
     * To decouple logic between update and new, arguably:
     *
     * (Downside) This roughly doubles the number of ui components to implement, but not particularly difficult to just
     * implement non-transient version of each property field
     *
     * (Upside) Potentially avoids a server-side call when transitioning back from New to Update mode.
     * Also simplifies dynamic ui logic by hiding/unhiding entire block rather than individual ui components
     * as well as not having to write logic that heavily depends on what mode the page is transitioning from/to and
     * the current state of each ui component (ex. transitioning from New, while having a non-lpn managed product that is selected)
     */
    newBlock: ui.containers.Block;
    stockCountListDetailLineNumbers: ui.fields.Reference<StockCountListDetail>;
    product: ui.fields.Reference<Product>;
    productLocalizedDescription1: ui.fields.Reference<Product>;
    editableLicensePlateNumber: ui.fields.Reference<LicensePlateNumber>;
    location: ui.fields.Reference<Location>;
    editableLot: ui.fields.FilterSelect<Lot>;
    sublot: ui.fields.Text;
    serialNumber: ui.fields.Text;
    majorVersion: ui.fields.Reference<MajorVersionStatus>;
    minorVersion: ui.fields.Text;
    packingUnit: ui.fields.Reference<UnitOfMeasure>;
    status: ui.fields.Text;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    quantityInPackingUnit: ui.fields.Numeric;
    isZeroStock: ui.fields.Label;
    countedStockInPackingUnit: ui.fields.Numeric;
    newProduct: ui.fields.Reference<Product>;
    newLicensePlateNumber: ui.fields.Reference<LicensePlateNumber>;
    newLocation: ui.fields.Reference<Location>;
    newLot: ui.fields.FilterSelect<Lot>;
    newSublot: ui.fields.Text;
    newSerialNumber: ui.fields.Text;
    newMajorVersion: ui.fields.Reference<MajorVersionStatus>;
    newMinorVersion: ui.fields.Text;
    newPackingUnit: ui.fields.Select;
    newStatus: ui.fields.Reference<StockStatus>;
    newCountedStockInPackingUnit: ui.fields.Numeric;
    nextButton: ui.PageAction;
    updateButton: ui.PageAction;
    newButton: ui.PageAction;
    viewCountsButton: ui.PageAction;
    cancelButton: ui.PageAction;
    createButton: ui.PageAction;
    hiddenShortcutButton: ui.PageAction;
    private _preloadVersion;
    /**
     * Initialize the states of fields on the ADC Count Detail page
     * @param mode - specify whether to be in update or new (aka. create) mode
     * @param productCode - (optional) specify a productCode to refresh and set the state of the specified mode (update or new) based on the productCode's product settings.
     * If you merely switching back to the previous mode, don't specify this parameter to avoid a server-side call
     */
    private _initializePage;
    private _initializeNewBlock;
    private _initializeUpdateBlock;
    private _fetchProductSettings;
    private _mapMultiCountMode;
    private _filterLicensePlateNumber;
    private _onChangeLicensePlateNumber;
    private _onChangeNewPackingUnit;
    private _onChangeLot;
    private _onChangeSublot;
    private _onClickUpdate;
    private _onClickCreate;
    private _validateCount;
    private _getIsTheoreticalQuantityDisplayed;
}
//# sourceMappingURL=mobile-stock-count-detail.d.ts.map