/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/display.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/display.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NotifyAndWait = void 0;\nclass NotifyAndWait {\n    constructor(instance) {\n        this.pageInstance = instance;\n    }\n    async showAndWait(message, type, timeout) {\n        await _notifyAndWait(this.pageInstance, message, type, timeout);\n    }\n    show(message, type, timeout) {\n        _notify(this.pageInstance, message, type, timeout);\n    }\n}\nexports.NotifyAndWait = NotifyAndWait;\nfunction _notifyAndWait(pageInstance, localizedNotificationText, type, timeout) {\n    return new Promise(resolve => {\n        _notify(pageInstance, localizedNotificationText, type, timeout);\n        setTimeout(resolve, timeout);\n    });\n}\nfunction _notify(pageInstance, localizedNotificationText, type, timeout = 5000) {\n    pageInstance.$.showToast(localizedNotificationText, { type: type, timeout });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/display.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-change-by-lpn.ts":
/*!*************************************************!*\
  !*** ./lib/pages/mobile-stock-change-by-lpn.ts ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockChangeByLpn = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_page_values_not_transient_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-page-values-not-transient */ \"../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst stock_control_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/stock-control */ \"../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst display_1 = __webpack_require__(/*! ../client-functions/display */ \"./lib/client-functions/display.ts\");\nlet MobileStockChangeByLpn = class MobileStockChangeByLpn extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._notifier = new display_1.NotifyAndWait(this);\n    }\n    /*\n     *  Init functions\n     */\n    async _init() {\n        await this._readSavedObject();\n        await this._initSite();\n        if (this.stockSite.value) {\n            this._initDestination();\n            await this._initTransaction();\n            this._initStockChangeLines();\n            this._postInitStockChangeLines();\n        }\n        else {\n            this._disablePage();\n        }\n    }\n    _disablePage() {\n        this.effectiveDate.isDisabled = true;\n        this.transaction.isDisabled = true;\n        this.licensePlateNumber.isDisabled = true;\n    }\n    async _initSite() {\n        this.stockSite.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n    }\n    _initDestination() {\n        const destination = this.$.storage.get('mobile-label-destination');\n        if (destination) {\n            this.savedObject.destination = destination;\n        }\n    }\n    async _initTransaction() {\n        let transaction = this.savedObject.selectedTransaction;\n        let hideTransaction = this.savedObject.started;\n        try {\n            this._transactions = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock/StockEntryTransaction')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n                isActive: true,\n                stockAutomaticJournal: { code: false },\n                localizedDescription: true,\n                isLocationChange: true,\n                isStatusChange: true,\n                isUnitChange: false,\n                transactionType: true,\n                identifier1Destination: false,\n                identifier2Destination: false,\n                identifier1Detail: false,\n                identifier2Detail: false,\n                printingMode: true,\n                defaultStockMovementGroup: {\n                    code: true,\n                },\n                stockMovementCode: {\n                    code: true,\n                },\n                companyOrSiteGroup: {\n                    group: true,\n                },\n            }, {\n                filter: {\n                    transactionType: 'stockChange',\n                    isActive: true,\n                    stockChangeDestination: 'internal',\n                    stockChangeAccessMode: { _eq: 'containerNumber' },\n                },\n            }))\n                .execute());\n        }\n        catch (err) {\n            ui.console.error(err);\n        }\n        if (transaction?.code) {\n            if (!this._transactions.some(trs => {\n                return typesLib.strictEq(trs.code, transaction?.code);\n            })) {\n                this.effectiveDate.isDisabled = true;\n                this.transaction.isDisabled = true;\n                this.licensePlateNumber.isDisabled = true;\n                throw new Error('Transaction not authorized, cannot continue');\n            }\n        }\n        else {\n            if (!this._transactions || typesLib.strictEq(this._transactions.length, 0)) {\n                this.effectiveDate.isDisabled = true;\n                this.transaction.isDisabled = true;\n                this.licensePlateNumber.isDisabled = true;\n                throw new Error('No transaction, cannot continue');\n            }\n            else {\n                transaction = this._transactions[0];\n            }\n        }\n        hideTransaction = typesLib.lte(this._transactions.length, 1);\n        this._setTransaction(transaction, hideTransaction, false);\n    }\n    _setTransaction(transaction, hideTransaction = false, disableProduct = true) {\n        if (this._transactions)\n            this.transaction.options = this._transactions?.map(trs => trs.code ?? '') ?? [];\n        this.transaction.value = transaction.code ?? null;\n        this.transaction.isHidden = hideTransaction;\n        this.savedObject = {\n            ...this.savedObject,\n            selectedTransaction: transaction,\n        };\n        this.licensePlateNumber.isDisabled = disableProduct;\n    }\n    async _readSavedObject() {\n        const _storedString = this.$.storage.get('mobile-stockChangeByLpn');\n        if (!_storedString) {\n            this._initStorage();\n        }\n        else {\n            this.savedObject = JSON.parse(_storedString);\n            if (!this._checkStorage()) {\n                await this._reInitStorage();\n            }\n        }\n    }\n    /*\n    storage functions\n    */\n    _checkStorage() {\n        if (!this.savedObject.stockChangeByLpn?.stockChangeLines) {\n            return false;\n        }\n        if (typesLib.strictNe(this.savedObject.username, this.$.userCode)) {\n            return false;\n        }\n        if (!this.savedObject.username) {\n            return false;\n        }\n        return true;\n    }\n    async _reInitStorage() {\n        await this._notifier.showAndWait(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn__notification__storage_error', `An error occurred loading the storage, the page will restart to cleanup`), 'error');\n        this._initStorage();\n        (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockChangeByLpn');\n    }\n    _initStorage() {\n        this.savedObject = {\n            stockChangeByLpn: {\n                id: '',\n                stockChangeLines: new Array(),\n            },\n            currentLine: 0,\n            username: this.$.userCode ?? '',\n            started: false,\n            selectedTransaction: undefined,\n            selectedLicensePlateNumber: undefined,\n        };\n        this._saveStockChangeByLpn(this.savedObject);\n    }\n    _saveStockChangeByLpn(data = this.savedObject) {\n        this.$.storage.set('mobile-stockChangeByLpn', JSON.stringify({ ...data }));\n    }\n    _mapStockChange(change) {\n        let rowCount = 0;\n        return change.map((line) => {\n            var _v;\n            return {\n                _id: String((_v = rowCount, rowCount = typesLib.add(rowCount, 1), _v)), // this defines the rowId parameter in dropdownActions onClick() event\n                licensePlateNumber: line.licensePlateNumber,\n                location: line.location ? `To ${line.location}` : null,\n                status: line.status ? `To ${line.status}` : null,\n                stockSite: this.stockSite.value,\n            };\n        });\n    }\n    _initStockChangeLines() {\n        if (this.savedObject.stockChangeByLpn.stockChangeLines) {\n            this.savedObject.stockChangeByLpn.stockChangeLines =\n                this.savedObject.stockChangeByLpn.stockChangeLines.map((line) => {\n                    return {\n                        ...line,\n                        stockSite: this.stockSite.value ?? undefined,\n                    };\n                });\n        }\n        if (typesLib.gt(Number(this.savedObject.stockChangeByLpn?.stockChangeLines?.length), 0)) {\n            this.stockChangeLinesBlock.isHidden = false;\n            this.transaction.isDisabled = true;\n            this.stockChangeLines.value =\n                this.savedObject.stockChangeByLpn?.stockChangeLines?.map(line => ({\n                    ...line,\n                    _id: this.stockChangeLines.generateRecordId(),\n                })) ?? [];\n            this.stockChangeLines.title = ` ${this.stockChangeLines.title} ${this.stockChangeLines.value.length.toString()}`;\n        }\n    }\n    _postInitStockChangeLines() {\n        if (this.savedObject.stockChangeByLpn.effectiveDate) {\n            this.effectiveDate.value = this.savedObject.stockChangeByLpn.effectiveDate;\n        }\n        else {\n            this.effectiveDate.value = xtrem_date_time_1.DateValue.today().toString();\n        }\n        if (typesLib.gt(Number(this.savedObject.stockChangeByLpn?.stockChangeLines?.length), 0)) {\n            this.createButton.isDisabled = false;\n            //to resynchronize the _id for the delete action\n            this.stockChangeLines.value = this._mapStockChange(this.savedObject.stockChangeByLpn?.stockChangeLines ?? []);\n        }\n    }\n    prepareDataMutation() {\n        const savedObject = this.savedObject;\n        const _selectedTransaction = savedObject?.selectedTransaction;\n        // not swallowing, need a new arrays\n        const _stockChangeLines = this.savedObject.stockChangeByLpn?.stockChangeLines?.map(line => {\n            const _line = {\n                ...line,\n                lineNumber: Number(typesLib.floor(typesLib.mul(Math.random(), xtrem_shared_1.MAX_INT_32))),\n            };\n            delete _line.stockId;\n            delete _line.stockSite;\n            return _line;\n        }) ?? [];\n        const _stockChangeByLpn = {\n            ...savedObject?.stockChangeByLpn,\n            stockChangeDestination: 'internal',\n            ...(this.savedObject?.destination && { destination: this.savedObject.destination }),\n            ...(_selectedTransaction?.stockMovementCode?.code && {\n                stockMovementCode: _selectedTransaction.stockMovementCode.code,\n            }),\n            ...(_selectedTransaction?.defaultStockMovementGroup?.code && {\n                stockMovementGroup: _selectedTransaction.defaultStockMovementGroup.code,\n            }),\n            ...(_selectedTransaction?.code && { transaction: _selectedTransaction.code }),\n            stockChangeLines: _stockChangeLines,\n        };\n        delete _stockChangeByLpn.id;\n        return _stockChangeByLpn ?? {};\n    }\n    async _callCreationAPI() {\n        const _stockChangeByLpnArgs = this.prepareDataMutation();\n        let _result;\n        try {\n            _result = await this.$.graph\n                .node('@sage/x3-stock/StockChangeByLpn')\n                .mutations.stockChangeByLpn({\n                id: true,\n            }, {\n                parameter: _stockChangeByLpnArgs,\n            })\n                .execute();\n            if (!_result) {\n                throw Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change__notification__no_create_results_error', 'No results received for the creation'));\n            }\n        }\n        catch (error) {\n            return error;\n        }\n        return _result;\n    }\n};\nexports.MobileStockChangeByLpn = MobileStockChangeByLpn;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobileStockChangeByLpn.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__createButton____title\", \"Create\"),\n        buttonType: 'primary',\n        isDisabled: true,\n        async onClick() {\n            if (typesLib.gt(Number(this.savedObject?.stockChangeByLpn?.stockChangeLines?.length), 0)) {\n                //to disable the create button\n                this.$.loader.isHidden = false;\n                const result = await this._callCreationAPI();\n                //to enable the create button\n                this.$.loader.isHidden = true;\n                if (!result || result instanceof Error) {\n                    const options = {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                        },\n                        cancelButton: {\n                            text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                        },\n                        size: 'small',\n                        mdContent: true,\n                    };\n                    let message = '';\n                    if (!result?.message) {\n                        message = `${ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                    }\n                    else {\n                        const _messages = [];\n                        const _results = result;\n                        let _diagnoses = _results?.diagnoses;\n                        if (typesLib.gt(_diagnoses?.length, 1)) {\n                            _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                        }\n                        ((_results?.errors\n                            ? _results.errors[0]?.extensions?.diagnoses\n                            : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                                _results.extensions?.diagnoses ??\n                                _diagnoses)) ?? [])\n                            .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                            .forEach((d) => {\n                            const _message = d.message.split(`\\n`);\n                            _messages.push(..._message);\n                        });\n                        const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                        message = `**${ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn__notification__creation_error', 'An error has occurred')}**\\n\\n`;\n                        if (typesLib.strictEq(_result.length, 1)) {\n                            message = typesLib.add(message, `${_result[0]}`);\n                        }\n                        else {\n                            message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                        }\n                    }\n                    await this.$.sound.error();\n                    if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), message, options)) {\n                        await this.$.router.refresh();\n                    }\n                    else {\n                        this.$.storage.remove('mobile-stockChangeByLpn');\n                        await this.$.router.emptyPage();\n                    }\n                }\n                else {\n                    const options = {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                        },\n                    };\n                    this.$.storage.remove('mobile-stockChangeByLpn');\n                    await this.$.sound.success();\n                    await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-stock/dialog-success-title', 'Success'), ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn__notification__creation_success', 'Document no. {{documentId}} created.', { documentId: result.id }), options);\n                    await this.$.router.emptyPage();\n                }\n            }\n            else {\n                // don't want to wait for this one\n                this._notifier.show(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn__notification__no_products_error', `Enter at least one product.`), 'error');\n            }\n        },\n    })\n], MobileStockChangeByLpn.prototype, \"createButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockChangeByLpn.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        width: 'extra-large',\n        isTitleHidden: true,\n    })\n], MobileStockChangeByLpn.prototype, \"firstLineBlock\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__effectiveDate____title\", \"Change date\"),\n        isMandatory: true,\n        width: 'small',\n        maxDate: xtrem_date_time_1.DateValue.today().toString(),\n        onChange() { },\n    })\n], MobileStockChangeByLpn.prototype, \"effectiveDate\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__transaction____title\", \"Transaction\"),\n        //options: ['ALL'],\n        isTransient: true,\n        async onChange() {\n            if (this.transaction.value) {\n                let _theTransaction = this.transaction.value;\n                if (typesLib.strictNe(this.transaction.value.search(':'), 0)) {\n                    const _transaction = this.transaction.value.split(':');\n                    _theTransaction = _transaction[0];\n                }\n                const _transaction = this._transactions.find(trs => typesLib.strictEq(trs.code, _theTransaction)) ?? {};\n                this._setTransaction(_transaction, false, false);\n                await this.$.commitValueAndPropertyChanges();\n                this.transaction.getNextField(true)?.focus();\n            }\n            else {\n                this.licensePlateNumber.isDisabled = true;\n            }\n        },\n    })\n], MobileStockChangeByLpn.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        width: 'extra-large',\n        isTitleHidden: true,\n    })\n], MobileStockChangeByLpn.prototype, \"thirdBlock\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.thirdBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__licensePlateNumber____title\", \"License plate number\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        isTransient: true,\n        canFilter: false,\n        isAutoSelectEnabled: true,\n        isDisabled: false,\n        isFullWidth: true,\n        shouldSuggestionsIncludeColumns: true,\n        filter() {\n            return {\n                _and: [\n                    { isActive: true },\n                    { status: 'inStock' },\n                    { stockSite: { code: this.stockSite.value ?? undefined } },\n                ],\n            };\n        },\n        onChange() {\n            if (this.licensePlateNumber.value?.code) {\n                const lpnIndex = this.savedObject.stockChangeByLpn?.stockChangeLines\n                    ?.map(lpn => lpn.licensePlateNumber)\n                    .indexOf(this.licensePlateNumber.value.code) ?? -1;\n                if (typesLib.strictNe(lpnIndex, -1)) {\n                    this.$.showToast(ui.localize('@sage/x3-stock/notification-error-stock-change-by-lpn-invalid-lpn', 'The lpn is already on the stock change'), { type: 'error' });\n                    return;\n                }\n                else {\n                    const values = (0, get_page_values_not_transient_1.getPageValuesNotTransient)(this);\n                    this.savedObject = {\n                        ...this.savedObject,\n                        stockChangeByLpn: { ...this.savedObject.stockChangeByLpn, ...values },\n                        started: true,\n                        selectedLicensePlateNumber: this.licensePlateNumber.value,\n                    };\n                    this._saveStockChangeByLpn();\n                    (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockChangeByLpnDestination');\n                }\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n        ],\n    })\n], MobileStockChangeByLpn.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLinesBlock____title\", \"LPN in progress\"),\n        width: 'extra-large',\n        isHidden: true,\n    })\n], MobileStockChangeByLpn.prototype, \"stockChangeLinesBlock\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.stockChangeLinesBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLines____title\", \"LPNs:\"),\n        isTransient: true,\n        canSelect: false,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLines____columns__title__product\", \"LPN\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLines____columns__title__location\", \"Location\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLines____columns__title__status\", \"Status\"),\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'delete',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn__stockChangeLines____dropdownActions__title\", \"Delete\"),\n                onClick(rowId) {\n                    const _stockChangeLines = this.savedObject.stockChangeByLpn?.stockChangeLines ?? [];\n                    _stockChangeLines.splice(rowId, 1);\n                    if (!_stockChangeLines.length) {\n                        this._initStorage();\n                        this.createButton.isDisabled = true;\n                        (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockChangeByLpn');\n                    }\n                    else {\n                        this.stockChangeLines.value = this._mapStockChange(_stockChangeLines);\n                        this.stockChangeLines.title = this.stockChangeLines.title?.replace(/\\d/, this.stockChangeLines.value.length.toString());\n                        const values = (0, get_page_values_not_transient_1.getPageValuesNotTransient)(this);\n                        // don't forget to update session storage or deleted lines will reappear if user refreshes the page\n                        this.savedObject = {\n                            ...this.savedObject,\n                            stockChangeByLpn: { ...this.savedObject.stockChangeByLpn, ...values },\n                        };\n                        this._saveStockChangeByLpn();\n                    }\n                },\n            },\n        ],\n        mobileCard: {\n            title: ui.nestedFields.text({\n                bind: 'licensePlateNumber',\n            }),\n            titleRight: ui.nestedFields.text({\n                bind: 'location',\n            }),\n            line2Right: ui.nestedFields.text({\n                bind: 'status',\n            }),\n        },\n    })\n], MobileStockChangeByLpn.prototype, \"stockChangeLines\", void 0);\nexports.MobileStockChangeByLpn = MobileStockChangeByLpn = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn____title\", \"Stock change by LPN\"),\n        mode: 'default',\n        menuItem: stock_control_1.stockControl,\n        priority: 200,\n        isTransient: false,\n        isTitleHidden: true,\n        authorizationCode: 'CWSSCSL',\n        access: { node: '@sage/x3-stock/StockChangeByLpn' },\n        skipDirtyCheck: true,\n        async onLoad() {\n            this.transaction.isDisabled = false;\n            const returnFromDetail = this.$.queryParameters['ReturnFromDetail'];\n            if (typesLib.ne(returnFromDetail, 'yes'))\n                this.$.storage.remove('mobile-stockChangeByLpn');\n            await this._init();\n        },\n        businessActions() {\n            return [this.createButton];\n        },\n    })\n], MobileStockChangeByLpn);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-change-by-lpn.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts":
/*!*****************************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getPageValuesNotTransient = void 0;\n/**\n * Return values not transient for current page\n * @param pageInstance Current page instance\n * @returns array of values not transient\n */\nconst getPageValuesNotTransient = (pageInstance) => {\n    const screenValues = pageInstance.$.values;\n    const keys = Object.keys(screenValues);\n    keys.forEach(elementId => {\n        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];\n        if (properties && properties.isTransient) {\n            delete screenValues[elementId];\n        }\n    });\n    return screenValues;\n};\nexports.getPageValuesNotTransient = getPageValuesNotTransient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2dldC1wYWdlLXZhbHVlcy1ub3QtdHJhbnNpZW50LnRzIiwibWFwcGluZ3MiOiI7OztBQUVBOzs7O0dBSUc7QUFFSSxNQUFNLHlCQUF5QixHQUFHLENBQ3JDLFlBQXFCLEVBQ1osRUFBRTtJQUNYLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO0lBQzNDLE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDdkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtRQUNyQixNQUFNLFVBQVUsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQy9FLElBQUksVUFBVSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN2QyxPQUFPLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNuQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDSCxPQUFPLFlBQVksQ0FBQztBQUN4QixDQUFDLENBQUM7QUFaVyxpQ0FBeUIsNkJBWXBDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvZ2V0LXBhZ2UtdmFsdWVzLW5vdC10cmFuc2llbnQudHM/YTdhNSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaWN0IH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbi8qKlxuICogUmV0dXJuIHZhbHVlcyBub3QgdHJhbnNpZW50IGZvciBjdXJyZW50IHBhZ2VcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgQ3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcmV0dXJucyBhcnJheSBvZiB2YWx1ZXMgbm90IHRyYW5zaWVudFxuICovXG5cbmV4cG9ydCBjb25zdCBnZXRQYWdlVmFsdWVzTm90VHJhbnNpZW50ID0gKFxuICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbik6IERpY3Q8YW55PiA9PiB7XG4gICAgY29uc3Qgc2NyZWVuVmFsdWVzID0gcGFnZUluc3RhbmNlLiQudmFsdWVzO1xuICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhzY3JlZW5WYWx1ZXMpO1xuICAgIGtleXMuZm9yRWFjaChlbGVtZW50SWQgPT4ge1xuICAgICAgICBjb25zdCBwcm9wZXJ0aWVzID0gcGFnZUluc3RhbmNlLl9wYWdlTWV0YWRhdGEudWlDb21wb25lbnRQcm9wZXJ0aWVzW2VsZW1lbnRJZF07XG4gICAgICAgIGlmIChwcm9wZXJ0aWVzICYmIHByb3BlcnRpZXMuaXNUcmFuc2llbnQpIHtcbiAgICAgICAgICAgIGRlbGV0ZSBzY3JlZW5WYWx1ZXNbZWxlbWVudElkXTtcbiAgICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBzY3JlZW5WYWx1ZXM7XG59OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/stock-control.js":
/*!************************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/stock-control.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.stockControl = void 0;\nexports.stockControl = {\n    id: '@sage/x3-stock-data/stock-control-root',\n    priority: 200,\n    title: 'Stock control',\n    icon: 'squares_nine',\n};\n//# sourceMappingURL=stock-control.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcyIsIm1hcHBpbmdzIjoiQUFBYTtBQUNiLDhDQUE2QyxFQUFFLGFBQWEsRUFBQztBQUM3RCxvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ3BCO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvc3RvY2stY29udHJvbC5qcz9kNTQ5Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5zdG9ja0NvbnRyb2wgPSB2b2lkIDA7XG5leHBvcnRzLnN0b2NrQ29udHJvbCA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvc3RvY2stY29udHJvbC1yb290JyxcbiAgICBwcmlvcml0eTogMjAwLFxuICAgIHRpdGxlOiAnU3RvY2sgY29udHJvbCcsXG4gICAgaWNvbjogJ3NxdWFyZXNfbmluZScsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9c3RvY2stY29udHJvbC5qcy5tYXAiXSwibmFtZXMiOltdLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/stock-control.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-change-by-lpn.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;