/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-stock-change-by-lpn-destination.ts":
/*!*************************************************************!*\
  !*** ./lib/pages/mobile-stock-change-by-lpn-destination.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockChangeByLpnDestination = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_page_values_not_transient_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-page-values-not-transient */ \"../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nlet MobileStockChangeByLpnDestination = class MobileStockChangeByLpnDestination extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._currentLine = 0;\n    }\n    /*\n     *  Functions\n     */\n    async _fetchLicensePlateNumber(licensePlateNumberCode) {\n        // read license plate number record\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/LicensePlateNumber')\n            .read({\n            code: true,\n            location: {\n                code: true,\n            },\n            isSingleProduct: true,\n            isSingleLot: true,\n            status: true,\n            container: {\n                code: true,\n            },\n            stockSite: {\n                code: true,\n            },\n        }, `${licensePlateNumberCode}`)\n            .execute();\n        // If an error occurred during the API call\n        if (!response) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__notification__invalid_license_plate_number_error', `Could not retrieve your licensePlateNumber {{ licensePlateNumberCode }}`, {\n                licensePlateNumberCode: licensePlateNumberCode,\n            }));\n        }\n        return response;\n    }\n    async _fetchStockStatuses() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }))\n            .execute());\n        if (!response || typesLib.strictEq(response.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change_destination__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        return response.map((stockStatus) => stockStatus.code);\n    }\n    async _LoadProductLotLpn() {\n        try {\n            const _stocks = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                product: { product: { code: true } },\n                lot: true,\n            }, {\n                filter: { licensePlateNumber: this.licensePlateNumber.value ?? undefined },\n            }))\n                .execute());\n            if (_stocks.length) {\n                this.product.value = _stocks[0].product?.product?.code ? _stocks[0].product.product.code : '';\n                if (this._licensePlateNumber.isSingleLot) {\n                    this.lot.value = _stocks[0].lot ? _stocks[0].lot : '';\n                }\n                else {\n                    this.lot.value = null;\n                }\n            }\n            return;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/error-loading-stock', 'Error loading stock'), String(e));\n            return;\n        }\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('mobile-stockChangeByLpn'));\n    }\n    _createDetail() {\n        const values = (0, get_page_values_not_transient_1.getPageValuesNotTransient)(this);\n        this._currentLine = typesLib.sub(this._stockChangeLines.push(values), 1);\n        this._saveDetail();\n    }\n    _saveDetail() {\n        const currentStockChangeLines = this._stockChangeLines[this._currentLine];\n        this._stockChangeLines[this._currentLine] = {\n            ...currentStockChangeLines,\n        };\n        this._saveStockChange();\n    }\n    _saveStockChange() {\n        const _savedInputs = this._getSavedInputs();\n        _savedInputs.stockChangeByLpn.stockChangeLines = this._stockChangeLines;\n        _savedInputs.currentLine = this._currentLine;\n        const currentLine = _savedInputs.currentLine;\n        _savedInputs.stockChangeByLpn.stockChangeLines[currentLine].licensePlateNumber =\n            this.licensePlateNumber.value ?? undefined;\n        if (!this.statusDestination.isHidden) {\n            _savedInputs.stockChangeByLpn.stockChangeLines[currentLine].status = this.statusDestination.value\n                ? this.statusDestination.value\n                : '';\n        }\n        if (!this.locationDestination.isHidden) {\n            _savedInputs.stockChangeByLpn.stockChangeLines[currentLine].location = this.locationDestination.value\n                ? this.locationDestination.value.code\n                : '';\n        }\n        _savedInputs.stockChangeByLpn.stockChangeLines[currentLine] = {\n            ..._savedInputs.stockChangeByLpn.stockChangeLines[currentLine],\n        };\n        this.$.storage.set('mobile-stockChangeByLpn', JSON.stringify(_savedInputs));\n    }\n    async _fieldChangeTransactionLogic() {\n        const _savedInputs = this._getSavedInputs();\n        const transaction = _savedInputs.selectedTransaction;\n        this.locationDestination.isHidden = !transaction.isLocationChange;\n        this.locationDestination.isMandatory = !transaction.isLocationChange;\n        this.statusDestination.isHidden = !transaction.isStatusChange;\n        this.statusDestination.isMandatory = !transaction.isStatusChange;\n    }\n};\nexports.MobileStockChangeByLpnDestination = MobileStockChangeByLpnDestination;\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__viewStockByLpn____title\", \"View LPN\"),\n        buttonType: 'secondary',\n        isDisabled: false,\n        async onClick() {\n            // this._createDetail();\n            this.$.setPageClean();\n            const stockSite = String(this.stockSite.value);\n            const location = String(this.location.value);\n            const licensePlateNumber = this.licensePlateNumber.value ?? undefined;\n            const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .aggregate.query(ui.queryUtils.edgesSelector({\n                group: {\n                    product: {\n                        product: {\n                            code: true,\n                        },\n                    },\n                },\n            }, {\n                filter: {\n                    stockSite: {\n                        code: stockSite,\n                    },\n                    location: {\n                        code: location,\n                    },\n                    licensePlateNumber: licensePlateNumber,\n                },\n            }))\n                .execute());\n            (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileViewStockByLpnSelectProduct', {\n                licensePlateNumber: licensePlateNumber ?? '',\n                location: location.toString(),\n                distinctProductCount: response.length,\n            });\n        },\n    })\n], MobileStockChangeByLpnDestination.prototype, \"viewStockByLpn\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__nextButton____title\", \"Next\"),\n        buttonType: 'primary',\n        isDisabled: true,\n        onClick() {\n            this._createDetail();\n            (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockChangeByLpn', { ReturnFromDetail: 'yes' });\n        },\n    })\n], MobileStockChangeByLpnDestination.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n        isTitleHidden: true,\n    })\n], MobileStockChangeByLpnDestination.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__locationDestination____title\", \"Destination location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__locationDestination____placeholder\", \"Scan or select...\"),\n        isTransient: true,\n        //isMandatory: true,\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isHidden: true,\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.stockSite.value ?? undefined },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n        },\n        async onChange() {\n            this.nextButton.isDisabled = !this.locationDestination.value;\n            await this.$.commitValueAndPropertyChanges();\n            this.locationDestination.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__locationDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__locationDestination____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileStockChangeByLpnDestination.prototype, \"locationDestination\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__statusDestination____title\", \"Destination status\"),\n        //isMandatory: true,\n        isTransient: true,\n        isHidden: true,\n        onChange() {\n            this.nextButton.isDisabled = !this.statusDestination.value;\n        },\n    })\n], MobileStockChangeByLpnDestination.prototype, \"statusDestination\", void 0);\nexports.MobileStockChangeByLpnDestination = MobileStockChangeByLpnDestination = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination____title\", \"Stock change by LPN\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination____subtitle\", \"Enter destination\"),\n        mode: 'default',\n        isTransient: false,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.licensePlateNumber,\n                titleRight: this.location,\n                line2: this.product,\n                line2Right: this.lot,\n            };\n        },\n        async onLoad() {\n            // TODO: Insert logic here to populate values on the header card based on user inputs from MobileInternalStockChangeByLpn page\n            this.stockSite.value = this.$.storage.get('mobile-selected-stock-site');\n            const _inputStockChangeByLpn = this._getSavedInputs();\n            if (!_inputStockChangeByLpn?.selectedLicensePlateNumber?.code) {\n                this.nextButton.isHidden = true;\n                this.viewStockByLpn.isHidden = true;\n                this.block.isHidden = true;\n                return;\n            }\n            this._stockChangeLines = _inputStockChangeByLpn?.stockChangeByLpn?.stockChangeLines ?? [];\n            //const currentLine = inputStockChangeByLpn.currentLine;\n            this.licensePlateNumber.value = _inputStockChangeByLpn?.selectedLicensePlateNumber?.code ?? null;\n            this._licensePlateNumber = await this._fetchLicensePlateNumber(this.licensePlateNumber.value ?? '');\n            this.location.value = this._licensePlateNumber?.location?.code ?? null;\n            if (this._licensePlateNumber.isSingleProduct) {\n                this._LoadProductLotLpn();\n            }\n            this.statusDestination.options = await this._fetchStockStatuses();\n            await this._fieldChangeTransactionLogic();\n        },\n        businessActions() {\n            return [this.viewStockByLpn, this.nextButton];\n        },\n    })\n], MobileStockChangeByLpnDestination);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-change-by-lpn-destination.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts":
/*!*****************************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getPageValuesNotTransient = void 0;\n/**\n * Return values not transient for current page\n * @param pageInstance Current page instance\n * @returns array of values not transient\n */\nconst getPageValuesNotTransient = (pageInstance) => {\n    const screenValues = pageInstance.$.values;\n    const keys = Object.keys(screenValues);\n    keys.forEach(elementId => {\n        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];\n        if (properties && properties.isTransient) {\n            delete screenValues[elementId];\n        }\n    });\n    return screenValues;\n};\nexports.getPageValuesNotTransient = getPageValuesNotTransient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2dldC1wYWdlLXZhbHVlcy1ub3QtdHJhbnNpZW50LnRzIiwibWFwcGluZ3MiOiI7OztBQUVBOzs7O0dBSUc7QUFFSSxNQUFNLHlCQUF5QixHQUFHLENBQ3JDLFlBQXFCLEVBQ1osRUFBRTtJQUNYLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO0lBQzNDLE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDdkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtRQUNyQixNQUFNLFVBQVUsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQy9FLElBQUksVUFBVSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN2QyxPQUFPLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNuQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDSCxPQUFPLFlBQVksQ0FBQztBQUN4QixDQUFDLENBQUM7QUFaVyxpQ0FBeUIsNkJBWXBDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvZ2V0LXBhZ2UtdmFsdWVzLW5vdC10cmFuc2llbnQudHM/YTdhNSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaWN0IH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbi8qKlxuICogUmV0dXJuIHZhbHVlcyBub3QgdHJhbnNpZW50IGZvciBjdXJyZW50IHBhZ2VcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgQ3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcmV0dXJucyBhcnJheSBvZiB2YWx1ZXMgbm90IHRyYW5zaWVudFxuICovXG5cbmV4cG9ydCBjb25zdCBnZXRQYWdlVmFsdWVzTm90VHJhbnNpZW50ID0gKFxuICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbik6IERpY3Q8YW55PiA9PiB7XG4gICAgY29uc3Qgc2NyZWVuVmFsdWVzID0gcGFnZUluc3RhbmNlLiQudmFsdWVzO1xuICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhzY3JlZW5WYWx1ZXMpO1xuICAgIGtleXMuZm9yRWFjaChlbGVtZW50SWQgPT4ge1xuICAgICAgICBjb25zdCBwcm9wZXJ0aWVzID0gcGFnZUluc3RhbmNlLl9wYWdlTWV0YWRhdGEudWlDb21wb25lbnRQcm9wZXJ0aWVzW2VsZW1lbnRJZF07XG4gICAgICAgIGlmIChwcm9wZXJ0aWVzICYmIHByb3BlcnRpZXMuaXNUcmFuc2llbnQpIHtcbiAgICAgICAgICAgIGRlbGV0ZSBzY3JlZW5WYWx1ZXNbZWxlbWVudElkXTtcbiAgICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBzY3JlZW5WYWx1ZXM7XG59OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-change-by-lpn-destination.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;