/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-stock-change-by-identifier-destination.ts":
/*!********************************************************************!*\
  !*** ./lib/pages/mobile-stock-change-by-identifier-destination.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockChangeByIdentifierDestination = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nlet MobileStockChangeByIdentifierDestination = class MobileStockChangeByIdentifierDestination extends ui.Page {\n    async _getStockStatuses() {\n        try {\n            return (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/StockStatus')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }))\n                .execute()).map((status) => status.code);\n        }\n        catch (err) {\n            this.$.dialog.message('error', ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__notification__invalid_stock_status_error', 'No stock status'), String(err));\n            return [''];\n        }\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('mobile-stockChangeByIdentifier'));\n    }\n    _saveStockChange() {\n        const _savedInputs = this._getSavedInputs();\n        const _stockChangeLines = _savedInputs?.stockChange?.stockChangeLines;\n        if (_stockChangeLines) {\n            const _status = !this.statusDestination.isHidden ? this.statusDestination.value ?? undefined : undefined;\n            const _location = !this.locationDestination.isHidden\n                ? this.locationDestination.value?.code\n                : undefined;\n            _stockChangeLines.forEach(_ => {\n                // For transaction card display only\n                if (_status) {\n                    _.statusDestination = _status;\n                }\n                if (_location) {\n                    _.locationDestination = _location;\n                }\n                // For transaction herself\n                _?.stockDetails?.forEach(_stockDetail => {\n                    if (_status) {\n                        _stockDetail.status = _status;\n                    }\n                    if (_location) {\n                        _stockDetail.location = _location;\n                    }\n                });\n            });\n            this.$.storage.set('mobile-stockChangeByIdentifier', JSON.stringify(_savedInputs));\n        }\n    }\n    async _DisplayFieldsByTransaction() {\n        const _transaction = this._getSavedInputs()?.selectedTransaction;\n        this.locationDestination.isHidden = _transaction ? !_transaction.isLocationChange : true;\n        this.statusDestination.isHidden = _transaction ? !_transaction.isStatusChange : true;\n    }\n};\nexports.MobileStockChangeByIdentifierDestination = MobileStockChangeByIdentifierDestination;\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__nextButton____title\", \"Next\"),\n        buttonType: 'primary',\n        shortcut: ['f3'],\n        isDisabled: true,\n        async onClick() {\n            if (!(await (0, control_1.validateWithDetails)(this)))\n                return;\n            this._saveStockChange();\n            (0, on_goto_1.onGoto)(this, '@sage/x3-stock/MobileStockChangeByIdentifier', {\n                ReturnFromDetail: 'yes',\n                locationDestination: !this.locationDestination.isHidden && this.locationDestination.value?.code,\n                statusDestination: !this.statusDestination.isHidden && this.statusDestination.value,\n            });\n        },\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n        isTitleHidden: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"_site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"_identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"_identifier2\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"_identifier3\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__locationDestination____title\", \"Destination location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__locationDestination____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        isHidden: false,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this._site.value },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            const _stockChangeLines = this._getSavedInputs()?.stockChange?.stockChangeLines;\n            let _sameLocationOrStatus = false;\n            if (this.locationDestination.value?.code) {\n                if (_stockChangeLines) {\n                    _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                        return _.stockDetails?.some(_stockDetail => {\n                            return typesLib.strictEq(_stockDetail.location, this.locationDestination.value?.code);\n                        });\n                    });\n                    if (this.statusDestination?.value && _sameLocationOrStatus) {\n                        _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                            return _.stockDetails?.some(_stockDetail => {\n                                return typesLib.strictEq(_stockDetail.status, this.statusDestination.value);\n                            });\n                        });\n                    }\n                    if (!_sameLocationOrStatus) {\n                        await this.$.commitValueAndPropertyChanges();\n                        this.nextButton.isDisabled = !this.locationDestination.value;\n                        this.locationDestination.getNextField(true)?.focus();\n                    }\n                    else {\n                        this.$.showToast(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__notification__invalid_stock_location_destination__error', 'The destination location code and the original destination code are the same: {{ code }}.', { code: this.locationDestination?.value?.code }), { type: 'error' });\n                        this.locationDestination.focus();\n                        this.nextButton.isDisabled = true;\n                        return;\n                    }\n                }\n            }\n            else {\n                if (_stockChangeLines && this.statusDestination.value) {\n                    if (this.statusDestination?.value) {\n                        _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                            return _.stockDetails?.some(_stockDetail => {\n                                return typesLib.strictEq(_stockDetail.status, this.statusDestination.value);\n                            });\n                        });\n                    }\n                }\n                this.nextButton.isDisabled = !(this.statusDestination.value && !_sameLocationOrStatus);\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__locationDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__locationDestination____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"locationDestination\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__statusDestination____title\", \"Destination status\"),\n        isMandatory: false,\n        isTransient: true,\n        isHidden: false,\n        async onChange() {\n            const _stockChangeLines = this._getSavedInputs()?.stockChange?.stockChangeLines;\n            let _sameLocationOrStatus = false;\n            if (this.statusDestination.value) {\n                if (_stockChangeLines) {\n                    _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                        return _.stockDetails?.some(_stockDetail => {\n                            return typesLib.strictEq(_stockDetail.status, this.statusDestination.value);\n                        });\n                    });\n                    if (this.locationDestination.value?.code && _sameLocationOrStatus) {\n                        _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                            return _.stockDetails?.some(_stockDetail => {\n                                return typesLib.strictEq(_stockDetail.location, this.locationDestination.value?.code);\n                            });\n                        });\n                    }\n                    if (!_sameLocationOrStatus) {\n                        await this.$.commitValueAndPropertyChanges();\n                        this.nextButton.isDisabled = !this.statusDestination.value;\n                    }\n                    else {\n                        this.$.showToast(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination__notification__invalid_stock_status_destination__error', 'The destination status code and the original destination code are the same: {{ status }}.', { status: this.statusDestination.value }), { type: 'error' });\n                        this.statusDestination.focus();\n                        this.nextButton.isDisabled = true;\n                        return;\n                    }\n                }\n            }\n            else {\n                if (_stockChangeLines && this.locationDestination.value?.code) {\n                    _sameLocationOrStatus = _stockChangeLines.some(_ => {\n                        return _.stockDetails?.some(_stockDetail => {\n                            return typesLib.strictEq(_stockDetail.location, this.locationDestination.value?.code);\n                        });\n                    });\n                }\n                this.nextButton.isDisabled = !(this.locationDestination.value && !_sameLocationOrStatus);\n            }\n        },\n    })\n], MobileStockChangeByIdentifierDestination.prototype, \"statusDestination\", void 0);\nexports.MobileStockChangeByIdentifierDestination = MobileStockChangeByIdentifierDestination = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination____title\", \"Stock change\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_stock_change_by_identifier_destination____subtitle\", \"Enter destination\"),\n        mode: 'default',\n        isTransient: false,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this._identifier1,\n                line2: this._identifier2,\n                line3: this._identifier3,\n            };\n        },\n        async onLoad() {\n            const _siteCode = this.$.storage.get('mobile-selected-stock-site');\n            const identifierValues = this.$.queryParameters.identifierValues.split(',', 3);\n            if (typesLib.gt(identifierValues.length, 0)) {\n                this._identifier1.value = identifierValues[0];\n            }\n            if (typesLib.gt(identifierValues.length, 1)) {\n                this._identifier2.value = identifierValues[1];\n            }\n            if (typesLib.gt(identifierValues.length, 2)) {\n                this._identifier3.value = identifierValues[2];\n            }\n            this._site.value = _siteCode;\n            await this._DisplayFieldsByTransaction();\n            this.statusDestination.options = await this._getStockStatuses();\n        },\n        businessActions() {\n            return [this.nextButton];\n        },\n    })\n], MobileStockChangeByIdentifierDestination);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-stock-change-by-identifier-destination.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-stock-change-by-identifier-destination.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;