/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-putaway-todo.ts":
/*!******************************************!*\
  !*** ./lib/pages/mobile-putaway-todo.ts ***!
  \******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePutawayTodo = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_decimal_2 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nlet MobilePutawayTodo = class MobilePutawayTodo extends ui.Page {\n};\nexports.MobilePutawayTodo = MobilePutawayTodo;\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isHidden: false,\n    })\n], MobilePutawayTodo.prototype, \"_storageListNumber\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePutawayTodo.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobilePutawayTodo.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        node: '@sage/x3-stock/StorageDetails',\n        isTransient: true,\n        isFullWidth: true,\n        isTitleHidden: false,\n        canFilter: false,\n        canSelect: false,\n        canExport: false,\n        canUserHideColumns: false,\n        hasSearchBoxMobile: true,\n        orderBy: {\n            // this needed because additional rows may be created in a transient matter for product that is receivedIssued serial managed\n            stockId: +1,\n            documentType: +1,\n            documentNumber: +1,\n            documentLineNumber: +1,\n            storageSequenceNumber: +1,\n            startingSerialNumber: +1,\n        },\n        onRowClick(rowId, rowItem) {\n            this.$.storage.set(this.$.page.id, JSON.stringify({\n                ...rowItem,\n                storageListNumber: this.$.queryParameters.storageListNumber,\n                storageSite: {\n                    code: this.$.queryParameters.site,\n                },\n            }));\n            this.$.router.goTo('@sage/x3-stock/MobilePutawayDetail', {\n                stockTransaction: this._stockTransaction,\n                totalCount: this.lines.value.length,\n            });\n        },\n        columns: [\n            ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { product: { upc: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            ui.nestedFields.text({\n                bind: 'quantityInPackingUnitFormatted',\n                postfix(v, rowValue) {\n                    return rowValue.packingUnit.code;\n                },\n            }),\n            ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { location: { code: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: '_id',\n            }),\n        ],\n        cardView: true,\n        mobileCard: {\n            title: ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { product: { code: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            titleRight: ui.nestedFields.text({\n                bind: 'quantityInPackingUnitFormatted',\n                postfix(v, rowValue) {\n                    return rowValue.packingUnit.code;\n                },\n            }),\n            line2: ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { product: { localizedDescription1: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            line2Right: ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { product: { upc: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            line3: ui.nestedFields.reference({\n                bind: 'storage',\n                valueField: { location: { code: true } },\n                node: '@sage/x3-stock/Storage',\n            }),\n            line3Right: ui.nestedFields.text({\n                bind: 'startingSerialNumber',\n                isReadOnly: true,\n                isHidden(value) {\n                    return !value;\n                },\n            }),\n        },\n    })\n], MobilePutawayTodo.prototype, \"lines\", void 0);\nexports.MobilePutawayTodo = MobilePutawayTodo = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_todo____title\", \"Putaway\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_putaway_todo____subtitle\", \"Select a product\"),\n        isTitleHidden: true,\n        isTransient: true,\n        mode: 'default',\n        skipDirtyCheck: true,\n        async onLoad() {\n            if (!this.$.queryParameters.site ||\n                !this.$.queryParameters.storageListNumber ||\n                !this.$.queryParameters.stockTransaction) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-error-missing-params', 'Missing required parameters'), { type: 'error' });\n                this.$.router.goTo('@sage/x3-stock/MobilePutaway');\n                return;\n            }\n            this._stockTransaction = this.$.queryParameters.stockTransaction;\n            this._storageListNumber.value = this.$.queryParameters.storageListNumber;\n            this.lines.value = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock/StorageDetails')\n                .query(ui.queryUtils.edgesSelector({\n                _id: true,\n                stockId: true,\n                documentType: true,\n                documentNumber: true,\n                documentLineNumber: true,\n                storageSequenceNumber: true,\n                packingUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                quantityInPackingUnit: true,\n                packingUnitToStockUnitConversionFactor: true,\n                status: {\n                    code: true,\n                    description: true,\n                    shortDescription: true,\n                    localizedShortDescription: true,\n                },\n                location: {\n                    code: true, // to location\n                    type: true,\n                },\n                lot: true,\n                sublot: true,\n                startingSerialNumber: true,\n                endingSerialNumber: true,\n                licensePlateNumber: {\n                    code: true,\n                    status: true,\n                    location: {\n                        code: true,\n                    },\n                    container: {\n                        code: true,\n                    },\n                },\n                storage: {\n                    product: {\n                        code: true,\n                        localizedDescription1: true,\n                        lotManagementMode: true, // whether sub/lot should be displayed\n                        lotSequenceNumber: true, // whether lot should be optional\n                        serialNumberManagementMode: true, // whether serial should be displayed\n                        serialSequenceNumber: true, // whether serial should be optional\n                        productSites: {\n                            query: {\n                                edges: {\n                                    node: {\n                                        isLicensePlateNumberManaged: true, // whether LPN & Container should be displayed\n                                    },\n                                },\n                                __args: {\n                                    filter: JSON.stringify({\n                                        stockSite: {\n                                            code: this.$.queryParameters.site,\n                                        },\n                                    }),\n                                },\n                            },\n                        },\n                        upc: true,\n                    },\n                    status: {\n                        code: true,\n                    },\n                    location: {\n                        code: true, // from location\n                    },\n                },\n            }, {\n                filter: {\n                    storageListNumber: this.$.queryParameters.storageListNumber,\n                    storageSite: {\n                        code: this.$.queryParameters.site,\n                    },\n                },\n                first: 1000,\n            }))\n                .execute()).reduce((previousValue, currentValue) => {\n                if (typesLib.strictNe(currentValue.storage.product.serialNumberManagementMode, 'receivedIssued') ||\n                    !currentValue.startingSerialNumber ||\n                    !currentValue.endingSerialNumber || typesLib.lte(Number(currentValue.quantityInPackingUnit), 1)) {\n                    previousValue.push({\n                        ...currentValue,\n                        // to format quantityInPackingUnit based on unit of measure's number of decimals\n                        quantityInPackingUnitFormatted: typesLib.strictEq(currentValue.packingUnit.numberOfDecimals, 0) ? currentValue.quantityInPackingUnit\n                            : xtrem_decimal_2.Decimal.make(currentValue.quantityInPackingUnit)\n                                .toDecimalPlaces(currentValue.packingUnit.numberOfDecimals)\n                                .toString(),\n                        _id: `${currentValue.storage.product.code}!${currentValue.storage.product.localizedDescription1}!${currentValue.storage.product.upc}!${currentValue.storage.location.code}!${currentValue.packingUnit.code}!${currentValue.startingSerialNumber}!${currentValue._id}`,\n                    }); // TODO Issue: Have to use 'any' to allow custom formatting\n                }\n                else {\n                    const totalQuantity = Number(currentValue.quantityInPackingUnit);\n                    let index = 0;\n                    let currSerialNumber = currentValue.startingSerialNumber;\n                    do {\n                        // TODO Issue: Have to use 'any' to allow custom formatting\n                        const shallowCopy = { ...currentValue }; // Only need to modify quantity, starting, & ending serial number, while the rest should be the same. So a 'spread' copy should suffice + the user can only update one line at a time\n                        shallowCopy._id = this.lines.generateRecordId();\n                        shallowCopy.quantityInPackingUnit = String(1);\n                        shallowCopy.quantityInPackingUnitFormatted = String(1);\n                        shallowCopy.startingSerialNumber = shallowCopy.endingSerialNumber = currSerialNumber;\n                        previousValue.push(shallowCopy);\n                    } while (typesLib.lt((index = typesLib.add(index, 1)), totalQuantity) &&\n                        (currSerialNumber = currSerialNumber.replace(/\\d+$/, match => {\n                            return (typesLib.add(Number(match), 1)).toString().padStart(match.length, '0');\n                        })));\n                }\n                return previousValue;\n            }, []);\n            // To handle some extreme, but rare scenarios of being routed to this page, yet at this time there are no more lines to process for this storage list #\n            if (typesLib.strictEq(this.lines.value.length, 0)) {\n                this.$.showToast(ui.localize('@sage/x3-stock/notification-warning-no-storage-lines', 'No more lines to process for {{code}} ', { code: this._storageListNumber.value }), { type: 'warning', timeout: 30000 });\n                this.$.router.goTo('@sage/x3-stock/MobilePutaway');\n            }\n        },\n        headerCard() {\n            return {\n                title: this._storageListNumber,\n            };\n        },\n    })\n], MobilePutawayTodo);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-putaway-todo.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-putaway-todo.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;