/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/control.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/control.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.controlLotReceipt = exports.renumberStockCountList = exports.validateWithDetails = exports.validatePage = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nfunction validate(pageInstance, isPageValid, fieldsData) {\n    const fieldErrors = new Array();\n    let areAllFieldsValid = true;\n    fieldsData.forEach(field => {\n        if (!_validateField(field)) {\n            areAllFieldsValid = false;\n            fieldErrors.push(field.fieldName ?? '');\n        }\n    });\n    if (typesLib.gte(fieldErrors.length, 1))\n        _notifyFieldNotValid(pageInstance, fieldErrors);\n    return isPageValid && areAllFieldsValid;\n}\nexports.validate = validate;\nfunction _validateField(data) {\n    return !data.validate ? true : false;\n}\nfunction _notifyFieldNotValid(pageInstance, fields) {\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fields.map(field => pageInstance[field].title) }), { type: 'error', timeout: 5000 });\n}\nasync function validatePage(pageInstance) {\n    const errors = await pageInstance.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(`${ui.localize('@sage/x3-stock/notification-validation-error', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validatePage = validatePage;\nasync function validateWithDetails(pageInstance) {\n    // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n    await pageInstance.$.commitValueAndPropertyChanges();\n    const errors = await pageInstance.$.page.validateWithDetails();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    pageInstance.$.removeToasts();\n    pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__utils__notification__invalid_inputs_error', `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, {\n        // TODO: Issue: Perhaps a better way in Typescript to dynamically retrieve a page's components rather than to cast it to 'any' type\n        fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n    }), { type: 'error', timeout: 5000 });\n    return false;\n}\nexports.validateWithDetails = validateWithDetails;\n// Decision made to not present an error to the user if one occurs during renumbering\nasync function renumberStockCountList(stockCountSessionNumber, stockCountListNumber, page) {\n    try {\n        const _renumberListArgs = {\n            stockCountSessionNumber: stockCountSessionNumber,\n            stockCountListNumber: stockCountListNumber,\n        };\n        await page.$.graph\n            .node('@sage/x3-stock/StockCountListDetail')\n            .mutations.renumberCountList({\n            stockCountSessionNumber: true,\n            stockCountListNumber: true,\n        }, {\n            parameters: _renumberListArgs,\n        })\n            .execute();\n    }\n    catch (e) {\n        ui.console.error(`renumberCountList :\\n${JSON.stringify(e)}`);\n    }\n}\nexports.renumberStockCountList = renumberStockCountList;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock/StockJournal')\n        .query(ui.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast(ui.localize('@sage/x3-stock/notification-error-receipt-lot', 'The lot number {{ lot }} already exists for this product.', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/control.ts\n");

/***/ }),

/***/ "./lib/client-functions/defaultValue.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/defaultValue.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.useByDateDefaultValue = exports.expirationDateDefaultValue = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\n/**\n * Return the default value corresponding to the product rule for the expiry date\n * @param product\n * @param effectiveDate\n * @return\n */\nfunction expirationDateDefaultValue(productExpirationManagement, productExpirationLeadTime, productExpirationLeadTimeUnit, effectiveDate) {\n    let _tmpDate = effectiveDate ? xtrem_date_time_1.date.parse(effectiveDate) : null;\n    let expiryDate;\n    if (typesLib.strictEq(_tmpDate, null))\n        return null;\n    if (typesLib.strictNe(productExpirationManagement, null)) {\n        // Check if the product is not managed in expiration mode\n        if (typesLib.strictEq(productExpirationManagement, 'notManaged') || typesLib.strictEq(productExpirationManagement, 'manualEntry')) {\n            // returns 2999-12-31\n            //expiryDate = date.make(2999, 12, 31);\n            return null;\n        }\n        else {\n            expiryDate = null;\n            if (typesLib.strictEq(productExpirationLeadTimeUnit, 'calendarDays')) {\n                // the expiry date is effectiveDate + expirationLeadTime duration value in days\n                expiryDate = _tmpDate.addDays(productExpirationLeadTime);\n            }\n            // Check if expiration time unit is months\n            if (typesLib.strictEq(productExpirationLeadTimeUnit, 'month')) {\n                // the expiry date is effectiveDate + expirationLeadTime in months\n                expiryDate = _tmpDate.addMonths(productExpirationLeadTime);\n            }\n            if (typesLib.strictEq(productExpirationManagement, 'roundingMonthEnd') || typesLib.strictEq(productExpirationManagement, 'roundingBeginningMonth1')) {\n                // Check if the product expiration mode indicate a rounding rule\n                if (typesLib.strictEq(productExpirationManagement, 'roundingMonthEnd')) {\n                    // if the rounding rule is month end\n                    expiryDate = _tmpDate.endOfMonth();\n                }\n                else if (typesLib.strictEq(productExpirationManagement, 'roundingBeginningMonth1')) {\n                    // if the rounding rule is next month begin\n                    expiryDate = _tmpDate.begOfMonth().addMonths(1);\n                }\n            }\n        }\n    }\n    else {\n        return null;\n    }\n    // if none of the above conditions are met:\n    return expiryDate ? expiryDate.format('YYYY-MM-DD') : null;\n}\nexports.expirationDateDefaultValue = expirationDateDefaultValue;\nfunction useByDateDefaultValue(expirationDate, referenceDate, productExpirationManagement, useByDateCoefficient) {\n    let _tmpExpirationDate = expirationDate ? xtrem_date_time_1.date.parse(expirationDate) : null;\n    let _tmpReferenceDate = referenceDate ? xtrem_date_time_1.date.parse(referenceDate) : null;\n    let useByDate;\n    if (typesLib.strictEq(_tmpExpirationDate, null) && typesLib.strictEq(_tmpReferenceDate, null))\n        return null;\n    if (typesLib.strictNe(productExpirationManagement, null)) {\n        // Check if the product is not managed in expiration mode\n        if (typesLib.strictEq(productExpirationManagement, 'notManaged') || typesLib.strictEq(productExpirationManagement, 'manualEntry')) {\n            return null;\n        }\n        if (typesLib.gt(useByDateCoefficient, 1) || typesLib.strictEq(useByDateCoefficient, 0) || typesLib.lt(useByDateCoefficient, 0)) {\n            useByDateCoefficient = 1;\n        }\n        if (_tmpExpirationDate) {\n            if (_tmpReferenceDate && typesLib.gt(_tmpExpirationDate, _tmpReferenceDate)) {\n                const delay = typesLib.round(typesLib.mul(useByDateCoefficient, _tmpExpirationDate.daysDiff(_tmpReferenceDate)));\n                useByDate = _tmpReferenceDate.addDays(delay);\n            }\n            else {\n                useByDate = _tmpExpirationDate;\n            }\n        }\n        else {\n            return null;\n        }\n    }\n    else {\n        return null;\n    }\n    return useByDate.format('YYYY-MM-DD');\n}\nexports.useByDateDefaultValue = useByDateDefaultValue;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/defaultValue.ts\n");

/***/ }),

/***/ "./lib/client-functions/display.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/display.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NotifyAndWait = void 0;\nclass NotifyAndWait {\n    constructor(instance) {\n        this.pageInstance = instance;\n    }\n    async showAndWait(message, type, timeout) {\n        await _notifyAndWait(this.pageInstance, message, type, timeout);\n    }\n    show(message, type, timeout) {\n        _notify(this.pageInstance, message, type, timeout);\n    }\n}\nexports.NotifyAndWait = NotifyAndWait;\nfunction _notifyAndWait(pageInstance, localizedNotificationText, type, timeout) {\n    return new Promise(resolve => {\n        _notify(pageInstance, localizedNotificationText, type, timeout);\n        setTimeout(resolve, timeout);\n    });\n}\nfunction _notify(pageInstance, localizedNotificationText, type, timeout = 5000) {\n    pageInstance.$.showToast(localizedNotificationText, { type: type, timeout });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/display.ts\n");

/***/ }),

/***/ "./lib/client-functions/get-product-site.ts":
/*!**************************************************!*\
  !*** ./lib/client-functions/get-product-site.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getProductSite = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function getProductSite(pageInstance, productCode, siteCode, storageProductSite) {\n    if (!storageProductSite) {\n        // read product site record\n        const productSiteToReceive = await pageInstance.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .read({\n            stockSite: { code: true },\n            isLocationManaged: true,\n            isLicensePlateNumberManaged: true,\n            defaultInternalContainer: {\n                code: true,\n            },\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n            product: {\n                code: true,\n                localizedDescription1: true,\n                productCategory: {\n                    code: true,\n                },\n                lotManagementMode: true,\n                serialNumberManagementMode: true,\n                stockVersionMode: true,\n                expirationManagementMode: true,\n                serialSequenceNumber: true,\n                lotSequenceNumber: true,\n                stockManagementMode: true,\n                defaultPotencyInPercentage: true,\n                expirationLeadTime: true,\n                expirationTimeUnit: true,\n                useByDateCoefficient: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${productCode}|${siteCode}`)\n            .execute();\n        // If an error occurred during the API call\n        if (!productSiteToReceive) {\n            pageInstance.$.showToast(ui.localize('@sage/x3-stock/pages__miscellaneous_receipt_details__notification__invalid_product_site_error', `Could not retrieve your product {{ productCode }} for the site {{ siteCode }}`, {\n                productCode: productCode,\n                siteCode: siteCode,\n            }), {\n                type: 'error',\n                timeout: 5000,\n            });\n            return pageInstance.$.router.goTo('@sage/x3-stock/MobileMiscellaneousReceipt', {\n                ReturnFromDetail: 'yes',\n            });\n        }\n        return productSiteToReceive;\n    }\n    else {\n        pageInstance.$.storage.remove('productSite');\n        return JSON.parse(storageProductSite);\n    }\n}\nexports.getProductSite = getProductSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/get-product-site.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-stock/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-miscellaneous-receipt-details.ts":
/*!***********************************************************!*\
  !*** ./lib/pages/mobile-miscellaneous-receipt-details.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileMiscellaneousReceiptDetails = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_page_values_not_transient_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-page-values-not-transient */ \"../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst control_1 = __webpack_require__(/*! ../client-functions/control */ \"./lib/client-functions/control.ts\");\nconst defaultValue_1 = __webpack_require__(/*! ../client-functions/defaultValue */ \"./lib/client-functions/defaultValue.ts\");\nconst display_1 = __webpack_require__(/*! ../client-functions/display */ \"./lib/client-functions/display.ts\");\nconst get_product_site_1 = __webpack_require__(/*! ../client-functions/get-product-site */ \"./lib/client-functions/get-product-site.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\n/** Created with X3 Etna Studio at 2020-01-20T10:46:11.764Z */\nlet MobileMiscellaneousReceiptDetails = class MobileMiscellaneousReceiptDetails extends ui.Page {\n    constructor() {\n        /*\n         *\n         *  Technical properties\n         *\n         */\n        super(...arguments);\n        this._currentLine = 0;\n        this._effectiveDate = xtrem_date_time_1.DateValue.today().toString();\n        this._newDetail = false;\n        this._notifier = new display_1.NotifyAndWait(this);\n    }\n    async _fieldsData(validateField) {\n        return [\n            {\n                fieldIsHidden: this.packingUnit.isHidden ?? false,\n                fieldValue: this.packingUnit.value,\n                fieldName: 'packingUnit',\n                validate: validateField ? await this.packingUnit.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.quantityInPackingUnit.isHidden ?? false,\n                fieldValue: this.quantityInPackingUnit.value,\n                fieldName: 'quantityInPackingUnit',\n                validate: validateField ? await this.quantityInPackingUnit.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.packingUnitToStockUnitConversionFactor.isHidden ?? false,\n                fieldValue: this.packingUnitToStockUnitConversionFactor.value,\n                fieldName: 'packingUnitToStockUnitConversionFactor',\n                validate: validateField ? await this.packingUnitToStockUnitConversionFactor.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.status.isHidden ?? false,\n                fieldValue: this.status.value,\n                fieldName: 'status',\n                validate: validateField ? await this.status.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.licensePlateNumber.isHidden ?? false,\n                fieldValue: this.licensePlateNumber.value,\n                fieldName: 'licensePlateNumber',\n                validate: validateField ? await this.licensePlateNumber.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.container.isHidden ?? false,\n                fieldValue: this.container.value,\n                fieldName: 'container',\n                validate: validateField ? await this.container.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.location.isHidden ?? false,\n                fieldValue: this.location.value,\n                fieldName: 'location',\n                validate: validateField ? await this.location.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.serialNumber.isHidden ?? false,\n                fieldValue: this.serialNumber.value,\n                fieldName: 'serialNumber',\n                validate: validateField ? await this.serialNumber.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.supplierLot.isHidden ?? false,\n                fieldValue: this.supplierLot.value,\n                fieldName: 'supplierLot',\n                validate: validateField ? await this.supplierLot.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.lot.isHidden ?? false,\n                fieldValue: this.lot.value,\n                fieldName: 'lot',\n                validate: validateField ? await this.lot.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.sublot.isHidden ?? false,\n                fieldValue: this.sublot.value,\n                fieldName: 'sublot',\n                validate: validateField ? await this.sublot.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.majorVersion.isHidden ?? false,\n                fieldValue: this.majorVersion.value,\n                fieldName: 'majorVersion',\n                validate: validateField ? await this.majorVersion.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.minorVersion.isHidden ?? false,\n                fieldValue: this.minorVersion.value,\n                fieldName: 'minorVersion',\n                validate: validateField ? await this.minorVersion.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.potency.isHidden ?? false,\n                fieldValue: this.potency.value,\n                fieldName: 'potency',\n                validate: validateField ? await this.potency.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.expirationDate.isHidden ?? false,\n                fieldValue: this.expirationDate.value,\n                fieldName: 'expirationDate',\n                validate: validateField ? await this.expirationDate.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.lotCustomField1.isHidden ?? false,\n                fieldValue: this.lotCustomField1.value,\n                fieldName: 'lotCustomField1',\n                validate: validateField ? await this.lotCustomField1.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.lotCustomField2.isHidden ?? false,\n                fieldValue: this.lotCustomField2.value,\n                fieldName: 'lotCustomField2',\n                validate: validateField ? await this.lotCustomField2.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.lotCustomField3.isHidden ?? false,\n                fieldValue: this.lotCustomField3.value,\n                fieldName: 'lotCustomField3',\n                validate: validateField ? await this.lotCustomField3.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.lotCustomField4.isHidden ?? false,\n                fieldValue: this.lotCustomField4.value,\n                fieldName: 'lotCustomField4',\n                validate: validateField ? await this.lotCustomField4.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.identifier1.isHidden ?? false,\n                fieldValue: this.identifier1.value,\n                fieldName: 'identifier1',\n                validate: validateField ? await this.identifier1.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.identifier2.isHidden ?? false,\n                fieldValue: this.identifier2.value,\n                fieldName: 'identifier2',\n                validate: validateField ? await this.identifier2.validate() : undefined,\n            },\n            {\n                fieldIsHidden: this.useByDate.isHidden ?? false,\n                fieldValue: this.useByDate.value,\n                fieldName: 'useByDate',\n                validate: validateField ? await this.useByDate.validate() : undefined,\n            },\n        ];\n    }\n    /*\n     *\n     *  Init functions\n     *\n     */\n    async _init() {\n        const storageProductSite = this.$.storage.get('productSite');\n        this._isPageActive = true;\n        this._miscellaneousReceiptLines = this._getSavedInputs().miscellaneousReceipt.miscellaneousReceiptLines ?? [];\n        this._initSiteCodeField();\n        this._isLocationPreloaded = typesLib.strictEq(this.$.queryParameters['isLocationPreloaded'], '1') ? true : false;\n        this._productSite = await (0, get_product_site_1.getProductSite)(this, this.$.queryParameters['productSite'], this.site.value, storageProductSite);\n        this._initmiscellaneousReceiptLines(!!storageProductSite);\n        await this._initDirty();\n        this._initTechnicalProperties();\n        this._fieldsManagement();\n        this._selectedStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(this.site.value ?? '', this._productSite.product.productCategory.code, '1', this._selectedTransaction.stockMovementCode?.code ?? null, this);\n        this._miscellaneousFieldsManagement();\n    }\n    async _initDirty(forceDirty = false) {\n        let isDirty = forceDirty || typesLib.gt((this._getSavedInputs()?.miscellaneousReceipt?.miscellaneousReceiptLines ?? []).length, 0);\n        // Ignore empty new row\n        if (isDirty) {\n            this.product.isDirty = true;\n        }\n        return isDirty;\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('miscellaneousReceipt'));\n    }\n    _initmiscellaneousReceiptLines(newDetail = false) {\n        if (!newDetail) {\n            this._miscellaneousReceiptLines.push({\n                stockDetails: [],\n            });\n        }\n        this._currentLine = typesLib.sub(this._miscellaneousReceiptLines.length, 1);\n        if (typesLib.strictEq(this._miscellaneousReceiptLines[this._currentLine].stockDetails.length, 0)) {\n            this._miscellaneousReceiptLines[this._currentLine] = {\n                ...this._miscellaneousReceiptLines[this._currentLine],\n                product: this.product.value,\n                packingUnitToStockUnitConversionFactor: 1,\n                packingUnit: this._productSite.product.stockUnit.code,\n            };\n        }\n        this.potency.value = Number(this._productSite.product.defaultPotencyInPercentage);\n    }\n    _initSiteCodeField() {\n        // assign site code\n        const siteCode = this.$.storage.get('mobile-selected-stock-site');\n        if (siteCode) {\n            this.site.value = siteCode;\n        }\n    }\n    _initTechnicalProperties() {\n        this.product.value = this._productSite.product.code;\n        this.localizedDescription.value = this._productSite.product.localizedDescription1;\n    }\n    /*\n     *\n     *  Fields management functions\n     *\n     */\n    async _fieldsManagement() {\n        this._selectedTransaction = this._getSavedInputs().selectedTransaction;\n        this._lotManagement();\n        this._initPackingUnitFields();\n    }\n    _lotManagement() {\n        const lotManagement = this._productSite.product.lotManagementMode;\n        const lotNotManaged = typesLib.strictEq(lotManagement, 'notManaged');\n        this.lot.isHidden = lotNotManaged;\n        this.sublot.isHidden = lotNotManaged;\n        //user lot area\n        this.lotCustomField1.isHidden = lotNotManaged || !this._selectedTransaction.isLotCustomField1Allowed;\n        this.lotCustomField2.isHidden = lotNotManaged || !this._selectedTransaction.isLotCustomField2Allowed;\n        this.lotCustomField3.isHidden = lotNotManaged || !this._selectedTransaction.isLotCustomField3Allowed;\n        this.lotCustomField4.isHidden = lotNotManaged || !this._selectedTransaction.isLotCustomField4Allowed;\n        //Supplier Lot\n        switch (this._selectedTransaction.supplierLot) {\n            case 'entered': {\n                this.supplierLot.isHidden = lotNotManaged || false;\n                this.supplierLot.isDisabled = false;\n                break;\n            }\n            case 'displayed': {\n                this.supplierLot.isHidden = lotNotManaged || false;\n                this.supplierLot.isDisabled = true;\n                break;\n            }\n            default: {\n                this.supplierLot.isHidden = lotNotManaged || true;\n            }\n        }\n        //Potency management\n        const potencyManagement = this._productSite.product.stockManagementMode;\n        this.potency.isHidden =\n            lotNotManaged || !this._selectedTransaction.isLotPotencyAllowed || typesLib.strictNe(potencyManagement, 'potencyManaged');\n        //Expiration Date\n        const expirationManagement = this._productSite.product.expirationManagementMode;\n        this.expirationDate.isHidden =\n            lotNotManaged || typesLib.strictEq(expirationManagement, 'notManaged') ||\n                (!this._selectedTransaction.isLotExpirationDateAllowed && typesLib.strictNe(expirationManagement, 'manualEntry') && typesLib.strictNe(expirationManagement, 'mandatoryEntry'));\n        this.useByDate.isHidden = this.expirationDate.isHidden;\n        //disable useByDate field\n        if (['roundingBeginningMonth1', 'roundingMonthEnd'].includes(expirationManagement))\n            this.useByDate.isDisabled = true;\n        //version\n        const versionManagementMode = this._productSite.product.stockVersionMode;\n        this.majorVersion.isHidden =\n            lotNotManaged || !this._productSite.product.stockVersionMode || typesLib.strictEq(versionManagementMode, 'no');\n        this.minorVersion.isHidden = lotNotManaged || typesLib.strictNe(versionManagementMode, 'majorAndMinor');\n        this.sublot.isHidden = typesLib.strictNe(lotManagement, 'lotAndSublot');\n    }\n    _initPackingUnitFields() {\n        let productPackingList = (0, xtrem_client_1.extractEdges)(this._productSite.product.packingUnits.query).filter(productPacking => {\n            return !!productPacking.packingUnit?.code;\n        });\n        this._packingUnits = productPackingList.map(productPacking => {\n            return { node: productPacking };\n        });\n        let productPakingUnitSelectValues = productPackingList.map(productPacking => {\n            //return `${productPacking.packingUnit.code} = ${productPacking.packingUnitToStockUnitConversionFactor} ${this._productSite.product.stockUnit.code}`;\n            return `${productPacking.packingUnit.code}`;\n        });\n        this.packingUnit.options = [this._productSite.product.stockUnit.code, ...productPakingUnitSelectValues];\n        this.packingUnit.value = this.packingUnit.options[0];\n        this.packingUnitToStockUnitConversionFactor.value = 1;\n        this._GetNumberOfDecimals();\n    }\n    _miscellaneousFieldsManagement() {\n        //location fields\n        this.location.isHidden = !this._productSite.isLocationManaged;\n        this.suggestedLocation.isHidden = this.location.isHidden;\n        //serial number fields\n        const serialNumberManagement = this._productSite.product.serialNumberManagementMode;\n        this.serialNumber.isHidden = ['notManaged', 'issued'].includes(serialNumberManagement);\n        //mandatory if no sequence number\n        if (!(this.serialNumber.isHidden || !!this._productSite.product.serialSequenceNumber))\n            this.serialNumber.isMandatory = true;\n        //lot field: mandatory if no sequence number\n        if (typesLib.strictEq(this._selectedStockManagementRules.lotEntry, 'no')) {\n            this.lot.isDisabled = true;\n            if (typesLib.strictEq(this.sublot.isHidden, false)) {\n                this.sublot.value = '00001';\n                this.sublot.isDisabled = true;\n            }\n        }\n        else if (typesLib.strictEq(this._selectedStockManagementRules.lotEntry, 'newLot')) {\n            if (typesLib.strictEq(this.sublot.isHidden, false))\n                this.sublot.value = '00001';\n        }\n        else if (typesLib.strictEq(this._selectedStockManagementRules.lotEntry, 'free') && typesLib.strictEq(this._selectedStockManagementRules.lotByDefault, 'documentNumber')) {\n            if (typesLib.strictEq(this.sublot.isHidden, false))\n                this.sublot.value = '00001';\n        }\n        const lotManagementMode = this._productSite.product.lotManagementMode;\n        if (!(this.lot.isHidden || !!this._productSite.product.lotSequenceNumber) &&\n            ['lotAndSublot', 'mandatoryLot'].includes(lotManagementMode) && typesLib.strictNe(this._selectedStockManagementRules.lotByDefault, 'documentNumber'))\n            this.lot.isMandatory = true;\n        //container field\n        this.container.isHidden =\n            typesLib.strictNe(this._selectedStockManagementRules.licensePlateNumberEntry, 'mandatory') ||\n                !this._productSite.isLicensePlateNumberManaged;\n        //license plate number fields\n        this.licensePlateNumber.isHidden = !this._productSite.isLicensePlateNumberManaged;\n        //identifier 1 and identifier 2\n        switch (this._selectedTransaction.identifier1Detail) {\n            case 'entered': {\n                this.identifier1.isHidden = false;\n                this.identifier1.isDisabled = false;\n                break;\n            }\n            case 'displayed': {\n                this.identifier1.isHidden = false;\n                this.identifier1.isDisabled = true;\n                break;\n            }\n            default: {\n                this.identifier1.isHidden = true;\n            }\n        }\n        switch (this._selectedTransaction.identifier2Detail) {\n            case 'entered': {\n                this.identifier2.isHidden = false;\n                this.identifier2.isDisabled = false;\n                break;\n            }\n            case 'displayed': {\n                this.identifier2.isHidden = false;\n                this.identifier2.isDisabled = true;\n                break;\n            }\n            default: {\n                this.identifier2.isHidden = true;\n            }\n        }\n    }\n    _getNextField(field) {\n        if (!this._isPageActive) {\n            return field;\n        }\n        let _nextField = field.getNextField(true);\n        if (typesLib.strictNe(this._productSite.product.expirationManagementMode, 'manualEntry')) {\n            while (typesLib.strictEq(_nextField, this.expirationDate) || typesLib.strictEq(_nextField, this.useByDate)) {\n                _nextField = _nextField.getNextField(true);\n            }\n        }\n        return _nextField;\n    }\n    /*\n     *\n     *  record management functions\n     *\n     */\n    _createDetail() {\n        const values = (0, get_page_values_not_transient_1.getPageValuesNotTransient)(this);\n        Object.keys(values).forEach(elementId => {\n            if (!values[elementId])\n                values[elementId] = undefined;\n        });\n        if (this.location.value?.code) {\n            values.location = this.location.value.code;\n        }\n        if (this.licensePlateNumber.value?.code) {\n            values.licensePlateNumber = this.licensePlateNumber.value.code;\n        }\n        if (this.warehouse.value?.code) {\n            values.warehouse = this.warehouse.value.code;\n        }\n        if (this.majorVersion.value?.code) {\n            values.majorVersion = this.majorVersion.value.code;\n        }\n        if (this.minorVersion.value?.minorVersion) {\n            values.minorVersion = this.minorVersion.value.minorVersion;\n        }\n        this._miscellaneousReceiptLines[this._currentLine].stockDetails.push(values);\n        if (this.container.value?.code) {\n            this._miscellaneousReceiptLines[this._currentLine].container = this.container.value.code;\n        }\n        this._saveDetail();\n    }\n    /* private _createDetail() {\n        this._miscellaneousReceiptLines[this._currentLine].stockDetails.push({\n            packingUnit: this.packingUnit.value ?? undefined,\n            packingUnitToStockUnitConversionFactor: this.packingUnitToStockUnitConversionFactor.value ?? undefined,\n            quantityInPackingUnit: Number(this.quantityInPackingUnit.value),\n            quantityInStockUnit:\n                Number(this.quantityInPackingUnit.value) * Number(this.packingUnitToStockUnitConversionFactor.value),\n            location: this.location.value?.code ?? undefined,\n            licensePlateNumber: this.licensePlateNumber.value?.code ?? undefined,\n            lot: this.lot.value ?? undefined,\n            status: this.status.value ?? undefined,\n            sublot: this.sublot.value ?? undefined,\n            serialNumber: this.serialNumber.value ?? undefined,\n            identifier1: this.identifier1.value ?? undefined,\n            identifier2: this.identifier2.value ?? undefined,\n            potency: this.potency.value ?? undefined,\n            expirationDate: this.expirationDate.value ?? undefined,\n            useByDate: this.useByDate.value ?? undefined,\n            lotCustomField1: this.lotCustomField1.value ?? undefined,\n            lotCustomField2: this.lotCustomField2.value ?? undefined,\n            lotCustomField3: this.lotCustomField3.value ?? undefined,\n            lotCustomField4: this.lotCustomField4.value ?? undefined,\n            majorVersion: this.majorVersion.value?.code ?? undefined,\n            minorVersion: this.minorVersion.value?.minorVersion ?? undefined,\n            warehouse: this.warehouse.value?.code ?? undefined,\n        });\n\n        if (this.container.value?.code) {\n            this._miscellaneousReceiptLines[this._currentLine].container = this.container.value.code;\n        }\n\n        this._saveDetail();\n    } */\n    _saveDetail() {\n        const currentmiscellaneousReceiptLines = this._miscellaneousReceiptLines[this._currentLine];\n        this._miscellaneousReceiptLines[this._currentLine] = {\n            ...currentmiscellaneousReceiptLines,\n            ...this._aggregateDetailsQuantity(currentmiscellaneousReceiptLines),\n        };\n        this._saveMiscellaneousReceipt();\n    }\n    _aggregateDetailsQuantity(line) {\n        return line.stockDetails.reduce((accumulator, detail) => {\n            const quantityInStockUnit = typesLib.add(typesLib.plus(accumulator.quantityInStockUnit), typesLib.mul(typesLib.plus(detail.quantityInPackingUnit), typesLib.plus(detail.packingUnitToStockUnitConversionFactor)));\n            return {\n                ...accumulator,\n                product: detail.product,\n                quantityInStockUnit: quantityInStockUnit,\n                quantityInPackingUnit: quantityInStockUnit,\n            };\n        }, { quantityInStockUnit: 0, packingUnit: this._productSite.product.stockUnit.code });\n    }\n    _saveMiscellaneousReceipt() {\n        const savedInputs = this._getSavedInputs();\n        savedInputs.miscellaneousReceipt.miscellaneousReceiptLines = this._miscellaneousReceiptLines;\n        this.$.storage.set('miscellaneousReceipt', JSON.stringify(savedInputs));\n    }\n    async _getStockStatus() {\n        const selectedStatus = [];\n        this._selectedStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        const response = await this.$.graph\n            // with 'provides' property defined in accessCode of this node, should automatically return only transactions that are accessible for the current user\n            .node('@sage/x3-stock-data/StockStatus')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n        }, {\n            filter: {\n                code: { _or: selectedStatus },\n            },\n        }))\n            .execute();\n        if (!response.edges || typesLib.strictEq(response.edges.length, 0)) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__miscellaneous_receipt_details__notification__invalid_stock_status_error', 'No stock status'));\n        }\n        // transform Stock status response into a string array\n        return response.edges.map((stockStatus) => {\n            return stockStatus.node.code;\n        });\n    }\n    _enableLotFields() {\n        this.supplierLot.isDisabled = false;\n        //set the default values for expiration date and use by date\n        this.expirationDate.value = (0, defaultValue_1.expirationDateDefaultValue)(this._productSite.product.expirationManagementMode, this._productSite.product.expirationLeadTime, this._productSite.product.expirationTimeUnit, this._effectiveDate);\n        this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, this._effectiveDate, this._productSite.product.expirationManagementMode, Number(this._productSite.product.useByDateCoefficient));\n        this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n        this.expirationDate.isDisabled = false;\n        //Expiration Date\n        const expirationManagement = this._productSite.product.expirationManagementMode;\n        //disable useByDate field\n        this.useByDate.isDisabled = ['roundingBeginningMonth1', 'roundingMonthEnd'].includes(expirationManagement);\n        this.lotCustomField1.value = null;\n        this.lotCustomField1.isDisabled = false;\n        this.lotCustomField2.value = null;\n        this.lotCustomField2.isDisabled = false;\n        this.lotCustomField3.value = null;\n        this.lotCustomField3.isDisabled = false;\n        this.lotCustomField4.value = null;\n        this.lotCustomField4.isDisabled = false;\n        this.potency.value = Number(this._productSite.product.defaultPotencyInPercentage);\n        this.potency.isDisabled = false;\n        this.majorVersion.value = null;\n        this.majorVersion.isDisabled = false;\n        this.minorVersion.value = null;\n        this.minorVersion.isDisabled = !this.majorVersion.value;\n        //this.minorVersion.isDisabled = false;\n    }\n    _disableLotField() {\n        if (!this.identifier1.isHidden)\n            this.identifier1.focus();\n        else if (!this.identifier2.isHidden)\n            this.identifier2.focus();\n        this.supplierLot.value = this._selectedLot.supplierLot ?? null;\n        this.supplierLot.isDisabled = true;\n        this.expirationDate.value = this._selectedLot.expirationDate ?? null;\n        this.expirationDate.isDisabled = true;\n        this.useByDate.value = this._selectedLot.useByDate ?? null;\n        this.useByDate.isDisabled = true;\n        this.lotCustomField1.value = this._selectedLot.lotCustomField1 ?? null;\n        this.lotCustomField1.isDisabled = true;\n        this.lotCustomField2.value = this._selectedLot.lotCustomField2 ?? null;\n        this.lotCustomField2.isDisabled = true;\n        this.lotCustomField3.value = Number(this._selectedLot.lotCustomField3);\n        this.lotCustomField3.isDisabled = true;\n        if (!!this._selectedLot.lotCustomField4 && !this._selectedLot.lotCustomField4.startsWith('1599')) {\n            this.lotCustomField4.value = this._selectedLot.lotCustomField4;\n        }\n        this.lotCustomField4.isDisabled = true;\n        this.potency.value = Number(this._selectedLot.potency);\n        this.potency.isDisabled = true;\n        if (!this.majorVersion.isHidden) {\n            this.majorVersion.value = this._selectedLot.majorVersion ?? null;\n            this.majorVersion.isDisabled = true;\n        }\n        if (!this.minorVersion.isHidden) {\n            this.minorVersion.value = { code: this._selectedLot.minorVersion ?? null };\n            this.minorVersion.isDisabled = true;\n        }\n    }\n    async _InitLotFields() {\n        try {\n            this._selectedLot = await this.$.graph\n                .node('@sage/x3-stock-data/Lot')\n                .read({\n                expirationDate: true,\n                lotCustomField1: true,\n                lotCustomField2: true,\n                lotCustomField3: true,\n                lotCustomField4: true,\n                potency: true,\n                useByDate: true,\n                supplierLot: true,\n                majorVersion: { code: true },\n                minorVersion: true,\n            }, `${this._productSite.product.code}|${this.lot.value}|${this.sublot.value ? this.sublot.value : ' '}`)\n                .execute();\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/error-loading-lot', 'Error loading lot'), String(e));\n        }\n        if (this._selectedLot) {\n            this._disableLotField();\n        }\n        else {\n            this._enableLotFields();\n        }\n    }\n    async _getMinorVersions(majorVersion) {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/ProductVersion')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            minorVersion: true,\n        }, {\n            filter: {\n                product: this.product.value,\n                majorVersion: this.majorVersion.value?.code,\n                type: { _eq: 'stock' },\n                useStatus: { _eq: 'availableToUse' },\n            },\n            orderBy: {\n                minorVersion: 1,\n            },\n        }))\n            .execute());\n    }\n    async _getWarehouseFromLocation() {\n        try {\n            this._selectedLocation = await this.$.graph\n                .node('@sage/x3-stock-data/Location')\n                .read({\n                warehouse: { code: true },\n            }, `${this.site.value}|${this.location.value.code}`)\n                .execute();\n            this.warehouse.value = this._selectedLocation.warehouse ?? null;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/error-loading-location', 'Error loading location'), String(e));\n        }\n    }\n    async _GetNumberOfDecimals() {\n        try {\n            const NumberofDecimals = await this.$.graph\n                .node('@sage/x3-master-data/UnitOfMeasure')\n                .read({\n                _id: true,\n                numberOfDecimals: true,\n            }, `${this.packingUnit.value}`)\n                .execute();\n            this.quantityInPackingUnit.scale = NumberofDecimals.numberOfDecimals;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/error-loading-unit', 'Error loading unit'), String(e));\n        }\n    }\n    _manageLicensePlateNumberLocation() {\n        if (!!this.licensePlateNumber.value?.location?.code) {\n            this.location.value = this.licensePlateNumber.value.location;\n            this.location.isHidden = true;\n            this.dummyLocation.value = this.licensePlateNumber.value.location.code;\n            this.dummyLocation.isHidden = false;\n        }\n        else {\n            if (!this._miscellaneousReceiptLines.find(line => {\n                return line.stockDetails?.find(detail => {\n                    if (typesLib.strictEq(detail.licensePlateNumber, this.licensePlateNumber.value?.code)) {\n                        this.location.value = { code: detail.location };\n                        this.location.isDisabled = true;\n                        return true;\n                    }\n                    else {\n                        return false;\n                    }\n                });\n            })) {\n                this.location.value = null;\n                this.location.isDisabled = false;\n                this.location.isHidden = false;\n                this.dummyLocation.value = null;\n                this.dummyLocation.isHidden = true;\n            }\n        }\n    }\n    async _getLotValues() {\n        if (this.lot.value && (this.sublot.isHidden || this.sublot.value)) {\n            try {\n                const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                    .node('@sage/x3-stock-data/Lot')\n                    .query(ui.queryUtils.edgesSelector({\n                    code: true,\n                    product: {\n                        code: true,\n                    },\n                    sublot: true,\n                    supplierLot: true,\n                    expirationDate: true,\n                    lotCustomField1: true,\n                    lotCustomField2: true,\n                    lotCustomField3: true,\n                    lotCustomField4: true,\n                    majorVersion: {\n                        code: true,\n                    },\n                    minorVersion: true,\n                    potency: true,\n                    useByDate: true,\n                }, {\n                    filter: {\n                        product: this.product.value,\n                        code: this.lot.value,\n                        sublot: typesLib.strictEq(this.sublot.value, null) ? '' : this.sublot.value,\n                    },\n                }))\n                    .execute());\n                if (typesLib.strictNe(result.length, 0)) {\n                    this._setLotValues(result);\n                }\n                else {\n                    this._initLotValues();\n                }\n            }\n            catch (e) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-set-expdate', 'Error while reading the lot information'), String(e)));\n                return;\n            }\n        }\n        else {\n            this._initLotValues();\n        }\n    }\n    async _setLotValues(lotValues) {\n        if (!this.expirationDate.isHidden) {\n            this.expirationDate.value = lotValues[0].expirationDate;\n        }\n        this.useByDate.value = lotValues[0].useByDate;\n        this.supplierLot.value = lotValues[0].supplierLot;\n        this.lotCustomField1.value = lotValues[0].lotCustomField1;\n        this.lotCustomField2.value = lotValues[0].lotCustomField2;\n        this.lotCustomField3.value = Number(lotValues[0].lotCustomField3);\n        this.lotCustomField4.value = lotValues[0].lotCustomField4;\n        this.majorVersion.value = null;\n        this.minorVersion.value = null;\n        this.$.commitValueAndPropertyChanges();\n        this.majorVersion.value = { code: lotValues[0].majorVersion ? lotValues[0].majorVersion.code : null };\n        this.minorVersion.value = {\n            minorVersion: lotValues[0].minorVersion ? lotValues[0].minorVersion : null,\n        };\n        this.potency.value = Number(lotValues[0].potency);\n        this.supplierLot.isDisabled = true;\n        this.lotCustomField1.isDisabled = true;\n        this.lotCustomField2.isDisabled = true;\n        this.lotCustomField3.isDisabled = true;\n        this.lotCustomField4.isDisabled = true;\n        this.majorVersion.isDisabled = true;\n        this.minorVersion.isDisabled = true;\n        this.potency.isDisabled = true;\n        this.expirationDate.isDisabled = true;\n        this.useByDate.isDisabled = true;\n    }\n    async _initLotValues() {\n        const expirationManagement = this._productSite.product.expirationManagementMode;\n        if (!this.expirationDate.value) {\n            this.expirationDate.value = this.useByDate.value = null;\n            this.expirationDate.value = (0, defaultValue_1.expirationDateDefaultValue)(this._productSite.product.expirationManagementMode, this._productSite.product.expirationLeadTime, this._productSite.product.expirationTimeUnit, this._effectiveDate);\n        }\n        if (!this.useByDate.value) {\n            this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, this._effectiveDate, this._productSite.product.expirationManagementMode, Number(this._productSite.product.useByDateCoefficient));\n        }\n        //disable expirationDate field\n        this.expirationDate.isDisabled = false;\n        //disable useByDate field\n        this.useByDate.isDisabled = ['roundingBeginningMonth1', 'roundingMonthEnd'].includes(expirationManagement);\n        this.lotCustomField1.value = null;\n        this.lotCustomField2.value = null;\n        this.lotCustomField3.value = null;\n        this.lotCustomField4.value = null;\n        this.potency.value = Number(this._productSite.product.defaultPotencyInPercentage);\n        this.supplierLot.isDisabled = false;\n        this.lotCustomField1.isDisabled = false;\n        this.lotCustomField2.isDisabled = false;\n        this.lotCustomField3.isDisabled = false;\n        this.lotCustomField4.isDisabled = false;\n        this.majorVersion.isDisabled = false;\n        this.minorVersion.isDisabled = !this.majorVersion.value;\n        this.potency.isDisabled = false;\n    }\n    async _isEmptyLpnAndContainerValues() {\n        if (!this.container.isHidden &&\n            !this.licensePlateNumber.isHidden &&\n            (!this.container.value || typesLib.strictEq(this.container.value?.code, '')) &&\n            (!this.licensePlateNumber.value || typesLib.strictEq(this.licensePlateNumber.value?.code, ''))) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages__miscellaneous_receipt_details__notification__container_license_plate_number_mandatory_error', 'Container or license plate number is mandatory'));\n            return true;\n        }\n        else {\n            return false;\n        }\n    }\n};\nexports.MobileMiscellaneousReceiptDetails = MobileMiscellaneousReceiptDetails;\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        size: 'small',\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"localizedDescription\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isDisabled: true,\n        isTransient: true,\n        prefix: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__site____prefix\", \"Site:\"),\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        node: '@sage/x3-stock-data/Warehouse',\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__warehouse____placeholder\", \"Scan or select...\"),\n        isHidden: true,\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { _id: { _eq: this.site.value } },\n            };\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"warehouse\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__addDetails____title\", \"Add quantity\"),\n        buttonType: 'secondary',\n        async onClick() {\n            if (await this._isEmptyLpnAndContainerValues()) {\n                return;\n            }\n            if ((0, control_1.validate)(this, await this.$.page.isValid, await this._fieldsData(true))) {\n                this._createDetail();\n                this.$.storage.set('productSite', JSON.stringify(this._productSite));\n                this.$.storage.set('miscellaneous-receipt-details-container', JSON.stringify(this.container.value));\n                this.$.storage.set('miscellaneous-receipt-details-location', JSON.stringify(this.location.value));\n                this.$.storage.set('miscellaneous-receipt-details-licensePlateNumber', JSON.stringify(this.licensePlateNumber.value));\n                await this._notifier.showAndWait(ui.localize('@sage/x3-stock/pages__miscellaneous_receipt_details__notification__quantity_added', 'Quantity added'), 'success', 3000);\n                this.$.setPageClean();\n                this.$.router.goTo('@sage/x3-stock/MobileMiscellaneousReceiptDetails', { NewDetail: 'Yes' });\n            }\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"addDetails\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__addProduct____title\", \"Next\"),\n        buttonType: 'primary',\n        shortcut: ['f3'],\n        async onClick() {\n            if (await this._isEmptyLpnAndContainerValues()) {\n                return;\n            }\n            if ((0, control_1.validate)(this, await this.$.page.isValid, await this._fieldsData(true))) {\n                this._createDetail();\n                this.$.setPageClean();\n                this._isPageActive = false;\n                this.$.router.goTo('@sage/x3-stock/MobileMiscellaneousReceipt', { ReturnFromDetail: 'yes' });\n            }\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"addProduct\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.sectionHeader;\n        },\n        width: 'extra-large',\n        isTitleHidden: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"firstLineBlock\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__packingUnit____title\", \"Unit\"),\n        width: 'small',\n        options: ['UN'],\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__packingUnit____placeholder\", \"Select...\"),\n        isMandatory: true,\n        async onChange() {\n            if (!this.packingUnit.value)\n                return;\n            const selectedValue = this.packingUnit.value;\n            const packingUnitIndex = this._packingUnits\n                .map(packingUnit => packingUnit.node.packingUnit.code)\n                .indexOf(selectedValue);\n            if (typesLib.strictNe(packingUnitIndex, -1)) {\n                const selectedUnit = this._packingUnits[packingUnitIndex].node;\n                this.packingUnitToStockUnitConversionFactor.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n                this.packingUnitToStockUnitConversionFactor.isDisabled = !selectedUnit.isPackingFactorEntryAllowed;\n                this.quantityInPackingUnit.scale = selectedUnit.packingUnit.numberOfDecimals;\n            }\n            else {\n                this.packingUnitToStockUnitConversionFactor.value = 1;\n                this.packingUnitToStockUnitConversionFactor.isDisabled = true;\n                if (this.packingUnit.value)\n                    this._GetNumberOfDecimals();\n            }\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"packingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__quantityInPackingUnit____title\", \"Quantity\"),\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__quantityInPackingUnit____placeholder\", \"Enter...\"),\n        width: 'small',\n        isMandatory: true,\n        validation: /[0-9]{1,}/,\n        min: 0,\n        isNotZero: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"quantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        isDisabled: true,\n        isMandatory: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__packingUnitToStockUnitConversionFactor____placeholder\", \"Enter...\"),\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__status____title\", \"Status\"),\n        isMandatory: true,\n        options: ['A'],\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__status____placeholder\", \"Scan or select...\"),\n        onChange() { },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__container____title\", \"Container\"),\n        node: '@sage/x3-master-data/Container',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__container____placeholder\", \"Scan or select...\"),\n        width: 'large',\n        isTransient: true,\n        canFilter: false,\n        filter() {\n            return {\n                isInternal: { _eq: true },\n                isActive: { _eq: true },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__container____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'containerType',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__container____columns__title__containerType\", \"Type\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'description',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__container____columns__title__description\", \"Description\"),\n            }),\n        ],\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"container\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____title\", \"License Plate Number\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        width: 'large',\n        canFilter: false,\n        filter() {\n            let licensePlateNumberFilter = {\n                stockSite: { code: this.site.value },\n                isActive: { _eq: true },\n                _or: [\n                    {\n                        isSingleProduct: { _eq: true },\n                        stock: { _atLeast: 1, product: { product: { code: this.product.value } } },\n                    },\n                    { isSingleProduct: { _eq: true }, stock: { _none: true } },\n                    // { isSingleProduct: { _eq: false } },\n                    { isSingleProduct: { _in: [false, null] } },\n                ],\n            };\n            if (this.container.value) {\n                licensePlateNumberFilter = {\n                    ...licensePlateNumberFilter,\n                    container: { code: this.container.value?.code },\n                };\n            }\n            return licensePlateNumberFilter;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____columns__title__location__code\", \"Location\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____columns__title__container__code\", \"Container\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__licensePlateNumber____columns__title__status\", \"Status\"),\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n        ],\n        async onChange() {\n            if (await this.licensePlateNumber.value?.code) {\n                this._manageLicensePlateNumberLocation();\n                if (this.licensePlateNumber.value.container) {\n                    this.container.value = this.licensePlateNumber.value.container;\n                    this.container.isDisabled = true;\n                }\n                else {\n                    this.container.isDisabled = false;\n                }\n            }\n            else {\n                this.location.isHidden = false;\n                this.location.isDisabled = false;\n                this.location.value = null;\n                this.dummyLocation.isHidden = true;\n                this.dummyLocation.value = null;\n                this.container.isDisabled = this._newDetail;\n            }\n            if (this.location.value && this.location.value.code)\n                this._getWarehouseFromLocation();\n            await this.$.commitValueAndPropertyChanges();\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__suggestedLocation____title\", \"Suggested location\"),\n        isReadOnly: true,\n        width: 'large',\n        isTransient: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"suggestedLocation\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__location____title\", \"Location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__location____placeholder\", \"Scan or select...\"),\n        isAutoSelectEnabled: true,\n        width: 'large',\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.site.value },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n        },\n        async onChange() {\n            if (this.location.value)\n                this._getWarehouseFromLocation();\n            await this.$.commitValueAndPropertyChanges();\n            if (this.location.value)\n                this.location.getNextField(true)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__location____columns__title__code\", \"Code\"),\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__dummyLocation____title\", \"Location\"),\n        isMandatory: true,\n        isHidden: true,\n        isDisabled: true,\n        isTransient: true,\n        width: 'large',\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"dummyLocation\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__serialNumber____title\", \"Serial number\"),\n        width: 'large',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__serialNumber____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__supplierLot____title\", \"Supplier lot\"),\n        width: 'large',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__supplierLot____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        async onChange() {\n            this.supplierLot.value ? (this.supplierLot.value = this.supplierLot.value.toUpperCase()) : '';\n            if (this.supplierLot.value && typesLib.strictEq(this._selectedStockManagementRules.lotByDefault, 'supplierLot') && typesLib.strictEq(this._selectedStockManagementRules.lotEntry, 'newLot')) {\n                if (typesLib.strictEq((await (0, control_1.controlLotReceipt)(this, this.supplierLot.value, this._productSite.product.code, '19', this.site.value)), false)) {\n                    this.supplierLot.value = null;\n                    this.supplierLot.focus();\n                }\n            }\n            this.lot.value = this.supplierLot.value;\n            await this.$.commitValueAndPropertyChanges();\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"supplierLot\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        node: '@sage/x3-stock-data/LotsSites',\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lot____title\", \"Lot\"),\n        valueField: 'lot',\n        isNewEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lot____placeholder\", \"Scan or select...\"),\n        canFilter: false,\n        parent() {\n            return this.firstLineBlock;\n        },\n        validation: /^$|^[^|]+$/,\n        filter() {\n            return {\n                product: { code: this.product.value },\n                storageSite: { code: this.site.value },\n                stock: { _atLeast: 1 },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n        async onChange() {\n            this.lot.value = this.lot.value.toUpperCase();\n            if (this.lot.value && typesLib.strictEq(this._selectedStockManagementRules.lotEntry, 'newLot') && typesLib.strictEq((await (0, control_1.controlLotReceipt)(this, this.lot.value, this._productSite.product.code, '19', this.site.value)), false)) {\n                this.lot.value = null;\n                this.lot.focus();\n            }\n            this.sublot.value && !this.sublot.isHidden && typesLib.strictNe(this.svgLot.value, this.lot.value)\n                ? (this.sublot.value = null)\n                : null;\n            await this._getLotValues();\n            this.svgLot.value = this.lot.value;\n            if (this.lot.value) {\n                this._getNextField(this.lot)?.focus();\n            }\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        isHidden: true,\n        isTransient: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"svgLot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__sublot____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__sublot____title\", \"Sublot\"),\n        validation: /^$|^[^|]+$/,\n        isMandatory: true,\n        async onInputValueChange(rawData) {\n            this.expirationDate.isDisabled = true;\n            this.useByDate.isDisabled = true;\n        },\n        async onChange() {\n            // this.sublot.value ? (this.sublot.value = this.sublot.value.toUpperCase()) : '';\n            // this._InitLotFields();\n            // await this.$.commitValueAndPropertyChanges();\n            // this.sublot.getNextField(true)?.focus();\n            this.sublot.value ? (this.sublot.value = this.sublot.value.toUpperCase()) : '';\n            await this._getLotValues();\n            this._getNextField(this.sublot)?.focus();\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__majorVersion____placeholder\", \"Scan or select...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__majorVersion____title\", \"Major version\"),\n        isMandatory: true,\n        node: '@sage/x3-stock-data/MajorVersionStatus',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value },\n                // (X3-227355) TODO: Issue: Cannot use the less verbose _in operator instead of individual _or filter criterion\n                _or: [{ status: 'prototypeVersion' }, { status: 'activeVersion' }, { status: 'stoppedVersion' }],\n            };\n        },\n        async onChange() {\n            // if not major & minor version managed\n            if (this.minorVersion.isHidden) {\n                if (this.majorVersion.value) {\n                    await this.$.commitValueAndPropertyChanges();\n                    this._getNextField(this.majorVersion)?.focus();\n                }\n            }\n            // if major version is cleared out, clear out minor version if any as well\n            else if ((this.minorVersion.isDisabled = !this.majorVersion.value)) {\n                this.minorVersion.value = null;\n            }\n            else {\n                // Auto-populate minor version based on the last minor version available\n                const minorVersions = await this._getMinorVersions(this.majorVersion.value.code);\n                this.minorVersion.value = {\n                    _id: minorVersions[typesLib.sub(minorVersions.length, 1)]._id,\n                    minorVersion: minorVersions[typesLib.sub(minorVersions.length, 1)].minorVersion,\n                };\n                await this.$.commitValueAndPropertyChanges();\n                this._getNextField(this.majorVersion)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__majorVersion____columns__title__code\", \"Major Version\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__majorVersion____columns__title__status\", \"Status\"),\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"majorVersion\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__minorVersion____placeholder\", \"Scan or select...\"),\n        isHidden: true,\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__minorVersion____title\", \"Minor version\"),\n        isMandatory: true,\n        node: '@sage/x3-master-data/ProductVersion',\n        valueField: 'minorVersion',\n        isAutoSelectEnabled: true,\n        canFilter: false,\n        filter() {\n            // to handle extreme case of user clearing out major version and then directly clicking on minor version's lookup button\n            if (!this.majorVersion.value) {\n                return;\n            }\n            return {\n                product: { code: this.product.value },\n                majorVersion: this.majorVersion.value.code,\n                type: 'stock',\n                useStatus: 'availableToUse',\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'minorVersion',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__minorVersion____columns__title__minorVersion\", \"Minor version\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'majorVersion',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'useStatus',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"minorVersion\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__potency____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__potency____title\", \"potency %\"),\n        isMandatory: true,\n        scale: 4,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 0,\n        max: 100,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"potency\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__expirationDate____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__expirationDate____title\", \"Expiration date\"),\n        isMandatory: true,\n        onChange() {\n            this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, this._effectiveDate, this._productSite.product.expirationManagementMode, Number(this._productSite.product.useByDateCoefficient));\n            this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n        },\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__useByDate____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__useByDate____title\", \"Use-by date\"),\n        isMandatory: true,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"useByDate\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField1____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField1____title\", \"Lot custom text 1\"),\n        validation: /^$|^[^|]+$/,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"lotCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField2____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField2____title\", \"Lot custom text 2\"),\n        validation: /^$|^[^|]+$/,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"lotCustomField2\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField3____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField3____title\", \"Lot custom number\"),\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"lotCustomField3\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField4____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__lotCustomField4____title\", \"Lot custom date\"),\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"lotCustomField4\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__identifier1____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__identifier1____title\", \"Identifier 1\"),\n        validation: /^$|^[^|]+$/,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.firstLineBlock;\n        },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__identifier2____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details__identifier2____title\", \"Identifier 2\"),\n        validation: /^$|^[^|]+$/,\n    })\n], MobileMiscellaneousReceiptDetails.prototype, \"identifier2\", void 0);\nexports.MobileMiscellaneousReceiptDetails = MobileMiscellaneousReceiptDetails = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details____title\", \"Miscellaneous receipt\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_miscellaneous_receipt_details____subtitle\", \"Enter stock details\"),\n        module: 'x3-stock',\n        mode: 'default',\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.product,\n                line2: this.localizedDescription,\n            };\n        },\n        businessActions() {\n            return [this.addDetails, this.addProduct];\n        },\n        async onLoad() {\n            if ((!this.$.queryParameters['productSite'] && !this.$.storage.get('productSite')) ||\n                !this._getSavedInputs()?.miscellaneousReceipt.miscellaneousReceiptLines) {\n                this.addProduct.isHidden = true;\n                this.addDetails.isHidden = true;\n                this.firstLineBlock.isHidden = true;\n                return;\n            }\n            await this._init();\n            this.status.options = await this._getStockStatus();\n            this.status.value = this._selectedStockManagementRules.defaultStatus;\n            if (!this.suggestedLocation.isHidden) {\n                this.suggestedLocation.value = await (0, stock_management_rules_1.findDefaultLocation)(this._productSite, this._selectedStockManagementRules, this);\n                if (!this.suggestedLocation.value)\n                    this.suggestedLocation.isHidden = true;\n                else if (this._isLocationPreloaded) {\n                    this.location.value = {\n                        code: this.suggestedLocation.value,\n                        stockSite: {\n                            code: this.site.value,\n                        },\n                    };\n                }\n            }\n            //this.status.value = this.status.options[0];\n            if (!this.expirationDate.isHidden) {\n                this.expirationDate.value = (0, defaultValue_1.expirationDateDefaultValue)(this._productSite.product.expirationManagementMode, this._productSite.product.expirationLeadTime, this._productSite.product.expirationTimeUnit, this._effectiveDate);\n                this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, this._effectiveDate, this._productSite.product.expirationManagementMode, Number(this._productSite.product.useByDateCoefficient));\n                this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n            }\n            this.packingUnit.isReadOnly = typesLib.lte(this.packingUnit.options.length, 1);\n            typesLib.gt(this.packingUnit.options.length, 1) ? this.packingUnit.focus() : this.quantityInPackingUnit.focus();\n            this._newDetail = typesLib.strictEq(String(this.$.queryParameters['NewDetail']), 'Yes');\n            if (this._newDetail) {\n                const storageLocation = this.$.storage.get('miscellaneous-receipt-details-location');\n                this.location.value = JSON.parse(storageLocation);\n            }\n            if (!this.container.isHidden) {\n                if (this._newDetail) {\n                    const storageContainer = this.$.storage.get('miscellaneous-receipt-details-container');\n                    const storageLpn = this.$.storage.get('miscellaneous-receipt-details-licensePlateNumber');\n                    this.container.value = JSON.parse(storageContainer);\n                    if (this.container.value) {\n                        this.container.isDisabled = true;\n                    }\n                    else if (storageLpn) {\n                        this.container.isDisabled = true;\n                    }\n                    else {\n                        this.container.value = this._productSite.defaultInternalContainer;\n                        this.container.isDisabled = false;\n                    }\n                    this.licensePlateNumber.isDisabled = typesLib.strictEq(storageLpn, 'null');\n                }\n                else {\n                    this.container.value = this._productSite.defaultInternalContainer;\n                }\n            }\n            await this.$.commitValueAndPropertyChanges();\n        },\n    })\n], MobileMiscellaneousReceiptDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-miscellaneous-receipt-details.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts":
/*!*****************************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getPageValuesNotTransient = void 0;\n/**\n * Return values not transient for current page\n * @param pageInstance Current page instance\n * @returns array of values not transient\n */\nconst getPageValuesNotTransient = (pageInstance) => {\n    const screenValues = pageInstance.$.values;\n    const keys = Object.keys(screenValues);\n    keys.forEach(elementId => {\n        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];\n        if (properties && properties.isTransient) {\n            delete screenValues[elementId];\n        }\n    });\n    return screenValues;\n};\nexports.getPageValuesNotTransient = getPageValuesNotTransient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2dldC1wYWdlLXZhbHVlcy1ub3QtdHJhbnNpZW50LnRzIiwibWFwcGluZ3MiOiI7OztBQUVBOzs7O0dBSUc7QUFFSSxNQUFNLHlCQUF5QixHQUFHLENBQ3JDLFlBQXFCLEVBQ1osRUFBRTtJQUNYLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO0lBQzNDLE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDdkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtRQUNyQixNQUFNLFVBQVUsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQy9FLElBQUksVUFBVSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN2QyxPQUFPLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNuQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDSCxPQUFPLFlBQVksQ0FBQztBQUN4QixDQUFDLENBQUM7QUFaVyxpQ0FBeUIsNkJBWXBDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvZ2V0LXBhZ2UtdmFsdWVzLW5vdC10cmFuc2llbnQudHM/YTdhNSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaWN0IH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbi8qKlxuICogUmV0dXJuIHZhbHVlcyBub3QgdHJhbnNpZW50IGZvciBjdXJyZW50IHBhZ2VcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgQ3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcmV0dXJucyBhcnJheSBvZiB2YWx1ZXMgbm90IHRyYW5zaWVudFxuICovXG5cbmV4cG9ydCBjb25zdCBnZXRQYWdlVmFsdWVzTm90VHJhbnNpZW50ID0gKFxuICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbik6IERpY3Q8YW55PiA9PiB7XG4gICAgY29uc3Qgc2NyZWVuVmFsdWVzID0gcGFnZUluc3RhbmNlLiQudmFsdWVzO1xuICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhzY3JlZW5WYWx1ZXMpO1xuICAgIGtleXMuZm9yRWFjaChlbGVtZW50SWQgPT4ge1xuICAgICAgICBjb25zdCBwcm9wZXJ0aWVzID0gcGFnZUluc3RhbmNlLl9wYWdlTWV0YWRhdGEudWlDb21wb25lbnRQcm9wZXJ0aWVzW2VsZW1lbnRJZF07XG4gICAgICAgIGlmIChwcm9wZXJ0aWVzICYmIHByb3BlcnRpZXMuaXNUcmFuc2llbnQpIHtcbiAgICAgICAgICAgIGRlbGV0ZSBzY3JlZW5WYWx1ZXNbZWxlbWVudElkXTtcbiAgICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBzY3JlZW5WYWx1ZXM7XG59OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-miscellaneous-receipt-details.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;