import { ProductInput } from '@sage/x3-master-data-api';
import { MiscellaneousIssueInput, StockEntryTransaction } from '@sage/x3-stock-api';
import * as ui from '@sage/xtrem-ui';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockEntryTransaction = DeepPartial<StockEntryTransaction>;
export type inputsMiscIssue = {
    miscellaneousIssue: MiscellaneousIssueInput & {
        id: string;
    };
    username: string;
    currentLine?: number;
    currentDetail?: number;
    currentOperation?: number;
    started: boolean;
    selectedTransaction: PartialStockEntryTransaction;
    selectedProduct?: ProductInput;
    destination?: string;
    printingMode?: string;
};
export declare class MobileMiscellaneousIssue extends ui.Page {
    savedObject: inputsMiscIssue;
    private _transactions;
    private _notifier;
    private _mobileSettingsIssue;
    private _numberOfDecimalList;
    _currentOperation: number;
    _isGoto: boolean;
    stockSite: ui.fields.Text;
    private _showErrors;
    private _showSuccess;
    private _showSeverityThreeAndFour;
    private _showSeverityOneAndTwo;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    transactionBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    thirdBlock: ui.containers.Block;
    product: ui.fields.Reference;
    miscIssueLinesBlock: ui.containers.Block;
    miscellaneousIssueLines: ui.fields.Table<any>;
    private _init;
    private _disablePage;
    private _initSite;
    private _initDestination;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveMiscIssue;
    private _mapMiscIssue;
    private _initMiscIssueLines;
    private _postInitMiscIssueLines;
    prepareDataMutation(): void;
    private _callCreationAPI;
}
export {};
//# sourceMappingURL=mobile-miscellaneous-issue.d.ts.map