/// <reference types="@sage/x3-system/api" />
import { Product, ProductSite, SerialNumberManagement } from '@sage/x3-master-data-api';
import { GraphApi, MiscellaneousIssueLineInput } from '@sage/x3-stock-api';
import { Location, LotsSites, SerialNumber, Stock, StockManagementRules, StockSearchFilter } from '@sage/x3-stock-data-api';
import { Site } from '@sage/x3-system-api';
import * as ui from '@sage/xtrem-ui';
import { originalStockLine, packingUnit } from '../client-functions/miscellaneous-issue-details-control';
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialLocation = DeepPartial<Location>;
/** Created with X3 Etna Studio at 2020-01-20T10:46:11.764Z */
export declare class MobileMiscellaneousIssueDetails extends ui.Page<GraphApi> {
    _packingUnits: packingUnit[];
    _productSite: ProductSite;
    _currentLine: number | undefined;
    _currentDetail: number | undefined;
    _currentOperation: number | undefined;
    _miscellaneousIssueLines: Partial<MiscellaneousIssueLineInput>[];
    _selectedLocation: PartialLocation;
    _stockFieldSettings: StockSearchFilter[];
    _stockSite: Site;
    _serialNumberManagementMode: SerialNumberManagement | undefined;
    _selectedStockManagementRules: StockManagementRules;
    _originalStockLines: originalStockLine[];
    product: ui.fields.Reference<Product>;
    isLocationManaged: ui.fields.Checkbox;
    isLicensePlateNumberManaged: ui.fields.Checkbox;
    localizedDescription: ui.fields.Text;
    site: ui.fields.Text;
    nextButton: ui.PageAction;
    helperCancelButton: ui.PageAction;
    helperSelectButton: ui.PageAction;
    addSerialRange: ui.PageAction;
    mainSection: ui.containers.Section;
    detailPanelSection: ui.containers.Section;
    sectionHeader: ui.containers.Section;
    bodyBlock: ui.containers.Block;
    detailsBlock: ui.containers.Block;
    gridBlock: ui.containers.GridRowBlock;
    quantityBlock: ui.containers.Block;
    serialNumberBlock: ui.containers.Block;
    destinationBlock: ui.containers.Block;
    listSerialNumberBlock: ui.containers.Block;
    licensePlateNumber: ui.fields.Reference;
    location: ui.fields.Reference;
    lot: ui.fields.Reference<LotsSites>;
    sublot: ui.fields.Reference<LotsSites>;
    serialNumber: ui.fields.Reference<SerialNumber>;
    status: ui.fields.Select;
    packingUnit: ui.fields.Select;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    stockCustomField1: ui.fields.Text;
    stockCustomField2: ui.fields.Text;
    stock: ui.fields.Table<Stock>;
    stockDetails: ui.fields.DetailList<Stock>;
    packingUnitToIssue: ui.fields.DropdownList;
    packingUnitToStockUnitConversionFactorToIssue: ui.fields.Numeric;
    quantityToMove: ui.fields.Numeric;
    startingSerialNumber: ui.fields.Reference<SerialNumber>;
    endingSerialNumber: ui.fields.Text;
    _stockId: ui.fields.Text;
    serialNumberLines: ui.fields.Table<any>;
    private _init;
    private _initSiteCodeField;
    private _initTechnicalProperties;
    private _onChangeLot;
    private _onChangeSerialNumber;
    private _initPackingUnitFields;
}
export {};
//# sourceMappingURL=mobile-miscellaneous-issue-details.d.ts.map