import { Product } from '@sage/x3-master-data-api';
import { GraphApi } from '@sage/x3-stock-api';
import { Location, LotsSites, SerialNumber, Stock } from '@sage/x3-stock-data-api';
import * as ui from '@sage/xtrem-ui';
type packingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
    };
};
export declare class MobileLpnUnlinkStockLines extends ui.Page<GraphApi> {
    _getStockChangeLine(_recordId: string | null | undefined): Promise<import('@sage/xtrem-ui/build/lib/component/types').PartialCollectionValueWithIds<Stock> | null>;
    private _stockSite;
    private _stockFilter;
    private _stockFieldSettings;
    private _unitMap;
    private _stockChangeLines;
    private _selectedLocation?;
    private _selectedLicensePlateNumber;
    private _currentLine;
    private _currentOperation;
    _packingUnits: packingUnit[];
    private _productSite;
    private _notifier;
    private _savedStockId;
    _licensePlateNumber: ui.fields.Text;
    headerProduct: ui.fields.Text;
    product: ui.fields.Reference<Product>;
    headerLocation: ui.fields.Text;
    headerLot: ui.fields.Text;
    isLocationManaged: ui.fields.Checkbox;
    isLicensePlateNumberManaged: ui.fields.Checkbox;
    totalStocks: ui.fields.Count;
    nextButton: ui.PageAction;
    helperCancelButton: ui.PageAction;
    helperSelectButton: ui.PageAction;
    addSerialRange: ui.PageAction;
    mainSection: ui.containers.Section;
    detailPanelSection: ui.containers.Section;
    bodyBlock: ui.containers.Block;
    detailsBlock: ui.containers.Block;
    quantityBlock: ui.containers.GridRowBlock;
    locationDestinationBlock: ui.containers.Block;
    serialNumberBlock: ui.containers.Block;
    lot: ui.fields.Reference<LotsSites>;
    sublot: ui.fields.Reference<LotsSites>;
    serialNumber: ui.fields.Reference<SerialNumber>;
    status: ui.fields.Select;
    packingUnit: ui.fields.Select;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    stockCustomField1: ui.fields.Text;
    stockCustomField2: ui.fields.Text;
    stock: ui.fields.Table<Stock>;
    stockDetails: ui.fields.DetailList<Stock>;
    quantityInPackingUnit: ui.fields.Numeric;
    locationDestination: ui.fields.Reference<Location>;
    startingSerialNumber: ui.fields.Reference<SerialNumber>;
    endingSerialNumber: ui.fields.Text;
    _stockId: ui.fields.Text;
    serialNumberLines: ui.fields.Table<any>;
    private _formatUnit;
    private _fetchProductPackingUnits;
    private _getSavedInputs;
    private _saveDetail;
    private _createDetail;
    private _initStockChangeLines;
    private _getResidualQuantity;
    private _saveLpnOperations;
    private _getStockStatus;
    private _initPackingUnitFields;
    private _onChangeBody;
    private _onLocationDestination;
    private _onQuantityInPackingUnit;
    private _calculateEndingSerialNumber;
    private _getProductSite;
}
export {};
//# sourceMappingURL=mobile-lpn-unlink-stock-lines.d.ts.map