/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/display.ts":
/*!*****************************************!*\
  !*** ./lib/client-functions/display.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.NotifyAndWait = void 0;\nclass NotifyAndWait {\n    constructor(instance) {\n        this.pageInstance = instance;\n    }\n    async showAndWait(message, type, timeout) {\n        await _notifyAndWait(this.pageInstance, message, type, timeout);\n    }\n    show(message, type, timeout) {\n        _notify(this.pageInstance, message, type, timeout);\n    }\n}\nexports.NotifyAndWait = NotifyAndWait;\nfunction _notifyAndWait(pageInstance, localizedNotificationText, type, timeout) {\n    return new Promise(resolve => {\n        _notify(pageInstance, localizedNotificationText, type, timeout);\n        setTimeout(resolve, timeout);\n    });\n}\nfunction _notify(pageInstance, localizedNotificationText, type, timeout = 5000) {\n    pageInstance.$.showToast(localizedNotificationText, { type: type, timeout });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvY2xpZW50LWZ1bmN0aW9ucy9kaXNwbGF5LnRzIiwibWFwcGluZ3MiOiI7OztBQUdBLE1BQWEsYUFBYTtJQUd0QixZQUFZLFFBQWlCO1FBQ3pCLElBQUksQ0FBQyxZQUFZLEdBQUcsUUFBUSxDQUFDO0lBQ2pDLENBQUM7SUFFRCxLQUFLLENBQUMsV0FBVyxDQUFDLE9BQWUsRUFBRSxJQUEyQixFQUFFLE9BQWdCO1FBQzVFLE1BQU0sY0FBYyxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNwRSxDQUFDO0lBRUQsSUFBSSxDQUFDLE9BQWUsRUFBRSxJQUEyQixFQUFFLE9BQWdCO1FBQy9ELE9BQU8sQ0FBQyxJQUFJLENBQUMsWUFBWSxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDdkQsQ0FBQztDQUNKO0FBZEQsc0NBY0M7QUFFRCxTQUFTLGNBQWMsQ0FDbkIsWUFBcUIsRUFDckIseUJBQWlDLEVBQ2pDLElBQTJCLEVBQzNCLE9BQWdCO0lBRWhCLE9BQU8sSUFBSSxPQUFPLENBQU8sT0FBTyxDQUFDLEVBQUU7UUFDL0IsT0FBTyxDQUFDLFlBQVksRUFBRSx5QkFBeUIsRUFBRSxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDaEUsVUFBVSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNqQyxDQUFDLENBQUMsQ0FBQztBQUNQLENBQUM7QUFFRCxTQUFTLE9BQU8sQ0FDWixZQUFxQixFQUNyQix5QkFBaUMsRUFDakMsSUFBMkIsRUFDM0IsT0FBTyxHQUFHLElBQUk7SUFFZCxZQUFZLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyx5QkFBeUIsRUFBRSxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQztBQUNqRixDQUFDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uL2xpYi9jbGllbnQtZnVuY3Rpb25zL2Rpc3BsYXkudHM/OGIwMyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyB1aSBmcm9tICdAc2FnZS94dHJlbS11aSc7XG5pbXBvcnQgeyBUb2FzdFByb3BzIH0gZnJvbSAnY2FyYm9uLXJlYWN0L2VzbS9jb21wb25lbnRzL3RvYXN0JztcblxuZXhwb3J0IGNsYXNzIE5vdGlmeUFuZFdhaXQge1xuICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZTtcblxuICAgIGNvbnN0cnVjdG9yKGluc3RhbmNlOiB1aS5QYWdlKSB7XG4gICAgICAgIHRoaXMucGFnZUluc3RhbmNlID0gaW5zdGFuY2U7XG4gICAgfVxuXG4gICAgYXN5bmMgc2hvd0FuZFdhaXQobWVzc2FnZTogc3RyaW5nLCB0eXBlOiBUb2FzdFByb3BzWyd2YXJpYW50J10sIHRpbWVvdXQ/OiBudW1iZXIpIHtcbiAgICAgICAgYXdhaXQgX25vdGlmeUFuZFdhaXQodGhpcy5wYWdlSW5zdGFuY2UsIG1lc3NhZ2UsIHR5cGUsIHRpbWVvdXQpO1xuICAgIH1cblxuICAgIHNob3cobWVzc2FnZTogc3RyaW5nLCB0eXBlOiBUb2FzdFByb3BzWyd2YXJpYW50J10sIHRpbWVvdXQ/OiBudW1iZXIpIHtcbiAgICAgICAgX25vdGlmeSh0aGlzLnBhZ2VJbnN0YW5jZSwgbWVzc2FnZSwgdHlwZSwgdGltZW91dCk7XG4gICAgfVxufVxuXG5mdW5jdGlvbiBfbm90aWZ5QW5kV2FpdChcbiAgICBwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsXG4gICAgbG9jYWxpemVkTm90aWZpY2F0aW9uVGV4dDogc3RyaW5nLFxuICAgIHR5cGU6IFRvYXN0UHJvcHNbJ3ZhcmlhbnQnXSxcbiAgICB0aW1lb3V0PzogbnVtYmVyLFxuKSB7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlPHZvaWQ+KHJlc29sdmUgPT4ge1xuICAgICAgICBfbm90aWZ5KHBhZ2VJbnN0YW5jZSwgbG9jYWxpemVkTm90aWZpY2F0aW9uVGV4dCwgdHlwZSwgdGltZW91dCk7XG4gICAgICAgIHNldFRpbWVvdXQocmVzb2x2ZSwgdGltZW91dCk7XG4gICAgfSk7XG59XG5cbmZ1bmN0aW9uIF9ub3RpZnkoXG4gICAgcGFnZUluc3RhbmNlOiB1aS5QYWdlLFxuICAgIGxvY2FsaXplZE5vdGlmaWNhdGlvblRleHQ6IHN0cmluZyxcbiAgICB0eXBlOiBUb2FzdFByb3BzWyd2YXJpYW50J10sXG4gICAgdGltZW91dCA9IDUwMDAsXG4pIHtcbiAgICBwYWdlSW5zdGFuY2UuJC5zaG93VG9hc3QobG9jYWxpemVkTm90aWZpY2F0aW9uVGV4dCwgeyB0eXBlOiB0eXBlLCB0aW1lb3V0IH0pO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./lib/client-functions/display.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-lpn-splitting.ts":
/*!*******************************************!*\
  !*** ./lib/pages/mobile-lpn-splitting.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileLpnSplitting = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst lpn_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/lpn */ \"../../shared/x3-stock-data/build/lib/menu-items/lpn.js\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst display_1 = __webpack_require__(/*! ../client-functions/display */ \"./lib/client-functions/display.ts\");\nlet MobileLpnSplitting = class MobileLpnSplitting extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._notifier = new display_1.NotifyAndWait(this);\n    }\n    async _init() {\n        await this._readSavedObject();\n        await this._initSite();\n        if (this.stockSite.value && this._mobileSettings.stockField1) {\n            this._initStockChangeLines();\n            this._postInitStockChangeLines();\n            if (this.savedObject.selectedLicensePlateNumber) {\n                this.licensePlateNumber.value = this.savedObject.selectedLicensePlateNumber;\n                this.licensePlateNumber.isDisabled = true;\n                if (this.savedObject.licensePlateNumberDestination) {\n                    this.licensePlateNumberDestination.value = this.savedObject.licensePlateNumberDestination;\n                    this.licensePlateNumberDestination.isDisabled = true;\n                }\n                if (this.savedObject.locationDestination) {\n                    this.locationDestination.value = this.savedObject.locationDestination;\n                    this.locationDestination.isDisabled = typesLib.strictEq(this.licensePlateNumberDestination.value?.status, 'inStock');\n                }\n                if (this.licensePlateNumber.value.isSingleProduct) {\n                    this.product.value = { product: this.savedObject.selectedProduct, site: this.stockSite.value };\n                    this.product.isDisabled = true;\n                }\n                else\n                    this.product.isDisabled = false;\n            }\n            this.licensePlateNumber.focus();\n        }\n        else {\n            this._disablePage();\n        }\n    }\n    _saveLpnOperations(data = this.savedObject) {\n        this.$.storage.set('mobile-lpnOperations', JSON.stringify({ ...data }));\n    }\n    _mapStockChange(change) {\n        let rowCount = 0;\n        return change.map((line) => {\n            var _v;\n            return {\n                _id: String((_v = rowCount, rowCount = typesLib.add(rowCount, 1), _v)), // this defines the rowId parameter in dropdownActions onClick() event\n                //licensePlateNumber: line.stockDetails[0].licensePlateNumber,\n                product: line.product,\n                location: line.stockDetails[0].location ? `${line.stockDetails[0].location}` : null,\n                licensePlateNumber: line.stockDetails[0].licensePlateNumber\n                    ? `${line.stockDetails[0].licensePlateNumber}`\n                    : null,\n                //status: line.status ? `To ${line.status}` : null,\n                stockSite: this.stockSite.value,\n            };\n        });\n    }\n    async _initSite() {\n        this.stockSite.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n        if (this.stockSite.value) {\n            this._mobileSettings = JSON.parse(this.$.storage.get('mobile-settings-lpn-operation'));\n            if (!this._mobileSettings.stockField1) {\n                (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_you_need_to_select_stock_search_parameters_to_set_up_Mobile_Automation_FUNADCSEARCH_function', 'You need to select stock search parameters to set up Mobile Automation - FUNADCSEARCH function.'));\n            }\n        }\n    }\n    async _readSavedObject() {\n        const storedString = this.$.storage.get('mobile-lpnOperations');\n        if (!storedString) {\n            this._initStorage();\n        }\n        else {\n            this.savedObject = JSON.parse(this.$.storage.get('mobile-lpnOperations'));\n            if (!this._checkStorage()) {\n                await this._reInitStorage();\n            }\n        }\n    }\n    _disablePage() {\n        this.effectiveDate.isDisabled = true;\n        this.licensePlateNumber.isDisabled = true;\n        this.product.isDisabled = true;\n        this.licensePlateNumberDestination.isDisabled = true;\n        this.locationDestination.isDisabled = true;\n    }\n    _checkStorage() {\n        if (!this.savedObject.lpnOperations.stockChangeLines) {\n            return false;\n        }\n        if (typesLib.strictNe(this.savedObject.username, this.$.userCode)) {\n            return false;\n        }\n        if (!this.savedObject.username) {\n            return false;\n        }\n        return true;\n    }\n    async _reInitStorage() {\n        await this._notifier.showAndWait(ui.localize('@sage/x3-stock/pages_mobile_stock_change_by_lpn__notification__storage_error', `An error occurred loading the storage, the page will restart to cleanup`), 'error');\n        this._initStorage();\n        this.$.router.goTo('@sage/x3-stock/MobileLpnSplitting');\n    }\n    _initStorage() {\n        this.savedObject = {\n            lpnOperations: {\n                id: '',\n                stockChangeLines: new Array(),\n            },\n            currentLine: 0,\n            username: this.$.userCode,\n            started: false,\n            selectedLicensePlateNumber: null,\n            selectedProduct: null,\n            licensePlateNumberDestination: null,\n            locationDestination: null,\n        };\n        this._saveLpnOperations(this.savedObject);\n    }\n    _initStockChangeLines() {\n        this.savedObject.lpnOperations.licensePlateNumberOperationMode = 2;\n        this.savedObject.lpnOperations.stockSite = this.stockSite.value;\n        if (this.savedObject.lpnOperations.stockChangeLines) {\n            this.savedObject.lpnOperations.stockChangeLines = this.savedObject.lpnOperations.stockChangeLines.map((line) => {\n                return {\n                    ...line,\n                    stockSite: this.stockSite.value,\n                };\n            });\n        }\n        if (typesLib.gt(this.savedObject.lpnOperations.stockChangeLines.length, 0)) {\n            this.stockChangeLinesBlock.isHidden = false;\n            this.stockChangeLines.value = this.savedObject.lpnOperations.stockChangeLines.map(line => ({\n                ...line,\n                _id: this.stockChangeLines.generateRecordId(),\n            }));\n            this.stockChangeLines.title = ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__title_table', 'Splitting: {{ title }}', {\n                title: this.stockChangeLines.value.length.toString(),\n            });\n        }\n    }\n    _postInitStockChangeLines() {\n        if (this.savedObject.lpnOperations.effectiveDate) {\n            this.effectiveDate.value = this.savedObject.lpnOperations.effectiveDate;\n        }\n        else {\n            this.effectiveDate.value = xtrem_date_time_1.DateValue.today().toString();\n        }\n        if (typesLib.gt(this.savedObject.lpnOperations.stockChangeLines.length, 0)) {\n            this._showLayout();\n            //to resynchronise the _id for the delete action\n            // this.stockChangeLines.value = this._mapStockChange(this.savedObject.lpnOperations.stockChangeLines);\n        }\n    }\n    prepareDataMutation() {\n        const _lpnOperations = this.savedObject?.lpnOperations;\n        delete _lpnOperations.id;\n        _lpnOperations.stockChangeLines =\n            _lpnOperations.stockChangeLines?.map((line) => {\n                line.lineNumber = Number(typesLib.floor(typesLib.mul(Math.random(), xtrem_shared_1.MAX_INT_32)));\n                return line;\n            }) ?? [];\n        return _lpnOperations;\n    }\n    async _callCreationAPI() {\n        const _lpnOperations = this.prepareDataMutation();\n        let result;\n        try {\n            result = await this.$.graph\n                .node('@sage/x3-stock/LpnOperations')\n                .mutations.lpnOperations({\n                id: true,\n            }, {\n                parameter: _lpnOperations,\n            })\n                .execute();\n            if (!result) {\n                throw Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change__notification__no_create_results_error', 'No results received for the creation'));\n            }\n        }\n        catch (error) {\n            return error;\n        }\n        return result;\n    }\n    _showLayout() {\n        this.product.isDisabled = !this.licensePlateNumber.value;\n        if (this.product.isDisabled) {\n            this.product.value = null;\n        }\n        this.nextButton.isHidden = !this.licensePlateNumber.value || !this.product.value?.product.code;\n        this.createButton.isDisabled =\n            typesLib.eq(this.savedObject.lpnOperations.stockChangeLines.length, 0) ||\n                !this.licensePlateNumber.value ||\n                !this.licensePlateNumberDestination.value ||\n                !this.locationDestination.value ||\n                !this.locationDestination.value?.code;\n    }\n    _showLpnLocationDestination() {\n        this.savedObject.lpnOperations.licensePlateNumberDestination = this.licensePlateNumberDestination.value?.code;\n        this.savedObject.lpnOperations.locationDestination = this.locationDestination.value?.code;\n        this.savedObject.lpnOperations?.stockChangeLines?.forEach(line => {\n            line.licensePlateNumber = this.licensePlateNumberDestination.value?.code;\n            line.location = this.locationDestination.value?.code;\n            line.stockDetails?.forEach(item => {\n                item.licensePlateNumber = this.licensePlateNumberDestination.value?.code;\n                item.location = this.locationDestination.value?.code;\n            });\n        });\n        this.stockChangeLines.value = this.savedObject.lpnOperations.stockChangeLines.map(line => ({\n            ...line,\n            _id: this.stockChangeLines.generateRecordId(),\n        }));\n    }\n    /*\n     * Read the stock node to ensure there is some inventory for the entered details\n     */\n    async _getProductOrLot(singleLot, lpnDestination, location) {\n        try {\n            const stockFilter = {\n                stockSite: this.stockSite.value,\n                licensePlateNumber: lpnDestination,\n                location: location,\n            };\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                product: {\n                    product: {\n                        code: true,\n                    },\n                },\n                location: {\n                    code: true,\n                },\n                lot: true,\n            }, {\n                filter: stockFilter,\n                first: 1,\n            }))\n                .execute());\n            if (typesLib.gte(result.length, 1)) {\n                this.singleLot.value = singleLot ? result[0].lot : null;\n                this.product.value = await this._fetchProductSite(result[0].product.product.code);\n                this.product.isDisabled = true;\n            }\n            return;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-stock', 'Reading stock record: '), String(e)));\n            return;\n        }\n    }\n    async _fetchProductSite(productCode) {\n        // read product site record\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/ProductSite')\n            .read({\n            product: {\n                code: true,\n                localizedDescription1: true,\n            },\n            stockSite: {\n                code: true,\n            },\n        }, `${productCode}|${this.stockSite.value}`)\n            .execute();\n        // If an error occurred\n        if (!response) {\n            throw new Error(ui.localize('@sage/x3-stock/pages_mobile_notification__invalid_product_site_error', `Could not retrieve your product {{ productCode }} for the site {{ siteCode }}`, {\n                productCode: productCode,\n                siteCode: this.stockSite.value,\n            }));\n        }\n        return response;\n    }\n    async _validateSingleProduct() {\n        let resultReturn = true;\n        let resultProduct = this.product.value?.product.code;\n        this.savedObject.lpnOperations?.stockChangeLines?.forEach(line => {\n            if (resultProduct) {\n                if (typesLib.strictNe(line.product, resultProduct)) {\n                    resultReturn = false;\n                }\n            }\n            else {\n                resultProduct = line.product;\n            }\n        });\n        if (resultReturn && resultProduct) {\n            const response = await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({ _id: true }, {\n                filter: {\n                    product: { product: { code: { _ne: resultProduct } } },\n                    licensePlateNumber: this.licensePlateNumberDestination.value?.code,\n                },\n            }))\n                .execute();\n            resultReturn = typesLib.strictEq(response.edges.length, 0);\n        }\n        return resultReturn;\n    }\n};\nexports.MobileLpnSplitting = MobileLpnSplitting;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobileLpnSplitting.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__nextButton____title\", \"Next\"),\n        isHidden: true,\n        buttonType: 'primary',\n        async onClick() {\n            if (this.product.value) {\n                const returnFromDetail = this.$.queryParameters['ReturnFromDetail'];\n                let curLine = 0;\n                typesLib.strictEq(returnFromDetail, 'yes') ? (curLine = this.savedObject.currentLine) : (curLine = 0);\n                typesLib.strictEq(returnFromDetail, 'yes') && typesLib.strictNe(this.savedObject.currentOperation, undefined)\n                    ? (this._currentOperation = typesLib.add(this.savedObject.currentOperation, 1))\n                    : (this._currentOperation = 0);\n                this.savedObject = {\n                    ...this.savedObject,\n                    lpnOperations: {\n                        ...this.savedObject.lpnOperations,\n                        effectiveDate: this.effectiveDate.value,\n                    },\n                    started: true,\n                    selectedLicensePlateNumber: this.licensePlateNumber.value,\n                    selectedProduct: this.product.value.product,\n                    licensePlateNumberDestination: this.licensePlateNumberDestination.value,\n                    locationDestination: this.locationDestination.value,\n                    currentOperation: this._currentOperation,\n                };\n                this._saveLpnOperations();\n                this.$.setPageClean();\n                let licensePlateNumberOrigin = this.licensePlateNumber.value?.code;\n                let location = this.locationDestination.value?.code;\n                this.$.router.goTo('@sage/x3-stock/MobileLpnSplittingStockLines', {\n                    _id: `${this.product.value.product.code}|${this.stockSite.value}`, // necessary for loading data in a non-transient way\n                    mobileSettings: JSON.stringify({ ...this._mobileSettings }),\n                    lpnOperations: JSON.stringify({\n                        stockSite: { code: this.stockSite.value },\n                        licensePlateNumberDestination: this.licensePlateNumberDestination.value?.code,\n                        locationDestination: this.locationDestination.value?.code,\n                    }),\n                    ...(this.singleLot.value && {\n                        lot: this.singleLot.value,\n                    }),\n                    licensePlateNumberOrigin: licensePlateNumberOrigin,\n                    location: location,\n                });\n            }\n            else {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_stock_change_by_lpn__notification__no_products_error', `Enter at least one product.`));\n            }\n        },\n    })\n], MobileLpnSplitting.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__createButton____title\", \"Create\"),\n        buttonType: 'primary',\n        isHidden: false,\n        async onClick() {\n            this.licensePlateNumberDestination.isDirty = false;\n            this.locationDestination.isDirty = false;\n            this.product.isDirty = false;\n            if (this.savedObject?.lpnOperations?.stockChangeLines && typesLib.gt(this.savedObject.lpnOperations.stockChangeLines.length, 50)) {\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                    },\n                };\n                await this.$.sound.error();\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_lpn_unlink__notification__this_transaction_has_more_seventy_stock_lines', 'This transaction has more than 50 stock lines. The document will not be created.'), options);\n                return;\n            }\n            if (this.savedObject?.lpnOperations?.stockChangeLines && typesLib.gt(this.savedObject.lpnOperations.stockChangeLines.length, 0)) {\n                //to disable the create button\n                this.$.loader.isHidden = false;\n                const result = await this._callCreationAPI();\n                //to enable the create button\n                this.$.loader.isHidden = true;\n                // Special case unable to connect check type of error\n                if ((!result.errors || !result.errors.length) && result instanceof Error) {\n                    this.$.loader.isHidden = true;\n                    const options = {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                        },\n                        cancelButton: {\n                            text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                        },\n                        size: 'small',\n                    };\n                    await this.$.sound.error();\n                    if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), `${ui.localize('@sage/x3-stock/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`, options)) {\n                        await this.$.router.refresh();\n                    }\n                    else {\n                        this.$.storage.remove('mobile-lpnOperations');\n                        await this.$.router.emptyPage();\n                    }\n                    return;\n                }\n                if ((!result.errors || !result.errors.length || typesLib.strictEq(result.errors.length, 0)) && !result.message) {\n                    const options = {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                        },\n                    };\n                    this.$.storage.remove('mobile-lpnOperations');\n                    await this.$.sound.success();\n                    await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-stock/dialog-success-title', 'Success'), ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__notification__creation_success', 'Document no. {{documentId}} created.', { documentId: result.id }), options);\n                    await this.$.router.emptyPage();\n                }\n                else {\n                    //severity 3 and 4\n                    if (typesLib.strictNe(result.errors[0].extensions.diagnoses.filter((d) => typesLib.gt(d.severity, 2) && d.message).length, 0)) {\n                        this.$.loader.isHidden = true;\n                        const options = {\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-stock/button-goback', 'Go back'),\n                            },\n                            cancelButton: {\n                                text: ui.localize('@sage/x3-stock/button-cancel', 'Cancel'),\n                            },\n                            size: 'small',\n                            mdContent: true,\n                        };\n                        await this.$.sound.error();\n                        const messageArray = result.errors[0].extensions.diagnoses[0].message.split(`\\n`);\n                        let message = `**${ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__notification__creation_error', 'An error has occurred')}**\\n\\n`;\n                        if (typesLib.strictEq(messageArray.length, 1)) {\n                            message = typesLib.add(message, `${messageArray[0]}`);\n                        }\n                        else {\n                            message = typesLib.add(message, messageArray.map(item => `* ${item}`).join('\\n'));\n                        }\n                        if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), `${message}`, options)) {\n                            await this.$.router.refresh();\n                        }\n                        else {\n                            this.$.storage.remove('mobile-lpnOperations');\n                            await this.$.router.emptyPage();\n                        }\n                    }\n                    else {\n                        //severity 1 and 2\n                        const options = {\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-stock/button-accept-ok', 'OK'),\n                            },\n                            mdContent: true,\n                        };\n                        this.$.storage.remove('mobile-lpnOperations');\n                        await this.$.sound.success();\n                        const messageArray = result.errors[0].extensions.diagnoses[0].message.split(`\\n`);\n                        let message = `**${ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__notification__creation_success', 'Document no. {{documentId}} created.', { documentId: result.id })}**\\n\\n`;\n                        if (typesLib.strictEq(messageArray.length, 1)) {\n                            message = typesLib.add(message, `${messageArray[0]}`);\n                        }\n                        else {\n                            message = typesLib.add(message, messageArray.map(item => `* ${item}`).join('\\n'));\n                        }\n                        if (await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-stock/dialog-success-title', 'Success'), `${message}`, options)) {\n                            await this.$.router.refresh();\n                        }\n                        else {\n                            this.$.storage.remove('mobile-lpnOperations');\n                            await this.$.router.emptyPage();\n                        }\n                    }\n                }\n            }\n            else {\n                // don't want to wait for this one\n                await this.$.sound.error();\n                this._notifier.show(ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__notification__no_products_error', `Enter at least one product.`), 'error');\n            }\n        },\n    })\n], MobileLpnSplitting.prototype, \"createButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileLpnSplitting.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobileLpnSplitting.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__effectiveDate____title\", \"Change date\"),\n        isMandatory: true,\n        maxDate: xtrem_date_time_1.DateValue.today().toString(),\n    })\n], MobileLpnSplitting.prototype, \"effectiveDate\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumber____title\", \"License plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        isTransient: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ status: 'inStock' }, { stockSite: { code: this.stockSite.value ?? undefined } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.code) {\n                if (this.licensePlateNumber.value.isSingleProduct) {\n                    await this._getProductOrLot(this.licensePlateNumber.value.isSingleLot, this.licensePlateNumber.value.code, this.licensePlateNumber.value.location.code);\n                }\n            }\n            this._showLayout();\n            this.$.commitValueAndPropertyChanges();\n            if (this.licensePlateNumber.value?.code) {\n                this.licensePlateNumber.getNextField(true)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumber____columns__title__status\", \"Status\"),\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleLot',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileLpnSplitting.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileLpnSplitting.prototype, \"singleLot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__product____title\", \"Product\"),\n        node: '@sage/x3-master-data/ProductSite',\n        valueField: { product: { code: true } },\n        helperTextField: { product: { upc: true } },\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__product____placeholder\", \"Scan or select\\u2026\"),\n        isTransient: true,\n        canFilter: false,\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        shouldSuggestionsIncludeColumns: true,\n        isDisabled: true,\n        isMandatory: true,\n        filter() {\n            return {\n                stockSite: { code: this.stockSite.value ?? undefined },\n                stock: {\n                    _atLeast: 1,\n                    licensePlateNumber: this.licensePlateNumber.value?.code,\n                    stockSite: this.stockSite.value ?? undefined,\n                },\n            };\n        },\n        async onChange() {\n            if (await this.product.value?.product.code) {\n                const response = await this.$.graph\n                    .node('@sage/x3-master-data/ProductSite')\n                    .query(ui.queryUtils.edgesSelector({\n                    isBeingCounted: true,\n                }, {\n                    filter: {\n                        product: {\n                            code: this.product.value?.product?.code,\n                        },\n                        stockSite: {\n                            code: this.stockSite.value,\n                        },\n                    },\n                }))\n                    .execute();\n                if (typesLib.strictEq(response.edges[0].node.isBeingCounted, true)) {\n                    if (await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                        acceptButton: {\n                            text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                        },\n                        cancelButton: {\n                            text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                        },\n                    })) {\n                        this.nextButton.isHidden = false;\n                        this.product.getNextField(true)?.focus();\n                    }\n                    else {\n                        this.nextButton.isHidden = true;\n                        this.product.value = null;\n                        this.product.focus();\n                    }\n                }\n                else {\n                    this.nextButton.isHidden = false;\n                    this.product.getNextField(true)?.focus();\n                }\n                if (this.licensePlateNumberDestination.value?.isSingleProduct &&\n                    !(await this._validateSingleProduct())) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting_destination_lpn_single_product', `The Destination License plate number is single product.`));\n                    this.nextButton.isHidden = true;\n                    this.product.value = null;\n                    this.product.focus();\n                }\n            }\n            else {\n                this.nextButton.isHidden = true;\n            }\n            this._showLayout();\n            this.$.commitValueAndPropertyChanges();\n        },\n        columns: [\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: 'code',\n                node: '@sage/x3-master-data/Product',\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: 'localizedDescription1',\n                node: '@sage/x3-master-data/Product',\n            }),\n            ui.nestedFields.reference({\n                bind: 'product',\n                valueField: 'upc',\n                node: '@sage/x3-master-data/Product',\n            }),\n        ],\n    })\n], MobileLpnSplitting.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumberDestination____title\", \"Destination license plate number\"),\n        valueField: 'code',\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumberDestination____placeholder\", \"Scan or select...\"),\n        isMandatory: false,\n        isTransient: false,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        canFilter: false,\n        filter() {\n            return {\n                _and: [{ isActive: true }, { stockSite: { code: this.stockSite.value ?? undefined } }],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumberDestination.value?.isSingleProduct && !(await this._validateSingleProduct())) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting_destination_lpn_single_product', `The Destination License plate number is single product.`));\n                this.licensePlateNumberDestination.value = null;\n                this.licensePlateNumberDestination.focus();\n            }\n            if (await this.licensePlateNumberDestination.value?.isSingleLot) {\n                let resultSingleLot = true;\n                let resultLot = undefined;\n                this.savedObject.lpnOperations?.stockChangeLines?.forEach(line => {\n                    line.stockDetails?.forEach(lineDetail => {\n                        if (resultLot) {\n                            if (typesLib.strictNe(lineDetail.lot, resultLot)) {\n                                resultSingleLot = false;\n                            }\n                        }\n                        else {\n                            resultLot = lineDetail.lot;\n                        }\n                    });\n                });\n                if (resultSingleLot && resultLot) {\n                    const response = await this.$.graph\n                        .node('@sage/x3-stock-data/Stock')\n                        .query(ui.queryUtils.edgesSelector({ _id: true }, {\n                        filter: {\n                            lot: { _ne: resultLot },\n                            licensePlateNumber: this.licensePlateNumberDestination.value?.code,\n                        },\n                    }))\n                        .execute();\n                    resultSingleLot = typesLib.strictEq(response.edges.length, 0);\n                }\n                if (!resultSingleLot) {\n                    await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting_destination_lpn_single_lot', `The Destination License plate number is single lot.`));\n                    this.licensePlateNumberDestination.value = null;\n                    this.licensePlateNumberDestination.focus();\n                }\n            }\n            if (this.licensePlateNumberDestination.value?.code) {\n                if (this.licensePlateNumberDestination.value.location) {\n                    this.locationDestination.value = this.licensePlateNumberDestination.value.location;\n                    this.locationDestination.isDisabled = typesLib.strictEq(this.licensePlateNumberDestination.value.status, 'inStock');\n                }\n                else {\n                    this.locationDestination.value = null;\n                    this.locationDestination.isDisabled = false;\n                }\n            }\n            else {\n                this.locationDestination.value = null;\n                this.locationDestination.isDisabled = false;\n            }\n            this._showLpnLocationDestination();\n            this.$.commitValueAndPropertyChanges();\n            this._showLayout();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n            }),\n            ui.nestedFields.reference({\n                bind: 'location',\n                valueField: 'code',\n                node: '@sage/x3-stock-data/Location',\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__licensePlateNumberDestination____columns__title__status\", \"Status\"),\n                isHidden: false,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleLot',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileLpnSplitting.prototype, \"licensePlateNumberDestination\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.mainBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__locationDestination____title\", \"Destination location\"),\n        node: '@sage/x3-stock-data/Location',\n        valueField: 'code',\n        isMandatory: false,\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__locationDestination____placeholder\", \"Scan or select\\u2026\"),\n        isAutoSelectEnabled: true,\n        isFullWidth: true,\n        canFilter: false,\n        filter() {\n            const locationFilter = {\n                stockSite: { code: this.stockSite.value },\n                category: { _nin: ['subcontract', 'customer'] },\n            };\n            return locationFilter;\n        },\n        async onChange() {\n            if (await this.locationDestination.value?.code) {\n                this.locationDestination.getNextField(true)?.focus();\n            }\n            this._showLpnLocationDestination();\n            this._showLayout();\n            this.$.commitValueAndPropertyChanges();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__locationDestination____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__locationDestination____columns__title__type\", \"Type\"),\n            }),\n        ],\n    })\n], MobileLpnSplitting.prototype, \"locationDestination\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__stockChangeLinesBlock____title\", \"Splitting in progress\"),\n        width: 'extra-large',\n        isHidden: true,\n    })\n], MobileLpnSplitting.prototype, \"stockChangeLinesBlock\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.stockChangeLinesBlock;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__stockChangeLines____title\", \"Splitting:\"),\n        isTransient: true,\n        canSelect: false,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__stockChangeLines____columns__title__product\", \"Product\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'licensePlateNumber',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__stockChangeLines____columns__title__licensePlateNumber\", \"License plate number\"),\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'delete',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting__stockChangeLines____dropdownActions__title\", \"Delete\"),\n                onClick(rowId) {\n                    const _stockChangeLines = this.savedObject?.lpnOperations?.stockChangeLines;\n                    _stockChangeLines?.splice(rowId, 1);\n                    if (!_stockChangeLines || typesLib.strictEq(Number(_stockChangeLines.length), 0)) {\n                        this._initStorage();\n                        this.createButton.isDisabled = true;\n                        this.$.router.goTo('@sage/x3-stock/MobileLpnSplitting');\n                    }\n                    else {\n                        this.stockChangeLines.value = this._mapStockChange(_stockChangeLines);\n                        this.stockChangeLines.title = ui.localize('@sage/x3-stock/pages_mobile_lpn_splitting__title_table', 'Splitting: {{ title }}', {\n                            title: this.stockChangeLines.value.length.toString(),\n                        });\n                        // don't forget to update session storage or deleted lines will reappear if user refreshes the page\n                        this.savedObject = {\n                            ...this.savedObject,\n                            lpnOperations: {\n                                ...this.savedObject.lpnOperations,\n                                effectiveDate: this.effectiveDate.value,\n                            },\n                        };\n                        this._saveLpnOperations();\n                    }\n                },\n            },\n        ],\n        mobileCard: {\n            title: ui.nestedFields.text({\n                bind: 'product',\n            }),\n            titleRight: ui.nestedFields.text({\n                bind: 'licensePlateNumber',\n            }),\n        },\n    })\n], MobileLpnSplitting.prototype, \"stockChangeLines\", void 0);\nexports.MobileLpnSplitting = MobileLpnSplitting = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_splitting____title\", \"LPN splitting\"),\n        mode: 'default',\n        menuItem: lpn_1.lpn,\n        priority: 300,\n        isTransient: false,\n        isTitleHidden: true,\n        authorizationCode: 'CWSLPNS',\n        access: { node: '@sage/x3-stock-data/LicensePlateNumber' },\n        skipDirtyCheck: true,\n        async onLoad() {\n            const returnFromDetail = this.$.queryParameters['ReturnFromDetail'];\n            if (typesLib.ne(returnFromDetail, 'yes'))\n                this.$.storage.remove('mobile-lpnOperations');\n            this._currentOperation = 0;\n            await this._init();\n            this.effectiveDate.value = xtrem_date_time_1.DateValue.today().toString();\n            this._showLpnLocationDestination();\n            this._showLayout();\n        },\n        businessActions() {\n            return [this.createButton, this.nextButton];\n        },\n    })\n], MobileLpnSplitting);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-lpn-splitting.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-stock-data/build/lib/menu-items/lpn.js":
/*!**************************************************************!*\
  !*** ../../shared/x3-stock-data/build/lib/menu-items/lpn.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\n// Uncomment lines 3+ when the LPN menu item is needed.\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.lpn = void 0;\nexports.lpn = {\n    id: '@sage/x3-stock-data/lpn-root',\n    priority: 400,\n    title: 'LPN',\n    icon: 'three_boxes',\n};\n//# sourceMappingURL=lpn.js.map//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLXN0b2NrLWRhdGEvYnVpbGQvbGliL21lbnUtaXRlbXMvbHBuLmpzIiwibWFwcGluZ3MiOiJBQUFhO0FBQ2I7QUFDQSw4Q0FBNkMsRUFBRSxhQUFhLEVBQUM7QUFDN0QsV0FBVztBQUNYLFdBQVc7QUFDWDtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly94dHJlbUFydGlmYWN0Ly4uLy4uL3NoYXJlZC94My1zdG9jay1kYXRhL2J1aWxkL2xpYi9tZW51LWl0ZW1zL2xwbi5qcz81NDI1Il0sInNvdXJjZXNDb250ZW50IjpbIlwidXNlIHN0cmljdFwiO1xuLy8gVW5jb21tZW50IGxpbmVzIDMrIHdoZW4gdGhlIExQTiBtZW51IGl0ZW0gaXMgbmVlZGVkLlxuT2JqZWN0LmRlZmluZVByb3BlcnR5KGV4cG9ydHMsIFwiX19lc01vZHVsZVwiLCB7IHZhbHVlOiB0cnVlIH0pO1xuZXhwb3J0cy5scG4gPSB2b2lkIDA7XG5leHBvcnRzLmxwbiA9IHtcbiAgICBpZDogJ0BzYWdlL3gzLXN0b2NrLWRhdGEvbHBuLXJvb3QnLFxuICAgIHByaW9yaXR5OiA0MDAsXG4gICAgdGl0bGU6ICdMUE4nLFxuICAgIGljb246ICd0aHJlZV9ib3hlcycsXG59O1xuLy8jIHNvdXJjZU1hcHBpbmdVUkw9bHBuLmpzLm1hcCJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-stock-data/build/lib/menu-items/lpn.js\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-date-time":
/*!****************************************!*\
  !*** external "@sage/xtrem-date-time" ***!
  \****************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-date-time");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-shared":
/*!*************************************!*\
  !*** external "@sage/xtrem-shared" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-shared");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-lpn-splitting.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;