/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-lpn-grouping-select-lpn.ts":
/*!*****************************************************!*\
  !*** ./lib/pages/mobile-lpn-grouping-select-lpn.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileLpnGroupingSelectLpn = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_page_values_not_transient_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-page-values-not-transient */ \"../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nlet MobileLpnGroupingSelectLpn = class MobileLpnGroupingSelectLpn extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this._currentLine = 0;\n    }\n    /*\n     *  Functions\n     */\n    async _fetchLicensePlateNumber(licensePlateNumberCode) {\n        // read license plate number record\n        const response = await this.$.graph\n            .node('@sage/x3-stock-data/license-plate-number')\n            .read({\n            code: true,\n            location: {\n                code: true,\n            },\n            isSingleProduct: true,\n            isSingleLot: true,\n            status: true,\n            container: {\n                code: true,\n            },\n            stockSite: {\n                code: true,\n            },\n        }, `${licensePlateNumberCode}`)\n            .execute();\n        // If an error occurred\n        if (!response) {\n            throw new Error(ui.localize('@sage/x3-stock/pages__mobile_stock_change_by_lpn_destination__notification__invalid_license_plate_number_error', `Could not retrieve your licensePlateNumber {{ licensePlateNumberCode }}`, {\n                licensePlateNumberCode: licensePlateNumberCode,\n            }));\n        }\n        return response;\n    }\n    async _loadProductLotLpn() {\n        try {\n            const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                product: { product: { code: true } },\n                lot: true,\n            }, {\n                filter: { licensePlateNumber: this.licensePlateNumberDestination.value },\n                first: 1,\n            }))\n                .execute());\n            if (typesLib.strictNe(result.length, 0)) {\n                this.product.value = result[0].product?.product?.code ?? '';\n                this.lot.value = this._licensePlateNumber?.isSingleLot ? result[0]?.lot ?? '' : null;\n            }\n            return;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/error-loading-stock', 'Error loading stock'), String(e));\n            return;\n        }\n    }\n    _getSavedInputs() {\n        return JSON.parse(this.$.storage.get('mobile-lpnGrouping'));\n    }\n    _createDetail() {\n        const values = (0, get_page_values_not_transient_1.getPageValuesNotTransient)(this);\n        this._currentLine = typesLib.sub(this._stockChangeLines.push(values), 1);\n        this._saveDetail();\n    }\n    _saveDetail() {\n        let currentStockChangeLines = this._stockChangeLines[this._currentLine];\n        this._stockChangeLines[this._currentLine] = {\n            ...currentStockChangeLines,\n        };\n        this._saveStockChange();\n    }\n    _saveStockChange() {\n        let savedInputs = this._getSavedInputs();\n        savedInputs.stockChangeByLpn.stockChangeLines = this._stockChangeLines;\n        savedInputs.currentLine = this._currentLine;\n        const currentLine = savedInputs.currentLine;\n        savedInputs.stockChangeByLpn.stockChangeLines[currentLine].licensePlateNumber =\n            this.licensePlateNumber.value?.code;\n        savedInputs.stockChangeByLpn.stockChangeLines[currentLine] = {\n            ...savedInputs.stockChangeByLpn.stockChangeLines[currentLine],\n        };\n        this.$.storage.set('mobile-lpnGrouping', JSON.stringify(savedInputs));\n    }\n    /*\n     * Check the stock records for the entered LPN to ensure it doesn't contain\n     * product(s) or lot(s) that conflict with the destination LPN\n     */\n    async _checkStock() {\n        try {\n            let stockFilter;\n            if (this.lot.value) {\n                stockFilter = {\n                    stockSite: this.stockSite.value,\n                    licensePlateNumber: this.licensePlateNumber.value?.code,\n                    _or: [{ product: { _ne: this.product.value } }, { lot: { _ne: this.lot.value } }],\n                };\n            }\n            else {\n                stockFilter = {\n                    stockSite: this.stockSite.value,\n                    licensePlateNumber: this.licensePlateNumber.value?.code,\n                    product: { _ne: this.product.value },\n                };\n            }\n            const result = await this.$.graph\n                .node('@sage/x3-stock-data/Stock')\n                .query(ui.queryUtils.edgesSelector({\n                product: { product: { code: true } },\n                lot: true,\n            }, {\n                filter: stockFilter,\n            }))\n                .execute();\n            if (typesLib.gt(result.edges.length, 0)) {\n                this.$.removeToasts();\n                this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-singleProductOrLot', 'LPN contains product(s) or lot(s) that cannot be grouped'), { type: 'error' });\n                return false;\n            }\n            return true;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-stock/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-stock/dialog-error-reading-stock', 'Reading stock record: '), String(e)));\n            return false;\n        }\n    }\n};\nexports.MobileLpnGroupingSelectLpn = MobileLpnGroupingSelectLpn;\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"licensePlateNumberDestination\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n        isReadOnly: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__nextButton____title\", \"Next\"),\n        buttonType: 'primary',\n        isDisabled: true,\n        shortcut: ['f3'],\n        async onClick() {\n            if (this.licensePlateNumber.value?.code) {\n                this._createDetail();\n            }\n            this.$.setPageClean();\n            this.$.router.goTo('@sage/x3-stock/MobileLpnGrouping', { ReturnFromDetail: 'yes' });\n        },\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__moreButton____title\", \"Add LPN\"),\n        buttonType: 'secondary',\n        isDisabled: true,\n        shortcut: ['f7'],\n        async onClick() {\n            if (this.licensePlateNumber.value?.code) {\n                this._createDetail();\n                this.licensePlateNumber.value = null;\n                this.licensePlateNumber.focus();\n                await this.$.commitValueAndPropertyChanges();\n            }\n        },\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"moreButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__viewStockByLpn____title\", \"View stock by LPN\"),\n        buttonType: 'secondary',\n        isDisabled: false,\n        async onClick() {\n            this.$.setPageClean();\n            this.$.router.goTo('@sage/x3-stock/MobileViewStockByLpn');\n        },\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"viewStockByLpn\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n        isTitleHidden: true,\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.block;\n        },\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____title\", \"License plate number to group\"),\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        valueField: 'code',\n        placeholder: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____placeholder\", \"Scan or select\\u2026\"),\n        isMandatory: true,\n        isTransient: true,\n        canFilter: false,\n        isAutoSelectEnabled: true,\n        isDisabled: false,\n        isFullWidth: true,\n        shouldSuggestionsIncludeColumns: true,\n        filter() {\n            return {\n                _and: [\n                    { isActive: true },\n                    { status: { _eq: 'inStock' } },\n                    { stockSite: { code: this.stockSite.value } },\n                    // { code: { _ne: this.licensePlateNumberDestination.value } },\n                ],\n            };\n        },\n        async onChange() {\n            if (this.licensePlateNumber.value?.code) {\n                // Make sure they didn't enter the destination LPN\n                if (typesLib.strictEq(this.licensePlateNumber.value.code, this.licensePlateNumberDestination.value)) {\n                    this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-same-as-destination-lpn', 'LPN selected is the LPN destination'), { type: 'error' });\n                    this.licensePlateNumber.value = null;\n                    this.licensePlateNumber.focus();\n                    return;\n                }\n                // See if we need to check the product and lot\n                // associated with the LPN to group\n                if (this.product.value || this.lot.value) {\n                    if (!(await this._checkStock())) {\n                        this.licensePlateNumber.value = null;\n                        this.licensePlateNumber.focus();\n                        return;\n                    }\n                    //check if product is blocked by count\n                    const response = await this.$.graph\n                        .node('@sage/x3-master-data/ProductSite')\n                        .query(ui.queryUtils.edgesSelector({\n                        isBeingCounted: true,\n                    }, {\n                        filter: {\n                            product: {\n                                code: this.product.value,\n                            },\n                            stockSite: {\n                                code: this.stockSite.value,\n                            },\n                        },\n                    }))\n                        .execute();\n                    if (typesLib.strictEq(response.edges[0].node?.isBeingCounted, true)) {\n                        if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-stock/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-stock/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-stock/button-accept-yes', 'Yes'),\n                            },\n                            cancelButton: {\n                                text: ui.localize('@sage/x3-stock/button-cancel-no', 'No'),\n                            },\n                        }))) {\n                            this.licensePlateNumber.value = null;\n                            this.licensePlateNumber.focus();\n                            return;\n                        }\n                    }\n                }\n                // Check to see if the user already chose this LPN\n                // Don't allow them to add a duplicate LPN\n                if (this._stockChangeLines.find(lpn => typesLib.strictEq(lpn.licensePlateNumber, this.licensePlateNumber.value?.code))) {\n                    this.$.showToast(ui.localize('@sage/x3-stock/dialog-error-lpn-already-in-use', 'LPN already in use'), { type: 'error' });\n                    this.licensePlateNumber.value = null;\n                    this.licensePlateNumber.focus();\n                    return;\n                }\n                this.moreButton.isDisabled = false;\n                this.nextButton.isDisabled = false;\n            }\n            else {\n                this.moreButton.isDisabled = true;\n                this.nextButton.isDisabled = true;\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____columns__title__code\", \"License plate number to group\"),\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____columns__title__location__code\", \"Location\"),\n                bind: 'location',\n                valueField: 'code',\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____columns__title__status\", \"Status\"),\n                isHidden: false,\n            }),\n            ui.nestedFields.checkbox({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____columns__title__isSingleProduct\", \"Single product\"),\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn__licensePlateNumber____columns__title__isSingleLot\", \"Single lot\"),\n                bind: 'isSingleLot',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileLpnGroupingSelectLpn.prototype, \"licensePlateNumber\", void 0);\nexports.MobileLpnGroupingSelectLpn = MobileLpnGroupingSelectLpn = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn____title\", \"LPN grouping\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_lpn_grouping_select_lpn____subtitle\", \"Select LPN\"),\n        mode: 'default',\n        isTransient: false,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.licensePlateNumberDestination,\n                titleRight: this.location,\n                line2: this.product,\n                line2Right: this.lot,\n            };\n        },\n        async onLoad() {\n            this.stockSite.value = this.$.storage.get('mobile-selected-stock-site');\n            const inputStockChangeByLpn = this._getSavedInputs();\n            if (!this.stockSite.value || !inputStockChangeByLpn?.selectedDestinationLPN?.code) {\n                this.nextButton.isHidden = true;\n                this.viewStockByLpn.isHidden = true;\n                this.block.isHidden = true;\n                return;\n            }\n            this._stockChangeLines = inputStockChangeByLpn?.stockChangeByLpn?.stockChangeLines;\n            this.licensePlateNumberDestination.value = inputStockChangeByLpn?.selectedDestinationLPN?.code;\n            this._licensePlateNumber = await this._fetchLicensePlateNumber(this.licensePlateNumberDestination.value ?? '');\n            this.location.value = this._licensePlateNumber?.location\n                ? this._licensePlateNumber?.location?.code ?? null\n                : inputStockChangeByLpn?.destinationLocation ?? null;\n            if (this._licensePlateNumber?.isSingleProduct) {\n                await this._loadProductLotLpn();\n            }\n            this.licensePlateNumber.focus();\n        },\n        businessActions() {\n            return [this.nextButton, this.moreButton, this.viewStockByLpn];\n        },\n    })\n], MobileLpnGroupingSelectLpn);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-lpn-grouping-select-lpn.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts":
/*!*****************************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getPageValuesNotTransient = void 0;\n/**\n * Return values not transient for current page\n * @param pageInstance Current page instance\n * @returns array of values not transient\n */\nconst getPageValuesNotTransient = (pageInstance) => {\n    const screenValues = pageInstance.$.values;\n    const keys = Object.keys(screenValues);\n    keys.forEach(elementId => {\n        const properties = pageInstance._pageMetadata.uiComponentProperties[elementId];\n        if (properties && properties.isTransient) {\n            delete screenValues[elementId];\n        }\n    });\n    return screenValues;\n};\nexports.getPageValuesNotTransient = getPageValuesNotTransient;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL2dldC1wYWdlLXZhbHVlcy1ub3QtdHJhbnNpZW50LnRzIiwibWFwcGluZ3MiOiI7OztBQUVBOzs7O0dBSUc7QUFFSSxNQUFNLHlCQUF5QixHQUFHLENBQ3JDLFlBQXFCLEVBQ1osRUFBRTtJQUNYLE1BQU0sWUFBWSxHQUFHLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO0lBQzNDLE1BQU0sSUFBSSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDdkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsRUFBRTtRQUNyQixNQUFNLFVBQVUsR0FBRyxZQUFZLENBQUMsYUFBYSxDQUFDLHFCQUFxQixDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQy9FLElBQUksVUFBVSxJQUFJLFVBQVUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztZQUN2QyxPQUFPLFlBQVksQ0FBQyxTQUFTLENBQUMsQ0FBQztRQUNuQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7SUFDSCxPQUFPLFlBQVksQ0FBQztBQUN4QixDQUFDLENBQUM7QUFaVyxpQ0FBeUIsNkJBWXBDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvZ2V0LXBhZ2UtdmFsdWVzLW5vdC10cmFuc2llbnQudHM/YTdhNSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEaWN0IH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbi8qKlxuICogUmV0dXJuIHZhbHVlcyBub3QgdHJhbnNpZW50IGZvciBjdXJyZW50IHBhZ2VcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgQ3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcmV0dXJucyBhcnJheSBvZiB2YWx1ZXMgbm90IHRyYW5zaWVudFxuICovXG5cbmV4cG9ydCBjb25zdCBnZXRQYWdlVmFsdWVzTm90VHJhbnNpZW50ID0gKFxuICAgIHBhZ2VJbnN0YW5jZTogdWkuUGFnZSxcbik6IERpY3Q8YW55PiA9PiB7XG4gICAgY29uc3Qgc2NyZWVuVmFsdWVzID0gcGFnZUluc3RhbmNlLiQudmFsdWVzO1xuICAgIGNvbnN0IGtleXMgPSBPYmplY3Qua2V5cyhzY3JlZW5WYWx1ZXMpO1xuICAgIGtleXMuZm9yRWFjaChlbGVtZW50SWQgPT4ge1xuICAgICAgICBjb25zdCBwcm9wZXJ0aWVzID0gcGFnZUluc3RhbmNlLl9wYWdlTWV0YWRhdGEudWlDb21wb25lbnRQcm9wZXJ0aWVzW2VsZW1lbnRJZF07XG4gICAgICAgIGlmIChwcm9wZXJ0aWVzICYmIHByb3BlcnRpZXMuaXNUcmFuc2llbnQpIHtcbiAgICAgICAgICAgIGRlbGV0ZSBzY3JlZW5WYWx1ZXNbZWxlbWVudElkXTtcbiAgICAgICAgfVxuICAgIH0pO1xuICAgIHJldHVybiBzY3JlZW5WYWx1ZXM7XG59OyJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-page-values-not-transient.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-lpn-grouping-select-lpn.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;