/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/pages/mobile-location-reorder-todo.ts":
/*!***************************************************!*\
  !*** ./lib/pages/mobile-location-reorder-todo.ts ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileLocationReorderTodo = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nlet MobileLocationReorderTodo = class MobileLocationReorderTodo extends ui.Page {\n    constructor() {\n        super(...arguments);\n        this.locationReorders = [];\n    }\n    async searchLocationReorders(stockSite, storageListNumber, transactionCode) {\n        const rawAllocationRecords = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock/Allocation')\n            .query(ui.queryUtils.edgesSelector({\n            stockSite: {\n                code: true,\n            },\n            product: {\n                code: true,\n                localizedDescription1: true,\n                serialNumberManagementMode: true,\n                upc: true,\n            },\n            stockId: true,\n            sequenceNumber: true,\n            allocationType: true,\n            documentType: true,\n            documentNumber: true,\n            documentLineNumber: true,\n            documentSequenceNumber: true,\n            quantityInStockUnit: true,\n            activeQuantityInStockUnit: true,\n            warehouse: true,\n            location: true,\n            lot: true,\n            sublot: true,\n            status: true,\n            serialNumber: true,\n            majorVersion: {\n                code: true,\n            },\n            consumptionLocation: true,\n            defaultWarehouse: true,\n            defaultLocation: true,\n            defaultLocationType: true,\n            storageQuantityInStockUnit: true,\n            storageListNumber: true,\n            storageListLineNumber: true,\n            pickingNumber: true,\n            requirementDate: true,\n            transactionDescription: true,\n            businessPartner: {\n                code: true,\n            },\n            deliveryAddress: {\n                shipToAddress: {\n                    code: true,\n                }\n            },\n            stockLine: {\n                stockId: true,\n                location: {\n                    code: true,\n                },\n                packingUnitToStockUnitConversionFactor: true,\n                packingUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                lot: true,\n                sublot: true,\n                serialNumber: true,\n                status: {\n                    code: true,\n                },\n                identifier1: true,\n                identifier2: true,\n                licensePlateNumber: {\n                    code: true,\n                },\n            },\n            reorderLine: {\n                query: {\n                    edges: {\n                        node: {\n                            _id: true,\n                            destinationLocation: true,\n                        },\n                    },\n                },\n            },\n        }, {\n            filter: {\n                stockSite: stockSite,\n                storageListNumber: storageListNumber,\n            },\n        }))\n            .execute());\n        const allocationRecords = await rawAllocationRecords\n            .sort((a, b) => (typesLib.gt((a.storageListLineNumber), (b.storageListLineNumber)) ? 1 : -1));\n        const map = await this.getShortagesDetailed(allocationRecords);\n        const locationReorder = [];\n        allocationRecords.forEach((element) => {\n            if (element.reorderLine?.length) {\n                // replenishment type\n                // Get 'product' for replenishment reorder type\n                const product = element.product?.code;\n                const localizedDescription1 = element.product?.localizedDescription1;\n                const upc = element.product?.upc;\n                // Get 'toLocation'  for replenishment reorder type\n                const toLocation = element.reorderLine[0]?.destinationLocation;\n                const fromLocation = (element.stockLine?.location)\n                    ? element.stockLine?.location?.code : '';\n                // Get 'packingUnitToStockUnitConversionFactor' for replenishment reorder type\n                let packingUnitToStockUnitConversionFactor = element.stockLine?.packingUnitToStockUnitConversionFactor;\n                // Get 'reorderQuantity' for replenishment reorder type\n                let reorderQuantity;\n                if (packingUnitToStockUnitConversionFactor) {\n                    reorderQuantity = (typesLib.div(Number(element.quantityInStockUnit), Number(packingUnitToStockUnitConversionFactor))).toString();\n                }\n                else {\n                    reorderQuantity = element.quantityInStockUnit.toString();\n                    packingUnitToStockUnitConversionFactor = '1';\n                }\n                // Get 'decimalPrecision' for replenishment reorder type\n                const decimalPrecision = (element.stockLine?.packingUnit)\n                    ? element.stockLine?.packingUnit?.numberOfDecimals?.toString()\n                    : '0';\n                // round 'reorderQuantity'\n                reorderQuantity = this.round(Number(reorderQuantity), Number(decimalPrecision)).toString();\n                // Get 'reorderUnit' for replenishment reorder type\n                const reorderUnit = (element.stockLine?.packingUnit)\n                    ? element.stockLine?.packingUnit?.code\n                    : '';\n                // Get 'lot' for replenishment reorder type\n                const lot = (element.stockLine?.lot) ? element.stockLine?.lot?.toString() : '';\n                // Get 'sublot' for replenishment reorder type\n                const sublot = (element.stockLine?.sublot) ? element.stockLine?.sublot?.toString() : '';\n                // Get 'serialNumber' for replenishment reorder type\n                const serialNumber = this.getSerialNumber(element);\n                // Get 'status' for replenishment reorder type\n                const status = (element.stockLine) ? element.stockLine?.status?.code : '';\n                // Get 'documentLine' for replenishment reorder type\n                const documentLine = element.documentLineNumber?.toString() || '';\n                // Get 'stockId' for replenishment reorder type\n                const stockId = element.stockId?.toString() || '';\n                // Get 'stockSequence' for replenishment reorder type\n                const stockSequence = element.sequenceNumber?.toString() || '';\n                // Get 'identifier1' for replenishment reorder type\n                const identifier1 = (element.stockLine) ? element.stockLine.identifier1?.toString() : '';\n                // Get 'identifier2' for replenishment reorder type\n                const identifier2 = (element.stockLine) ? element.stockLine.identifier2?.toString() : '';\n                // Get 'licensePlateNumber' for replenishment reorder type\n                const licensePlateNumber = (element.stockLine) ? element.stockLine.licensePlateNumber?.code?.toString() : '';\n                if (typesLib.strictNe(reorderQuantity, undefined) && typesLib.strictNe(reorderUnit, undefined)) {\n                    const locationReorderInstance = {\n                        product,\n                        localizedDescription1,\n                        upc,\n                        toLocation,\n                        fromLocation,\n                        reorderQuantity,\n                        reorderUnit,\n                        decimalPrecision,\n                        source: 'Replenishment',\n                        lot,\n                        sublot,\n                        serialNumber,\n                        status,\n                        documentLine,\n                        stockId,\n                        stockSequence,\n                        identifier1,\n                        identifier2,\n                        licensePlateNumber,\n                        packingUnitToStockUnitConversionFactor: packingUnitToStockUnitConversionFactor.toString(),\n                    };\n                    locationReorder.push(locationReorderInstance);\n                }\n            }\n            else if (element.consumptionLocation) {\n                // consumption type\n                // Get 'product' for consumptions reorder type\n                const product = element.product?.code;\n                const localizedDescription1 = element.product?.localizedDescription1;\n                const upc = element.product?.upc;\n                // Get 'toLocation' for consumptions reorder type\n                const toLocation = element.consumptionLocation;\n                // Get 'fromLocation' for consumptions reorder type\n                const fromLocation = (element.stockLine?.location)\n                    ? element.stockLine?.location?.code?.toString()\n                    : '';\n                // Get 'packingUnitToStockUnitConversionFactor' for consumptions reorder type\n                let packingUnitToStockUnitConversionFactor = element.stockLine?.packingUnitToStockUnitConversionFactor;\n                // Get 'reorderQuantity' for consumptions reorder type\n                let reorderQuantity;\n                if (packingUnitToStockUnitConversionFactor) {\n                    reorderQuantity = (typesLib.div(Number(element.quantityInStockUnit), Number(packingUnitToStockUnitConversionFactor))).toString();\n                }\n                else {\n                    reorderQuantity = element.quantityInStockUnit?.toString();\n                    packingUnitToStockUnitConversionFactor = '1';\n                }\n                // Get 'decimalPrecision' for consumptions reorder type\n                let decimalPrecision = (element.stockLine?.packingUnit)\n                    ? element.stockLine?.packingUnit?.numberOfDecimals?.toString()\n                    : '0';\n                reorderQuantity = this.round(Number(reorderQuantity), Number(decimalPrecision)).toString();\n                // Get 'reorderUnit' for consumptions reorder type\n                const reorderUnit = (element.stockLine?.packingUnit) ? element.stockLine?.packingUnit?.code : '';\n                // Get 'lot' for consumptions reorder type\n                const lot = (element.stockLine) ? element.stockLine?.lot?.toString() : '';\n                // Get 'sublot' for consumptions reorder type\n                const sublot = (element.stockLine) ? element.stockLine?.sublot?.toString() : '';\n                // Get 'serialNumber' for consumptions reorder type\n                const serialNumber = this.getSerialNumber(element);\n                // Get 'status' for consumptions reorder type\n                const status = (element.stockLine) ? element.stockLine?.status?.code?.toString() : '';\n                // Get 'documentLine' for consumptions reorder type\n                const documentLine = element.documentLineNumber?.toString();\n                // Get 'stockId' for consumptions reorder type\n                const stockId = element.stockId?.toString();\n                // Get 'stockSequence' for consumptions reorder type\n                const stockSequence = element.sequenceNumber?.toString();\n                // Get 'identifier1' for consumptions reorder type\n                const identifier1 = (element.stockLine) ? element.stockLine.identifier1?.toString() : '';\n                // Get 'identifier2' for consumptions reorder type\n                const identifier2 = (element.stockLine) ? element.stockLine.identifier2?.toString() : '';\n                // Get 'licensePlateNumber' for consumptions reorder type\n                const licensePlateNumber = (element.stockLine) ? element.stockLine.licensePlateNumber?.code?.toString() : '';\n                if (typesLib.strictNe(reorderQuantity, undefined) && typesLib.strictNe(reorderUnit, undefined)) {\n                    const locationReorderInstance = {\n                        product,\n                        localizedDescription1,\n                        upc,\n                        toLocation,\n                        fromLocation,\n                        reorderQuantity,\n                        reorderUnit,\n                        decimalPrecision,\n                        source: 'Consumption',\n                        lot,\n                        sublot,\n                        serialNumber,\n                        status,\n                        documentLine,\n                        stockId,\n                        stockSequence,\n                        identifier1,\n                        identifier2,\n                        licensePlateNumber,\n                        packingUnitToStockUnitConversionFactor: packingUnitToStockUnitConversionFactor.toString(),\n                    };\n                    locationReorder.push(locationReorderInstance);\n                }\n            }\n            else if (typesLib.strictNe(element.allocationType, 'detailedShortage')) {\n                // shortage type\n                // Get 'product' for shortage reorder type\n                const product = element.product?.code;\n                const localizedDescription1 = element.product?.localizedDescription1;\n                const upc = element.product?.upc;\n                // Get 'documentLine' for shortage reorder type\n                const documentLine = element.documentLineNumber?.toString();\n                // Get 'stockSequence' for shortage reorder type\n                const stockSequence = element.sequenceNumber?.toString();\n                // The following variables will be retrieved depending on whether the allocation type is 'shortagesDetailed' or 'detailed'\n                const toLocation = map.get(element.storageListLineNumber)?.location;\n                // inside location.code property of 'shortages detailed' allocation type record\n                const fromLocation = (element.stockLine?.location)\n                    ? element.stockLine?.location?.code?.toString()\n                    : ''; // inside stock line property of 'detailed' allocation type record\n                let packingUnitToStockUnitConversionFactor;\n                let reorderQuantity; // inside stock line property of 'detailed' allocation type record\n                const reorderUnit = element.stockLine?.packingUnit?.code;\n                // inside stock line property of 'detailed' allocation type record\n                let decimalPrecision;\n                let lot; // inside stock line property of 'detailed' allocation type record\n                let sublot; // inside stock line property of 'detailed' allocation type record\n                let serialNumber; // inside stock line property of 'detailed' allocation type record\n                let status; // inside stock line property of 'detailed' allocation type record\n                let stockId;\n                let identifier1;\n                let identifier2;\n                let licensePlateNumber;\n                packingUnitToStockUnitConversionFactor = Number(element.stockLine?.packingUnitToStockUnitConversionFactor);\n                if (typesLib.strictNe(packingUnitToStockUnitConversionFactor, undefined)) {\n                    reorderQuantity = (typesLib.div(Number(element.quantityInStockUnit), Number(packingUnitToStockUnitConversionFactor))).toString();\n                }\n                else {\n                    reorderQuantity = element.quantityInStockUnit?.toString();\n                    packingUnitToStockUnitConversionFactor = 1;\n                }\n                decimalPrecision = (element.stockLine) ? element.stockLine.packingUnit?.numberOfDecimals?.toString() : '0';\n                reorderQuantity = this.round(Number(reorderQuantity), Number(decimalPrecision)).toString();\n                lot = (element.stockLine) ? element.stockLine.lot?.toString() : '';\n                sublot = (element.stockLine) ? element.stockLine.sublot?.toString() : '';\n                if (typesLib.strictEq(element.product?.serialNumberManagementMode, 'receivedIssued')) {\n                    serialNumber = (element.stockLine) ? element.stockLine.serialNumber?.toString() : '';\n                }\n                else if (typesLib.strictEq(element.product?.serialNumberManagementMode, 'globalReceivedIssued')) {\n                    serialNumber = element.serialNumber;\n                }\n                status = (element.stockLine) ? element.stockLine.status?.code?.toString() : '';\n                stockId = (element.stockLine) ? element.stockLine.stockId?.toString() : '';\n                identifier1 = (element.stockLine) ? element.stockLine.identifier1?.toString() : '';\n                identifier2 = (element.stockLine) ? element.stockLine.identifier2?.toString() : '';\n                licensePlateNumber = (element.stockLine) ? element.stockLine.licensePlateNumber?.code?.toString() : '';\n                if (typesLib.strictNe(reorderQuantity, undefined) && typesLib.strictNe(reorderUnit, undefined)) {\n                    const locationReorderInstance = {\n                        product,\n                        localizedDescription1,\n                        upc,\n                        toLocation,\n                        fromLocation,\n                        reorderQuantity,\n                        reorderUnit,\n                        decimalPrecision,\n                        source: 'Shortage',\n                        lot,\n                        sublot,\n                        serialNumber,\n                        status,\n                        documentLine,\n                        stockId,\n                        stockSequence,\n                        identifier1,\n                        identifier2,\n                        licensePlateNumber,\n                        packingUnitToStockUnitConversionFactor: packingUnitToStockUnitConversionFactor.toString(),\n                    };\n                    locationReorder.push(locationReorderInstance);\n                }\n            }\n        });\n        const stockEntryTransaction = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock/StockEntryTransaction')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n            isLocationReplenishable: true,\n            isConsumptionArea: true,\n            isShortages: true,\n        }, {\n            filter: {\n                code: transactionCode,\n                transactionType: 'reorderPlan',\n            },\n        }))\n            .execute());\n        // filter locationReorders\n        if (!(await stockEntryTransaction[0].isLocationReplenishable)) {\n            // If the transaction is not replenishable, pop out replenishment records\n            for (let i = 0; typesLib.lt(i, locationReorder.length); i = typesLib.add(i, 1)) {\n                if (typesLib.strictNe(locationReorder[i], undefined)) {\n                    if (typesLib.strictEq(locationReorder[i].source, 'Replenishment')) {\n                        delete locationReorder[i];\n                    }\n                }\n            }\n        }\n        if (!(await stockEntryTransaction[0].isConsumptionArea)) {\n            // If the transaction is not consumptions, pop out consumption records\n            for (let i = 0; typesLib.lt(i, locationReorder.length); i = typesLib.add(i, 1)) {\n                if (typesLib.strictNe(locationReorder[i], undefined)) {\n                    if (typesLib.strictEq(locationReorder[i].source, 'Consumption')) {\n                        delete locationReorder[i];\n                    }\n                }\n            }\n        }\n        if (!(await stockEntryTransaction[0].isShortages)) {\n            // If the transaction is not shortages, pop out shortages records\n            for (let i = 0; typesLib.lt(i, locationReorder.length); i = typesLib.add(i, 1)) {\n                if (typesLib.strictNe(locationReorder[i], undefined)) {\n                    if (typesLib.strictEq(locationReorder[i].source, 'Shortage')) {\n                        delete locationReorder[i];\n                    }\n                }\n            }\n        }\n        locationReorder.sort((a, b) => {\n            // Sort by product first\n            if (typesLib.gt(a.product, b.product))\n                return 1;\n            if (typesLib.lt(a.product, b.product))\n                return -1;\n            // If product is the same, sort by serial number\n            if (typesLib.gt(a.serialNumber, b.serialNumber))\n                return 1;\n            if (typesLib.lt(a.serialNumber, b.serialNumber))\n                return -1;\n            return 0;\n        });\n        return locationReorder;\n    }\n    round(reorderQuantity, decimalPrecision) {\n        const factorOfTen = 10 ** decimalPrecision;\n        return typesLib.div(typesLib.round(typesLib.mul(reorderQuantity, factorOfTen)), factorOfTen);\n    }\n    async getShortagesDetailed(allocationRecords) {\n        const map = new Map();\n        for (let i = 0; typesLib.lt(i, allocationRecords.length); i = typesLib.add(i, 1)) {\n            if (typesLib.strictEq((await allocationRecords[i].allocationType), 'detailedShortage')) {\n                map.set(await allocationRecords[i].storageListLineNumber, allocationRecords[i]);\n            }\n        }\n        return map;\n    }\n    getSerialNumber(element) {\n        if (typesLib.strictEq(element.product?.serialNumberManagementMode, 'receivedIssued')) {\n            return (element.stockLine) ? element.stockLine?.serialNumber?.toString() : '';\n        }\n        return (typesLib.strictEq(element.product?.serialNumberManagementMode, 'globalReceivedIssued')) ? element.serialNumber : '';\n    }\n};\nexports.MobileLocationReorderTodo = MobileLocationReorderTodo;\n__decorate([\n    ui.decorators.textField({\n        isTransient: false,\n        isReadOnly: true,\n    })\n], MobileLocationReorderTodo.prototype, \"storageListNumber\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n        isHidden: false,\n    })\n], MobileLocationReorderTodo.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n    })\n], MobileLocationReorderTodo.prototype, \"mainBlock\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.mainBlock;\n        },\n        isHelperTextHidden: true,\n        canSelect: false,\n        canFilter: false,\n        canUserHideColumns: false,\n        hasSearchBoxMobile: true,\n        cardView: true,\n        mobileCard: {\n            title: ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____mobileCard__title__title\", \"Product\"),\n                bind: 'product',\n                isReadOnly: true,\n            }),\n            titleRight: ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____mobileCard__titleRight__title\", \"Quantity and unit\"),\n                bind: 'quantityAndUnit',\n                isReadOnly: true,\n            }),\n            line2: ui.nestedFields.text({\n                bind: 'localizedDescription1',\n                isReadOnly: true,\n            }),\n            line2Right: ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____mobileCard__line2Right__title\", \"UPC code\"),\n                bind: 'upc',\n                isReadOnly: true,\n            }),\n            line3: ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____mobileCard__line3__title\", \"From location\"),\n                bind: 'fromLocation',\n                isReadOnly: true,\n            }),\n            line3Right: ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____mobileCard__line3Right__title\", \"Serial number\"),\n                bind: 'serialNumber',\n                isReadOnly: true,\n            }),\n        },\n        columns: [\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__title__product\", \"Product\"),\n                bind: 'product',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__title__upc\", \"UPC code\"),\n                bind: 'upc',\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__title__quantityAndUnit\", \"Quantity and unit\"),\n                bind: 'quantityAndUnit',\n                prefix: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__prefix__quantityAndUnit\", \"Quantity and unit\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__title__fromLocation\", \"From location\"),\n                bind: 'fromLocation',\n                prefix: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__prefix__fromLocation\", \"From location:\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__title__serialNumber\", \"Serial number\"),\n                prefix: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo__reorders____columns__prefix__serialNumber\", \"Serial number:\"),\n                bind: 'serialNumber',\n                isReadOnly: true,\n            }),\n        ],\n        onRowClick(rowId, rowItem) {\n            const rowIdNum = parseInt(rowId);\n            this.$.router.goTo('@sage/x3-stock/MobileLocationReorderDetail', {\n                entryTransaction: this.transaction,\n                stockSite: this.stockSite,\n                storageListNumber: this.storageListNumber.value,\n                product: this.locationReorders[rowIdNum].product,\n                toLocation: this.locationReorders[rowIdNum].toLocation,\n                fromLocation: this.locationReorders[rowIdNum].fromLocation,\n                source: this.locationReorders[rowIdNum].source,\n                reorderQuantity: this.locationReorders[rowIdNum].reorderQuantity,\n                reorderUnit: this.locationReorders[rowIdNum].reorderUnit,\n                decimalPrecision: this.locationReorders[rowIdNum].decimalPrecision,\n                lot: this.locationReorders[rowIdNum].lot,\n                sublot: this.locationReorders[rowIdNum].sublot,\n                serialNumber: this.locationReorders[rowIdNum].serialNumber,\n                status: this.locationReorders[rowIdNum].status,\n                documentLineNumber: this.locationReorders[rowIdNum].documentLine,\n                stockId: this.locationReorders[rowIdNum].stockId,\n                stockSequence: this.locationReorders[rowIdNum].stockSequence,\n                identifier1: this.locationReorders[rowIdNum].identifier1,\n                identifier2: this.locationReorders[rowIdNum].identifier2,\n                licensePlateNumber: this.locationReorders[rowIdNum].licensePlateNumber,\n                packingUnitToStockUnitConversionFactor: this.locationReorders[rowIdNum].packingUnitToStockUnitConversionFactor,\n                size: this.locationReorders.length,\n            });\n        },\n    })\n], MobileLocationReorderTodo.prototype, \"reorders\", void 0);\nexports.MobileLocationReorderTodo = MobileLocationReorderTodo = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo____title\", \"Location reordering\"),\n        subtitle: ui.localize(\"@sage/x3-stock/pages__mobile_location_reorder_todo____subtitle\", \"Select a product\"),\n        isTitleHidden: true,\n        isTransient: true,\n        skipDirtyCheck: true,\n        headerCard() {\n            return {\n                title: this.storageListNumber,\n            };\n        },\n        async onLoad() {\n            let stockSite = String(this.$.queryParameters.stockSite);\n            let storageListNumber = String(this.$.queryParameters.storageListNumber);\n            let entryTransaction = String(this.$.queryParameters.entryTransaction);\n            this.storageListNumber.value = storageListNumber;\n            this.stockSite = stockSite;\n            this.transaction = entryTransaction;\n            this.locationReorders = await this.searchLocationReorders(stockSite, storageListNumber, entryTransaction);\n            let counter = 0;\n            this.reorders.value = this.locationReorders.map((currentRecord) => {\n                var _v;\n                return {\n                    _id: String((_v = counter, counter = typesLib.add(counter, 1), _v)),\n                    product: currentRecord.product,\n                    localizedDescription1: currentRecord.localizedDescription1,\n                    upc: currentRecord.upc,\n                    quantityAndUnit: typesLib.add(typesLib.add(currentRecord.reorderQuantity, ' '), currentRecord.reorderUnit),\n                    fromLocation: currentRecord.fromLocation,\n                    serialNumber: currentRecord.serialNumber,\n                };\n            });\n        },\n    })\n], MobileLocationReorderTodo);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-location-reorder-todo.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-location-reorder-todo.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;