import { ProductInput } from '@sage/x3-master-data-api';
import { GraphApi, StockChangeInput, StockEntryTransaction } from '@sage/x3-stock-api';
import { SupportServiceManagementGs1Page } from '@sage/x3-system/lib/client-functions/support-service-management-gs-1-page';
import * as ui from '@sage/xtrem-ui';
export declare const mobileApplicationGs1Key = "MobileInventoryStockChangeGs1Key";
type DeepPartial<T> = T extends Object ? {
    [K in keyof T]?: DeepPartial<T[K]>;
} : T;
type PartialStockEntryTransaction = DeepPartial<StockEntryTransaction>;
export type inputsStockChange = {
    stockChange: StockChangeInput & {
        id?: string;
    };
    username: string;
    currentLine?: number;
    currentOperation?: number;
    started: boolean;
    selectedTransaction?: PartialStockEntryTransaction;
    selectedProduct?: ProductInput;
    destination?: string;
    printingMode?: string;
};
export declare enum PrintingModeEnum {
    noPrint = 1,
    stockLabel = 2,
    substituteValue3 = 3,
    transfertDocument = 4,
    analysisDocument = 5,
    createdContainerLabel = 6,
    stockLabelAndCreatedContainerLabel = 7
}
export declare class MobileInternalStockChange extends SupportServiceManagementGs1Page<GraphApi> {
    savedObject: inputsStockChange;
    private _transactions;
    private _notifier;
    private _mobileSettings;
    private _currentOperation;
    private _isGoto;
    private _numberOfDecimalList;
    stockSite: ui.fields.Text;
    createButton: ui.PageAction;
    mainSection: ui.containers.Section;
    transactionBlock: ui.containers.Block;
    effectiveDate: ui.fields.Date;
    transaction: ui.fields.DropdownList;
    thirdBlock: ui.containers.Block;
    product: ui.fields.Reference;
    stockChangeLinesBlock: ui.containers.Block;
    stockChangeLines: ui.fields.Table<any>;
    private _init;
    /**
     * Initialize ControlManagerGs1
     * @returns true when ControlManagerGs1 has usable
     */
    private _initControlManagerGs1;
    private _disablePage;
    private _initSite;
    private _initDestination;
    private _initTransaction;
    private _setTransaction;
    private _readSavedObject;
    private _checkStorage;
    private _reInitStorage;
    private _initStorage;
    private _saveStockChange;
    private _mapStockChange;
    private _initStockChangeLines;
    private _postInitStockChangeLines;
    prepareDataMutation(): void;
    private _callCreationAPI;
}
export {};
//# sourceMappingURL=mobile-internal-stock-change.d.ts.map