"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockReorder = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        stockSite: {
            code: 'stockSite',
        },
        product: {
            code: 'product',
        },
        warehouse: {
            code: 'warehouse',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
    },
};
let StockReorder = class StockReorder extends xtrem_core_1.Node {
    static processReorder(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'StockReorder', 'processReorder', parameters);
    }
};
exports.StockReorder = StockReorder;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StockReorder.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockReorder.prototype, "destinationLocation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StockReorder.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCCAT',
        dataType: () => sageX3StockData.enums.locationCategoryDatatype,
    })
], StockReorder.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], StockReorder.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYP',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], StockReorder.prototype, "documentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockReorder.prototype, "documentNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLIN',
    })
], StockReorder.prototype, "documentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StockReorder.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "quantityInPackingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEFPOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "potencyDefault", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StockReorder.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTUACT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "activeQuantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BESDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockReorder.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STAFLG',
        dataType: () => sageX3StockData.enums.reorderSituationDatatype,
    })
], StockReorder.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTUORIA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockReorder.prototype, "activeOriginalStockQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLEFLG',
    })
], StockReorder.prototype, "isClosed", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockReorder.prototype, "processingTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVTDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockReorder.prototype, "movementDescription", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ProcessReorder */
        isPublished: true,
        authorizationCode: 'CWSALR',
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    stockEntryTransaction: {
                        isMandatory: true,
                        type: 'string',
                    },
                    documentNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    documentLine: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    stockSite: {
                        isMandatory: true,
                        type: 'string',
                    },
                    destinationLocation: {
                        isMandatory: true,
                        type: 'string',
                    },
                    source: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    stockId: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    stockSequence: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    product: {
                        isMandatory: true,
                        type: 'string',
                    },
                    fromLocation: {
                        isMandatory: true,
                        type: 'string',
                    },
                    lot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    sublot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    serialNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    status: {
                        isMandatory: true,
                        type: 'string',
                    },
                    identifier1: {
                        isMandatory: true,
                        type: 'string',
                    },
                    identifier2: {
                        isMandatory: true,
                        type: 'string',
                    },
                    licensePlateNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    packingUnit: {
                        isMandatory: true,
                        type: 'string',
                    },
                    packingUnitToStockUnitConversionFactor: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    packingQuantity: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                stockEntryTransaction: {
                    isMandatory: true,
                    type: 'string',
                },
                documentNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                documentLine: {
                    isMandatory: true,
                    type: 'integer',
                },
                stockSite: {
                    isMandatory: true,
                    type: 'string',
                },
                destinationLocation: {
                    isMandatory: true,
                    type: 'string',
                },
                source: {
                    isMandatory: true,
                    type: 'integer',
                },
                stockId: {
                    isMandatory: true,
                    type: 'integer',
                },
                stockSequence: {
                    isMandatory: true,
                    type: 'integer',
                },
                product: {
                    isMandatory: true,
                    type: 'string',
                },
                fromLocation: {
                    isMandatory: true,
                    type: 'string',
                },
                lot: {
                    isMandatory: true,
                    type: 'string',
                },
                sublot: {
                    isMandatory: true,
                    type: 'string',
                },
                serialNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                status: {
                    isMandatory: true,
                    type: 'string',
                },
                identifier1: {
                    isMandatory: true,
                    type: 'string',
                },
                identifier2: {
                    isMandatory: true,
                    type: 'string',
                },
                licensePlateNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                packingUnit: {
                    isMandatory: true,
                    type: 'string',
                },
                packingUnitToStockUnitConversionFactor: {
                    isMandatory: true,
                    type: 'decimal',
                },
                packingQuantity: {
                    isMandatory: true,
                    type: 'decimal',
                },
            },
        },
    })
], StockReorder, "processReorder", null);
exports.StockReorder = StockReorder = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOREO',
        keyPropertyNames: ['stockSite', 'destinationLocation', 'product'],
        indexes: [
            {
                orderBy: {
                    stockSite: 1,
                    destinationLocation: 1,
                    product: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['destinationLocation'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockReorder);
//# sourceMappingURL=stock-reorder.js.map