import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference } from '@sage/xtrem-core';
export declare class StockEntryTransaction extends Node {
    readonly transactionType: Promise<sageX3StockData.enums.TypeOfStockTransaction | null>;
    readonly code: Promise<string>;
    readonly localizedDescription: Promise<string>;
    readonly accessCode: Reference<sageX3System.nodes.Access | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly document: Reference<sageX3System.nodes.GenericPrintReport | null>;
    readonly isAutomaticallyPrinted: Promise<boolean>;
    readonly defaultStockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly supplierLot: Promise<sageX3System.enums.EntryMode | null>;
    readonly identifier1Detail: Promise<sageX3System.enums.EntryMode | null>;
    readonly identifier2Detail: Promise<sageX3System.enums.EntryMode | null>;
    readonly printingMode: Promise<sageX3StockData.enums.LabelPrinting | null>;
    readonly isLotExpirationDateAllowed: Promise<boolean>;
    readonly isLotPotencyAllowed: Promise<boolean>;
    readonly isLotCustomField1Allowed: Promise<boolean>;
    readonly isLotCustomField2Allowed: Promise<boolean>;
    readonly isLotCustomField3Allowed: Promise<boolean>;
    readonly isLotCustomField4Allowed: Promise<boolean>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly isActive: Promise<boolean>;
    readonly companyOrSiteGroup: Reference<sageX3Structure.nodes.SiteGroupings | null>;
    readonly isAutomaticDetermination: Promise<boolean>;
    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
    readonly isLocationChange: Promise<boolean>;
    readonly isStatusChange: Promise<boolean>;
    readonly isUnitChange: Promise<boolean>;
    readonly ischangeInMass: Promise<boolean>;
    readonly preloadedQuantity: Promise<sageX3StockData.enums.QtyPreCharged | null>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly identifier1Destination: Promise<sageX3System.enums.EntryMode | null>;
    readonly identifier2Destination: Promise<sageX3System.enums.EntryMode | null>;
    readonly isLocationReplenishable: Promise<boolean>;
    readonly isConsumptionArea: Promise<boolean>;
    readonly isShortages: Promise<boolean>;
    readonly identifier1Entry: Promise<sageX3System.enums.EntryMode | null>;
    readonly identifier2Entry: Promise<sageX3System.enums.EntryMode | null>;
    readonly isEnterableDestinationLocation: Promise<boolean>;
    readonly isEnterableDestinationWarehouse: Promise<boolean>;
    readonly stockChangeAccessMode: Promise<sageX3StockData.enums.StockChangeAccess | null>;
}
//# sourceMappingURL=stock-entry-transaction.d.ts.map