"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountSession = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        fromProduct: {
            code: 'fromProduct',
        },
        toProduct: {
            code: 'toProduct',
        },
        fromLocation: {
            stockSite: 'stockSite',
            code: 'fromLocation',
        },
        toLocation: {
            stockSite: 'stockSite',
            code: 'toLocation',
        },
        fromCategory: {
            stockSite: 'stockSite',
            code: 'fromCategory',
        },
        toCategory: {
            stockSite: 'stockSite',
            code: 'toCategory',
        },
        fromBusinessPartner: {
            code: 'fromBusinessPartner',
        },
        toBusinessPartner: {
            code: 'toBusinessPartner',
        },
        fromBuyer: {
            code: 'fromBuyer',
        },
        toBuyer: {
            code: 'toBuyer',
        },
        stockSite: {
            code: 'stockSite',
        },
        fromWarehouse: {
            code: 'fromWarehouse',
        },
        toWarehouse: {
            code: 'toWarehouse',
        },
    },
};
let StockCountSession = class StockCountSession extends xtrem_core_1.Node {
};
exports.StockCountSession = StockCountSession;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNSSSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "stockCountSession", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNSSSDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "stockCountSessionDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNSSSTYP',
        dataType: () => sageX3StockData.enums.stockCountTypeDatatype,
    })
], StockCountSession.prototype, "stockCountSessionType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNSSSMOD',
        dataType: () => sageX3StockData.enums.stockCountListChoiceDatatype,
    })
], StockCountSession.prototype, "stockCountSessionMode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNSSSSTA',
        dataType: () => sageX3StockData.enums.stockCountSessionStatusDatatype,
    })
], StockCountSession.prototype, "stockCountSessionStatus", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNSSSDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountSession.prototype, "stockCountDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNSRTCOD',
        dataType: () => sageX3StockData.enums.stockTakeSequenceDatatype,
    })
], StockCountSession.prototype, "stockCountSortCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNLASFLG',
    })
], StockCountSession.prototype, "isGlobal", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MAXLIG',
    })
], StockCountSession.prototype, "maximumNumberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCLIG',
    })
], StockCountSession.prototype, "maximumPercentLimit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMNBR',
    })
], StockCountSession.prototype, "numberOfProducts", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCPOS',
    })
], StockCountSession.prototype, "numberOfPositionsInLocationCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "productFormula", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFSTR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StockCountSession.prototype, "fromProduct", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFEND',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StockCountSession.prototype, "toProduct", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMSTA006',
    })
], StockCountSession.prototype, "isNonUsableProductSelected", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCTYPSTR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "fromLocationType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOCTYPEND',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "toLocationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCSTR',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], StockCountSession.prototype, "fromLocation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCEND',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], StockCountSession.prototype, "toLocation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TCLCODSTR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], StockCountSession.prototype, "fromCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TCLCODEND',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], StockCountSession.prototype, "toCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRNUMSTR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], StockCountSession.prototype, "fromBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPRNUMEND',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], StockCountSession.prototype, "toBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUYSTR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], StockCountSession.prototype, "fromBuyer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BUYEND',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], StockCountSession.prototype, "toBuyer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOTSTR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "fromLot", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOTEND',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "toLot", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StockCountSession.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ABCCLSA',
    })
], StockCountSession.prototype, "stockCycleCountClassA", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLCUNNBRA',
    })
], StockCountSession.prototype, "numberOfProductsSelectedInClassA", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNNBRA',
    })
], StockCountSession.prototype, "numberOfCountsInClassA", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ABCCLSB',
    })
], StockCountSession.prototype, "stockCycleCountClassB", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLCUNNBRB',
    })
], StockCountSession.prototype, "numberOfProductsSelectedInClassB", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNNBRB',
    })
], StockCountSession.prototype, "numberOfCountsInClassB", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ABCCLSC',
    })
], StockCountSession.prototype, "stockCycleCountClassC", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLCUNNBRC',
    })
], StockCountSession.prototype, "numberOfProductsSelectedInClassC", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNNBRC',
    })
], StockCountSession.prototype, "numberOfCountsInClassC", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ABCCLSD',
    })
], StockCountSession.prototype, "stockCycleCountClassD", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPLCUNNBRD',
    })
], StockCountSession.prototype, "numberOfProductsSelectedInClassD", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNNBRD',
    })
], StockCountSession.prototype, "numberOfCountsInClassD", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RCPLOCFLG',
    })
], StockCountSession.prototype, "isReceiptLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOLOCFLG',
    })
], StockCountSession.prototype, "isStorageLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PICLOCFLG',
    })
], StockCountSession.prototype, "isPickingLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRALOCFLG',
    })
], StockCountSession.prototype, "isWorkStationLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUALOCFLG',
    })
], StockCountSession.prototype, "isDockLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MAGLOCFLG',
    })
], StockCountSession.prototype, "isShopLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RETLOCFLG',
    })
], StockCountSession.prototype, "isReturnLocation", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNNULSTK',
    })
], StockCountSession.prototype, "productsWithZeroStock", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MULLISFLG',
    })
], StockCountSession.prototype, "isMultilist", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR0',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "productFormula2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "stockFormula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "locationFormula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "warehouseFormula", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SELFOR00',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSession.prototype, "productWarehouseFormula", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHSTR',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
    })
], StockCountSession.prototype, "fromWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHEND',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
    })
], StockCountSession.prototype, "toWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNITMWRH',
    })
], StockCountSession.prototype, "productWarehouse", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MULCTGFLG',
    })
], StockCountSession.prototype, "isMultipleCount", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Stock.nodes.StockCountSessionFromStatisticalGroups,
    })
], StockCountSession.prototype, "fromStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Stock.nodes.StockCountSessionToStatisticalGroups,
    })
], StockCountSession.prototype, "toStatisticalGroups", void 0);
exports.StockCountSession = StockCountSession = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CUNSESSION',
        keyPropertyNames: ['stockCountSession'],
        indexes: [
            {
                orderBy: {
                    stockCountSession: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockCountSession);
//# sourceMappingURL=stock-count-session.js.map