"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountSessionFromStatisticalGroups = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'STI'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockCountSession: 'stockCountSession',
        },
        fromStatisticalGroup: {
            async glossaryId() {
                return typesLib.add(typesLib.sub((await this.denormalizedIndex), 1), 40);
            },
            code: 'fromStatisticalGroup',
        },
    },
};
let StockCountSessionFromStatisticalGroups = class StockCountSessionFromStatisticalGroups extends xtrem_core_1.Node {
};
exports.StockCountSessionFromStatisticalGroups = StockCountSessionFromStatisticalGroups;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], StockCountSessionFromStatisticalGroups.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CUNSSSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountSessionFromStatisticalGroups.prototype, "stockCountSession", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Stock.nodes.StockCountSession,
    })
], StockCountSessionFromStatisticalGroups.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TSICODSTR',
        columnType: 'string',
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], StockCountSessionFromStatisticalGroups.prototype, "fromStatisticalGroup", void 0);
exports.StockCountSessionFromStatisticalGroups = StockCountSessionFromStatisticalGroups = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CUNSESSION',
        keyPropertyNames: ['denormalizedIndex', 'stockCountSession'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], StockCountSessionFromStatisticalGroups);
//# sourceMappingURL=stock-count-session-from-statistical-groups.js.map