"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountListDetail = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        stockCountList: {
            stockCountSessionNumber: 'stockCountSessionNumber',
            stockCountListNumber: 'stockCountList',
        },
        stockSite: {
            code: 'stockSite',
        },
        product: {
            code: 'product',
        },
        location: {
            stockSite: 'stockSite',
            code: 'location',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        warehouse: {
            code: 'warehouse',
        },
        majorVersion: {
            product: 'product',
            code: 'majorVersion',
        },
        licensePlateNumber: {
            code: 'licensePlateNumber',
        },
        stockCountSession: {
            stockCountSession: 'stockCountSessionNumber',
        },
        stockLine: {
            stockSite: 'stockSite',
            stockId: 'stockId',
        },
    },
    collectionJoins: {
        serialNumberLines: {
            stockCountSessionNumber: 'stockCountSessionNumber',
            stockCountListNumber: 'stockCountList',
            serialNumberSequenceNumber: 'serialNumberSequenceNumber',
        },
    },
};
let StockCountListDetail = class StockCountListDetail extends xtrem_core_1.Node {
    static processCount(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'StockCountListDetail', 'processCount', parameters);
    }
    static renumberCountList(context, parameters) {
        return xtrem_x3_gateway_1.X3StorageManager.executeApiOperation(context, 'SCRIPT', 'StockCountListDetail', 'renumberCountList', parameters);
    }
};
exports.StockCountListDetail = StockCountListDetail;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUNSSSNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "stockCountSessionNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNLISNUM',
        columnType: 'string',
        node: () => sageX3Stock.nodes.StockCountList,
    })
], StockCountListDetail.prototype, "stockCountList", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMLISNUM',
    })
], StockCountListDetail.prototype, "productRankNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StockCountListDetail.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OWNER',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "owner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], StockCountListDetail.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "lot", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SLO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "sublot", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOC',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Location,
    })
], StockCountListDetail.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ABCCLS',
        dataType: () => sageX3MasterData.enums.productAbcClassDatatype,
    })
], StockCountListDetail.prototype, "abcClass", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "stockCountDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], StockCountListDetail.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCUNEW',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInPackingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTUNEW',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZERSTOFLG',
    })
], StockCountListDetail.prototype, "isZeroStock", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "quantityInPackingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINFLG',
        dataType: () => sageX3StockData.enums.enteredStockLineStatusDatatype,
    })
], StockCountListDetail.prototype, "isOriginOfLineNote", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOCOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "stockId", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNCSTCOD',
        dataType: () => sageX3StockData.enums.costSourceDatatype,
    })
], StockCountListDetail.prototype, "stockCountCostCode", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNCST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "stockCountUnitCost", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETCUNCST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "stockCountNetCost", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IPTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "allocationDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SERNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "serialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNLOKFLG',
        dataType: () => sageX3StockData.enums.blockedStockDatatype,
    })
], StockCountListDetail.prototype, "isStockCountLocked", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUNLISSTA',
        dataType: () => sageX3StockData.enums.stockCountDetailStatusDatatype,
    })
], StockCountListDetail.prototype, "stockCountListStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PALNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "identifier1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CTRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "identifier2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QLYCTLDEM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockCountListDetail.prototype, "qualityAnalysisRequestId", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIORD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "orderPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "potency", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'REFPER',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "expirationReferenceDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "expirationDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLUDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "useByDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NEWLTIDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], StockCountListDetail.prototype, "recontrolDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], StockCountListDetail.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCVALMAJ',
        columnType: 'string',
        node: () => sageX3StockData.nodes.MajorVersionStatus,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], StockCountListDetail.prototype, "majorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCVALMIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.EccActivityCode],
    })
], StockCountListDetail.prototype, "minorVersion", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFLD1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.SfdActivityCode],
    })
], StockCountListDetail.prototype, "stockUserArea1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFLD2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.SfdActivityCode],
    })
], StockCountListDetail.prototype, "stockUserArea2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCUNEW1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInPackingUnit1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTUNEW1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInStockUnit1", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZERSTOFLG1',
    })
], StockCountListDetail.prototype, "isZeroStock1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPCUNEW2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInPackingUnit2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTUNEW2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], StockCountListDetail.prototype, "countedStockInStockUnit2", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ZERSTOFLG2',
    })
], StockCountListDetail.prototype, "isZeroStock2", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SERSEQ',
    })
], StockCountListDetail.prototype, "serialNumberSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LPNNUM',
        columnType: 'string',
        node: () => sageX3StockData.nodes.LicensePlateNumber,
        serviceOptions: () => [sageX3System.serviceOptions.LpnActivityCode],
    })
], StockCountListDetail.prototype, "licensePlateNumber", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Stock.nodes.StockCountSerialNumber,
        dependsOn: ['stockCountSessionNumber', 'stockCountList', 'serialNumberSequenceNumber'],
    })
], StockCountListDetail.prototype, "serialNumberLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3Stock.nodes.StockCountSession,
    })
], StockCountListDetail.prototype, "stockCountSession", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnType: 'decimal',
        node: () => sageX3StockData.nodes.Stock,
    })
], StockCountListDetail.prototype, "stockLine", void 0);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: ProcessCount */
        isPublished: true,
        authorizationCode: 'CWSACC',
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    stockCountSessionNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    stockCountListNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    productRankNumber: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    product: {
                        isMandatory: true,
                        type: 'string',
                    },
                    licensePlateNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    location: {
                        isMandatory: true,
                        type: 'string',
                    },
                    lot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    sublot: {
                        isMandatory: true,
                        type: 'string',
                    },
                    serialNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    status: {
                        isMandatory: true,
                        type: 'string',
                    },
                    majorVersion: {
                        isMandatory: true,
                        type: 'string',
                    },
                    minorVersion: {
                        isMandatory: true,
                        type: 'string',
                    },
                    packingUnit: {
                        isMandatory: true,
                        type: 'string',
                    },
                    countedStockInPackingUnit: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    packingUnitToStockUnitConversionFactor: {
                        isMandatory: true,
                        type: 'decimal',
                    },
                    multiCountNumber: {
                        isMandatory: true,
                        type: 'integer',
                    },
                    serialNumberQuantity: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'decimal',
                        },
                    },
                    startingSerialNumber: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    endingSerialNumber: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                    serialNumberVariance: {
                        isMandatory: true,
                        type: 'array',
                        item: {
                            isMandatory: true,
                            type: 'string',
                        },
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                stockCountSessionNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                stockCountListNumber: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], StockCountListDetail, "processCount", null);
__decorate([
    xtrem_core_1.decorators.mutation({
        /* RequestNodeName: RenumberCountList */
        isPublished: true,
        authorizationCode: 'CWSACC',
        parameters: [
            {
                name: 'parameters',
                type: 'object',
                properties: {
                    stockCountSessionNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                    stockCountListNumber: {
                        isMandatory: true,
                        type: 'string',
                    },
                },
            },
        ],
        return: {
            type: 'object',
            properties: {
                stockCountSessionNumber: {
                    isMandatory: true,
                    type: 'string',
                },
                stockCountListNumber: {
                    isMandatory: true,
                    type: 'string',
                },
            },
        },
    })
], StockCountListDetail, "renumberCountList", null);
exports.StockCountListDetail = StockCountListDetail = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'CUNLISDET',
        keyPropertyNames: ['stockCountSessionNumber', 'stockCountList', 'productRankNumber'],
        indexes: [
            {
                orderBy: {
                    stockCountSessionNumber: 1,
                    stockCountList: 1,
                    productRankNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['stockCountSessionNumber', 'stockCountList', 'productRankNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockCountListDetail);
//# sourceMappingURL=stock-count-list-detail.js.map