import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3SalesData from '@sage/x3-sales-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class PickTicket extends Node {
    readonly id: Promise<string>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly sourcePickTicket: Promise<sageX3StockData.enums.PickingNoteSource | null>;
    readonly pickListNumber: Promise<string>;
    readonly salesDelivery: Promise<string>;
    readonly deliveryType: Reference<sageX3SalesData.nodes.SalesDeliveryType | null>;
    readonly soldToCustomer: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly shipToCustomerAddress: Reference<sageX3MasterData.nodes.ShipToCustomerAddress | null>;
    readonly shipmentDate: Promise<date>;
    readonly deliveryDate: Promise<date | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly routeNumber: Promise<sageX3SalesData.enums.RouteCode | null>;
    readonly preparationCode: Promise<string>;
    readonly pickTicketStatus: Promise<sageX3StockData.enums.PickingNoteStatus | null>;
    readonly isPacked: Promise<boolean>;
    readonly numberOfPackages: Promise<integer | null>;
    readonly isPickTicketPrinted: Promise<boolean>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly grossWeight: Promise<decimal | null>;
    readonly netWeight: Promise<decimal | null>;
    readonly pickTicketHeaderText: Promise<string>;
    readonly pickTicketFooterText: Promise<string>;
    readonly picker: Reference<sageX3System.nodes.User | null>;
    readonly pickTicketLines: Collection<sageX3Stock.nodes.PickTicketLine>;
}
//# sourceMappingURL=pick-ticket.d.ts.map