"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PickList = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3SalesData = require("@sage/x3-sales-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Stock = require("..");
const joins = {
    referenceJoins: {
        pickTicket: {
            id: 'pickTicket',
        },
        pickTicketLine: {
            pickTicket: 'pickTicket',
            pickTicketLine: 'pickTicketLine',
        },
        stockSite: {
            code: 'stockSite',
        },
        product: {
            code: 'product',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        soldToCustomer: {
            code: 'soldToCustomer',
        },
        deliveryAddress: {
            customer: 'soldToCustomer',
            shipToAddress: 'deliveryAddress',
        },
        carrier: {
            code: 'carrier',
        },
        picker: {
            code: 'picker',
        },
    },
};
let PickList = class PickList extends xtrem_core_1.Node {
};
exports.PickList = PickList;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRLNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickList.prototype, "preparationList", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRLSEQ',
    })
], PickList.prototype, "preparationListSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRHNUM',
        columnType: 'string',
        node: () => sageX3Stock.nodes.PickTicket,
    })
], PickList.prototype, "pickTicket", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRELIN',
        columnType: 'integer',
        node: () => sageX3Stock.nodes.PickTicketLine,
    })
], PickList.prototype, "pickTicketLine", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORITYP',
        dataType: () => sageX3StockData.enums.preparationSourceDatatype,
    })
], PickList.prototype, "sourcePickTicketType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickList.prototype, "sourcePickTicket", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORILIN',
    })
], PickList.prototype, "sourcePickTicketLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORISEQ',
    })
], PickList.prototype, "sourcePickTicketSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3SalesData.enums.lineTypeDatatype,
    })
], PickList.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PickList.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PickList.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REOLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PickList.prototype, "subcontractReorderLocation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SEQ',
    })
], PickList.prototype, "allocationSequence", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BESDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PickList.prototype, "requirementDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DLVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PickList.prototype, "deliveryDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickList.prototype, "quantityInStockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PickList.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PickList.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCUSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickList.prototype, "packingUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPCORD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], PickList.prototype, "soldToCustomer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPAADD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ShipToCustomerAddress,
    })
], PickList.prototype, "deliveryAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], PickList.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCKCAP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PickList.prototype, "packagingCapacity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PREUSR',
        columnType: 'string',
        node: () => sageX3System.nodes.User,
    })
], PickList.prototype, "picker", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCKFLG',
    })
], PickList.prototype, "isPacked", void 0);
exports.PickList = PickList = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOPRELIS',
        keyPropertyNames: ['preparationList', 'preparationListSequenceNumber'],
        indexes: [
            {
                orderBy: {
                    preparationList: 1,
                    preparationListSequenceNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['preparationList', 'preparationListSequenceNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PickList);
//# sourceMappingURL=pick-list.js.map