import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, Collection, Context } from '@sage/xtrem-core';
import * as sageX3Stock from '..';
export declare class LpnOperations extends Node {
    readonly id: Promise<string>;
    readonly stockChangeDestination: Promise<sageX3StockData.enums.DestinationChoice | null>;
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly stockSiteDestination: Reference<sageX3System.nodes.Site | null>;
    readonly purchaseSite: Reference<sageX3System.nodes.Site | null>;
    readonly salesSite: Reference<sageX3System.nodes.Site | null>;
    readonly receiptStockSiteAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly subcontractor: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly subcontractorAddress: Reference<sageX3MasterData.nodes.Address | null>;
    readonly subcontractLocation: Reference<sageX3StockData.nodes.Location | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly customer: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly customerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly isIntercompany: Promise<boolean>;
    readonly mustBeInvoiced: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly salesInvoiceNumber: Promise<string>;
    readonly effectiveDate: Promise<date | null>;
    readonly documentDescription: Promise<string>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly importLine: Promise<integer | null>;
    readonly isSigned: Promise<boolean>;
    readonly transportDocumentType: Promise<string>;
    readonly temporaryDocumentId: Promise<string>;
    readonly manualDocument: Promise<string>;
    readonly atCode: Promise<string>;
    readonly departureDate: Promise<date | null>;
    readonly departureTime: Promise<string>;
    readonly arrivalDate: Promise<date | null>;
    readonly arrivalTime: Promise<string>;
    readonly registration: Promise<string>;
    readonly trailerRegistration: Promise<string>;
    readonly licensePlateNumberOperationMode: Promise<integer | null>;
    readonly stockChangeByLicencePlateNumberOrigin: Promise<integer | null>;
    readonly licensePlateNumberDestination: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly locationDestination: Promise<string>;
    readonly stockChangeLines: Collection<sageX3Stock.nodes.LpnOperationsLine>;
    static lpnOperations(context: Context, parameter: LpnOperations): Promise<LpnOperations>;
}
//# sourceMappingURL=lpn-operations.d.ts.map