import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import { NodeExtension, Reference, Collection, integer, decimal } from '@sage/xtrem-core';
export declare class ProductSiteExtension extends NodeExtension<sageX3MasterData.nodes.ProductSite> {
    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
    readonly stock: Collection<sageX3StockData.nodes.Stock>;
    readonly countOfStockRecords: Promise<integer | null>;
    readonly distinctCountOfLocations: Promise<integer | null>;
    readonly distinctCountOfLots: Promise<integer | null>;
    readonly distinctCountOfStockQuantity: Promise<decimal | null>;
    readonly distinctCountOfSublots: Promise<integer | null>;
    readonly stockUnitCode: Promise<string>;
}
declare module '@sage/x3-master-data/lib/nodes/product-site' {
    interface ProductSite extends ProductSiteExtension {
    }
}
//# sourceMappingURL=product-site-extension.d.ts.map