import { Stock, StockJournalInput } from '@sage/x3-stock-data-api';
import { Filter } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
export declare const optionsIdentifier: string[];
export type packingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
    };
};
export interface originalStockLine {
    id: string;
    stockId: string;
    packingUnit: any;
    packingUnitToStockUnitConversionFactor: number;
    quantityInPackingUnit: number;
    quantityInStockUnit: number;
    quantityInPackingUnitIssue: number;
}
export declare function calculateEndingSerialNumber(startingSerialNumber: string, quantity: number): string;
export declare function readStockIdFromSerialNumber(pageInstance: ui.Page): Promise<string[]>;
export declare function onChangeFilterStock(pageInstance: ui.Page, filter: Filter<Stock>): Promise<Filter<Stock>>;
export declare function onRemoveLpnFilter(pageInstance: ui.Page, filter: Filter<Stock>): Promise<Filter<Stock>>;
export declare function onChangeFilterLicensePlateNumber(pageInstance: ui.Page, filter: Filter<Stock>): Promise<Filter<Stock>>;
export declare function checkIdentifierField(field: string, identifierFields: string | null): boolean;
export declare function initFieldsToBeVisible(pageInstance: ui.Page, identifierFields: string): Promise<void>;
export declare function getIdentifierValues(pageInstance: ui.Page, identifierFields: string): string[];
export declare function getIdentifierFieldsCount(identifierFields: string): number;
export declare function isProductGlobalReceivedIssuedInStock(pageInstance: ui.Page): boolean;
export declare function addValueToSelectedIdentifier(pageInstance: ui.Page, field: string, value: string): void;
export declare function disableButton(pageInstance: ui.Page): void;
export declare function getStockResults(pageInstance: ui.Page, filter: Filter<Stock>, maxResult?: number): Promise<import("@sage/xtrem-client").ExtractEdges<Stock>[]>;
export declare function isStockJournalInRecord(record: any, line: Partial<StockJournalInput>): boolean;
//# sourceMappingURL=stock-change-by-identifier-details-control.d.ts.map