"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readStockIdFromSerialNumber = void 0;
const dialogs_1 = require("@sage/x3-master-data/lib/client-functions/dialogs");
const ui = require("@sage/xtrem-ui");
async function readStockIdFromSerialNumber(pageInstance, serialNumber, product) {
    try {
        const serialNumberNode = await pageInstance.$.graph
            .node('@sage/x3-stock-data/SerialNumber')
            .read({
            stockId: true,
        }, `${product}|${serialNumber}`)
            .execute();
        return serialNumberNode?.stockId;
    }
    catch (e) {
        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number', 'Error loading serial number'), String(e));
    }
    return null;
}
exports.readStockIdFromSerialNumber = readStockIdFromSerialNumber;
//# sourceMappingURL=read-stock-id-from-serial-number.js.map