"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateEndingSerialNumber = exports.isSerialNumberAllocated = exports.readSerialNumberFromStockId = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const dialogs_1 = require("@sage/x3-master-data/lib/client-functions/dialogs");
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
async function readSerialNumberFromStockId(pageInstance, stockId, orderBy) {
    if (stockId) {
        try {
            const serialNumber = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
                .node('@sage/x3-stock-data/SerialNumber')
                .query(ui.queryUtils.edgesSelector({
                code: true,
            }, {
                filter: { stockId },
                orderBy: { code: orderBy },
            }))
                .execute());
            if (serialNumber[0]) {
                return serialNumber[0];
            }
        }
        catch (e) {
            await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-stock/error-loading-serial-number-node', 'Error loading serial number node'), String(e));
        }
    }
    return null;
}
exports.readSerialNumberFromStockId = readSerialNumberFromStockId;
async function isSerialNumberAllocated(pageInstance, stockSite, product, startingSerialNumber, endingSerialNumber) {
    const response = await pageInstance.$.graph
        .node('@sage/x3-stock/Allocation')
        .query(ui.queryUtils.edgesSelector({
        _id: true,
        serialNumber: true,
        quantityInStockUnit: true,
    }, {
        filter: {
            stockSite: { code: stockSite },
            product: { code: product },
        },
        first: 500,
    }))
        .execute();
    let result;
    result = false;
    response.edges.forEach((item) => {
        if ((typesLib.gte(startingSerialNumber, item.node.serialNumber) && typesLib.lte(startingSerialNumber, calculateEndingSerialNumber(item.node.serialNumber, Number(item.node.quantityInStockUnit)))) ||
            (typesLib.gte(endingSerialNumber, item.node.serialNumber) && typesLib.lte(endingSerialNumber, calculateEndingSerialNumber(item.node.serialNumber, Number(item.node.quantityInStockUnit)))) ||
            (typesLib.gte(item.node.serialNumber, startingSerialNumber) && typesLib.lte(item.node.serialNumber, endingSerialNumber))) {
            result = true;
        }
    });
    return result;
}
exports.isSerialNumberAllocated = isSerialNumberAllocated;
function calculateEndingSerialNumber(startingSerialNumber, quantity) {
    return startingSerialNumber.replace(/\d+$/, match => {
        const endingNumber = (typesLib.sub(typesLib.add(Number(match), quantity), 1)).toString();
        const lengthDiff = typesLib.max(typesLib.sub(endingNumber.length, match.length), 0);
        return endingNumber.padStart(typesLib.add(match.length, lengthDiff), '0');
    });
}
exports.calculateEndingSerialNumber = calculateEndingSerialNumber;
//# sourceMappingURL=read-serial-number-from-stock-id.js.map