import { ProductSite } from '@sage/x3-master-data-api';
import { SerialNumber, Stock, StockSearchFilter } from '@sage/x3-stock-data-api';
import { ClientNode, ExtractEdges, ExtractEdgesPartial, Filter } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';
/**
 * Initialize manage page
 * @param pageInstance current page
 * @param stockSite stock site
 * @param productSite partial product site object
 * @param flowType type of flow
 * @param errorMessage error messages missing settings
 * @param stockSearchFilters mandatory array to return settings
 */
export declare function managePages(pageInstance: ui.Page, stockSite: string, productSite: ExtractEdgesPartial<ProductSite>, flowType: string, errorMessage: string, stockSearchFilters: StockSearchFilter[]): void | never;
/**
 * Search if filter
 * @param field current search field
 * @param fields list of current filter
 * @returns true when found used filter parameter
 */
export declare function findSetting(field: StockSearchFilter, fields: StockSearchFilter[]): boolean;
/**
 * Remove filter (asynchronous for avoiding anticipated onChange)
 * @param pageInstance current page
 */
export declare function removeFilters(pageInstance: ui.Page): Promise<void>;
export declare function generateStockTableFilter(pageInstance: ui.Page): Filter<Stock>;
export declare function handleFilterOnChange<T extends ClientNode>(pageInstance: ui.Page, field: ui.fields.Reference<T> | ui.fields.Text | ui.fields.Numeric | ui.fields.DropdownList | ui.fields.Select, filterCriterion?: any): Promise<void>;
/**
 * Read one serial number for a given stock id
 * @param pageInstance current page
 * @param stockId stock id
 * @param orderBy sort order
 * @returns serial number or null
 */
export declare function readSerialNumberFromStockId(pageInstance: ui.Page, stockId: string, orderBy: number): Promise<ExtractEdges<SerialNumber> | null>;
//# sourceMappingURL=manage-pages.d.ts.map