declare module '@sage/x3-physical-flows-data-api-partial' {
    import type {
        EarlyDiscountLateCharge,
        InvoicingTerm,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        ProductCategoryTaxLevels,
        ProductCategoryTaxLevelsBinding,
        ProductCategoryTaxLevelsInput,
        SupplierInvoiceHeaderBillBySupplierAddressLines,
        SupplierInvoiceHeaderBillBySupplierAddressLinesBinding,
        SupplierInvoiceHeaderBillBySupplierAddressLinesInput,
        SupplierInvoiceHeaderBillBySupplierCompanyNames,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesInput,
        SupplierInvoiceHeaderComments,
        SupplierInvoiceHeaderCommentsBinding,
        SupplierInvoiceHeaderCommentsInput,
        SupplierInvoiceHeaderInput,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput,
        SupplierInvoiceHeaderTaxes,
        SupplierInvoiceHeaderTaxesBinding,
        SupplierInvoiceHeaderTaxesInput,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type {
        BusinessPartner,
        BusinessPartnerAddress,
        Carrier,
        Currency,
        CustomerProductInput,
        Incoterm,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategoryInput,
        ProductCategoryStatisticalGroups,
        ProductCategoryStatisticalGroupsBinding,
        ProductCategoryStatisticalGroupsInput,
        Supplier,
        SupplierAddress,
        TechnicalSheet,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        Package as SageX3StockData$Package,
        ProductCategoryDefaultLocations,
        ProductCategoryDefaultLocationsBinding,
        ProductCategoryDefaultLocationsInput,
        ProductCategoryOverheads,
        ProductCategoryOverheadsBinding,
        ProductCategoryOverheadsInput,
        ProductCategoryPackingUnits,
        ProductCategoryPackingUnitsBinding,
        ProductCategoryPackingUnitsInput,
        StockManagementRules,
        StockManagementRulesInput,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package, SiteGroupings } from '@sage/x3-structure-api';
    import type {
        Company,
        GenericPrintReport,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface IntrastatStatisticalRule extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        physicalFlow: RuleFlow;
        valueStock: boolean;
        alpha1: string;
        alpha2: string;
        numeric1: string;
        numeric2: string;
        groupOfCompany: SiteGroupings;
        active: boolean;
    }
    export interface IntrastatStatisticalRuleInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        physicalFlow?: RuleFlow;
        valueStock?: boolean | string;
        alpha1?: string;
        alpha2?: string;
        numeric1?: decimal | string;
        numeric2?: decimal | string;
        groupOfCompany?: string;
        active?: boolean | string;
    }
    export interface IntrastatStatisticalRuleBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        physicalFlow: RuleFlow;
        valueStock: boolean;
        alpha1: string;
        alpha2: string;
        numeric1: string;
        numeric2: string;
        groupOfCompany: SiteGroupings;
        active: boolean;
    }
    export interface IntrastatStatisticalRule$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
        groupOfCompany: QueryOperation<SiteGroupings>;
    }
    export interface IntrastatStatisticalRule$Operations {
        query: QueryOperation<IntrastatStatisticalRule>;
        read: ReadOperation<IntrastatStatisticalRule>;
        aggregate: {
            read: AggregateReadOperation<IntrastatStatisticalRule>;
            query: AggregateQueryOperation<IntrastatStatisticalRule>;
        };
        lookups(dataOrId: string | { data: IntrastatStatisticalRuleInput }): IntrastatStatisticalRule$Lookups;
        getDefaults: GetDefaultsOperation<IntrastatStatisticalRule>;
    }
    export interface IntrastatTransactionNature extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        groupOfCompany: SiteGroupings;
        valueStock: boolean;
        active: boolean;
        alpha1: string;
        alpha2: string;
        numeric1: string;
        numeric2: string;
    }
    export interface IntrastatTransactionNatureInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        groupOfCompany?: string;
        valueStock?: boolean | string;
        active?: boolean | string;
        alpha1?: string;
        alpha2?: string;
        numeric1?: decimal | string;
        numeric2?: decimal | string;
    }
    export interface IntrastatTransactionNatureBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        groupOfCompany: SiteGroupings;
        valueStock: boolean;
        active: boolean;
        alpha1: string;
        alpha2: string;
        numeric1: string;
        numeric2: string;
    }
    export interface IntrastatTransactionNature$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
        groupOfCompany: QueryOperation<SiteGroupings>;
    }
    export interface IntrastatTransactionNature$Operations {
        query: QueryOperation<IntrastatTransactionNature>;
        read: ReadOperation<IntrastatTransactionNature>;
        aggregate: {
            read: AggregateReadOperation<IntrastatTransactionNature>;
            query: AggregateQueryOperation<IntrastatTransactionNature>;
        };
        lookups(dataOrId: string | { data: IntrastatTransactionNatureInput }): IntrastatTransactionNature$Lookups;
        getDefaults: GetDefaultsOperation<IntrastatTransactionNature>;
    }
    export interface Packaging extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface PackagingInput extends ClientNodeInput {
        code?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface PackagingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface Packaging$Operations {
        query: QueryOperation<Packaging>;
        read: ReadOperation<Packaging>;
        aggregate: {
            read: AggregateReadOperation<Packaging>;
            query: AggregateQueryOperation<Packaging>;
        };
        getDefaults: GetDefaultsOperation<Packaging>;
    }
    export interface CustomerProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        customer: BusinessPartner;
        isActive: boolean;
        customerProduct: string;
        customerProductDescription: string;
        salesUnit: UnitOfMeasure;
        salesUnitToStockUnitConversion: string;
        packingUnit1: UnitOfMeasure;
        packingUnit1ToSalesUnitConversion: string;
        packingUnit2: UnitOfMeasure;
        packingUnit2ToSalesUnitConversion: string;
        customerUseByDateCoefficient: string;
        journalNumberConfigurator: string;
        isVersionPreloaded: boolean;
        pickingText: TextStream;
        salesText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
    }
    export interface CustomerProductInputExtension {
        product?: string;
        customer?: string;
        isActive?: boolean | string;
        customerProduct?: string;
        customerProductDescription?: string;
        salesUnit?: string;
        salesUnitToStockUnitConversion?: decimal | string;
        packingUnit1?: string;
        packingUnit1ToSalesUnitConversion?: decimal | string;
        packingUnit2?: string;
        packingUnit2ToSalesUnitConversion?: decimal | string;
        customerUseByDateCoefficient?: decimal | string;
        journalNumberConfigurator?: string;
        isVersionPreloaded?: boolean | string;
        pickingText?: TextStream;
        salesText?: TextStream;
        packaging?: string;
        packagingCapacity?: decimal | string;
    }
    export interface CustomerProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        product: Product;
        customer: BusinessPartner;
        isActive: boolean;
        customerProduct: string;
        customerProductDescription: string;
        salesUnit: UnitOfMeasure;
        salesUnitToStockUnitConversion: string;
        packingUnit1: UnitOfMeasure;
        packingUnit1ToSalesUnitConversion: string;
        packingUnit2: UnitOfMeasure;
        packingUnit2ToSalesUnitConversion: string;
        customerUseByDateCoefficient: string;
        journalNumberConfigurator: string;
        isVersionPreloaded: boolean;
        pickingText: TextStream;
        salesText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
    }
    export interface CustomerProductExtension$Lookups {
        packaging: QueryOperation<Packaging>;
    }
    export interface CustomerProductExtension$Operations {
        lookups(dataOrId: string | { data: CustomerProductInput }): CustomerProductExtension$Lookups;
    }
    export interface ProductCategoryExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroups>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocations>;
        overheads: ClientCollection<ProductCategoryOverheads>;
        packingUnits: ClientCollection<ProductCategoryPackingUnits>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevels>;
        packaging: Packaging;
    }
    export interface ProductCategoryInputExtension {
        stockSite?: string;
        code?: string;
        description?: string;
        localizedDescription?: string;
        shortDescription?: string;
        localizedShortDescription?: string;
        isSold?: boolean | string;
        productSequenceNumber?: string;
        creationMethod?: ProductCreationMode;
        qualityControlManagementMode?: SubjectToControl;
        qualityControlAccessCode?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticUnit?: string;
        euUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        euUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseConversionFactorEntryAllowed?: boolean | string;
        isSalesConversionFactorEntryAllowed?: boolean | string;
        weightUnit?: string;
        stockUnitWeight?: decimal | string;
        volumeUnit?: string;
        stockUnitVolume?: decimal | string;
        labelFormatForStockUnit?: string;
        stockManagementMode?: StockManagement;
        managementMode?: StandardProductCode;
        isNegativeStockAuthorized?: boolean | string;
        lotSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        serialSequenceNumber?: string;
        valuationMethod?: string;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        userAccessCode?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        reorderLeadTime?: decimal | string;
        buyer?: string;
        planner?: string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        salesPriceOrigin?: PriceOrigin;
        percentagePricePurchaseApplied?: decimal | string;
        configuratorProductLine?: string;
        isLocationManaged?: boolean | string;
        salesOrderAllocationRule?: string;
        workOrderAllocationRule?: string;
        shipmentAllocationRule?: string;
        materialConsumptionAllocationRule?: string;
        transferAllocationRule?: string;
        subcontractReplenishmentAllocationRule?: string;
        subcontractConsumptionAllocationRule?: string;
        afterSalesAllocationRule?: string;
        isStatusAAuthorizedInGlobalAllocation?: boolean | string;
        isStatusQAuthorizedInGlobalAllocation?: boolean | string;
        isStatusRAuthorizedInGlobalAllocation?: boolean | string;
        abcClass?: ProductAbcClass;
        stockWithdrawalMode?: StockWithdrawal;
        countManagementMode?: Count;
        trendProfile?: string;
        shrinkagePercent?: decimal | string;
        planningFirmHorizon?: integer | string;
        planningFirmHorizonTimeUnit?: LeadTimeUnit;
        planningRequestHorizon?: integer | string;
        planningRequestHorizonTimeUnit?: LeadTimeUnit;
        reorderingPeriodicity?: integer | string;
        reorderingSuggestionType?: SuggestionType;
        reorderingSite?: string;
        reorderingPolicy?: string;
        stockCoverageInWeeks?: integer | string;
        safetyStock?: decimal | string;
        reorderingThreshold?: decimal | string;
        reorderingMaximumStock?: decimal | string;
        economicOrderQuantity?: decimal | string;
        technicalLotQuantity?: decimal | string;
        standardCostUpdate?: PriceUpdateMode;
        revisedStandardCostUpdate?: PriceUpdateMode;
        budgetStandardCostUpdate?: PriceUpdateMode;
        simulatedCostUpdate?: PriceUpdateMode;
        isReleasedIfShortage?: boolean | string;
        automaticClosingPercentage?: decimal | string;
        salesDeliveryTolerance?: decimal | string;
        salesMinimumQuantity?: decimal | string;
        salesMaximumQuantity?: decimal | string;
        isLoanAuthorized?: boolean | string;
        isBackToBackOrderManaged?: boolean | string;
        directBackToBackOrderQuantity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTool?: boolean | string;
        isDeliverable?: boolean | string;
        isIntermediary?: boolean | string;
        isMaintenance?: boolean | string;
        packagingCapacity?: decimal | string;
        assignmentRules?: string;
        isStockDetailedInPacking?: boolean | string;
        technicalSheet?: string;
        orderWarehouse?: string;
        workOrderWarehouse?: string;
        shippingWarehouse?: string;
        materialConsumptionWarehouse?: string;
        internalMovementWarehouse?: string;
        subcontractShipmentWarehouse?: string;
        subcontractConsumptionWarehouse?: string;
        afterSalesWarehouse?: string;
        canBeCapitalized?: boolean | string;
        isPackingManaged?: boolean | string;
        sageSalesTax?: string;
        saftProductType?: SafTProductType;
        freightClass?: string;
        freightCommodityCode?: string;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        inventoryProductType?: ProductType;
        containerManagement?: boolean | string;
        statisticalGroups?: Partial<ProductCategoryStatisticalGroupsInput>[];
        costType?: string;
        lotManagementMode?: LotManagementMode;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        materialCostGroup?: MaterialCostGroup;
        reorderingManagementMode?: ReorderingManagementMode;
        stockVersionMode?: StockVersionMode;
        stockManagementRules?: Partial<StockManagementRulesInput>[];
        defaultLocations?: Partial<ProductCategoryDefaultLocationsInput>[];
        overheads?: Partial<ProductCategoryOverheadsInput>[];
        packingUnits?: Partial<ProductCategoryPackingUnitsInput>[];
        invoicingTerm?: string;
        taxLevels?: Partial<ProductCategoryTaxLevelsInput>[];
        packaging?: string;
    }
    export interface ProductCategoryBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        stockSite: Site;
        code: string;
        description: string;
        localizedDescription: string;
        shortDescription: string;
        localizedShortDescription: string;
        isSold: boolean;
        productSequenceNumber: string;
        creationMethod: ProductCreationMode;
        qualityControlManagementMode: SubjectToControl;
        qualityControlAccessCode: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticUnit: UnitOfMeasure;
        euUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        salesUnitToStockUnitConversionFactor: string;
        statisticalUnitToStockUnitConversionFactor: string;
        euUnitToStockUnitConversionFactor: string;
        isPurchaseConversionFactorEntryAllowed: boolean;
        isSalesConversionFactorEntryAllowed: boolean;
        weightUnit: UnitOfMeasure;
        stockUnitWeight: string;
        volumeUnit: UnitOfMeasure;
        stockUnitVolume: string;
        labelFormatForStockUnit: GenericPrintReport;
        stockManagementMode: StockManagement;
        managementMode: StandardProductCode;
        isNegativeStockAuthorized: boolean;
        lotSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        serialSequenceNumber: string;
        valuationMethod: string;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        userAccessCode: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        reorderLeadTime: string;
        buyer: User;
        planner: User;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        salesPriceOrigin: PriceOrigin;
        percentagePricePurchaseApplied: string;
        configuratorProductLine: string;
        isLocationManaged: boolean;
        salesOrderAllocationRule: string;
        workOrderAllocationRule: string;
        shipmentAllocationRule: string;
        materialConsumptionAllocationRule: string;
        transferAllocationRule: string;
        subcontractReplenishmentAllocationRule: string;
        subcontractConsumptionAllocationRule: string;
        afterSalesAllocationRule: string;
        isStatusAAuthorizedInGlobalAllocation: boolean;
        isStatusQAuthorizedInGlobalAllocation: boolean;
        isStatusRAuthorizedInGlobalAllocation: boolean;
        abcClass: ProductAbcClass;
        stockWithdrawalMode: StockWithdrawal;
        countManagementMode: Count;
        trendProfile: string;
        shrinkagePercent: string;
        planningFirmHorizon: integer;
        planningFirmHorizonTimeUnit: LeadTimeUnit;
        planningRequestHorizon: integer;
        planningRequestHorizonTimeUnit: LeadTimeUnit;
        reorderingPeriodicity: integer;
        reorderingSuggestionType: SuggestionType;
        reorderingSite: Site;
        reorderingPolicy: string;
        stockCoverageInWeeks: integer;
        safetyStock: string;
        reorderingThreshold: string;
        reorderingMaximumStock: string;
        economicOrderQuantity: string;
        technicalLotQuantity: string;
        standardCostUpdate: PriceUpdateMode;
        revisedStandardCostUpdate: PriceUpdateMode;
        budgetStandardCostUpdate: PriceUpdateMode;
        simulatedCostUpdate: PriceUpdateMode;
        isReleasedIfShortage: boolean;
        automaticClosingPercentage: string;
        salesDeliveryTolerance: string;
        salesMinimumQuantity: string;
        salesMaximumQuantity: string;
        isLoanAuthorized: boolean;
        isBackToBackOrderManaged: boolean;
        directBackToBackOrderQuantity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTool: boolean;
        isDeliverable: boolean;
        isIntermediary: boolean;
        isMaintenance: boolean;
        packagingCapacity: string;
        assignmentRules: string;
        isStockDetailedInPacking: boolean;
        technicalSheet: TechnicalSheet;
        orderWarehouse: string;
        workOrderWarehouse: string;
        shippingWarehouse: string;
        materialConsumptionWarehouse: string;
        internalMovementWarehouse: string;
        subcontractShipmentWarehouse: string;
        subcontractConsumptionWarehouse: string;
        afterSalesWarehouse: string;
        canBeCapitalized: boolean;
        isPackingManaged: boolean;
        sageSalesTax: MiscellaneousTable;
        saftProductType: SafTProductType;
        freightClass: string;
        freightCommodityCode: string;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        inventoryProductType: ProductType;
        containerManagement: boolean;
        statisticalGroups: ClientCollection<ProductCategoryStatisticalGroupsBinding>;
        costType: CostType;
        lotManagementMode: LotManagementMode;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        materialCostGroup: MaterialCostGroup;
        reorderingManagementMode: ReorderingManagementMode;
        stockVersionMode: StockVersionMode;
        stockManagementRules: ClientCollection<StockManagementRules>;
        defaultLocations: ClientCollection<ProductCategoryDefaultLocationsBinding>;
        overheads: ClientCollection<ProductCategoryOverheadsBinding>;
        packingUnits: ClientCollection<ProductCategoryPackingUnitsBinding>;
        invoicingTerm: InvoicingTerm;
        taxLevels: ClientCollection<ProductCategoryTaxLevelsBinding>;
        packaging: Packaging;
    }
    export interface ProductCategoryExtension$Lookups {
        packaging: QueryOperation<Packaging>;
    }
    export interface ProductCategoryExtension$Operations {
        lookups(dataOrId: string | { data: ProductCategoryInput }): ProductCategoryExtension$Lookups;
    }
    export interface SupplierInvoiceHeaderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportMode: IntrastatTransportMode;
    }
    export interface SupplierInvoiceHeaderInputExtension {
        id?: string;
        category?: InvoiceType;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        sourceModule?: ModuleTable;
        billBySupplier?: string;
        control?: string;
        company?: string;
        site?: string;
        accountingDate?: string;
        internalNumber?: integer | string;
        internalReference?: string;
        sourceDocumentDate?: string;
        sourceDocument?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rateDate?: string;
        isDAS2Submitted?: boolean | string;
        payToBusinessPartner?: string;
        dueDateCalculationStartDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        taxRule?: string;
        isEuropeanUnionInvoice?: boolean | string;
        intrastatProcessingNumber?: integer | string;
        status?: PurchasingInvoiceStatus;
        paymentApproval?: PaymentApprovalType;
        originalInvoiceNumber?: string;
        debitOrCredit?: integer | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        taxReferenceDate?: string;
        numberOfTaxes?: integer | string;
        billBySupplierAddress?: string;
        billBySupplierPostalCode?: string;
        billBySupplierCity?: string;
        billBySupplierState?: string;
        billBySupplierCountry?: string;
        billBySupplierCountryName?: string;
        payToBusinessPartnerAddress?: string;
        payToBusinessPartnerPostalCode?: string;
        payToBusinessPartnerCity?: string;
        payToBusinessPartnerState?: string;
        payToBusinessPartnerCountry?: string;
        payToBusinessPartnerCountryName?: string;
        incoterm?: string;
        incotermTown?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        fiscalYear?: integer | string;
        period?: integer | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        lastServiceAccountedDate?: string;
        unblockUser?: string;
        unblockDate?: string;
        unblockAmount?: decimal | string;
        matchStatus?: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        priceOrAmountType?: PriceAmountTaxTax;
        singleCustomsDocumentDate?: string;
        singleCustomsDocumentReference?: string;
        singleCustomsDocumentBusinessPartnerCode?: string;
        derCode?: string;
        versionControlSystemNumber?: string;
        priceOrAmountTaxType?: PriceAmountTaxTax;
        recurringNumber?: string;
        importTaxAmountNumber?: string;
        recurringInvoicingDate?: string;
        numberOfCompanies?: integer | string;
        cashVatTaxRule?: boolean | string;
        field40Reason?: string;
        field41Reason?: string;
        originalDocumentNumber?: string;
        inPaymentSlipWithReferenceLine?: string;
        bankId?: string;
        project?: string;
        numberOfInvoiceCopies?: integer | string;
        billBySupplierAddressLines?: Partial<SupplierInvoiceHeaderBillBySupplierAddressLinesInput>[];
        billBySupplierCompanyNames?: Partial<SupplierInvoiceHeaderBillBySupplierCompanyNamesInput>[];
        comments?: Partial<SupplierInvoiceHeaderCommentsInput>[];
        payToBusinessPartnerAddressLines?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput>[];
        payToBusinessPartnerCompanyNames?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput>[];
        taxes?: Partial<SupplierInvoiceHeaderTaxesInput>[];
        intrastatTransactionNature?: string;
        intrastatStatisticalRule?: string;
        intrastatTransportMode?: IntrastatTransportMode;
    }
    export interface SupplierInvoiceHeaderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        sourceModule: ModuleTable;
        billBySupplier: Supplier;
        control: string;
        company: Company;
        site: Site;
        accountingDate: string;
        internalNumber: integer;
        internalReference: string;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        isDAS2Submitted: boolean;
        payToBusinessPartner: BusinessPartner;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        isEuropeanUnionInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: PurchasingInvoiceStatus;
        paymentApproval: PaymentApprovalType;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billBySupplierAddress: SupplierAddress;
        billBySupplierPostalCode: string;
        billBySupplierCity: string;
        billBySupplierState: string;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerState: string;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        incoterm: Incoterm;
        incotermTown: string;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        unblockUser: User;
        unblockDate: string;
        unblockAmount: string;
        matchStatus: MatchStatusEnum;
        earlyDiscountOrLateChargeBasis: string;
        priceOrAmountType: PriceAmountTaxTax;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        derCode: string;
        versionControlSystemNumber: string;
        priceOrAmountTaxType: PriceAmountTaxTax;
        recurringNumber: string;
        importTaxAmountNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        inPaymentSlipWithReferenceLine: string;
        bankId: string;
        project: ProjectLink;
        numberOfInvoiceCopies: integer;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLinesBinding>;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNamesBinding>;
        comments: ClientCollection<SupplierInvoiceHeaderCommentsBinding>;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesBinding>;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesBinding>;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxesBinding>;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportMode: IntrastatTransportMode;
    }
    export interface SupplierInvoiceHeaderExtension$Lookups {
        intrastatTransactionNature: QueryOperation<IntrastatTransactionNature>;
        intrastatStatisticalRule: QueryOperation<IntrastatStatisticalRule>;
    }
    export interface SupplierInvoiceHeaderExtension$Operations {
        lookups(dataOrId: string | { data: SupplierInvoiceHeaderInput }): SupplierInvoiceHeaderExtension$Lookups;
    }
    export interface Package {
        '@sage/x3-physical-flows-data/IntrastatStatisticalRule': IntrastatStatisticalRule$Operations;
        '@sage/x3-physical-flows-data/IntrastatTransactionNature': IntrastatTransactionNature$Operations;
        '@sage/x3-physical-flows-data/Packaging': Packaging$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3InvoicingData$Package,
            SageX3MasterData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-physical-flows-data-api' {
    export type * from '@sage/x3-physical-flows-data-api-partial';
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-physical-flows-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        CustomerProductBindingExtension,
        CustomerProductExtension,
        CustomerProductExtension$Lookups,
        CustomerProductExtension$Operations,
        CustomerProductInputExtension,
        ProductCategoryBindingExtension,
        ProductCategoryExtension,
        ProductCategoryExtension$Lookups,
        ProductCategoryExtension$Operations,
        ProductCategoryInputExtension,
    } from '@sage/x3-physical-flows-data-api';
    export interface CustomerProduct extends CustomerProductExtension {}
    export interface CustomerProductBinding extends CustomerProductBindingExtension {}
    export interface CustomerProductInput extends CustomerProductInputExtension {}
    export interface CustomerProduct$Lookups extends CustomerProductExtension$Lookups {}
    export interface CustomerProduct$Operations extends CustomerProductExtension$Operations {}
    export interface ProductCategory extends ProductCategoryExtension {}
    export interface ProductCategoryBinding extends ProductCategoryBindingExtension {}
    export interface ProductCategoryInput extends ProductCategoryInputExtension {}
    export interface ProductCategory$Lookups extends ProductCategoryExtension$Lookups {}
    export interface ProductCategory$Operations extends ProductCategoryExtension$Operations {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type {
        SupplierInvoiceHeaderBindingExtension,
        SupplierInvoiceHeaderExtension,
        SupplierInvoiceHeaderExtension$Lookups,
        SupplierInvoiceHeaderExtension$Operations,
        SupplierInvoiceHeaderInputExtension,
    } from '@sage/x3-physical-flows-data-api';
    export interface SupplierInvoiceHeader extends SupplierInvoiceHeaderExtension {}
    export interface SupplierInvoiceHeaderBinding extends SupplierInvoiceHeaderBindingExtension {}
    export interface SupplierInvoiceHeaderInput extends SupplierInvoiceHeaderInputExtension {}
    export interface SupplierInvoiceHeader$Lookups extends SupplierInvoiceHeaderExtension$Lookups {}
    export interface SupplierInvoiceHeader$Operations extends SupplierInvoiceHeaderExtension$Operations {}
}
