import type { SitemapEntry } from '@sage/xtrem-shared';
export interface SyracuseEntity {
    $uuid: string;
    $key: string;
    $etag?: number | null;
    $creUser?: string;
    $updUser?: string;
    $updDate?: string;
}
export interface SyracuseEntityWithDescription extends SyracuseEntity {
    description?: string;
}
export interface UserPhoto {
    $uuid: string;
    $key: string;
    $url: string;
    $type: string;
    $contentType: string;
    $fileName: string;
    $length: number;
}
export interface User extends SyracuseEntity {
    $parent_uuid: string;
    $shortUrl: string;
    $active: boolean;
    $value: string;
    $url: string;
    firstName?: string;
    lastName?: string;
    login: string;
    email: string;
    title: string;
    photo?: UserPhoto;
    userCode?: string;
}
export interface EndpointOption extends SyracuseEntityWithDescription {
    nature?: string | null;
    isXtremEndpoint: boolean;
}
export interface SelectedEndpoint extends SyracuseEntityWithDescription {
    $url: string;
    $shortUrl: string;
    $parent_uuid: string;
    $value: string;
    databasePort: number;
    dataset: string;
    protocol: string;
    application: string;
    x3solution: string | null;
    applicationRef: SyracuseEntityWithDescription;
    groups: SyracuseEntityWithDescription[];
    username: string;
}
export interface SelectedLocale extends SyracuseEntityWithDescription {
    $url: string;
    $value: string;
    code: string;
}
export interface SelectedRole extends SyracuseEntityWithDescription {
    $url: string;
    $shortUrl: string;
    $parent_uuid: string;
    code: string;
    endPoints: EndpointOption[];
    securityProfile: SyracuseEntity;
    groups: SyracuseEntity[];
}
export interface XtremPageReference {
    key: string;
    title: string;
    category?: string;
}
export interface Profile extends SyracuseEntity {
    $key: string;
    $shortUrl: string;
    $trackingId: string;
    $url: string;
    adcSoundDisabled: boolean;
    endpoints: EndpointOption[];
    roles: SyracuseEntityWithDescription[];
    selectedEndpoint: SelectedEndpoint;
    selectedLocale: SelectedLocale;
    selectedRole: SelectedRole;
    user: User;
    xtremSitemap: SitemapEntry[];
}
//# sourceMappingURL=profile-schema.d.ts.map