import type { integration } from '@sage/xtrem-ui';
import type { Reducer } from 'redux';
import type { Profile } from '../service/profile-schema';
import type { AppAction } from './action-types';
import type { XtremStandaloneState } from './state';
import type { Dict } from '@sage/xtrem-shared';
export declare const path: (state: string | undefined, action: AppAction) => string;
export declare const pageTitle: (state: string | null | undefined, action: AppAction) => string | null;
export declare const pageSubtitle: (state: string | null | undefined, action: AppAction) => string | null;
export declare const profile: (state: Profile | null | undefined, action: AppAction) => Profile | null;
export declare const menuItems: (state: integration.Menu[] | undefined, action: AppAction) => integration.Menu[];
export declare const translation: (state: Dict<string> | undefined, action: AppAction) => Dict<string>;
export declare const isApplicationDirty: (state: boolean | undefined, action: AppAction) => boolean;
export declare const preNavigationConfirmation: (state: (() => Promise<void>) | null | undefined, action: AppAction) => (() => Promise<void>) | null;
export declare const isNavigationConfirmationPromptDisplayed: (state: boolean | undefined, action: AppAction) => boolean;
declare const rootReducer: Reducer<XtremStandaloneState, AppAction>;
export default rootReducer;
//# sourceMappingURL=reducer.d.ts.map