/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ConfigManager=void 0;const xtrem_bytenode_1=require("@sage/xtrem-bytenode"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),ajv_1=require("ajv"),bytes=require("bytes"),chokidar=require("chokidar"),events_1=require("events"),fs=require("fs"),js_yaml_1=require("js-yaml"),_=require("lodash"),fsp=require("path");(0,xtrem_bytenode_1.sourceMapSetup)();const logger=xtrem_log_1.Logger.getLogger(__filename,"config"),defaultPort={http:8240,https:443};class ConfigManager{static{this.fileWatcherMap=(0,xtrem_shared_1.createDictionary)()}static{this.emitter=new events_1.EventEmitter}static{this.configFilePaths=[]}static _checkDeploymentMode(e){if(e.deploymentMode=e.deploymentMode||"production",!/^(development|production)$/.test(e.deploymentMode))throw new Error(`invalid deploymentMode: ${e.deploymentMode}`)}static _checkIgnoreVendorProtection(e){if(e.ignoreVendorProtection)logger.warn("CAUTION: factory data protection is disabled because ignoreVendorProtection has been set to 'true'")}static _checkGraphQlConfig(e){if(!e.graphql)e.graphql={}}static _checkLogLevels(e){const t=e.logs?.domains;if("development"!==e.deploymentMode&&t){const e=Object.keys(t).find(e=>!/^(error|warn|info|verbose)$/.test(t[e].level));if(e)throw new Error(`${t[e]?.level} log level not allowed in production (domain=${e})`)}}static _checkNewRelicConfig(e){if(e.newRelic&&(!e.newRelic.accountId||!e.newRelic.applicationId||!e.newRelic.licenceKey||!e.newRelic.trustKey))throw new Error("'newRelic' config object is defined but one of the properties is not set.")}static _checkStorageConfig(e){const t=e.storage?.sql;if(t){["user","database","sysUser","sysDatabase"].forEach(e=>{const i=t[e];if(i)xtrem_shared_1.validator.isAlphaNumericName(i,{throw:{name:e}})})}else if(!e.storage?.managedExternal)throw new Error("Storage config missing")}static _checkAppName(e){if(!/^[a-z][a-z0-9_]*$/.test(e))throw new Error(`invalid app name (must be snake_case): ${e}`)}static _checkAppsConfig(e){if(e.app)this._checkAppName(e.app);if(e.apps)Object.keys(e.apps).forEach(this._checkAppName)}static _checkConfig(e){return this._checkDeploymentMode(e),this._checkIgnoreVendorProtection(e),this._checkGraphQlConfig(e),this._checkLogLevels(e),this._checkNewRelicConfig(e),this._checkStorageConfig(e),this._checkAppsConfig(e),e}static getDefaultSqlConfig(e){if("production"===e.deploymentMode)return{};return{hostname:"127.0.0.1",port:5432,database:"postgres",user:"postgres",password:"secret",sysDatabase:"postgres",sysUser:"postgres",sysPassword:"secret",poolMaxIdleSeconds:60,connectionMaxRetries:3,connectionRetryMillis:2e3,max:20,maxUses:7500,maxRetriesOnTransactionConflicts:10}}static getDefaultConfig(){return{config:{storage:{sql:ConfigManager.getDefaultSqlConfig({})}}}}static _load(e){let t=e;for(;;){const i=fsp.join(t,"xtrem-config.yml"),o=fsp.join(t,"etna-config.yml");let s;if(fs.existsSync(i))s=i;else if(fs.existsSync(o))logger.warn("etna-config.yml will be deprecated in the future, please rename to xtrem-config.yml"),s=o;if(s)return this._loadFromPath(t,s);const r=fsp.join(t,"..");if(r===t)return logger.warn(`config MISSING: ${fsp.join(e,"xtrem-config.yml")}`),ConfigManager.getDefaultConfig();t=r}}static _readConfigFile(e){return(0,js_yaml_1.load)(fs.readFileSync(e,"utf8"))}static _readConfigFiles(e,t={}){if(t[e])throw new Error(`circularity in config extends: dir=${e}`);t[e]=true;const i=fsp.join(e,"xtrem-config.yml");let o=fs.existsSync(i)?(0,js_yaml_1.load)(fs.readFileSync(i,"utf8")):this.getDefaultConfig().config;o.env={isCI:[process.env.TF_BUILD].some(e=>e&&/^true$/i.test(e))};const s=fsp.join(e,"xtrem-security.yml");if(fs.existsSync(s))o.security=this._readConfigFile(s);let r=fsp.join(e,"apps.yml");if(!fs.existsSync(r))r="/infra/apps.yml";if(fs.existsSync(r))o.apps=this._readConfigFile(r).apps;const n=o.uiConfigPath||fsp.join(e,"xtrem-ui.yml");if(fs.existsSync(n))o.ui=this._readConfigFile(n);if(o.extends){const i=fsp.dirname(fsp.join(e,o.extends));o=_.merge(this._readConfigFiles(i,t).config,o)}return{config:o,securityPath:s}}static _loadFromPath(e,t){const{config:i,securityPath:o}=this._readConfigFiles(e);return i.originFolder=fsp.join(e),this._checkDeploymentMode(i),logger.info(`Loading configuration: deploymentMode='${i.deploymentMode}'`),xtrem_log_1.Logger.reloadConfig(i),this._checkConfigJsonSchema(e,i),this._setStorageConfig(i),this._setServerConfig(i),{config:i,fromFile:t,securityFile:o}}static _checkConfigJsonSchema(e,t){const i=fsp.join(e,"xtrem-config-json-schema.json");if(fs.existsSync(i)){const e=this._readConfigFile(i),o=(new ajv_1.default).compile(e);if(!o(t))logger.warn(`xtrem-config.yml config data is invalid according to its JSON Schema. \n\n                                ${JSON.stringify(o.errors,null,4)}`);else logger.info("xtrem-config.yml config data is valid according to its JSON Schema.")}else logger.warn(`config Json Schema MISSING: ${fsp.join(e,"xtrem-config-json-schema.json")}`)}static _setStorageConfig(e){e.storage=e.storage||{};const t=e;if(!e.storage?.managedExternal){if(e.storage?.sql&&t.sql)throw new Error("config conflict between 'storage.sql' and 'sql', please remove the deprecated root level 'sql' config");if(t.sql)logger.warn("'sql' parameter is deprecated at the root level, please move it into 'storage' parameter");if(e.storage.sql=e.storage.sql||t.sql,e.storage={...e.storage,sql:{...ConfigManager.getDefaultSqlConfig(e),...e.storage.sql}},delete t.sql,e.storage.sql?.ssl&&"object"==typeof e.storage.sql.ssl)this._setSslPemOptions("storage.sql.ssl",e)}}static _setServerConfig(e){const t=e;if(e.server?.port&&t.port)throw new Error("config conflict between 'server.port' and 'port', please remove the deprecated root level 'port' config");if(t.port)logger.warn("'port' parameter is deprecated at the root level, please move it into 'server' parameter");if(e.server=e.server||{},e.server.port=e.server.port||(e.server.ssl?defaultPort.https:defaultPort.http)||t.port,e.server.requestFunnelSizeFactor=Math.max(e.server.requestFunnelSizeFactor||1,1),delete t.port,e.server.ssl)this._setSslPemOptions("server.ssl",e)}static{this.sizeLimits={}}static getSizeLimit(e){if(null!=this.sizeLimits[e])return this.sizeLimits[e];const t=this.current.security?.sizeLimits;switch(e){case"maxRequestSize":this.sizeLimits[e]=bytes.parse(t?.maxRequestSize||"100Mb");break;case"maxStreamSize":this.sizeLimits[e]=bytes.parse(t?.maxStreamSize||"32Mb");break;case"maxUploadSize":this.sizeLimits[e]=bytes.parse(t?.maxStreamSize||"1Gb");break;default:this.sizeLimits[e]=0}return this.sizeLimits[e]}static _setSslPemOptions(e,t){const i=`${e}ShallowCopy`;if(null!=_.property(i)(t))throw new Error(`'${i}' is not allowed in the configuration, please remove it`);const o=_.property(e)(t)??{};_.set(t,i,{...o});const s=o,r={},n=_.property(e)(this.config)??{},a={};["ca","cert","key"].filter(e=>null!=s[e]).forEach(e=>{(Array.isArray(s[e])?s[e]:[s[e]]).forEach(t=>{if("string"==typeof t&&!t.startsWith("-----BEGIN ")){const i=this._tryloadPemFile(t,e);if(null!=i)s[e]=i,r[e]=t}if(s[e]!==n[e])a[e]=s[e]})}),this._notifyTlsChangeAndInstallWatcher(e,r,a)}static _notifyTlsChangeAndInstallWatcher(e,t,i){const o=_.debounce(()=>{logger.info(()=>`Notify TLS change for '${e}' on [${Object.keys(i)}]`),this.emitter.emit("tlsChange",e,i)},500),s=_.debounce(()=>{logger.info(`Reload TLS files for '${e}'`),Object.keys(t).forEach(o=>{i[o]=fs.readFileSync(t[o],"utf8"),logger.info(`Reloaded TLS ${o} file for '${e}' from '${t[o]}'`)}),this.emitter.emit("tlsReload",e,t),o()},500);if(Object.values(i).length>0)o();const r=Object.values(t);let n=this.fileWatcherMap[e];if(null!=n?.watcher)if(_.isEqual(n.files,r));else{const t=n.watcher;n=void 0,delete this.fileWatcherMap[e],(async()=>{if(t)logger.info(`Closing TLS file watcher for '${e}'`),await t.close()})().catch(t=>{logger.error(`Failed to close file watcher '${e}': ${t.message}`)}).finally(()=>{})}if(!n?.watcher&&r.length>0)logger.info(`Creating TLS file watcher for '${e}'`),this.fileWatcherMap[e]={watcher:chokidar.watch(r,{persistent:true}).on("change",t=>{logger.info(`TLS file changed for '${e}': ${t}`),s()}),files:r},o()}static _tryloadPemFile(e,t){logger.info(`Loading ${t} pem file from ${e}`);try{return fs.readFileSync(e,"ascii").replace(/\r\n/g,"\n")}catch(i){return logger.error(`Failed to load ${t} pem file from ${e}: ${i.message}`),null}}static load(e,t,i){if(this.config&&this.config.extensionPath===i)return this.config;return this._loadConfiguration(e,t,i)}static _loadConfiguration(e,t,i){const o=this._load(e),s={};if(i){const e=fsp.join(i,"xtrem-config.yml"),t=fsp.join(i,"xtrem-security.yml");if(fs.existsSync(e)){const t=(0,js_yaml_1.load)(fs.readFileSync(e,"utf8"));s.fromFile=e,o.config=_.merge(o.config,t)}else logger.error(()=>`xtrem-config.yml file not found in config extension location provided ${i}`);if(fs.existsSync(t)){const i={security:(0,js_yaml_1.load)(fs.readFileSync(t,"utf8"))};s.securityFile=e,o.config=_.merge(o.config,i)}o.config.extensionPath=i}if(this.config=this._checkConfig(o.config),xtrem_log_1.Logger.setAppName(this.config.app),"test"===t&&this.config.logs?.disabledForTests)this.config.logs.disabled=true;if(this.config.logs?.disabled)xtrem_log_1.Logger.disable(),console.warn(`Logs are disabled by config (pid ${process.pid}, cwd ${process.cwd()})`);if(this.sizeLimits={},o.fromNpm)logger.info(`Configuration loaded from NPM package ${o.fromNpm}`);else if(o.fromFile){logger.info(`Loading configuration from ${o.fromFile}`);const r=_.uniq([o.fromFile,o.securityFile,s?.fromFile,s?.securityFile]).filter(e=>!!e);if(!_.isEqual(ConfigManager.configFilePaths,r))chokidar.watch(r,{persistent:true}).on("change",o=>{logger.info(`Configuration changed: ${o}`),this._loadConfiguration(e,t,i)}),ConfigManager.configFilePaths=r}if(!this.config.security)logger.warn("security configuration missing");if(!this.config.security&&(this.config.prodUi||"production"===this.config.deploymentMode))logger.warn("Production user interface is configured without a security config, pages will not be fetched.");const r=this.config.storage.sql;if(r){["driver","databaseDirs","databaseLayers","folderName"].filter(e=>Object.keys(r).includes(e)).forEach(e=>logger.warn(`Configuration parameter '${e}' is obsolete and will be ignored.`)),logger.info(`SQL config: host=${r.hostname}, port=${r.port}, database=${r.database}, user=${r.user}`)}if("development"===this.config.deploymentMode&&null==process.env.XTREM_ENV)process.env.XTREM_ENV="local",logger.info("'XTREM_ENV' environment variable was set to 'local'");this.config.textStreamContentTypes=this.config.textStreamContentTypes||[];const n=["image/*","application/pdf"];if(["application/xml","application/json","text/xml","text/plain","text/html","text/css"].forEach(e=>{if(!this.config.textStreamContentTypes.includes(e))logger.warn(`${e} was added to the list of allowed content-types of text stream`),this.config.textStreamContentTypes.push(e)}),n.forEach(e=>{if(!this.config.textStreamContentTypes.includes(e))logger.warn(`${e} was added to the list of allowed content-types of binary stream`),this.config.textStreamContentTypes.push(e)}),!this.config.serviceOptions)this.config.serviceOptions={level:"development"===this.config.deploymentMode?"workInProgress":"released"},logger.info(`config.serviceOptions.level was set to '${this.config.serviceOptions.level}'`);return this.emitter.emit("loaded",this.config),this.config}static notLoadedError(){return new Error("config not loaded!")}static get current(){if(!this.config)throw this.notLoadedError();return this.config}static get header(){if(!this.config)throw this.notLoadedError();return Buffer.from(JSON.stringify(this.config)).toString("base64")}static getSetting(e,t){const i=this.current.settings;return i&&e in i?i[e]:t}static fixServicesConfig(){if(!this.config)throw this.notLoadedError();const e=["sysUser","sysPassword","sysDatabase"],t=this.config.storage?.sql;if(t)e.forEach(e=>{if(t[e])logger.warn(`storage.sql.${e} has been deleted because it is not allowed in services mode`),delete t[e]})}}exports.ConfigManager=ConfigManager;
//# sourceMappingURL=config-manager.js.map