/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const child_process_1=require("child_process"),fs=require("fs"),glob=require("glob"),path=require("path"),wrap=require("module").wrap,xtremBytenode=require("./index.js"),args=process.argv.slice(2);if(args.includes("-c"))args[args.indexOf("-c")]="--compile";if(args.includes("-h"))args[args.indexOf("-h")]="--help";if(args.includes("-v"))args[args.indexOf("-v")]="--version";if(args.includes("-z"))args[args.indexOf("-z")]="--compress";if(args.includes("-e"))args[args.indexOf("-e")]="--source";if(args.includes("-d"))args[args.indexOf("-d")]="--delete-source";class Program{constructor(){this.dirname=__dirname,this.filename=__filename,this.nodeBin=process.argv[0],this.flags=args.filter(e=>"-"===e[0]&&"-"===e[1]),this.inclusions=args.filter(e=>"-"!==e[0]&&"-"!==e[1]),this.exclusions=args.filter(e=>"-"===e[0]&&"-"!==e[1]).map(e=>e.substring(1)),this.files=[]}async compile(){const e=require(path.join(dir,"package.json")),s=e.main;if(s)this.exclusions.push(s);const i=xtremBytenode.shouldMinify(e);this.minify=i;const o=this.exclusions.map(e=>path.resolve(e)),r=[];if(0===this.inclusions.length&&!this.flags.includes("--source"))r.push(`${dir}/**/*.js`);else this.inclusions.forEach(e=>r.push(path.resolve(e)));if(this.files=glob.sync(r,{ignore:o}),!this.files?.length)console.warn(`No files to process in '${dir}'.`),process.exit(0);if(!i&&this.files.length>1){const e=path.join(dir,"build","index.js");if(fs.existsSync(e)){const s=this.files.indexOf(e);if(s>-1)this.files.splice(s,1);xtremBytenode.reexportAll(e)}}return await Promise.all(this.files.map(async s=>{const o=path.resolve(s),r=o.slice(0,-3),unlinkFile=(e,s)=>{if(fs.existsSync(`${e}.${s}`))fs.unlinkSync(`${e}.${s}`)};if(unlinkFile(r,"jsb"),unlinkFile(r,"jsbz"),fs.existsSync(o)&&fs.statSync(o).isFile()){const s=!this.flags.includes("--no-module");try{const r={filename:o,compileAsModule:s,compress,minify:i,deleteSource:this.flags.includes("--delete-source"),module:"module"===e.type};await xtremBytenode.compileFile({...r})}catch(e){console.error(e)}}else console.error(`Error: Cannot find file '${o}'.`)})),this}}const program=new Program,compress=program.flags.includes("--compress"),verbose=program.flags.includes("--verbose"),dir=process.cwd(),startedAt=Date.now();if(program.flags.includes("--compile"))program.compile().then(()=>{const{files:e,minify:s}=program;if(0===e.length&&program.flags.includes("--source")){let e="";process.stdin.setEncoding("utf-8"),process.stdin.on("readable",()=>{const s=process.stdin.read();if(null!==s)e+=s}),process.stdin.on("end",()=>{try{const i=wrap(e);process.stdout.write(xtremBytenode.compileCode(i,{compress,minify:s,verbose}))}catch(e){console.error(e)}})}console.log(`Compiled to binary(${s?"minify":"bytenode"}) ${e.length} file${1===e.length?"":"s"} in ${Date.now()-startedAt}ms.`)}).catch(e=>{console.error(e),process.exit(1)});else if(program.flags.includes("--help"))console.log("\n  Usage: xtrem-bytenode [option] [ FILE... | - ] [arguments]\n\n  Options:\n    -c, --compile [ FILE... | - ]     compile stdin, a file, or a list of files\n      --no-module                   compile without producing commonjs module\n    -h, --help                        show help information.\n    -e, --source                      compile source passed in via the command line\n    -v, --version                     show xtrem-bytenode version.\n    -z, --compress                    compress binary source\n\n  Examples:\n\n  $ xtrem-bytenode -c script.js             compile `script.js` to `script.jsb`.\n  $ xtrem-bytenode -c server.js app.js\n  $ xtrem-bytenode -c                       compile all `.js` files in `build/` directory.\n  $ xtrem-bytenode -c src/*.js              compile all `.js` files in `src/` directory.\n  $ xtrem-bytenode                          open Node REPL with xtrem-bytenode pre-loaded.\n\n  $ echo 'console.log(\"Hello\");' | xtrem-bytenode --compile --source - > hello.jsb\n                                      compile from stdin and save to `hello.jsb`\n");else if(program.flags.includes("--version")&&1===program.flags.length&&0===program.inclusions.length){const e=require("./package.json");console.log(e.name,e.version)}else try{(0,child_process_1.spawnSync)(program.nodeBin,["-r",path.resolve(__dirname,"index.js")].concat(args),{stdio:"inherit"})}catch(e){console.error(e)}
//# sourceMappingURL=cli.js.map